#ifndef GABA_DEFINE
struct channel_read_state
{
  int fd;
  int ignored_error;
  int active;
  struct lsh_string *buffer;
};
extern void channel_read_state_mark(struct channel_read_state *i,
 void (*mark)(struct lsh_object *o));
extern void channel_read_state_free(struct channel_read_state *i);
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
void channel_read_state_mark(struct channel_read_state *i,
 void (*mark)(struct lsh_object *o))
{
  (void) mark; (void) i;
}
void channel_read_state_free(struct channel_read_state *i)
{
  (void) i;
  lsh_string_free(i->buffer);
}
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct channel_write_state
{
  int fd;
  int active;
  struct ssh_write_state *state;
};
extern void channel_write_state_mark(struct channel_write_state *i,
 void (*mark)(struct lsh_object *o));
extern void channel_write_state_free(struct channel_write_state *i);
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
void channel_write_state_mark(struct channel_write_state *i,
 void (*mark)(struct lsh_object *o))
{
  (void) mark; (void) i;
  mark((struct lsh_object *) i->state);
}
void channel_write_state_free(struct channel_write_state *i)
{
  (void) i;
}
#endif /* !GABA_DECLARE */

