/* 	$NetBSD: vt220koi8x10.h,v 1.1 2003/07/14 18:30:40 uwe Exp $	*/

/*
 * Copyright (c) 1992, 1995 Hellmuth Michaelis and Joerg Wunsch
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by
 *	Hellmuth Michaelis and Joerg Wunsch
 * 4. The name authors may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Translated into a wsfont form by Shin Takemura in Nov 2, 1999.
 */

#ifdef KOI8_U
#define _VT220KX8X10		vt220ku8x10
#define _VT220_KOI8_X_8X10_DATA	vt220_koi8_u_8x10_data
#define _VT220_KOI8_X_8X10_STR	"vt220_koi8_u_8x10"
#else
#define _VT220KX8X10		vt220kr8x10
#define _VT220_KOI8_X_8X10_DATA	vt220_koi8_r_8x10_data
#define _VT220_KOI8_X_8X10_STR	"vt220_koi8_r_8x10"
#endif

extern u_char _VT220_KOI8_X_8X10_DATA[];

struct wsdisplay_font _VT220KX8X10 = {
	_VT220_KOI8_X_8X10_STR,		/* typeface name */
	'\0',				/* firstchar */
	256,				/* numchars */
	WSDISPLAY_FONTENC_ISO,		/* encoding */	/* XXX !!! */
	8,				/* width */
	10,				/* height */
	1,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	_VT220_KOI8_X_8X10_DATA		/* data */
};

static u_char _VT220_KOI8_X_8X10_DATA[] = {
	/* code 0 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 1 */
	0x7e, /* ..############.. */
	0x81, /* ##............## */
	0xa5, /* ##..##....##..## */
	0xa5, /* ##..##....##..## */
	0x81, /* ##............## */
	0x81, /* ##............## */
	0xbd, /* ##..########..## */
	0x99, /* ##....####....## */
	0x81, /* ##............## */
	0x7e, /* ..############.. */

	/* code 2 */
	0x7e, /* ..############.. */
	0xff, /* ################ */
	0xdb, /* ####..####..#### */
	0xdb, /* ####..####..#### */
	0xff, /* ################ */
	0xff, /* ################ */
	0xc3, /* ####........#### */
	0xe7, /* ######....###### */
	0xff, /* ################ */
	0x7e, /* ..############.. */

	/* code 3 */
	0x6c, /* ..####..####.... */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0x7c, /* ..##########.... */
	0x7c, /* ..##########.... */
	0x38, /* ....######...... */
	0x38, /* ....######...... */
	0x10, /* ......##........ */
	0x10, /* ......##........ */
	0x00, /* ................ */

	/* code 4 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x10, /* ......##........ */
	0x38, /* ....######...... */
	0x7c, /* ..##########.... */
	0xfe, /* ##############.. */
	0x7c, /* ..##########.... */
	0x38, /* ....######...... */
	0x10, /* ......##........ */
	0x00, /* ................ */

	/* code 5 */
	0x38, /* ....######...... */
	0x7c, /* ..##########.... */
	0x7c, /* ..##########.... */
	0x38, /* ....######...... */
	0x7c, /* ..##########.... */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0x7c, /* ..##########.... */
	0x38, /* ....######...... */
	0x7c, /* ..##########.... */

	/* code 6 */
	0x10, /* ......##........ */
	0x10, /* ......##........ */
	0x38, /* ....######...... */
	0x38, /* ....######...... */
	0x7c, /* ..##########.... */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0x7c, /* ..##########.... */
	0x38, /* ....######...... */
	0x7c, /* ..##########.... */

	/* code 7 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 8 */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xe7, /* ######....###### */
	0xc3, /* ####........#### */
	0xc3, /* ####........#### */
	0xe7, /* ######....###### */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */

	/* code 9 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0x42, /* ..##........##.. */
	0x42, /* ..##........##.. */
	0x66, /* ..####....####.. */
	0x3c, /* ....########.... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 10 */
	0xff, /* ################ */
	0xff, /* ################ */
	0xc3, /* ####........#### */
	0x99, /* ##....####....## */
	0xbd, /* ##..########..## */
	0xbd, /* ##..########..## */
	0x99, /* ##....####....## */
	0xc3, /* ####........#### */
	0xff, /* ################ */
	0xff, /* ################ */

	/* code 11 */
	0x00, /* ................ */
	0x0f, /* ........######## */
	0x07, /* ..........###### */
	0x0f, /* ........######## */
	0x7d, /* ..##########..## */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 12 */
	0x00, /* ................ */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x7e, /* ..############.. */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 13 */
	0x3f, /* ....############ */
	0x33, /* ....####....#### */
	0x3f, /* ....############ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x70, /* ..######........ */
	0xf0, /* ########........ */
	0xe0, /* ######.......... */
	0x00, /* ................ */

	/* code 14 */
	0x7f, /* ..############## */
	0x63, /* ..####......#### */
	0x7f, /* ..############## */
	0x63, /* ..####......#### */
	0x63, /* ..####......#### */
	0x63, /* ..####......#### */
	0x67, /* ..####....###### */
	0xe6, /* ######....####.. */
	0xc0, /* ####............ */
	0x00, /* ................ */

	/* code 15 */
	0x00, /* ................ */
	0xdb, /* ####..####..#### */
	0x7e, /* ..############.. */
	0x3c, /* ....########.... */
	0xe7, /* ######....###### */
	0xe7, /* ######....###### */
	0x3c, /* ....########.... */
	0x7e, /* ..############.. */
	0xdb, /* ####..####..#### */
	0x00, /* ................ */

	/* code 16 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x80, /* ##.............. */
	0xe0, /* ######.......... */
	0xf8, /* ##########...... */
	0xfe, /* ##############.. */
	0xf8, /* ##########...... */
	0xe0, /* ######.......... */
	0x80, /* ##.............. */
	0x00, /* ................ */

	/* code 17 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x02, /* ............##.. */
	0x0e, /* ........######.. */
	0x3e, /* ....##########.. */
	0xfe, /* ##############.. */
	0x3e, /* ....##########.. */
	0x0e, /* ........######.. */
	0x02, /* ............##.. */
	0x00, /* ................ */

	/* code 18 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x7e, /* ..############.. */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x7e, /* ..############.. */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 19 */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x00, /* ................ */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x00, /* ................ */

	/* code 20 */
	0x7f, /* ..############## */
	0xdb, /* ####..####..#### */
	0xdb, /* ####..####..#### */
	0xdb, /* ####..####..#### */
	0x7b, /* ..########..#### */
	0x1b, /* ......####..#### */
	0x1b, /* ......####..#### */
	0x1b, /* ......####..#### */
	0x1b, /* ......####..#### */
	0x00, /* ................ */

	/* code 21 */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0x30, /* ....####........ */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x18, /* ......####...... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 22 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7e, /* ..############.. */
	0x7e, /* ..############.. */
	0x7e, /* ..############.. */
	0x7e, /* ..############.. */
	0x00, /* ................ */

	/* code 23 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x7e, /* ..############.. */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x7e, /* ..############.. */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0xff, /* ################ */

	/* code 24 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x7e, /* ..############.. */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 25 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x7e, /* ..############.. */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 26 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x0c, /* ........####.... */
	0xfe, /* ##############.. */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 27 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0xfe, /* ##############.. */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 28 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 29 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x24, /* ....##....##.... */
	0x66, /* ..####....####.. */
	0xff, /* ################ */
	0x66, /* ..####....####.. */
	0x24, /* ....##....##.... */
	0x00, /* ................ */

	/* code 30 */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x7e, /* ..############.. */
	0x7e, /* ..############.. */
	0xff, /* ################ */
	0xff, /* ################ */
	0x00, /* ................ */

	/* code 31 */
	0x00, /* ................ */
	0xff, /* ################ */
	0xff, /* ################ */
	0x7e, /* ..############.. */
	0x7e, /* ..############.. */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 32 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 33 */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x78, /* ..########...... */
	0x78, /* ..########...... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 34 */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x28, /* ....##..##...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 35 */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0xfe, /* ##############.. */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0xfe, /* ##############.. */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x00, /* ................ */

	/* code 36 */
	0x18, /* ......####...... */
	0x7e, /* ..############.. */
	0xd8, /* ####..####...... */
	0xd8, /* ####..####...... */
	0x7c, /* ..##########.... */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xfc, /* ############.... */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 37 */
	0xc6, /* ####......####.. */
	0xcc, /* ####....####.... */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x38, /* ....######...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0x66, /* ..####....####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 38 */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x30, /* ....####........ */
	0x76, /* ..######..####.. */
	0xdc, /* ####..######.... */
	0xcc, /* ####....####.... */
	0x76, /* ..######..####.. */
	0x00, /* ................ */

	/* code 39 */
	0xe0, /* ######.......... */
	0xe0, /* ######.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xc0, /* ####............ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 40 */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x0c, /* ........####.... */
	0x00, /* ................ */

	/* code 41 */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0x00, /* ................ */

	/* code 42 */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0xfe, /* ##############.. */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 43 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0xfc, /* ############.... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 44 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x70, /* ..######........ */
	0x70, /* ..######........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0x00, /* ................ */

	/* code 45 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 46 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 47 */
	0x00, /* ................ */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x00, /* ................ */

	/* code 48 */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xce, /* ####....######.. */
	0xde, /* ####..########.. */
	0xd6, /* ####..##..####.. */
	0xf6, /* ########..####.. */
	0xe6, /* ######....####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 49 */
	0x30, /* ....####........ */
	0x70, /* ..######........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 50 */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x06, /* ..........####.. */
	0x0c, /* ........####.... */
	0x38, /* ....######...... */
	0x60, /* ..####.......... */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 51 */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x06, /* ..........####.. */
	0x3c, /* ....########.... */
	0x06, /* ..........####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 52 */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x1c, /* ......######.... */
	0x3c, /* ....########.... */
	0x6c, /* ..####..####.... */
	0xcc, /* ####....####.... */
	0xfe, /* ##############.. */
	0x0c, /* ........####.... */
	0x1e, /* ......########.. */
	0x00, /* ................ */

	/* code 53 */
	0xfe, /* ##############.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xfc, /* ############.... */
	0x06, /* ..........####.. */
	0x06, /* ..........####.. */
	0x06, /* ..........####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 54 */
	0x1c, /* ......######.... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0xc0, /* ####............ */
	0xfc, /* ############.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 55 */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */
	0x06, /* ..........####.. */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 56 */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 57 */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7e, /* ..############.. */
	0x06, /* ..........####.. */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x70, /* ..######........ */
	0x00, /* ................ */

	/* code 58 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 59 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0x00, /* ................ */

	/* code 60 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0xc0, /* ####............ */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 61 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 62 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0x00, /* ................ */

	/* code 63 */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x06, /* ..........####.. */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 64 */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xce, /* ####....######.. */
	0xda, /* ####..####..##.. */
	0xd6, /* ####..##..####.. */
	0xde, /* ####..########.. */
	0xc0, /* ####............ */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 65 */
	0x38, /* ....######...... */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 66 */
	0xfc, /* ############.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x7c, /* ..##########.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 67 */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0x66, /* ..####....####.. */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 68 */
	0xf8, /* ##########...... */
	0x6c, /* ..####..####.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x6c, /* ..####..####.... */
	0xf8, /* ##########...... */
	0x00, /* ................ */

	/* code 69 */
	0xfe, /* ##############.. */
	0x62, /* ..####......##.. */
	0x60, /* ..####.......... */
	0x68, /* ..####..##...... */
	0x78, /* ..########...... */
	0x68, /* ..####..##...... */
	0x60, /* ..####.......... */
	0x62, /* ..####......##.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 70 */
	0xfe, /* ##############.. */
	0x62, /* ..####......##.. */
	0x60, /* ..####.......... */
	0x68, /* ..####..##...... */
	0x78, /* ..########...... */
	0x68, /* ..####..##...... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */

	/* code 71 */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xce, /* ####....######.. */
	0xc6, /* ####......####.. */
	0x66, /* ..####....####.. */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 72 */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 73 */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 74 */
	0x1e, /* ......########.. */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 75 */
	0xe6, /* ######....####.. */
	0x66, /* ..####....####.. */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x78, /* ..########...... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x66, /* ..####....####.. */
	0xe6, /* ######....####.. */
	0x00, /* ................ */

	/* code 76 */
	0xf0, /* ########........ */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x62, /* ..####......##.. */
	0x66, /* ..####....####.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 77 */
	0xc6, /* ####......####.. */
	0xee, /* ######..######.. */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0xd6, /* ####..##..####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 78 */
	0xc6, /* ####......####.. */
	0xe6, /* ######....####.. */
	0xe6, /* ######....####.. */
	0xf6, /* ########..####.. */
	0xde, /* ####..########.. */
	0xce, /* ####....######.. */
	0xce, /* ####....######.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 79 */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x00, /* ................ */

	/* code 80 */
	0xfc, /* ############.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x7c, /* ..##########.... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */

	/* code 81 */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xce, /* ####....######.. */
	0x7c, /* ..##########.... */
	0x0e, /* ........######.. */
	0x00, /* ................ */

	/* code 82 */
	0xfc, /* ############.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x78, /* ..########...... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x66, /* ..####....####.. */
	0xe6, /* ######....####.. */
	0x00, /* ................ */

	/* code 83 */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc0, /* ####............ */
	0x60, /* ..####.......... */
	0x38, /* ....######...... */
	0x0c, /* ........####.... */
	0x06, /* ..........####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 84 */
	0x7e, /* ..############.. */
	0x5a, /* ..##..####..##.. */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 85 */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 86 */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 87 */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xd6, /* ####..##..####.. */
	0xfe, /* ##############.. */
	0xee, /* ######..######.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 88 */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x10, /* ......##........ */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 89 */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 90 */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */
	0x8c, /* ##......####.... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0xc2, /* ####........##.. */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 91 */
	0x1e, /* ......########.. */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x1e, /* ......########.. */
	0x00, /* ................ */

	/* code 92 */
	0x00, /* ................ */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x00, /* ................ */

	/* code 93 */
	0xf0, /* ########........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0xf0, /* ########........ */
	0x00, /* ................ */

	/* code 94 */
	0x10, /* ......##........ */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 95 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */

	/* code 96 */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 97 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0x0c, /* ........####.... */
	0x7c, /* ..##########.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x76, /* ..######..####.. */
	0x00, /* ................ */

	/* code 98 */
	0xe0, /* ######.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x7c, /* ..##########.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0xdc, /* ####..######.... */
	0x00, /* ................ */

	/* code 99 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 100 */
	0x1c, /* ......######.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x7c, /* ..##########.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x76, /* ..######..####.. */
	0x00, /* ................ */

	/* code 101 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 102 */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */

	/* code 103 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x76, /* ..######..####.. */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7c, /* ..##########.... */
	0x0c, /* ........####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */

	/* code 104 */
	0xe0, /* ######.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x6c, /* ..####..####.... */
	0x76, /* ..######..####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0xe6, /* ######....####.. */
	0x00, /* ................ */

	/* code 105 */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x70, /* ..######........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 106 */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x00, /* ................ */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */

	/* code 107 */
	0xe0, /* ######.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x66, /* ..####....####.. */
	0x6c, /* ..####..####.... */
	0x78, /* ..########...... */
	0x78, /* ..########...... */
	0x6c, /* ..####..####.... */
	0xe6, /* ######....####.. */
	0x00, /* ................ */

	/* code 108 */
	0x70, /* ..######........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 109 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0x00, /* ................ */

	/* code 110 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xdc, /* ####..######.... */
	0xe6, /* ######....####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 111 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 112 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xdc, /* ####..######.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x7c, /* ..##########.... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */

	/* code 113 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x76, /* ..######..####.. */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7c, /* ..##########.... */
	0x0c, /* ........####.... */
	0x1e, /* ......########.. */

	/* code 114 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xdc, /* ####..######.... */
	0x76, /* ..######..####.. */
	0x66, /* ..####....####.. */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */

	/* code 115 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0x70, /* ..######........ */
	0x1c, /* ......######.... */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 116 */
	0x20, /* ....##.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xfc, /* ############.... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x00, /* ................ */

	/* code 117 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x76, /* ..######..####.. */
	0x00, /* ................ */

	/* code 118 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x00, /* ................ */

	/* code 119 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0x6c, /* ..####..####.... */
	0x00, /* ................ */

	/* code 120 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 121 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7e, /* ..############.. */
	0x06, /* ..........####.. */
	0x06, /* ..........####.. */
	0xfc, /* ############.... */

	/* code 122 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0x8c, /* ##......####.... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x62, /* ..####......##.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 123 */
	0x0e, /* ........######.. */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x70, /* ..######........ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x0e, /* ........######.. */
	0x00, /* ................ */

	/* code 124 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 125 */
	0xe0, /* ######.......... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x1c, /* ......######.... */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0xe0, /* ######.......... */
	0x00, /* ................ */

	/* code 126 */
	0x76, /* ..######..####.. */
	0xdc, /* ####..######.... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 127 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x10, /* ......##........ */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 128 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 129 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 130 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 131 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */


	/* code 132 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 133 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 134 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 135 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 136 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 137 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 138 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xff, /* ################ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 139 */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 140 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */

	/* code 141 */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */
	0xff, /* ################ */

	/* code 142 */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */
	0xf0, /* ########........ */

	/* code 143 */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */
	0x0f, /* ........######## */

	/* code 144 */
	0x22, /* ....##......##.. */
	0x88, /* ##......##...... */
	0x22, /* ....##......##.. */
	0x88, /* ##......##...... */
	0x22, /* ....##......##.. */
	0x88, /* ##......##...... */
	0x22, /* ....##......##.. */
	0x88, /* ##......##...... */
	0x22, /* ....##......##.. */
	0x88, /* ##......##...... */

	/* code 145 */
	0x55, /* ..##..##..##..## */
	0xaa, /* ##..##..##..##.. */
	0x55, /* ..##..##..##..## */
	0xaa, /* ##..##..##..##.. */
	0x55, /* ..##..##..##..## */
	0xaa, /* ##..##..##..##.. */
	0x55, /* ..##..##..##..## */
	0xaa, /* ##..##..##..##.. */
	0x55, /* ..##..##..##..## */
	0xaa, /* ##..##..##..##.. */

	/* code 146 */
	0xdb, /* ####..####..#### */
	0x77, /* ..######..###### */
	0xdb, /* ####..####..#### */
	0xee, /* ######..######.. */
	0xdb, /* ####..####..#### */
	0x77, /* ..######..###### */
	0xdb, /* ####..####..#### */
	0xee, /* ######..######.. */
	0xdb, /* ####..####..#### */
	0x77, /* ..######..###### */

	/* code 147 */
	0x0e, /* ........######.. */
	0x1b, /* ......####..#### */
	0x1b, /* ......####..#### */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 148 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x3c, /* ....########.... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 149 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 150 */
	0x0f, /* ........######## */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0x0c, /* ........####.... */
	0xec, /* ######..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x34, /* ....####..##.... */
	0x3c, /* ....########.... */
	0x1c, /* ......######.... */

	/* code 151 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x76, /* ..######..####.. */
	0xdc, /* ####..######.... */
	0x00, /* ................ */
	0x76, /* ..######..####.. */
	0xdc, /* ####..######.... */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 152 */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x0c, /* ........####.... */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 153 */
	0x60, /* ..####.......... */
	0x30, /* ....####........ */
	0x18, /* ......####...... */
	0x0c, /* ........####.... */
	0x18, /* ......####...... */
	0x30, /* ....####........ */
	0x60, /* ..####.......... */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 154 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 155 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xd8, /* ####..####...... */
	0xd8, /* ####..####...... */
	0x70, /* ..######........ */

	/* code 156 */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 157 */
	0x70, /* ..######........ */
	0xd8, /* ####..####...... */
	0x18, /* ......####...... */
	0x70, /* ..######........ */
	0xc0, /* ####............ */
	0xf8, /* ##########...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 158 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 159 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0x00, /* ................ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */

	/* code 160 0240 0xa0 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 161 0241 0xa1 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 162 0242 0xa2 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 163 0243 0xa3 */
	0xcc, /* ####....####.... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 164 0244 0xa4 */
#ifdef KOI8_U
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xf0, /* ########........ */
	0xc0, /* ####............ */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */
#else
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x3f, /* ....############ */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
#endif

	/* code 165 0245 0xa5 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x3f, /* ....############ */
	0x30, /* ....####........ */
	0x37, /* ....####..###### */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 166 0246 0xa6 */
#ifdef KOI8_U
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x00, /* ................ */
	0x70, /* ..######........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */
#else
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
#endif

	/* code 167 0247 0xa7 */
#ifdef KOI8_U
	0xd8, /* ####..####...... */
	0xd8, /* ####..####...... */
	0x00, /* ................ */
	0x70, /* ..######........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x30, /* ....####........ */
	0x78, /* ..########...... */
	0x00, /* ................ */
#else
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
#endif

	/* code 168 0250 0xa8 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0x06, /* ..........####.. */
	0xf6, /* ########..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 169 0251 0xa9 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 170 0252 0xaa */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x3f, /* ....############ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 171 0253 0xab */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x37, /* ....####..###### */
	0x30, /* ....####........ */
	0x3f, /* ....############ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 172 0254 0xac */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 173 0255 0xad */
#ifdef KOI8_U
	0x00, /* ................ */
	0x02, /* ............##.. */
	0x06, /* ..........####.. */
	0xfc, /* ############.... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */
#else
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
#endif

	/* code 174 0256 0xae */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xf6, /* ########..####.. */
	0x06, /* ..........####.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 175 0257 0xaf */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x1f, /* ......########## */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 176 0260 0xb0 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x37, /* ....####..###### */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 177 0261 0xb1 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x37, /* ....####..###### */
	0x30, /* ....####........ */
	0x37, /* ....####..###### */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 178 0262 0xb2 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0xf8, /* ##########...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 179 0263 0xb3 */
	0x6c, /* ..####..####.... */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0x62, /* ..####......##.. */
	0x68, /* ..####..##...... */
	0x78, /* ..########...... */
	0x68, /* ..####..##...... */
	0x62, /* ..####......##.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 180 0264 0xb4 */
#ifdef KOI8_U
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xf8, /* ##########...... */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0x66, /* ..####....####.. */
	0x3c, /* ....########.... */
	0x00, /* ................ */
#else
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xf6, /* ########..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
#endif

	/* code 181 0265 0xb5 */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xf6, /* ########..####.. */
	0x06, /* ..........####.. */
	0xf6, /* ########..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 182 0266 0xb6 */
#ifdef KOI8_U
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x00, /* ................ */
#else
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
#endif

	/* code 183 0267 0xb7 */
#ifdef KOI8_U
	0x36, /* ....####..####.. */
	0x00, /* ................ */
	0x3c, /* ....########.... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x00, /* ................ */
#else
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
#endif

	/* code 184 0270 0xb8 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0xf7, /* ########..###### */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 185 0271 0xb9 */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xff, /* ################ */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 186 0272 0xba */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 187 0273 0xbb */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xf7, /* ########..###### */
	0x00, /* ................ */
	0xff, /* ################ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */

	/* code 188 0274 0xbc */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0xff, /* ################ */
	0x18, /* ......####...... */
	0xff, /* ################ */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */

	/* code 189 0275 0xbd */
#ifdef KOI8_U
	0x02, /* ............##.. */
	0xfe, /* ##############.. */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */
#else
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xff, /* ################ */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
#endif

	/* code 190 0276 0xbe */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0xf7, /* ########..###### */
	0x00, /* ................ */
	0xf7, /* ########..###### */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */

	/* code 191 0277 0xbf */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0x9a, /* ##....####..##.. */
	0xa2, /* ##..##......##.. */
	0xa2, /* ##..##......##.. */
	0xa2, /* ##..##......##.. */
	0x9a, /* ##....####..##.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 192 0300 0xc0 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xce, /* ####....######.. */
	0xdb, /* ####..####..#### */
	0xfb, /* ##########..#### */
	0xdb, /* ####..####..#### */
	0xdb, /* ####..####..#### */
	0xce, /* ####....######.. */
	0x00, /* ................ */

	/* code 193 0301 0xc1 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x78, /* ..########...... */
	0x0c, /* ........####.... */
	0x7c, /* ..##########.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x76, /* ..######..####.. */
	0x00, /* ................ */

	/* code 194 0302 0xc2 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x02, /* ............##.. */
	0x7e, /* ..############.. */
	0xc0, /* ####............ */
	0xfc, /* ############.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */


	/* code 195 0303 0xc3 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xfe, /* ##############.. */
	0x06, /* ..........####.. */

	/* code 196 0304 0xc4 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x3c, /* ....########.... */
	0x4c, /* ..##....####.... */
	0x4c, /* ..##....####.... */
	0x4c, /* ..##....####.... */
	0x4c, /* ..##....####.... */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */

	/* code 197 0305 0xc5 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 198 0306 0xc6 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x18, /* ......####...... */
	0x7e, /* ..############.. */
	0xdb, /* ####..####..#### */
	0xdb, /* ####..####..#### */
	0xdb, /* ####..####..#### */
	0xdb, /* ####..####..#### */
	0x7e, /* ..############.. */
	0x18, /* ......####...... */

	/* code 199 0307 0xc7 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0x62, /* ..####......##.. */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */

	/* code 200 0310 0xc8 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 201 0311 0xc9 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x76, /* ..######..####.. */
	0x00, /* ................ */

	/* code 202 0312 0xca */
	0x00, /* ................ */
	0x38, /* ....######...... */
	0x00, /* ................ */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x76, /* ..######..####.. */
	0x00, /* ................ */

	/* code 203 0313 0xcb */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xe6, /* ######....####.. */
	0x6c, /* ..####..####.... */
	0x78, /* ..########...... */
	0x78, /* ..########...... */
	0x6c, /* ..####..####.... */
	0xe6, /* ######....####.. */
	0x00, /* ................ */

	/* code 204 0314 0xcc */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x0e, /* ........######.. */
	0x1e, /* ......########.. */
	0x36, /* ....####..####.. */
	0x66, /* ..####....####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 205 0315 0xcd */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xee, /* ######..######.. */
	0xee, /* ######..######.. */
	0xd6, /* ####..##..####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 206 0316 0xce */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 207 0317 0xcf */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 208 0320 0xd0 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 209 0321 0xd1 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x76, /* ..######..####.. */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x7c, /* ..##########.... */
	0x6c, /* ..####..####.... */
	0xcc, /* ####....####.... */
	0x00, /* ................ */

	/* code 210 0322 0xd2 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xdc, /* ####..######.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x7c, /* ..##########.... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */

	/* code 211 0323 0xd3 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 212 0324 0xd4 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7e, /* ..############.. */
	0x5a, /* ..##..####..##.. */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x00, /* ................ */

	/* code 213 0325 0xd5 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7e, /* ..############.. */
	0x06, /* ..........####.. */
	0x06, /* ..........####.. */
	0xfc, /* ############.... */

	/* code 214 0326 0xd6 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xd6, /* ####..##..####.. */
	0x54, /* ..##..##..##.... */
	0x38, /* ....######...... */
	0x38, /* ....######...... */
	0x54, /* ..##..##..##.... */
	0xd6, /* ####..##..####.. */
	0x00, /* ................ */

	/* code 215 0327 0xd7 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xfc, /* ############.... */
	0xc6, /* ####......####.. */
	0xfc, /* ############.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 216 0330 0xd8 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xfc, /* ############.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 217 0331 0xd9 */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc3, /* ####........#### */
	0xc3, /* ####........#### */
	0xfb, /* ##########..#### */
	0xcd, /* ####....####..## */
	0xcd, /* ####....####..## */
	0xfb, /* ##########..#### */
	0x00, /* ................ */

	/* code 218 0332 0xda */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0x1c, /* ......######.... */
	0x06, /* ..........####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 219 0333 0xdb */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 220 0334 0xdc */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0x1e, /* ......########.. */
	0x06, /* ..........####.. */
	0xc6, /* ####......####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */

	/* code 221 0335 0xdd */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xff, /* ################ */
	0x03, /* ............#### */

	/* code 222 0336 0xde */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7e, /* ..############.. */
	0x06, /* ..........####.. */
	0x06, /* ..........####.. */
	0x00, /* ................ */

	/* code 223 0337 0xdf */
	0x00, /* ................ */
	0x00, /* ................ */
	0x00, /* ................ */
	0xf0, /* ########........ */
	0xb0, /* ##..####........ */
	0x3c, /* ....########.... */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 224 0340 0xe0 */
	0xcc, /* ####....####.... */
	0xd2, /* ####..##....##.. */
	0xb3, /* ##..####....#### */
	0xf3, /* ########....#### */
	0xf3, /* ########....#### */
	0xf3, /* ########....#### */
	0xb3, /* ##..####....#### */
	0xd2, /* ####..##....##.. */
	0xcc, /* ####....####.... */
	0x00, /* ................ */

	/* code 225 0341 0xe1 */
	0x38, /* ....######...... */
	0x7c, /* ..##########.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 226 0342 0xe2 */
	0xfe, /* ##############.. */
	0x62, /* ..####......##.. */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x7c, /* ..##########.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 227 0343 0xe3 */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xfe, /* ##############.. */
	0x06, /* ..........####.. */

	/* code 228 0344 0xe4 */
	0x0c, /* ........####.... */
	0x1c, /* ......######.... */
	0x2c, /* ....##..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */

	/* code 229 0345 0xe5 */
	0xfe, /* ##############.. */
	0x62, /* ..####......##.. */
	0x60, /* ..####.......... */
	0x68, /* ..####..##...... */
	0x78, /* ..########...... */
	0x68, /* ..####..##...... */
	0x60, /* ..####.......... */
	0x62, /* ..####......##.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 230 0346 0xe6 */
	0x7e, /* ..############.. */
	0xdb, /* ####..####..#### */
	0x99, /* ##....####....## */
	0x99, /* ##....####....## */
	0xdb, /* ####..####..#### */
	0x7e, /* ..############.. */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 231 0347 0xe7 */
	0xfe, /* ##############.. */
	0x62, /* ..####......##.. */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */

	/* code 232 0350 0xe8 */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x10, /* ......##........ */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 233 0351 0xe9 */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xce, /* ####....######.. */
	0xce, /* ####....######.. */
	0xde, /* ####..########.. */
	0xf6, /* ########..####.. */
	0xe6, /* ######....####.. */
	0xe6, /* ######....####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 234 0352 0xea */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xce, /* ####....######.. */
	0xce, /* ####....######.. */
	0xde, /* ####..########.. */
	0xf6, /* ########..####.. */
	0xe6, /* ######....####.. */
	0xe6, /* ######....####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 235 0353 0xeb */
	0xe6, /* ######....####.. */
	0x66, /* ..####....####.. */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x78, /* ..########...... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0x66, /* ..####....####.. */
	0xe6, /* ######....####.. */
	0x00, /* ................ */

	/* code 236 0354 0xec */
	0x1e, /* ......########.. */
	0x36, /* ....####..####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 237 0355 0xed */
	0xc6, /* ####......####.. */
	0xee, /* ######..######.. */
	0xfe, /* ##############.. */
	0xfe, /* ##############.. */
	0xd6, /* ####..##..####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 238 0356 0xee */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 239 0357 0xef */
	0x38, /* ....######...... */
	0x6c, /* ..####..####.... */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x6c, /* ..####..####.... */
	0x38, /* ....######...... */
	0x00, /* ................ */

	/* code 240 0360 0xf0 */
	0xfe, /* ##############.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x00, /* ................ */

	/* code 241 0361 0xf1 */
	0x7e, /* ..############.. */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0xcc, /* ####....####.... */
	0x3c, /* ....########.... */
	0x6c, /* ..####..####.... */
	0x6c, /* ..####..####.... */
	0xcc, /* ####....####.... */
	0xce, /* ####....######.. */
	0x00, /* ................ */

	/* code 242 0362 0xf2 */
	0xfc, /* ############.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x7c, /* ..##########.... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0xf0, /* ########........ */
	0x00, /* ................ */

	/* code 243 0363 0xf3 */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0xc0, /* ####............ */
	0x66, /* ..####....####.. */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 244 0364 0xf4 */
	0x7e, /* ..############.. */
	0x5a, /* ..##..####..##.. */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x18, /* ......####...... */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 245 0365 0xf5 */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7e, /* ..############.. */
	0x06, /* ..........####.. */
	0x06, /* ..........####.. */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 246 0366 0xf6 */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0x54, /* ..##..##..##.... */
	0x38, /* ....######...... */
	0x38, /* ....######...... */
	0x54, /* ..##..##..##.... */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0x00, /* ................ */

	/* code 247 0367 0xf7 */
	0xfc, /* ############.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x7c, /* ..##########.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 248 0370 0xf8 */
	0xf0, /* ########........ */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x60, /* ..####.......... */
	0x7c, /* ..##########.... */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0x66, /* ..####....####.. */
	0xfc, /* ############.... */
	0x00, /* ................ */

	/* code 249 0371 0xf9 */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xf6, /* ########..####.. */
	0xda, /* ####..####..##.. */
	0xda, /* ####..####..##.. */
	0xda, /* ####..####..##.. */
	0xf2, /* ########....##.. */
	0x00, /* ................ */

	/* code 250 0372 0xfa */
	0x3c, /* ....########.... */
	0x66, /* ..####....####.. */
	0x06, /* ..........####.. */
	0x06, /* ..........####.. */
	0x1c, /* ......######.... */
	0x06, /* ..........####.. */
	0x06, /* ..........####.. */
	0x66, /* ..####....####.. */
	0x3c, /* ....########.... */
	0x00, /* ................ */

	/* code 251 0373 0xfb */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xfe, /* ##############.. */
	0x00, /* ................ */

	/* code 252 0374 0xfc */
	0x78, /* ..########...... */
	0xcc, /* ####....####.... */
	0x06, /* ..........####.. */
	0x06, /* ..........####.. */
	0x3e, /* ....##########.. */
	0x06, /* ..........####.. */
	0x06, /* ..........####.. */
	0xcc, /* ####....####.... */
	0x78, /* ..########...... */
	0x00, /* ................ */

	/* code 253 0375 0xfd */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xd6, /* ####..##..####.. */
	0xff, /* ################ */
	0x03, /* ............#### */

	/* code 254 0376 0xfe */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0xc6, /* ####......####.. */
	0x7e, /* ..############.. */
	0x06, /* ..........####.. */
	0x06, /* ..........####.. */
	0x06, /* ..........####.. */
	0x00, /* ................ */

	/* code 255 0377 0xff */
	0xf8, /* ##########...... */
	0xb0, /* ##..####........ */
	0xb0, /* ##..####........ */
	0x30, /* ....####........ */
	0x3c, /* ....########.... */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x36, /* ....####..####.. */
	0x7c, /* ..##########.... */
	0x00, /* ................ */
};

#undef _VT220KX8X10
#undef _VT220_KOI8_X_8X10_DATA
#undef _VT220_KOI8_X_8X10_STR
