/*	$OpenBSD: wscons_font8x16.c,v 1.3 2004/06/05 22:54:40 miod Exp $	*/

/*
 *  Copyright (c) 1992, 1993, 1994 Hellmuth Michaelis and Joerg Wunsch
 *  
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. All advertising materials mentioning features or use of this software
 *     must display the following acknowledgement:
 *      This product includes software developed by
 *      Hellmuth Michaelis and Joerg Wunsch
 *  4. The name authors may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 * 
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Translated into compiler and human readable for for the Atari-TT port of
 * NetBSD by Leo Weppelman.
 *
 * Reorganized and edited some chars to fit the iso-8859-1 fontset by 
 * Thomas Gerner
 *
 * Translated to wscons format by Dale Rahn using a program.
 * cleaned up a couple of characters by hand afterword.
 */

#include <sys/types.h>

#include <dev/rcons/raster.h>

static u_int32_t fontdata16_0_pixels[] = {
/* 0x00 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_0 = { 8, 16, 1, 1, fontdata16_0_pixels, 0};

static u_int32_t fontdata16_1_pixels[] = {
/* 0x01 */ 0x00000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x3c000000, 0x7e000000, 0x7e000000, 0xff000000,
	   0xff000000, 0x7e000000, 0x7e000000, 0x3c000000,
	   0x3c000000, 0x18000000, 0x18000000, 0x00000000
};
static struct raster fontdata16_1 = { 8, 16, 1, 1, fontdata16_1_pixels, 0};

static u_int32_t fontdata16_2_pixels[] = {
/* 0x02 */ 0x42000000, 0x99000000, 0x99000000, 0x42000000,
	   0x42000000, 0x99000000, 0x99000000, 0x42000000,
	   0x42000000, 0x99000000, 0x99000000, 0x42000000,
	   0x42000000, 0x99000000, 0x99000000, 0x00000000
};
static struct raster fontdata16_2 = { 8, 16, 1, 1, fontdata16_2_pixels, 0};

static u_int32_t fontdata16_3_pixels[] = {
/* 0x03 */ 0x00000000, 0x00000000, 0x90000000, 0x90000000,
	   0xf0000000, 0x90000000, 0x90000000, 0x00000000,
	   0x3e000000, 0x08000000, 0x08000000, 0x08000000,
	   0x08000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_3 = { 8, 16, 1, 1, fontdata16_3_pixels, 0};

static u_int32_t fontdata16_4_pixels[] = {
/* 0x04 */ 0x00000000, 0x00000000, 0xf0000000, 0x80000000,
	   0xe0000000, 0x80000000, 0x80000000, 0x00000000,
	   0x1e000000, 0x10000000, 0x1c000000, 0x10000000,
	   0x10000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_4 = { 8, 16, 1, 1, fontdata16_4_pixels, 0};

static u_int32_t fontdata16_5_pixels[] = {
/* 0x05 */ 0x00000000, 0x00000000, 0x60000000, 0x90000000,
	   0x80000000, 0x90000000, 0x60000000, 0x00000000,
	   0x1c000000, 0x12000000, 0x1c000000, 0x12000000,
	   0x12000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_5 = { 8, 16, 1, 1, fontdata16_5_pixels, 0};

static u_int32_t fontdata16_6_pixels[] = {
/* 0x06 */ 0x00000000, 0x00000000, 0x80000000, 0x80000000,
	   0x80000000, 0x80000000, 0xf0000000, 0x00000000,
	   0x1e000000, 0x10000000, 0x1c000000, 0x10000000,
	   0x10000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_6 = { 8, 16, 1, 1, fontdata16_6_pixels, 0};

static u_int32_t fontdata16_7_pixels[] = {
/* 0x07 */ 0x00000000, 0x38000000, 0x6c000000, 0x6c000000,
	   0x38000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_7 = { 8, 16, 1, 1, fontdata16_7_pixels, 0};

static u_int32_t fontdata16_8_pixels[] = {
/* 0x08 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x18000000, 0x18000000, 0x7e000000, 0x18000000,
	   0x18000000, 0x00000000, 0x00000000, 0xff000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_8 = { 8, 16, 1, 1, fontdata16_8_pixels, 0};

static u_int32_t fontdata16_9_pixels[] = {
/* 0x09 */ 0x00000000, 0x00000000, 0x88000000, 0x98000000,
	   0xa8000000, 0xc8000000, 0x88000000, 0x00000000,
	   0x10000000, 0x10000000, 0x10000000, 0x10000000,
	   0x1e000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_9 = { 8, 16, 1, 1, fontdata16_9_pixels, 0};

static u_int32_t fontdata16_10_pixels[] = {
/* 0x0a */ 0x00000000, 0x00000000, 0x88000000, 0x88000000,
	   0x50000000, 0x50000000, 0x20000000, 0x00000000,
	   0x3e000000, 0x08000000, 0x08000000, 0x08000000,
	   0x08000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_10 = { 8, 16, 1, 1, fontdata16_10_pixels, 0};

static u_int32_t fontdata16_11_pixels[] = {
/* 0x0b */ 0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0xf8000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_11 = { 8, 16, 1, 1, fontdata16_11_pixels, 0};

static u_int32_t fontdata16_12_pixels[] = {
/* 0x0c */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0xf8000000,
	   0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x00000000
};
static struct raster fontdata16_12 = { 8, 16, 1, 1, fontdata16_12_pixels, 0};

static u_int32_t fontdata16_13_pixels[] = {
/* 0x0d */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x1f000000,
	   0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x00000000
};
static struct raster fontdata16_13 = { 8, 16, 1, 1, fontdata16_13_pixels, 0};

static u_int32_t fontdata16_14_pixels[] = {
/* 0x0e */ 0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x1f000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_14 = { 8, 16, 1, 1, fontdata16_14_pixels, 0};

static u_int32_t fontdata16_15_pixels[] = {
/* 0x0f */ 0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0xff000000,
	   0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x00000000
};
static struct raster fontdata16_15 = { 8, 16, 1, 1, fontdata16_15_pixels, 0};

static u_int32_t fontdata16_16_pixels[] = {
/* 0x10 */ 0xff000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_16 = { 8, 16, 1, 1, fontdata16_16_pixels, 0};

static u_int32_t fontdata16_17_pixels[] = {
/* 0x11 */ 0x00000000, 0x00000000, 0x00000000, 0xff000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_17 = { 8, 16, 1, 1, fontdata16_17_pixels, 0};

static u_int32_t fontdata16_18_pixels[] = {
/* 0x12 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0xff000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_18 = { 8, 16, 1, 1, fontdata16_18_pixels, 0};

static u_int32_t fontdata16_19_pixels[] = {
/* 0x13 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0xff000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_19 = { 8, 16, 1, 1, fontdata16_19_pixels, 0};

static u_int32_t fontdata16_20_pixels[] = {
/* 0x14 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_20 = { 8, 16, 1, 1, fontdata16_20_pixels, 0};

static u_int32_t fontdata16_21_pixels[] = {
/* 0x15 */ 0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x1f000000,
	   0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x00000000
};
static struct raster fontdata16_21 = { 8, 16, 1, 1, fontdata16_21_pixels, 0};

static u_int32_t fontdata16_22_pixels[] = {
/* 0x16 */ 0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0xf8000000,
	   0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x00000000
};
static struct raster fontdata16_22 = { 8, 16, 1, 1, fontdata16_22_pixels, 0};

static u_int32_t fontdata16_23_pixels[] = {
/* 0x17 */ 0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0xff000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_23 = { 8, 16, 1, 1, fontdata16_23_pixels, 0};

static u_int32_t fontdata16_24_pixels[] = {
/* 0x18 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0xff000000,
	   0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x00000000
};
static struct raster fontdata16_24 = { 8, 16, 1, 1, fontdata16_24_pixels, 0};

static u_int32_t fontdata16_25_pixels[] = {
/* 0x19 */ 0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x00000000
};
static struct raster fontdata16_25 = { 8, 16, 1, 1, fontdata16_25_pixels, 0};

static u_int32_t fontdata16_26_pixels[] = {
/* 0x1a */ 0x00000000, 0x00000000, 0x0c000000, 0x18000000,
	   0x30000000, 0x60000000, 0x30000000, 0x18000000,
	   0x0c000000, 0x00000000, 0x7e000000, 0x00000000,
	   0x7e000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_26 = { 8, 16, 1, 1, fontdata16_26_pixels, 0};

static u_int32_t fontdata16_27_pixels[] = {
/* 0x1b */ 0x00000000, 0x00000000, 0x30000000, 0x18000000,
	   0x0c000000, 0x06000000, 0x0c000000, 0x18000000,
	   0x30000000, 0x00000000, 0x7e000000, 0x00000000,
	   0x7e000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_27 = { 8, 16, 1, 1, fontdata16_27_pixels, 0};

static u_int32_t fontdata16_28_pixels[] = {
/* 0x1c */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0xfe000000, 0x6c000000, 0x6c000000, 0x6c000000,
	   0x6c000000, 0x6c000000, 0x6c000000, 0x6c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_28 = { 8, 16, 1, 1, fontdata16_28_pixels, 0};

static u_int32_t fontdata16_29_pixels[] = {
/* 0x1d */ 0x00000000, 0x00000000, 0x00000000, 0x18000000,
	   0x18000000, 0x7e000000, 0x18000000, 0x18000000,
	   0x7e000000, 0x18000000, 0x18000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_29 = { 8, 16, 1, 1, fontdata16_29_pixels, 0};

static u_int32_t fontdata16_30_pixels[] = {
/* 0x1e */ 0x00000000, 0x38000000, 0x6c000000, 0x64000000,
	   0x60000000, 0xf0000000, 0x60000000, 0x60000000,
	   0x60000000, 0x60000000, 0xe6000000, 0xfc000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_30 = { 8, 16, 1, 1, fontdata16_30_pixels, 0};

static u_int32_t fontdata16_31_pixels[] = {
/* 0x1f */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x18000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_31 = { 8, 16, 1, 1, fontdata16_31_pixels, 0};

static u_int32_t fontdata16_32_pixels[] = {
/* 0x20 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_32 = { 8, 16, 1, 1, fontdata16_32_pixels, 0};

static u_int32_t fontdata16_33_pixels[] = {
/* 0x21 */ 0x00000000, 0x00000000, 0x18000000, 0x3c000000,
	   0x3c000000, 0x3c000000, 0x18000000, 0x18000000,
	   0x18000000, 0x00000000, 0x18000000, 0x18000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_33 = { 8, 16, 1, 1, fontdata16_33_pixels, 0};

static u_int32_t fontdata16_34_pixels[] = {
/* 0x22 */ 0x00000000, 0x66000000, 0x66000000, 0x66000000,
	   0x24000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_34 = { 8, 16, 1, 1, fontdata16_34_pixels, 0};

static u_int32_t fontdata16_35_pixels[] = {
/* 0x23 */ 0x00000000, 0x00000000, 0x00000000, 0x6c000000,
	   0x6c000000, 0xfe000000, 0x6c000000, 0x6c000000,
	   0x6c000000, 0xfe000000, 0x6c000000, 0x6c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_35 = { 8, 16, 1, 1, fontdata16_35_pixels, 0};

static u_int32_t fontdata16_36_pixels[] = {
/* 0x24 */ 0x00000000, 0x18000000, 0x18000000, 0x7c000000,
	   0xc6000000, 0xc2000000, 0xc0000000, 0x7c000000,
	   0x06000000, 0x86000000, 0xc6000000, 0x7c000000,
	   0x18000000, 0x18000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_36 = { 8, 16, 1, 1, fontdata16_36_pixels, 0};

static u_int32_t fontdata16_37_pixels[] = {
/* 0x25 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0xc2000000, 0xc6000000, 0x0c000000, 0x18000000,
	   0x30000000, 0x60000000, 0xc6000000, 0x86000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_37 = { 8, 16, 1, 1, fontdata16_37_pixels, 0};

static u_int32_t fontdata16_38_pixels[] = {
/* 0x26 */ 0x00000000, 0x00000000, 0x38000000, 0x6c000000,
	   0x6c000000, 0x38000000, 0x76000000, 0xdc000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_38 = { 8, 16, 1, 1, fontdata16_38_pixels, 0};

static u_int32_t fontdata16_39_pixels[] = {
/* 0x27 */ 0x00000000, 0x30000000, 0x30000000, 0x30000000,
	   0x60000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_39 = { 8, 16, 1, 1, fontdata16_39_pixels, 0};

static u_int32_t fontdata16_40_pixels[] = {
/* 0x28 */ 0x00000000, 0x00000000, 0x0c000000, 0x18000000,
	   0x30000000, 0x30000000, 0x30000000, 0x30000000,
	   0x30000000, 0x30000000, 0x18000000, 0x0c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_40 = { 8, 16, 1, 1, fontdata16_40_pixels, 0};

static u_int32_t fontdata16_41_pixels[] = {
/* 0x29 */ 0x00000000, 0x00000000, 0x30000000, 0x18000000,
	   0x0c000000, 0x0c000000, 0x0c000000, 0x0c000000,
	   0x0c000000, 0x0c000000, 0x18000000, 0x30000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_41 = { 8, 16, 1, 1, fontdata16_41_pixels, 0};

static u_int32_t fontdata16_42_pixels[] = {
/* 0x2a */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x66000000, 0x3c000000, 0xff000000,
	   0x3c000000, 0x66000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_42 = { 8, 16, 1, 1, fontdata16_42_pixels, 0};

static u_int32_t fontdata16_43_pixels[] = {
/* 0x2b */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x18000000, 0x18000000, 0x7e000000,
	   0x18000000, 0x18000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_43 = { 8, 16, 1, 1, fontdata16_43_pixels, 0};

static u_int32_t fontdata16_44_pixels[] = {
/* 0x2c */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x18000000, 0x18000000, 0x18000000,
	   0x30000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_44 = { 8, 16, 1, 1, fontdata16_44_pixels, 0};

static u_int32_t fontdata16_45_pixels[] = {
/* 0x2d */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x7e000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_45 = { 8, 16, 1, 1, fontdata16_45_pixels, 0};

static u_int32_t fontdata16_46_pixels[] = {
/* 0x2e */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x18000000, 0x18000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_46 = { 8, 16, 1, 1, fontdata16_46_pixels, 0};

static u_int32_t fontdata16_47_pixels[] = {
/* 0x2f */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x02000000, 0x06000000, 0x0c000000, 0x18000000,
	   0x30000000, 0x60000000, 0xc0000000, 0x80000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_47 = { 8, 16, 1, 1, fontdata16_47_pixels, 0};

static u_int32_t fontdata16_48_pixels[] = {
/* 0x30 */ 0x00000000, 0x00000000, 0x7c000000, 0xc6000000,
	   0xc6000000, 0xce000000, 0xde000000, 0xf6000000,
	   0xe6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_48 = { 8, 16, 1, 1, fontdata16_48_pixels, 0};

static u_int32_t fontdata16_49_pixels[] = {
/* 0x31 */ 0x00000000, 0x00000000, 0x18000000, 0x38000000,
	   0x78000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x7e000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_49 = { 8, 16, 1, 1, fontdata16_49_pixels, 0};

static u_int32_t fontdata16_50_pixels[] = {
/* 0x32 */ 0x00000000, 0x00000000, 0x7c000000, 0xc6000000,
	   0x06000000, 0x0c000000, 0x18000000, 0x30000000,
	   0x60000000, 0xc0000000, 0xc6000000, 0xfe000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_50 = { 8, 16, 1, 1, fontdata16_50_pixels, 0};

static u_int32_t fontdata16_51_pixels[] = {
/* 0x33 */ 0x00000000, 0x00000000, 0x7c000000, 0xc6000000,
	   0x06000000, 0x06000000, 0x3c000000, 0x06000000,
	   0x06000000, 0x06000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_51 = { 8, 16, 1, 1, fontdata16_51_pixels, 0};

static u_int32_t fontdata16_52_pixels[] = {
/* 0x34 */ 0x00000000, 0x00000000, 0x0c000000, 0x1c000000,
	   0x3c000000, 0x6c000000, 0xcc000000, 0xfe000000,
	   0x0c000000, 0x0c000000, 0x0c000000, 0x1e000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_52 = { 8, 16, 1, 1, fontdata16_52_pixels, 0};

static u_int32_t fontdata16_53_pixels[] = {
/* 0x35 */ 0x00000000, 0x00000000, 0xfe000000, 0xc0000000,
	   0xc0000000, 0xc0000000, 0xfc000000, 0x06000000,
	   0x06000000, 0x06000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_53 = { 8, 16, 1, 1, fontdata16_53_pixels, 0};

static u_int32_t fontdata16_54_pixels[] = {
/* 0x36 */ 0x00000000, 0x00000000, 0x38000000, 0x60000000,
	   0xc0000000, 0xc0000000, 0xfc000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_54 = { 8, 16, 1, 1, fontdata16_54_pixels, 0};

static u_int32_t fontdata16_55_pixels[] = {
/* 0x37 */ 0x00000000, 0x00000000, 0xfe000000, 0xc6000000,
	   0x06000000, 0x06000000, 0x0c000000, 0x18000000,
	   0x30000000, 0x30000000, 0x30000000, 0x30000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_55 = { 8, 16, 1, 1, fontdata16_55_pixels, 0};

static u_int32_t fontdata16_56_pixels[] = {
/* 0x38 */ 0x00000000, 0x00000000, 0x7c000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0x7c000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_56 = { 8, 16, 1, 1, fontdata16_56_pixels, 0};

static u_int32_t fontdata16_57_pixels[] = {
/* 0x39 */ 0x00000000, 0x00000000, 0x7c000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0x7e000000, 0x06000000,
	   0x06000000, 0x06000000, 0x0c000000, 0x78000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_57 = { 8, 16, 1, 1, fontdata16_57_pixels, 0};

static u_int32_t fontdata16_58_pixels[] = {
/* 0x3a */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x18000000, 0x18000000, 0x00000000, 0x00000000,
	   0x00000000, 0x18000000, 0x18000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_58 = { 8, 16, 1, 1, fontdata16_58_pixels, 0};

static u_int32_t fontdata16_59_pixels[] = {
/* 0x3b */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x18000000, 0x18000000, 0x00000000, 0x00000000,
	   0x00000000, 0x18000000, 0x18000000, 0x30000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_59 = { 8, 16, 1, 1, fontdata16_59_pixels, 0};

static u_int32_t fontdata16_60_pixels[] = {
/* 0x3c */ 0x00000000, 0x00000000, 0x00000000, 0x06000000,
	   0x0c000000, 0x18000000, 0x30000000, 0x60000000,
	   0x30000000, 0x18000000, 0x0c000000, 0x06000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_60 = { 8, 16, 1, 1, fontdata16_60_pixels, 0};

static u_int32_t fontdata16_61_pixels[] = {
/* 0x3d */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x7e000000, 0x00000000, 0x00000000,
	   0x7e000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_61 = { 8, 16, 1, 1, fontdata16_61_pixels, 0};

static u_int32_t fontdata16_62_pixels[] = {
/* 0x3e */ 0x00000000, 0x00000000, 0x00000000, 0x60000000,
	   0x30000000, 0x18000000, 0x0c000000, 0x06000000,
	   0x0c000000, 0x18000000, 0x30000000, 0x60000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_62 = { 8, 16, 1, 1, fontdata16_62_pixels, 0};

static u_int32_t fontdata16_63_pixels[] = {
/* 0x3f */ 0x00000000, 0x00000000, 0x7c000000, 0xc6000000,
	   0xc6000000, 0x0c000000, 0x18000000, 0x18000000,
	   0x18000000, 0x00000000, 0x18000000, 0x18000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_63 = { 8, 16, 1, 1, fontdata16_63_pixels, 0};

static u_int32_t fontdata16_64_pixels[] = {
/* 0x40 */ 0x00000000, 0x00000000, 0x7c000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xde000000, 0xde000000,
	   0xde000000, 0xdc000000, 0xc0000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_64 = { 8, 16, 1, 1, fontdata16_64_pixels, 0};

static u_int32_t fontdata16_65_pixels[] = {
/* 0x41 */ 0x00000000, 0x00000000, 0x10000000, 0x38000000,
	   0x6c000000, 0xc6000000, 0xc6000000, 0xfe000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_65 = { 8, 16, 1, 1, fontdata16_65_pixels, 0};

static u_int32_t fontdata16_66_pixels[] = {
/* 0x42 */ 0x00000000, 0x00000000, 0xfc000000, 0x66000000,
	   0x66000000, 0x66000000, 0x7c000000, 0x66000000,
	   0x66000000, 0x66000000, 0x66000000, 0xfc000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_66 = { 8, 16, 1, 1, fontdata16_66_pixels, 0};

static u_int32_t fontdata16_67_pixels[] = {
/* 0x43 */ 0x00000000, 0x00000000, 0x3c000000, 0x66000000,
	   0xc2000000, 0xc0000000, 0xc0000000, 0xc0000000,
	   0xc0000000, 0xc2000000, 0x66000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_67 = { 8, 16, 1, 1, fontdata16_67_pixels, 0};

static u_int32_t fontdata16_68_pixels[] = {
/* 0x44 */ 0x00000000, 0x00000000, 0xf8000000, 0x6c000000,
	   0x66000000, 0x66000000, 0x66000000, 0x66000000,
	   0x66000000, 0x66000000, 0x6c000000, 0xf8000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_68 = { 8, 16, 1, 1, fontdata16_68_pixels, 0};

static u_int32_t fontdata16_69_pixels[] = {
/* 0x45 */ 0x00000000, 0x00000000, 0xfe000000, 0x66000000,
	   0x62000000, 0x68000000, 0x78000000, 0x68000000,
	   0x60000000, 0x62000000, 0x66000000, 0xfe000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_69 = { 8, 16, 1, 1, fontdata16_69_pixels, 0};

static u_int32_t fontdata16_70_pixels[] = {
/* 0x46 */ 0x00000000, 0x00000000, 0xfe000000, 0x66000000,
	   0x62000000, 0x68000000, 0x78000000, 0x68000000,
	   0x60000000, 0x60000000, 0x60000000, 0xf0000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_70 = { 8, 16, 1, 1, fontdata16_70_pixels, 0};

static u_int32_t fontdata16_71_pixels[] = {
/* 0x47 */ 0x00000000, 0x00000000, 0x3c000000, 0x66000000,
	   0xc2000000, 0xc0000000, 0xc0000000, 0xde000000,
	   0xc6000000, 0xc6000000, 0x66000000, 0x3a000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_71 = { 8, 16, 1, 1, fontdata16_71_pixels, 0};

static u_int32_t fontdata16_72_pixels[] = {
/* 0x48 */ 0x00000000, 0x00000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xfe000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_72 = { 8, 16, 1, 1, fontdata16_72_pixels, 0};

static u_int32_t fontdata16_73_pixels[] = {
/* 0x49 */ 0x00000000, 0x00000000, 0x3c000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_73 = { 8, 16, 1, 1, fontdata16_73_pixels, 0};

static u_int32_t fontdata16_74_pixels[] = {
/* 0x4a */ 0x00000000, 0x00000000, 0x1e000000, 0x0c000000,
	   0x0c000000, 0x0c000000, 0x0c000000, 0x0c000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x78000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_74 = { 8, 16, 1, 1, fontdata16_74_pixels, 0};

static u_int32_t fontdata16_75_pixels[] = {
/* 0x4b */ 0x00000000, 0x00000000, 0xe6000000, 0x66000000,
	   0x66000000, 0x6c000000, 0x78000000, 0x78000000,
	   0x6c000000, 0x66000000, 0x66000000, 0xe6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_75 = { 8, 16, 1, 1, fontdata16_75_pixels, 0};

static u_int32_t fontdata16_76_pixels[] = {
/* 0x4c */ 0x00000000, 0x00000000, 0xf0000000, 0x60000000,
	   0x60000000, 0x60000000, 0x60000000, 0x60000000,
	   0x60000000, 0x62000000, 0x66000000, 0xfe000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_76 = { 8, 16, 1, 1, fontdata16_76_pixels, 0};

static u_int32_t fontdata16_77_pixels[] = {
/* 0x4d */ 0x00000000, 0x00000000, 0xc6000000, 0xee000000,
	   0xfe000000, 0xfe000000, 0xd6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_77 = { 8, 16, 1, 1, fontdata16_77_pixels, 0};

static u_int32_t fontdata16_78_pixels[] = {
/* 0x4e */ 0x00000000, 0x00000000, 0xc6000000, 0xe6000000,
	   0xf6000000, 0xfe000000, 0xde000000, 0xce000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_78 = { 8, 16, 1, 1, fontdata16_78_pixels, 0};

static u_int32_t fontdata16_79_pixels[] = {
/* 0x4f */ 0x00000000, 0x00000000, 0x7c000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_79 = { 8, 16, 1, 1, fontdata16_79_pixels, 0};

static u_int32_t fontdata16_80_pixels[] = {
/* 0x50 */ 0x00000000, 0x00000000, 0xfc000000, 0x66000000,
	   0x66000000, 0x66000000, 0x7c000000, 0x60000000,
	   0x60000000, 0x60000000, 0x60000000, 0xf0000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_80 = { 8, 16, 1, 1, fontdata16_80_pixels, 0};

static u_int32_t fontdata16_81_pixels[] = {
/* 0x51 */ 0x00000000, 0x00000000, 0x7c000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xd6000000, 0xde000000, 0x7c000000,
	   0x0c000000, 0x0e000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_81 = { 8, 16, 1, 1, fontdata16_81_pixels, 0};

static u_int32_t fontdata16_82_pixels[] = {
/* 0x52 */ 0x00000000, 0x00000000, 0xfc000000, 0x66000000,
	   0x66000000, 0x66000000, 0x7c000000, 0x6c000000,
	   0x66000000, 0x66000000, 0x66000000, 0xe6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_82 = { 8, 16, 1, 1, fontdata16_82_pixels, 0};

static u_int32_t fontdata16_83_pixels[] = {
/* 0x53 */ 0x00000000, 0x00000000, 0x7c000000, 0xc6000000,
	   0xc6000000, 0x60000000, 0x38000000, 0x0c000000,
	   0x06000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_83 = { 8, 16, 1, 1, fontdata16_83_pixels, 0};

static u_int32_t fontdata16_84_pixels[] = {
/* 0x54 */ 0x00000000, 0x00000000, 0x7e000000, 0x7e000000,
	   0x5a000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_84 = { 8, 16, 1, 1, fontdata16_84_pixels, 0};

static u_int32_t fontdata16_85_pixels[] = {
/* 0x55 */ 0x00000000, 0x00000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_85 = { 8, 16, 1, 1, fontdata16_85_pixels, 0};

static u_int32_t fontdata16_86_pixels[] = {
/* 0x56 */ 0x00000000, 0x00000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0x6c000000, 0x38000000, 0x10000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_86 = { 8, 16, 1, 1, fontdata16_86_pixels, 0};

static u_int32_t fontdata16_87_pixels[] = {
/* 0x57 */ 0x00000000, 0x00000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xd6000000, 0xd6000000,
	   0xd6000000, 0xfe000000, 0xee000000, 0x6c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_87 = { 8, 16, 1, 1, fontdata16_87_pixels, 0};

static u_int32_t fontdata16_88_pixels[] = {
/* 0x58 */ 0x00000000, 0x00000000, 0xc6000000, 0xc6000000,
	   0x6c000000, 0x7c000000, 0x38000000, 0x38000000,
	   0x7c000000, 0x6c000000, 0xc6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_88 = { 8, 16, 1, 1, fontdata16_88_pixels, 0};

static u_int32_t fontdata16_89_pixels[] = {
/* 0x59 */ 0x00000000, 0x00000000, 0x66000000, 0x66000000,
	   0x66000000, 0x66000000, 0x3c000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_89 = { 8, 16, 1, 1, fontdata16_89_pixels, 0};

static u_int32_t fontdata16_90_pixels[] = {
/* 0x5a */ 0x00000000, 0x00000000, 0xfe000000, 0xc6000000,
	   0x86000000, 0x0c000000, 0x18000000, 0x30000000,
	   0x60000000, 0xc2000000, 0xc6000000, 0xfe000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_90 = { 8, 16, 1, 1, fontdata16_90_pixels, 0};

static u_int32_t fontdata16_91_pixels[] = {
/* 0x5b */ 0x00000000, 0x00000000, 0x3c000000, 0x30000000,
	   0x30000000, 0x30000000, 0x30000000, 0x30000000,
	   0x30000000, 0x30000000, 0x30000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_91 = { 8, 16, 1, 1, fontdata16_91_pixels, 0};

static u_int32_t fontdata16_92_pixels[] = {
/* 0x5c */ 0x00000000, 0x00000000, 0x00000000, 0x80000000,
	   0xc0000000, 0xe0000000, 0x70000000, 0x38000000,
	   0x1c000000, 0x0e000000, 0x06000000, 0x02000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_92 = { 8, 16, 1, 1, fontdata16_92_pixels, 0};

static u_int32_t fontdata16_93_pixels[] = {
/* 0x5d */ 0x00000000, 0x00000000, 0x3c000000, 0x0c000000,
	   0x0c000000, 0x0c000000, 0x0c000000, 0x0c000000,
	   0x0c000000, 0x0c000000, 0x0c000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_93 = { 8, 16, 1, 1, fontdata16_93_pixels, 0};

static u_int32_t fontdata16_94_pixels[] = {
/* 0x5e */ 0x10000000, 0x38000000, 0x6c000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_94 = { 8, 16, 1, 1, fontdata16_94_pixels, 0};

static u_int32_t fontdata16_95_pixels[] = {
/* 0x5f */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0xff000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_95 = { 8, 16, 1, 1, fontdata16_95_pixels, 0};

static u_int32_t fontdata16_96_pixels[] = {
/* 0x60 */ 0x30000000, 0x30000000, 0x18000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_96 = { 8, 16, 1, 1, fontdata16_96_pixels, 0};

static u_int32_t fontdata16_97_pixels[] = {
/* 0x61 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x78000000, 0x0c000000, 0x7c000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_97 = { 8, 16, 1, 1, fontdata16_97_pixels, 0};

static u_int32_t fontdata16_98_pixels[] = {
/* 0x62 */ 0x00000000, 0x00000000, 0xe0000000, 0x60000000,
	   0x60000000, 0x78000000, 0x6c000000, 0x66000000,
	   0x66000000, 0x66000000, 0x66000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_98 = { 8, 16, 1, 1, fontdata16_98_pixels, 0};

static u_int32_t fontdata16_99_pixels[] = {
/* 0x63 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0xc0000000,
	   0xc0000000, 0xc0000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_99 = { 8, 16, 1, 1, fontdata16_99_pixels, 0};

static u_int32_t fontdata16_100_pixels[] = {
/* 0x64 */ 0x00000000, 0x00000000, 0x1c000000, 0x0c000000,
	   0x0c000000, 0x3c000000, 0x6c000000, 0xcc000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_100 = { 8, 16, 1, 1, fontdata16_100_pixels, 0};

static u_int32_t fontdata16_101_pixels[] = {
/* 0x65 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0xfe000000,
	   0xc0000000, 0xc0000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_101 = { 8, 16, 1, 1, fontdata16_101_pixels, 0};

static u_int32_t fontdata16_102_pixels[] = {
/* 0x66 */ 0x00000000, 0x00000000, 0x38000000, 0x6c000000,
	   0x64000000, 0x60000000, 0xf0000000, 0x60000000,
	   0x60000000, 0x60000000, 0x60000000, 0xf0000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_102 = { 8, 16, 1, 1, fontdata16_102_pixels, 0};

static u_int32_t fontdata16_103_pixels[] = {
/* 0x67 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x76000000, 0xcc000000, 0xcc000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x7c000000,
	   0x0c000000, 0xcc000000, 0x78000000, 0x00000000
};
static struct raster fontdata16_103 = { 8, 16, 1, 1, fontdata16_103_pixels, 0};

static u_int32_t fontdata16_104_pixels[] = {
/* 0x68 */ 0x00000000, 0x00000000, 0xe0000000, 0x60000000,
	   0x60000000, 0x6c000000, 0x76000000, 0x66000000,
	   0x66000000, 0x66000000, 0x66000000, 0xe6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_104 = { 8, 16, 1, 1, fontdata16_104_pixels, 0};

static u_int32_t fontdata16_105_pixels[] = {
/* 0x69 */ 0x00000000, 0x00000000, 0x18000000, 0x18000000,
	   0x00000000, 0x38000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_105 = { 8, 16, 1, 1, fontdata16_105_pixels, 0};

static u_int32_t fontdata16_106_pixels[] = {
/* 0x6a */ 0x00000000, 0x00000000, 0x06000000, 0x06000000,
	   0x00000000, 0x0e000000, 0x06000000, 0x06000000,
	   0x06000000, 0x06000000, 0x06000000, 0x06000000,
	   0x66000000, 0x66000000, 0x3c000000, 0x00000000
};
static struct raster fontdata16_106 = { 8, 16, 1, 1, fontdata16_106_pixels, 0};

static u_int32_t fontdata16_107_pixels[] = {
/* 0x6b */ 0x00000000, 0x00000000, 0xe0000000, 0x60000000,
	   0x60000000, 0x66000000, 0x6c000000, 0x78000000,
	   0x78000000, 0x6c000000, 0x66000000, 0xe6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_107 = { 8, 16, 1, 1, fontdata16_107_pixels, 0};

static u_int32_t fontdata16_108_pixels[] = {
/* 0x6c */ 0x00000000, 0x00000000, 0x38000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_108 = { 8, 16, 1, 1, fontdata16_108_pixels, 0};

static u_int32_t fontdata16_109_pixels[] = {
/* 0x6d */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0xec000000, 0xfe000000, 0xd6000000,
	   0xd6000000, 0xd6000000, 0xd6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_109 = { 8, 16, 1, 1, fontdata16_109_pixels, 0};

static u_int32_t fontdata16_110_pixels[] = {
/* 0x6e */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0xdc000000, 0x66000000, 0x66000000,
	   0x66000000, 0x66000000, 0x66000000, 0x66000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_110 = { 8, 16, 1, 1, fontdata16_110_pixels, 0};

static u_int32_t fontdata16_111_pixels[] = {
/* 0x6f */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_111 = { 8, 16, 1, 1, fontdata16_111_pixels, 0};

static u_int32_t fontdata16_112_pixels[] = {
/* 0x70 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0xdc000000, 0x66000000, 0x66000000,
	   0x66000000, 0x66000000, 0x66000000, 0x7c000000,
	   0x60000000, 0x60000000, 0xf0000000, 0x00000000
};
static struct raster fontdata16_112 = { 8, 16, 1, 1, fontdata16_112_pixels, 0};

static u_int32_t fontdata16_113_pixels[] = {
/* 0x71 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x76000000, 0xcc000000, 0xcc000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x7c000000,
	   0x0c000000, 0x0c000000, 0x1e000000, 0x00000000
};
static struct raster fontdata16_113 = { 8, 16, 1, 1, fontdata16_113_pixels, 0};

static u_int32_t fontdata16_114_pixels[] = {
/* 0x72 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0xdc000000, 0x76000000, 0x66000000,
	   0x60000000, 0x60000000, 0x60000000, 0xf0000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_114 = { 8, 16, 1, 1, fontdata16_114_pixels, 0};

static u_int32_t fontdata16_115_pixels[] = {
/* 0x73 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0x60000000,
	   0x38000000, 0x0c000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_115 = { 8, 16, 1, 1, fontdata16_115_pixels, 0};

static u_int32_t fontdata16_116_pixels[] = {
/* 0x74 */ 0x00000000, 0x00000000, 0x10000000, 0x30000000,
	   0x30000000, 0xfc000000, 0x30000000, 0x30000000,
	   0x30000000, 0x30000000, 0x36000000, 0x1c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_116 = { 8, 16, 1, 1, fontdata16_116_pixels, 0};

static u_int32_t fontdata16_117_pixels[] = {
/* 0x75 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0xcc000000, 0xcc000000, 0xcc000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_117 = { 8, 16, 1, 1, fontdata16_117_pixels, 0};

static u_int32_t fontdata16_118_pixels[] = {
/* 0x76 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0x6c000000, 0x38000000, 0x10000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_118 = { 8, 16, 1, 1, fontdata16_118_pixels, 0};

static u_int32_t fontdata16_119_pixels[] = {
/* 0x77 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0xc6000000, 0xc6000000, 0xd6000000,
	   0xd6000000, 0xd6000000, 0xfe000000, 0x6c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_119 = { 8, 16, 1, 1, fontdata16_119_pixels, 0};

static u_int32_t fontdata16_120_pixels[] = {
/* 0x78 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0xc6000000, 0x6c000000, 0x38000000,
	   0x38000000, 0x38000000, 0x6c000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_120 = { 8, 16, 1, 1, fontdata16_120_pixels, 0};

static u_int32_t fontdata16_121_pixels[] = {
/* 0x79 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7e000000,
	   0x06000000, 0x0c000000, 0xf8000000, 0x00000000
};
static struct raster fontdata16_121 = { 8, 16, 1, 1, fontdata16_121_pixels, 0};

static u_int32_t fontdata16_122_pixels[] = {
/* 0x7a */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0xfe000000, 0xcc000000, 0x18000000,
	   0x30000000, 0x60000000, 0xc6000000, 0xfe000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_122 = { 8, 16, 1, 1, fontdata16_122_pixels, 0};

static u_int32_t fontdata16_123_pixels[] = {
/* 0x7b */ 0x00000000, 0x00000000, 0x0e000000, 0x18000000,
	   0x18000000, 0x18000000, 0x70000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x0e000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_123 = { 8, 16, 1, 1, fontdata16_123_pixels, 0};

static u_int32_t fontdata16_124_pixels[] = {
/* 0x7c */ 0x00000000, 0x00000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x00000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_124 = { 8, 16, 1, 1, fontdata16_124_pixels, 0};

static u_int32_t fontdata16_125_pixels[] = {
/* 0x7d */ 0x00000000, 0x00000000, 0x70000000, 0x18000000,
	   0x18000000, 0x18000000, 0x0e000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x70000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_125 = { 8, 16, 1, 1, fontdata16_125_pixels, 0};

static u_int32_t fontdata16_126_pixels[] = {
/* 0x7e */ 0x00000000, 0x00000000, 0x76000000, 0xdc000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_126 = { 8, 16, 1, 1, fontdata16_126_pixels, 0};

static u_int32_t fontdata16_127_pixels[] = {
/* 0x7f */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x10000000, 0x38000000, 0x6c000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xfe000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_127 = { 8, 16, 1, 1, fontdata16_127_pixels, 0};

static u_int32_t fontdata16_128_pixels[] = {
/* 0x80 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_128 = { 8, 16, 1, 1, fontdata16_128_pixels, 0};

static u_int32_t fontdata16_129_pixels[] = {
/* 0x81 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_129 = { 8, 16, 1, 1, fontdata16_129_pixels, 0};

static u_int32_t fontdata16_130_pixels[] = {
/* 0x82 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_130 = { 8, 16, 1, 1, fontdata16_130_pixels, 0};

static u_int32_t fontdata16_131_pixels[] = {
/* 0x83 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_131 = { 8, 16, 1, 1, fontdata16_131_pixels, 0};

static u_int32_t fontdata16_132_pixels[] = {
/* 0x84 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_132 = { 8, 16, 1, 1, fontdata16_132_pixels, 0};

static u_int32_t fontdata16_133_pixels[] = {
/* 0x85 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_133 = { 8, 16, 1, 1, fontdata16_133_pixels, 0};

static u_int32_t fontdata16_134_pixels[] = {
/* 0x86 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_134 = { 8, 16, 1, 1, fontdata16_134_pixels, 0};

static u_int32_t fontdata16_135_pixels[] = {
/* 0x87 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_135 = { 8, 16, 1, 1, fontdata16_135_pixels, 0};

static u_int32_t fontdata16_136_pixels[] = {
/* 0x88 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_136 = { 8, 16, 1, 1, fontdata16_136_pixels, 0};

static u_int32_t fontdata16_137_pixels[] = {
/* 0x89 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_137 = { 8, 16, 1, 1, fontdata16_137_pixels, 0};

static u_int32_t fontdata16_138_pixels[] = {
/* 0x8a */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_138 = { 8, 16, 1, 1, fontdata16_138_pixels, 0};

static u_int32_t fontdata16_139_pixels[] = {
/* 0x8b */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_139 = { 8, 16, 1, 1, fontdata16_139_pixels, 0};

static u_int32_t fontdata16_140_pixels[] = {
/* 0x8c */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_140 = { 8, 16, 1, 1, fontdata16_140_pixels, 0};

static u_int32_t fontdata16_141_pixels[] = {
/* 0x8d */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_141 = { 8, 16, 1, 1, fontdata16_141_pixels, 0};

static u_int32_t fontdata16_142_pixels[] = {
/* 0x8e */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_142 = { 8, 16, 1, 1, fontdata16_142_pixels, 0};

static u_int32_t fontdata16_143_pixels[] = {
/* 0x8f */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_143 = { 8, 16, 1, 1, fontdata16_143_pixels, 0};

static u_int32_t fontdata16_144_pixels[] = {
/* 0x90 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_144 = { 8, 16, 1, 1, fontdata16_144_pixels, 0};

static u_int32_t fontdata16_145_pixels[] = {
/* 0x91 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_145 = { 8, 16, 1, 1, fontdata16_145_pixels, 0};

static u_int32_t fontdata16_146_pixels[] = {
/* 0x92 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_146 = { 8, 16, 1, 1, fontdata16_146_pixels, 0};

static u_int32_t fontdata16_147_pixels[] = {
/* 0x93 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_147 = { 8, 16, 1, 1, fontdata16_147_pixels, 0};

static u_int32_t fontdata16_148_pixels[] = {
/* 0x94 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_148 = { 8, 16, 1, 1, fontdata16_148_pixels, 0};

static u_int32_t fontdata16_149_pixels[] = {
/* 0x95 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_149 = { 8, 16, 1, 1, fontdata16_149_pixels, 0};

static u_int32_t fontdata16_150_pixels[] = {
/* 0x96 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_150 = { 8, 16, 1, 1, fontdata16_150_pixels, 0};

static u_int32_t fontdata16_151_pixels[] = {
/* 0x97 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_151 = { 8, 16, 1, 1, fontdata16_151_pixels, 0};

static u_int32_t fontdata16_152_pixels[] = {
/* 0x98 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_152 = { 8, 16, 1, 1, fontdata16_152_pixels, 0};

static u_int32_t fontdata16_153_pixels[] = {
/* 0x99 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_153 = { 8, 16, 1, 1, fontdata16_153_pixels, 0};

static u_int32_t fontdata16_154_pixels[] = {
/* 0x9a */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_154 = { 8, 16, 1, 1, fontdata16_154_pixels, 0};

static u_int32_t fontdata16_155_pixels[] = {
/* 0x9b */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_155 = { 8, 16, 1, 1, fontdata16_155_pixels, 0};

static u_int32_t fontdata16_156_pixels[] = {
/* 0x9c */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_156 = { 8, 16, 1, 1, fontdata16_156_pixels, 0};

static u_int32_t fontdata16_157_pixels[] = {
/* 0x9d */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_157 = { 8, 16, 1, 1, fontdata16_157_pixels, 0};

static u_int32_t fontdata16_158_pixels[] = {
/* 0x9e */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_158 = { 8, 16, 1, 1, fontdata16_158_pixels, 0};

static u_int32_t fontdata16_159_pixels[] = {
/* 0x9f */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_159 = { 8, 16, 1, 1, fontdata16_159_pixels, 0};

static u_int32_t fontdata16_160_pixels[] = {
/* 0xa0 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_160 = { 8, 16, 1, 1, fontdata16_160_pixels, 0};

static u_int32_t fontdata16_161_pixels[] = {
/* 0xa1 */ 0x00000000, 0x00000000, 0x18000000, 0x18000000,
	   0x00000000, 0x18000000, 0x18000000, 0x18000000,
	   0x3c000000, 0x3c000000, 0x3c000000, 0x18000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_161 = { 8, 16, 1, 1, fontdata16_161_pixels, 0};

static u_int32_t fontdata16_162_pixels[] = {
/* 0xa2 */ 0x00000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x66000000, 0x60000000, 0x60000000, 0x60000000,
	   0x66000000, 0x3c000000, 0x18000000, 0x18000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_162 = { 8, 16, 1, 1, fontdata16_162_pixels, 0};

static u_int32_t fontdata16_163_pixels[] = {
/* 0xa3 */ 0x00000000, 0x38000000, 0x6c000000, 0x64000000,
	   0x60000000, 0xf0000000, 0x60000000, 0x60000000,
	   0x60000000, 0x60000000, 0xe6000000, 0xfc000000,
	   0x00000000, 0x00000000, 0x00000000, 0xc3000000
};
static struct raster fontdata16_163 = { 8, 16, 1, 1, fontdata16_163_pixels, 0};

static u_int32_t fontdata16_164_pixels[] = {
/* 0xa4 */ 0xc3000000, 0x3c000000, 0x66000000, 0x42000000,
	   0x66000000, 0x3c000000, 0xc3000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_164 = { 8, 16, 1, 1, fontdata16_164_pixels, 0};

static u_int32_t fontdata16_165_pixels[] = {
/* 0xa5 */ 0x00000000, 0x00000000, 0x66000000, 0x66000000,
	   0x3c000000, 0x18000000, 0x7e000000, 0x18000000,
	   0x7e000000, 0x18000000, 0x18000000, 0x18000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_165 = { 8, 16, 1, 1, fontdata16_165_pixels, 0};

static u_int32_t fontdata16_166_pixels[] = {
/* 0xa6 */ 0x00000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x00000000,
	   0x00000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x00000000
};
static struct raster fontdata16_166 = { 8, 16, 1, 1, fontdata16_166_pixels, 0};

static u_int32_t fontdata16_167_pixels[] = {
/* 0xa7 */ 0x00000000, 0x7c000000, 0xc6000000, 0x60000000,
	   0x38000000, 0x6c000000, 0xc6000000, 0xc6000000,
	   0x6c000000, 0x38000000, 0x0c000000, 0xc6000000,
	   0x7c000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_167 = { 8, 16, 1, 1, fontdata16_167_pixels, 0};

static u_int32_t fontdata16_168_pixels[] = {
/* 0xa8 */ 0x00000000, 0xc6000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_168 = { 8, 16, 1, 1, fontdata16_168_pixels, 0};

static u_int32_t fontdata16_169_pixels[] = {
/* 0xa9 */ 0x00000000, 0x7c000000, 0xc6000000, 0x82000000,
	   0x9a000000, 0xa6000000, 0xa2000000, 0xa6000000,
	   0x9a000000, 0x82000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_169 = { 8, 16, 1, 1, fontdata16_169_pixels, 0};

static u_int32_t fontdata16_170_pixels[] = {
/* 0xaa */ 0x00000000, 0x3c000000, 0x6c000000, 0x6c000000,
	   0x3e000000, 0x00000000, 0x7e000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_170 = { 8, 16, 1, 1, fontdata16_170_pixels, 0};

static u_int32_t fontdata16_171_pixels[] = {
/* 0xab */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x36000000, 0x6c000000, 0xd8000000,
	   0x6c000000, 0x36000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_171 = { 8, 16, 1, 1, fontdata16_171_pixels, 0};

static u_int32_t fontdata16_172_pixels[] = {
/* 0xac */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0xfe000000, 0x06000000,
	   0x06000000, 0x06000000, 0x06000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_172 = { 8, 16, 1, 1, fontdata16_172_pixels, 0};

static u_int32_t fontdata16_173_pixels[] = {
/* 0xad */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0xfe000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_173 = { 8, 16, 1, 1, fontdata16_173_pixels, 0};

static u_int32_t fontdata16_174_pixels[] = {
/* 0xae */ 0x00000000, 0x7c000000, 0xc6000000, 0x82000000,
	   0xba000000, 0xa6000000, 0xba000000, 0xaa000000,
	   0xa6000000, 0x82000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_174 = { 8, 16, 1, 1, fontdata16_174_pixels, 0};

static u_int32_t fontdata16_175_pixels[] = {
/* 0xaf */ 0x00000000, 0xfe000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_175 = { 8, 16, 1, 1, fontdata16_175_pixels, 0};

static u_int32_t fontdata16_176_pixels[] = {
/* 0xb0 */ 0x00000000, 0x38000000, 0x6c000000, 0x6c000000,
	   0x38000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_176 = { 8, 16, 1, 1, fontdata16_176_pixels, 0};

static u_int32_t fontdata16_177_pixels[] = {
/* 0xb1 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x18000000, 0x18000000, 0x7e000000, 0x18000000,
	   0x18000000, 0x00000000, 0x00000000, 0xff000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_177 = { 8, 16, 1, 1, fontdata16_177_pixels, 0};

static u_int32_t fontdata16_178_pixels[] = {
/* 0xb2 */ 0x00000000, 0x70000000, 0xd8000000, 0x30000000,
	   0x60000000, 0xc8000000, 0xf8000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_178 = { 8, 16, 1, 1, fontdata16_178_pixels, 0};

static u_int32_t fontdata16_179_pixels[] = {
/* 0xb3 */ 0x00000000, 0x70000000, 0xd8000000, 0x30000000,
	   0x30000000, 0xd8000000, 0x70000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_179 = { 8, 16, 1, 1, fontdata16_179_pixels, 0};

static u_int32_t fontdata16_180_pixels[] = {
/* 0xb4 */ 0x18000000, 0x30000000, 0x60000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_180 = { 8, 16, 1, 1, fontdata16_180_pixels, 0};

static u_int32_t fontdata16_181_pixels[] = {
/* 0xb5 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x66000000, 0x66000000, 0x66000000, 0x66000000,
	   0x66000000, 0x7c000000, 0x60000000, 0x60000000,
	   0xc0000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_181 = { 8, 16, 1, 1, fontdata16_181_pixels, 0};

static u_int32_t fontdata16_182_pixels[] = {
/* 0xb6 */ 0x00000000, 0x00000000, 0x7f000000, 0xdb000000,
	   0xdb000000, 0xdb000000, 0x7b000000, 0x1b000000,
	   0x1b000000, 0x1b000000, 0x1b000000, 0x1b000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_182 = { 8, 16, 1, 1, fontdata16_182_pixels, 0};

static u_int32_t fontdata16_183_pixels[] = {
/* 0xb7 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x18000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_183 = { 8, 16, 1, 1, fontdata16_183_pixels, 0};

static u_int32_t fontdata16_184_pixels[] = {
/* 0xb8 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x18000000,
	   0x30000000, 0x60000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_184 = { 8, 16, 1, 1, fontdata16_184_pixels, 0};

static u_int32_t fontdata16_185_pixels[] = {
/* 0xb9 */ 0x00000000, 0x30000000, 0x70000000, 0xf0000000,
	   0x30000000, 0x30000000, 0x78000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_185 = { 8, 16, 1, 1, fontdata16_185_pixels, 0};

static u_int32_t fontdata16_186_pixels[] = {
/* 0xba */ 0x00000000, 0x38000000, 0x6c000000, 0x6c000000,
	   0x38000000, 0x00000000, 0x7c000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_186 = { 8, 16, 1, 1, fontdata16_186_pixels, 0};

static u_int32_t fontdata16_187_pixels[] = {
/* 0xbb */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x00000000, 0xd8000000, 0x6c000000, 0x36000000,
	   0x6c000000, 0xd8000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_187 = { 8, 16, 1, 1, fontdata16_187_pixels, 0};

static u_int32_t fontdata16_188_pixels[] = {
/* 0xbc */ 0x00000000, 0xc0000000, 0xc0000000, 0xc2000000,
	   0xc6000000, 0xcc000000, 0x18000000, 0x30000000,
	   0x66000000, 0xce000000, 0x9e000000, 0x3e000000,
	   0x06000000, 0x06000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_188 = { 8, 16, 1, 1, fontdata16_188_pixels, 0};

static u_int32_t fontdata16_189_pixels[] = {
/* 0xbd */ 0x00000000, 0xc0000000, 0xc0000000, 0xc2000000,
	   0xc6000000, 0xcc000000, 0x18000000, 0x30000000,
	   0x60000000, 0xdc000000, 0x86000000, 0x0c000000,
	   0x18000000, 0x3e000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_189 = { 8, 16, 1, 1, fontdata16_189_pixels, 0};

static u_int32_t fontdata16_190_pixels[] = {
/* 0xbe */ 0x00000000, 0xc0000000, 0x60000000, 0xc2000000,
	   0x66000000, 0xcc000000, 0x18000000, 0x30000000,
	   0x66000000, 0xce000000, 0x9e000000, 0x3e000000,
	   0x06000000, 0x06000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_190 = { 8, 16, 1, 1, fontdata16_190_pixels, 0};

static u_int32_t fontdata16_191_pixels[] = {
/* 0xbf */ 0x00000000, 0x00000000, 0x30000000, 0x30000000,
	   0x00000000, 0x30000000, 0x30000000, 0x60000000,
	   0xc0000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_191 = { 8, 16, 1, 1, fontdata16_191_pixels, 0};

static u_int32_t fontdata16_192_pixels[] = {
/* 0xc0 */ 0x18000000, 0x0c000000, 0x06000000, 0x00000000,
	   0x38000000, 0x6c000000, 0xc6000000, 0xc6000000,
	   0xfe000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_192 = { 8, 16, 1, 1, fontdata16_192_pixels, 0};

static u_int32_t fontdata16_193_pixels[] = {
/* 0xc1 */ 0x18000000, 0x30000000, 0x60000000, 0x00000000,
	   0x38000000, 0x6c000000, 0xc6000000, 0xc6000000,
	   0xfe000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_193 = { 8, 16, 1, 1, fontdata16_193_pixels, 0};

static u_int32_t fontdata16_194_pixels[] = {
/* 0xc2 */ 0x10000000, 0x38000000, 0x6c000000, 0x00000000,
	   0x38000000, 0x6c000000, 0xc6000000, 0xc6000000,
	   0xfe000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_194 = { 8, 16, 1, 1, fontdata16_194_pixels, 0};

static u_int32_t fontdata16_195_pixels[] = {
/* 0xc3 */ 0x76000000, 0xdc000000, 0x00000000, 0x10000000,
	   0x38000000, 0x6c000000, 0xc6000000, 0xc6000000,
	   0xfe000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_195 = { 8, 16, 1, 1, fontdata16_195_pixels, 0};

static u_int32_t fontdata16_196_pixels[] = {
/* 0xc4 */ 0xc6000000, 0xc6000000, 0x00000000, 0x10000000,
	   0x38000000, 0x6c000000, 0xc6000000, 0xc6000000,
	   0xfe000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_196 = { 8, 16, 1, 1, fontdata16_196_pixels, 0};

static u_int32_t fontdata16_197_pixels[] = {
/* 0xc5 */ 0x38000000, 0x6c000000, 0x38000000, 0x00000000,
	   0x38000000, 0x6c000000, 0xc6000000, 0xc6000000,
	   0xfe000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_197 = { 8, 16, 1, 1, fontdata16_197_pixels, 0};

static u_int32_t fontdata16_198_pixels[] = {
/* 0xc6 */ 0x00000000, 0x00000000, 0x3e000000, 0x6c000000,
	   0xcc000000, 0xcc000000, 0xfe000000, 0xcc000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0xce000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_198 = { 8, 16, 1, 1, fontdata16_198_pixels, 0};

static u_int32_t fontdata16_199_pixels[] = {
/* 0xc7 */ 0x00000000, 0x00000000, 0x3c000000, 0x66000000,
	   0xc2000000, 0xc0000000, 0xc0000000, 0xc0000000,
	   0xc2000000, 0x66000000, 0x3c000000, 0x0c000000,
	   0x06000000, 0x7c000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_199 = { 8, 16, 1, 1, fontdata16_199_pixels, 0};

static u_int32_t fontdata16_200_pixels[] = {
/* 0xc8 */ 0x18000000, 0x0c000000, 0x06000000, 0x00000000,
	   0xfe000000, 0x66000000, 0x60000000, 0x7c000000,
	   0x60000000, 0x60000000, 0x66000000, 0xfe000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_200 = { 8, 16, 1, 1, fontdata16_200_pixels, 0};

static u_int32_t fontdata16_201_pixels[] = {
/* 0xc9 */ 0x18000000, 0x30000000, 0x60000000, 0x00000000,
	   0xfe000000, 0x66000000, 0x60000000, 0x7c000000,
	   0x60000000, 0x60000000, 0x66000000, 0xfe000000,
	   0x00000000, 0x00000000, 0x00000000, 0x10000000
};
static struct raster fontdata16_201 = { 8, 16, 1, 1, fontdata16_201_pixels, 0};

static u_int32_t fontdata16_202_pixels[] = {
/* 0xca */ 0x10000000, 0x38000000, 0x6c000000, 0x00000000,
	   0xfe000000, 0x66000000, 0x60000000, 0x7c000000,
	   0x60000000, 0x60000000, 0x66000000, 0xfe000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_202 = { 8, 16, 1, 1, fontdata16_202_pixels, 0};

static u_int32_t fontdata16_203_pixels[] = {
/* 0xcb */ 0x00000000, 0xc6000000, 0x00000000, 0xfe000000,
	   0x66000000, 0x60000000, 0x60000000, 0x7c000000,
	   0x60000000, 0x60000000, 0x66000000, 0xfe000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_203 = { 8, 16, 1, 1, fontdata16_203_pixels, 0};

static u_int32_t fontdata16_204_pixels[] = {
/* 0xcc */ 0x18000000, 0x0c000000, 0x06000000, 0x00000000,
	   0x3c000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_204 = { 8, 16, 1, 1, fontdata16_204_pixels, 0};

static u_int32_t fontdata16_205_pixels[] = {
/* 0xcd */ 0x18000000, 0x30000000, 0x60000000, 0x00000000,
	   0x3c000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_205 = { 8, 16, 1, 1, fontdata16_205_pixels, 0};

static u_int32_t fontdata16_206_pixels[] = {
/* 0xce */ 0x10000000, 0x38000000, 0x6c000000, 0x00000000,
	   0x3c000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_206 = { 8, 16, 1, 1, fontdata16_206_pixels, 0};

static u_int32_t fontdata16_207_pixels[] = {
/* 0xcf */ 0x00000000, 0x66000000, 0x00000000, 0x3c000000,
	   0x18000000, 0x18000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_207 = { 8, 16, 1, 1, fontdata16_207_pixels, 0};

static u_int32_t fontdata16_208_pixels[] = {
/* 0xd0 */ 0x00000000, 0x00000000, 0xf8000000, 0x6c000000,
	   0x66000000, 0x66000000, 0xf6000000, 0x66000000,
	   0x66000000, 0x66000000, 0x6c000000, 0xf8000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_208 = { 8, 16, 1, 1, fontdata16_208_pixels, 0};

static u_int32_t fontdata16_209_pixels[] = {
/* 0xd1 */ 0x76000000, 0xdc000000, 0x00000000, 0xc6000000,
	   0xe6000000, 0xf6000000, 0xfe000000, 0xde000000,
	   0xce000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_209 = { 8, 16, 1, 1, fontdata16_209_pixels, 0};

static u_int32_t fontdata16_210_pixels[] = {
/* 0xd2 */ 0x18000000, 0x0c000000, 0x06000000, 0x00000000,
	   0x7c000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_210 = { 8, 16, 1, 1, fontdata16_210_pixels, 0};

static u_int32_t fontdata16_211_pixels[] = {
/* 0xd3 */ 0x18000000, 0x30000000, 0x60000000, 0x00000000,
	   0x7c000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_211 = { 8, 16, 1, 1, fontdata16_211_pixels, 0};

static u_int32_t fontdata16_212_pixels[] = {
/* 0xd4 */ 0x10000000, 0x38000000, 0x6c000000, 0x00000000,
	   0x7c000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_212 = { 8, 16, 1, 1, fontdata16_212_pixels, 0};

static u_int32_t fontdata16_213_pixels[] = {
/* 0xd5 */ 0x76000000, 0xdc000000, 0x00000000, 0x7c000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_213 = { 8, 16, 1, 1, fontdata16_213_pixels, 0};

static u_int32_t fontdata16_214_pixels[] = {
/* 0xd6 */ 0xc6000000, 0xc6000000, 0x00000000, 0x7c000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_214 = { 8, 16, 1, 1, fontdata16_214_pixels, 0};

static u_int32_t fontdata16_215_pixels[] = {
/* 0xd7 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0xc6000000, 0x6c000000, 0x38000000, 0x38000000,
	   0x6c000000, 0xc6000000, 0x00000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_215 = { 8, 16, 1, 1, fontdata16_215_pixels, 0};

static u_int32_t fontdata16_216_pixels[] = {
/* 0xd8 */ 0x00000000, 0x06000000, 0x7e000000, 0xce000000,
	   0xce000000, 0xce000000, 0xd6000000, 0xd6000000,
	   0xe6000000, 0xe6000000, 0xe6000000, 0xfc000000,
	   0xc0000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_216 = { 8, 16, 1, 1, fontdata16_216_pixels, 0};

static u_int32_t fontdata16_217_pixels[] = {
/* 0xd9 */ 0x18000000, 0x0c000000, 0x06000000, 0x00000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_217 = { 8, 16, 1, 1, fontdata16_217_pixels, 0};

static u_int32_t fontdata16_218_pixels[] = {
/* 0xda */ 0x18000000, 0x30000000, 0x60000000, 0x00000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_218 = { 8, 16, 1, 1, fontdata16_218_pixels, 0};

static u_int32_t fontdata16_219_pixels[] = {
/* 0xdb */ 0x10000000, 0x38000000, 0x6c000000, 0x00000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_219 = { 8, 16, 1, 1, fontdata16_219_pixels, 0};

static u_int32_t fontdata16_220_pixels[] = {
/* 0xdc */ 0xc6000000, 0xc6000000, 0x00000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_220 = { 8, 16, 1, 1, fontdata16_220_pixels, 0};

static u_int32_t fontdata16_221_pixels[] = {
/* 0xdd */ 0x18000000, 0x30000000, 0x60000000, 0x00000000,
	   0x66000000, 0x66000000, 0x66000000, 0x3c000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_221 = { 8, 16, 1, 1, fontdata16_221_pixels, 0};

static u_int32_t fontdata16_222_pixels[] = {
/* 0xde */ 0x00000000, 0xf0000000, 0x60000000, 0x7c000000,
	   0x66000000, 0x66000000, 0x66000000, 0x7c000000,
	   0x60000000, 0x60000000, 0x60000000, 0xf0000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_222 = { 8, 16, 1, 1, fontdata16_222_pixels, 0};

static u_int32_t fontdata16_223_pixels[] = {
/* 0xdf */ 0x00000000, 0x00000000, 0x78000000, 0xcc000000,
	   0xcc000000, 0xcc000000, 0xd8000000, 0xcc000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0xcc000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_223 = { 8, 16, 1, 1, fontdata16_223_pixels, 0};

static u_int32_t fontdata16_224_pixels[] = {
/* 0xe0 */ 0x00000000, 0x60000000, 0x30000000, 0x18000000,
	   0x00000000, 0x78000000, 0x0c000000, 0x7c000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_224 = { 8, 16, 1, 1, fontdata16_224_pixels, 0};

static u_int32_t fontdata16_225_pixels[] = {
/* 0xe1 */ 0x00000000, 0x18000000, 0x30000000, 0x60000000,
	   0x00000000, 0x78000000, 0x0c000000, 0x7c000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_225 = { 8, 16, 1, 1, fontdata16_225_pixels, 0};

static u_int32_t fontdata16_226_pixels[] = {
/* 0xe2 */ 0x00000000, 0x10000000, 0x38000000, 0x6c000000,
	   0x00000000, 0x78000000, 0x0c000000, 0x7c000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_226 = { 8, 16, 1, 1, fontdata16_226_pixels, 0};

static u_int32_t fontdata16_227_pixels[] = {
/* 0xe3 */ 0x00000000, 0x00000000, 0x76000000, 0xdc000000,
	   0x00000000, 0x78000000, 0x0c000000, 0x7c000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_227 = { 8, 16, 1, 1, fontdata16_227_pixels, 0};

static u_int32_t fontdata16_228_pixels[] = {
/* 0xe4 */ 0x00000000, 0x00000000, 0xcc000000, 0x00000000,
	   0x00000000, 0x78000000, 0x0c000000, 0x7c000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_228 = { 8, 16, 1, 1, fontdata16_228_pixels, 0};

static u_int32_t fontdata16_229_pixels[] = {
/* 0xe5 */ 0x00000000, 0x38000000, 0x6c000000, 0x38000000,
	   0x00000000, 0x78000000, 0x0c000000, 0x7c000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_229 = { 8, 16, 1, 1, fontdata16_229_pixels, 0};

static u_int32_t fontdata16_230_pixels[] = {
/* 0xe6 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x6c000000, 0xfe000000, 0xb2000000, 0x32000000,
	   0x7e000000, 0xd8000000, 0xd8000000, 0x6e000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_230 = { 8, 16, 1, 1, fontdata16_230_pixels, 0};

static u_int32_t fontdata16_231_pixels[] = {
/* 0xe7 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x3c000000, 0x66000000, 0x60000000, 0x60000000,
	   0x66000000, 0x3c000000, 0x0c000000, 0x06000000,
	   0x3c000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_231 = { 8, 16, 1, 1, fontdata16_231_pixels, 0};

static u_int32_t fontdata16_232_pixels[] = {
/* 0xe8 */ 0x00000000, 0x60000000, 0x30000000, 0x18000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0xfe000000,
	   0xc0000000, 0xc0000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_232 = { 8, 16, 1, 1, fontdata16_232_pixels, 0};

static u_int32_t fontdata16_233_pixels[] = {
/* 0xe9 */ 0x00000000, 0x0c000000, 0x18000000, 0x30000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0xfe000000,
	   0xc0000000, 0xc0000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_233 = { 8, 16, 1, 1, fontdata16_233_pixels, 0};

static u_int32_t fontdata16_234_pixels[] = {
/* 0xea */ 0x00000000, 0x10000000, 0x38000000, 0x6c000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0xfe000000,
	   0xc0000000, 0xc0000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_234 = { 8, 16, 1, 1, fontdata16_234_pixels, 0};

static u_int32_t fontdata16_235_pixels[] = {
/* 0xeb */ 0x00000000, 0x00000000, 0xc6000000, 0x00000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0xfe000000,
	   0xc0000000, 0xc0000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_235 = { 8, 16, 1, 1, fontdata16_235_pixels, 0};

static u_int32_t fontdata16_236_pixels[] = {
/* 0xec */ 0x00000000, 0x60000000, 0x30000000, 0x18000000,
	   0x00000000, 0x38000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_236 = { 8, 16, 1, 1, fontdata16_236_pixels, 0};

static u_int32_t fontdata16_237_pixels[] = {
/* 0xed */ 0x00000000, 0x0c000000, 0x18000000, 0x30000000,
	   0x00000000, 0x38000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_237 = { 8, 16, 1, 1, fontdata16_237_pixels, 0};

static u_int32_t fontdata16_238_pixels[] = {
/* 0xee */ 0x00000000, 0x18000000, 0x3c000000, 0x66000000,
	   0x00000000, 0x38000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_238 = { 8, 16, 1, 1, fontdata16_238_pixels, 0};

static u_int32_t fontdata16_239_pixels[] = {
/* 0xef */ 0x00000000, 0x00000000, 0x66000000, 0x00000000,
	   0x00000000, 0x38000000, 0x18000000, 0x18000000,
	   0x18000000, 0x18000000, 0x18000000, 0x3c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_239 = { 8, 16, 1, 1, fontdata16_239_pixels, 0};

static u_int32_t fontdata16_240_pixels[] = {
/* 0xf0 */ 0x00000000, 0x00000000, 0x3e000000, 0x30000000,
	   0x18000000, 0x7c000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_240 = { 8, 16, 1, 1, fontdata16_240_pixels, 0};

static u_int32_t fontdata16_241_pixels[] = {
/* 0xf1 */ 0x00000000, 0x00000000, 0x76000000, 0xdc000000,
	   0x00000000, 0xdc000000, 0x66000000, 0x66000000,
	   0x66000000, 0x66000000, 0x66000000, 0x66000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_241 = { 8, 16, 1, 1, fontdata16_241_pixels, 0};

static u_int32_t fontdata16_242_pixels[] = {
/* 0xf2 */ 0x00000000, 0x60000000, 0x30000000, 0x18000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_242 = { 8, 16, 1, 1, fontdata16_242_pixels, 0};

static u_int32_t fontdata16_243_pixels[] = {
/* 0xf3 */ 0x00000000, 0x18000000, 0x30000000, 0x60000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_243 = { 8, 16, 1, 1, fontdata16_243_pixels, 0};

static u_int32_t fontdata16_244_pixels[] = {
/* 0xf4 */ 0x00000000, 0x10000000, 0x38000000, 0x6c000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_244 = { 8, 16, 1, 1, fontdata16_244_pixels, 0};

static u_int32_t fontdata16_245_pixels[] = {
/* 0xf5 */ 0x00000000, 0x00000000, 0x76000000, 0xdc000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_245 = { 8, 16, 1, 1, fontdata16_245_pixels, 0};

static u_int32_t fontdata16_246_pixels[] = {
/* 0xf6 */ 0x00000000, 0x00000000, 0xc6000000, 0x00000000,
	   0x00000000, 0x7c000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7c000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_246 = { 8, 16, 1, 1, fontdata16_246_pixels, 0};

static u_int32_t fontdata16_247_pixels[] = {
/* 0xf7 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x18000000, 0x18000000, 0x00000000, 0x7e000000,
	   0x00000000, 0x18000000, 0x18000000, 0x00000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_247 = { 8, 16, 1, 1, fontdata16_247_pixels, 0};

static u_int32_t fontdata16_248_pixels[] = {
/* 0xf8 */ 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	   0x06000000, 0x7e000000, 0xce000000, 0xce000000,
	   0xd6000000, 0xe6000000, 0xe6000000, 0xfc000000,
	   0xc0000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_248 = { 8, 16, 1, 1, fontdata16_248_pixels, 0};

static u_int32_t fontdata16_249_pixels[] = {
/* 0xf9 */ 0x00000000, 0x60000000, 0x30000000, 0x18000000,
	   0x00000000, 0xcc000000, 0xcc000000, 0xcc000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_249 = { 8, 16, 1, 1, fontdata16_249_pixels, 0};

static u_int32_t fontdata16_250_pixels[] = {
/* 0xfa */ 0x00000000, 0x18000000, 0x30000000, 0x60000000,
	   0x00000000, 0xcc000000, 0xcc000000, 0xcc000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_250 = { 8, 16, 1, 1, fontdata16_250_pixels, 0};

static u_int32_t fontdata16_251_pixels[] = {
/* 0xfb */ 0x00000000, 0x30000000, 0x78000000, 0xcc000000,
	   0x00000000, 0xcc000000, 0xcc000000, 0xcc000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_251 = { 8, 16, 1, 1, fontdata16_251_pixels, 0};

static u_int32_t fontdata16_252_pixels[] = {
/* 0xfc */ 0x00000000, 0x00000000, 0xcc000000, 0x00000000,
	   0x00000000, 0xcc000000, 0xcc000000, 0xcc000000,
	   0xcc000000, 0xcc000000, 0xcc000000, 0x76000000,
	   0x00000000, 0x00000000, 0x00000000, 0x00000000
};
static struct raster fontdata16_252 = { 8, 16, 1, 1, fontdata16_252_pixels, 0};

static u_int32_t fontdata16_253_pixels[] = {
/* 0xfd */ 0x00000000, 0x18000000, 0x30000000, 0x60000000,
	   0x00000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7e000000,
	   0x06000000, 0x0c000000, 0x78000000, 0x00000000
};
static struct raster fontdata16_253 = { 8, 16, 1, 1, fontdata16_253_pixels, 0};

static u_int32_t fontdata16_254_pixels[] = {
/* 0xfe */ 0x00000000, 0x00000000, 0x00000000, 0xf0000000,
	   0x60000000, 0x7c000000, 0x66000000, 0x66000000,
	   0x66000000, 0x66000000, 0x66000000, 0x7c000000,
	   0x60000000, 0x60000000, 0xf0000000, 0x00000000
};
static struct raster fontdata16_254 = { 8, 16, 1, 1, fontdata16_254_pixels, 0};

static u_int32_t fontdata16_255_pixels[] = {
/* 0xff */ 0x00000000, 0xc6000000, 0xc6000000, 0x00000000,
	   0x00000000, 0xc6000000, 0xc6000000, 0xc6000000,
	   0xc6000000, 0xc6000000, 0xc6000000, 0x7e000000,
	   0x06000000, 0x0c000000, 0x78000000, 0x00000000
};
static struct raster fontdata16_255 = { 8, 16, 1, 1, fontdata16_255_pixels, 0};

struct raster_font fontdata8x16 = {
    8, 16, 13, RASFONT_FIXEDWIDTH|RASFONT_NOVERTICALMOVEMENT,
    {
	{ &fontdata16_0, 0, -13, 8, 0 },
	{ &fontdata16_1, 0, -13, 8, 0 },
	{ &fontdata16_2, 0, -13, 8, 0 },
	{ &fontdata16_3, 0, -13, 8, 0 },
	{ &fontdata16_4, 0, -13, 8, 0 },
	{ &fontdata16_5, 0, -13, 8, 0 },
	{ &fontdata16_6, 0, -13, 8, 0 },
	{ &fontdata16_7, 0, -13, 8, 0 },
	{ &fontdata16_8, 0, -13, 8, 0 },
	{ &fontdata16_9, 0, -13, 8, 0 },
	{ &fontdata16_10, 0, -13, 8, 0 },
	{ &fontdata16_11, 0, -13, 8, 0 },
	{ &fontdata16_12, 0, -13, 8, 0 },
	{ &fontdata16_13, 0, -13, 8, 0 },
	{ &fontdata16_14, 0, -13, 8, 0 },
	{ &fontdata16_15, 0, -13, 8, 0 },
	{ &fontdata16_16, 0, -13, 8, 0 },
	{ &fontdata16_17, 0, -13, 8, 0 },
	{ &fontdata16_18, 0, -13, 8, 0 },
	{ &fontdata16_19, 0, -13, 8, 0 },
	{ &fontdata16_20, 0, -13, 8, 0 },
	{ &fontdata16_21, 0, -13, 8, 0 },
	{ &fontdata16_22, 0, -13, 8, 0 },
	{ &fontdata16_23, 0, -13, 8, 0 },
	{ &fontdata16_24, 0, -13, 8, 0 },
	{ &fontdata16_25, 0, -13, 8, 0 },
	{ &fontdata16_26, 0, -13, 8, 0 },
	{ &fontdata16_27, 0, -13, 8, 0 },
	{ &fontdata16_28, 0, -13, 8, 0 },
	{ &fontdata16_29, 0, -13, 8, 0 },
	{ &fontdata16_30, 0, -13, 8, 0 },
	{ &fontdata16_31, 0, -13, 8, 0 },
	{ &fontdata16_32, 0, -13, 8, 0 },
	{ &fontdata16_33, 0, -13, 8, 0 },
	{ &fontdata16_34, 0, -13, 8, 0 },
	{ &fontdata16_35, 0, -13, 8, 0 },
	{ &fontdata16_36, 0, -13, 8, 0 },
	{ &fontdata16_37, 0, -13, 8, 0 },
	{ &fontdata16_38, 0, -13, 8, 0 },
	{ &fontdata16_39, 0, -13, 8, 0 },
	{ &fontdata16_40, 0, -13, 8, 0 },
	{ &fontdata16_41, 0, -13, 8, 0 },
	{ &fontdata16_42, 0, -13, 8, 0 },
	{ &fontdata16_43, 0, -13, 8, 0 },
	{ &fontdata16_44, 0, -13, 8, 0 },
	{ &fontdata16_45, 0, -13, 8, 0 },
	{ &fontdata16_46, 0, -13, 8, 0 },
	{ &fontdata16_47, 0, -13, 8, 0 },
	{ &fontdata16_48, 0, -13, 8, 0 },
	{ &fontdata16_49, 0, -13, 8, 0 },
	{ &fontdata16_50, 0, -13, 8, 0 },
	{ &fontdata16_51, 0, -13, 8, 0 },
	{ &fontdata16_52, 0, -13, 8, 0 },
	{ &fontdata16_53, 0, -13, 8, 0 },
	{ &fontdata16_54, 0, -13, 8, 0 },
	{ &fontdata16_55, 0, -13, 8, 0 },
	{ &fontdata16_56, 0, -13, 8, 0 },
	{ &fontdata16_57, 0, -13, 8, 0 },
	{ &fontdata16_58, 0, -13, 8, 0 },
	{ &fontdata16_59, 0, -13, 8, 0 },
	{ &fontdata16_60, 0, -13, 8, 0 },
	{ &fontdata16_61, 0, -13, 8, 0 },
	{ &fontdata16_62, 0, -13, 8, 0 },
	{ &fontdata16_63, 0, -13, 8, 0 },
	{ &fontdata16_64, 0, -13, 8, 0 },
	{ &fontdata16_65, 0, -13, 8, 0 },
	{ &fontdata16_66, 0, -13, 8, 0 },
	{ &fontdata16_67, 0, -13, 8, 0 },
	{ &fontdata16_68, 0, -13, 8, 0 },
	{ &fontdata16_69, 0, -13, 8, 0 },
	{ &fontdata16_70, 0, -13, 8, 0 },
	{ &fontdata16_71, 0, -13, 8, 0 },
	{ &fontdata16_72, 0, -13, 8, 0 },
	{ &fontdata16_73, 0, -13, 8, 0 },
	{ &fontdata16_74, 0, -13, 8, 0 },
	{ &fontdata16_75, 0, -13, 8, 0 },
	{ &fontdata16_76, 0, -13, 8, 0 },
	{ &fontdata16_77, 0, -13, 8, 0 },
	{ &fontdata16_78, 0, -13, 8, 0 },
	{ &fontdata16_79, 0, -13, 8, 0 },
	{ &fontdata16_80, 0, -13, 8, 0 },
	{ &fontdata16_81, 0, -13, 8, 0 },
	{ &fontdata16_82, 0, -13, 8, 0 },
	{ &fontdata16_83, 0, -13, 8, 0 },
	{ &fontdata16_84, 0, -13, 8, 0 },
	{ &fontdata16_85, 0, -13, 8, 0 },
	{ &fontdata16_86, 0, -13, 8, 0 },
	{ &fontdata16_87, 0, -13, 8, 0 },
	{ &fontdata16_88, 0, -13, 8, 0 },
	{ &fontdata16_89, 0, -13, 8, 0 },
	{ &fontdata16_90, 0, -13, 8, 0 },
	{ &fontdata16_91, 0, -13, 8, 0 },
	{ &fontdata16_92, 0, -13, 8, 0 },
	{ &fontdata16_93, 0, -13, 8, 0 },
	{ &fontdata16_94, 0, -13, 8, 0 },
	{ &fontdata16_95, 0, -13, 8, 0 },
	{ &fontdata16_96, 0, -13, 8, 0 },
	{ &fontdata16_97, 0, -13, 8, 0 },
	{ &fontdata16_98, 0, -13, 8, 0 },
	{ &fontdata16_99, 0, -13, 8, 0 },
	{ &fontdata16_100, 0, -13, 8, 0 },
	{ &fontdata16_101, 0, -13, 8, 0 },
	{ &fontdata16_102, 0, -13, 8, 0 },
	{ &fontdata16_103, 0, -13, 8, 0 },
	{ &fontdata16_104, 0, -13, 8, 0 },
	{ &fontdata16_105, 0, -13, 8, 0 },
	{ &fontdata16_106, 0, -13, 8, 0 },
	{ &fontdata16_107, 0, -13, 8, 0 },
	{ &fontdata16_108, 0, -13, 8, 0 },
	{ &fontdata16_109, 0, -13, 8, 0 },
	{ &fontdata16_110, 0, -13, 8, 0 },
	{ &fontdata16_111, 0, -13, 8, 0 },
	{ &fontdata16_112, 0, -13, 8, 0 },
	{ &fontdata16_113, 0, -13, 8, 0 },
	{ &fontdata16_114, 0, -13, 8, 0 },
	{ &fontdata16_115, 0, -13, 8, 0 },
	{ &fontdata16_116, 0, -13, 8, 0 },
	{ &fontdata16_117, 0, -13, 8, 0 },
	{ &fontdata16_118, 0, -13, 8, 0 },
	{ &fontdata16_119, 0, -13, 8, 0 },
	{ &fontdata16_120, 0, -13, 8, 0 },
	{ &fontdata16_121, 0, -13, 8, 0 },
	{ &fontdata16_122, 0, -13, 8, 0 },
	{ &fontdata16_123, 0, -13, 8, 0 },
	{ &fontdata16_124, 0, -13, 8, 0 },
	{ &fontdata16_125, 0, -13, 8, 0 },
	{ &fontdata16_126, 0, -13, 8, 0 },
	{ &fontdata16_127, 0, -13, 8, 0 },
	{ &fontdata16_128, 0, -13, 8, 0 },
	{ &fontdata16_129, 0, -13, 8, 0 },
	{ &fontdata16_130, 0, -13, 8, 0 },
	{ &fontdata16_131, 0, -13, 8, 0 },
	{ &fontdata16_132, 0, -13, 8, 0 },
	{ &fontdata16_133, 0, -13, 8, 0 },
	{ &fontdata16_134, 0, -13, 8, 0 },
	{ &fontdata16_135, 0, -13, 8, 0 },
	{ &fontdata16_136, 0, -13, 8, 0 },
	{ &fontdata16_137, 0, -13, 8, 0 },
	{ &fontdata16_138, 0, -13, 8, 0 },
	{ &fontdata16_139, 0, -13, 8, 0 },
	{ &fontdata16_140, 0, -13, 8, 0 },
	{ &fontdata16_141, 0, -13, 8, 0 },
	{ &fontdata16_142, 0, -13, 8, 0 },
	{ &fontdata16_143, 0, -13, 8, 0 },
	{ &fontdata16_144, 0, -13, 8, 0 },
	{ &fontdata16_145, 0, -13, 8, 0 },
	{ &fontdata16_146, 0, -13, 8, 0 },
	{ &fontdata16_147, 0, -13, 8, 0 },
	{ &fontdata16_148, 0, -13, 8, 0 },
	{ &fontdata16_149, 0, -13, 8, 0 },
	{ &fontdata16_150, 0, -13, 8, 0 },
	{ &fontdata16_151, 0, -13, 8, 0 },
	{ &fontdata16_152, 0, -13, 8, 0 },
	{ &fontdata16_153, 0, -13, 8, 0 },
	{ &fontdata16_154, 0, -13, 8, 0 },
	{ &fontdata16_155, 0, -13, 8, 0 },
	{ &fontdata16_156, 0, -13, 8, 0 },
	{ &fontdata16_157, 0, -13, 8, 0 },
	{ &fontdata16_158, 0, -13, 8, 0 },
	{ &fontdata16_159, 0, -13, 8, 0 },
	{ &fontdata16_160, 0, -13, 8, 0 },
	{ &fontdata16_161, 0, -13, 8, 0 },
	{ &fontdata16_162, 0, -13, 8, 0 },
	{ &fontdata16_163, 0, -13, 8, 0 },
	{ &fontdata16_164, 0, -13, 8, 0 },
	{ &fontdata16_165, 0, -13, 8, 0 },
	{ &fontdata16_166, 0, -13, 8, 0 },
	{ &fontdata16_167, 0, -13, 8, 0 },
	{ &fontdata16_168, 0, -13, 8, 0 },
	{ &fontdata16_169, 0, -13, 8, 0 },
	{ &fontdata16_170, 0, -13, 8, 0 },
	{ &fontdata16_171, 0, -13, 8, 0 },
	{ &fontdata16_172, 0, -13, 8, 0 },
	{ &fontdata16_173, 0, -13, 8, 0 },
	{ &fontdata16_174, 0, -13, 8, 0 },
	{ &fontdata16_175, 0, -13, 8, 0 },
	{ &fontdata16_176, 0, -13, 8, 0 },
	{ &fontdata16_177, 0, -13, 8, 0 },
	{ &fontdata16_178, 0, -13, 8, 0 },
	{ &fontdata16_179, 0, -13, 8, 0 },
	{ &fontdata16_180, 0, -13, 8, 0 },
	{ &fontdata16_181, 0, -13, 8, 0 },
	{ &fontdata16_182, 0, -13, 8, 0 },
	{ &fontdata16_183, 0, -13, 8, 0 },
	{ &fontdata16_184, 0, -13, 8, 0 },
	{ &fontdata16_185, 0, -13, 8, 0 },
	{ &fontdata16_186, 0, -13, 8, 0 },
	{ &fontdata16_187, 0, -13, 8, 0 },
	{ &fontdata16_188, 0, -13, 8, 0 },
	{ &fontdata16_189, 0, -13, 8, 0 },
	{ &fontdata16_190, 0, -13, 8, 0 },
	{ &fontdata16_191, 0, -13, 8, 0 },
	{ &fontdata16_192, 0, -13, 8, 0 },
	{ &fontdata16_193, 0, -13, 8, 0 },
	{ &fontdata16_194, 0, -13, 8, 0 },
	{ &fontdata16_195, 0, -13, 8, 0 },
	{ &fontdata16_196, 0, -13, 8, 0 },
	{ &fontdata16_197, 0, -13, 8, 0 },
	{ &fontdata16_198, 0, -13, 8, 0 },
	{ &fontdata16_199, 0, -13, 8, 0 },
	{ &fontdata16_200, 0, -13, 8, 0 },
	{ &fontdata16_201, 0, -13, 8, 0 },
	{ &fontdata16_202, 0, -13, 8, 0 },
	{ &fontdata16_203, 0, -13, 8, 0 },
	{ &fontdata16_204, 0, -13, 8, 0 },
	{ &fontdata16_205, 0, -13, 8, 0 },
	{ &fontdata16_206, 0, -13, 8, 0 },
	{ &fontdata16_207, 0, -13, 8, 0 },
	{ &fontdata16_208, 0, -13, 8, 0 },
	{ &fontdata16_209, 0, -13, 8, 0 },
	{ &fontdata16_210, 0, -13, 8, 0 },
	{ &fontdata16_211, 0, -13, 8, 0 },
	{ &fontdata16_212, 0, -13, 8, 0 },
	{ &fontdata16_213, 0, -13, 8, 0 },
	{ &fontdata16_214, 0, -13, 8, 0 },
	{ &fontdata16_215, 0, -13, 8, 0 },
	{ &fontdata16_216, 0, -13, 8, 0 },
	{ &fontdata16_217, 0, -13, 8, 0 },
	{ &fontdata16_218, 0, -13, 8, 0 },
	{ &fontdata16_219, 0, -13, 8, 0 },
	{ &fontdata16_220, 0, -13, 8, 0 },
	{ &fontdata16_221, 0, -13, 8, 0 },
	{ &fontdata16_222, 0, -13, 8, 0 },
	{ &fontdata16_223, 0, -13, 8, 0 },
	{ &fontdata16_224, 0, -13, 8, 0 },
	{ &fontdata16_225, 0, -13, 8, 0 },
	{ &fontdata16_226, 0, -13, 8, 0 },
	{ &fontdata16_227, 0, -13, 8, 0 },
	{ &fontdata16_228, 0, -13, 8, 0 },
	{ &fontdata16_229, 0, -13, 8, 0 },
	{ &fontdata16_230, 0, -13, 8, 0 },
	{ &fontdata16_231, 0, -13, 8, 0 },
	{ &fontdata16_232, 0, -13, 8, 0 },
	{ &fontdata16_233, 0, -13, 8, 0 },
	{ &fontdata16_234, 0, -13, 8, 0 },
	{ &fontdata16_235, 0, -13, 8, 0 },
	{ &fontdata16_236, 0, -13, 8, 0 },
	{ &fontdata16_237, 0, -13, 8, 0 },
	{ &fontdata16_238, 0, -13, 8, 0 },
	{ &fontdata16_239, 0, -13, 8, 0 },
	{ &fontdata16_240, 0, -13, 8, 0 },
	{ &fontdata16_241, 0, -13, 8, 0 },
	{ &fontdata16_242, 0, -13, 8, 0 },
	{ &fontdata16_243, 0, -13, 8, 0 },
	{ &fontdata16_244, 0, -13, 8, 0 },
	{ &fontdata16_245, 0, -13, 8, 0 },
	{ &fontdata16_246, 0, -13, 8, 0 },
	{ &fontdata16_247, 0, -13, 8, 0 },
	{ &fontdata16_248, 0, -13, 8, 0 },
	{ &fontdata16_249, 0, -13, 8, 0 },
	{ &fontdata16_250, 0, -13, 8, 0 },
	{ &fontdata16_251, 0, -13, 8, 0 },
	{ &fontdata16_252, 0, -13, 8, 0 },
	{ &fontdata16_253, 0, -13, 8, 0 },
	{ &fontdata16_254, 0, -13, 8, 0 },
	{ &fontdata16_255, 0, -13, 8, 0 },
    }
#ifdef COLORFONT_CACHE
(struct raster_fontcache*) -1
#endif /* COLORFONT_CACHE */
};

