/*	$NetBSD: hil_keymaps.c,v 1.11 2003/11/17 14:37:59 tsutsui Exp $	*/

/*
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * the Systems Programming Group of the University of Utah Computer
 * Science Department.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * from: Utah $Hdr: hil_keymaps.c 1.1 90/07/09$
 *
 *	@(#)hil_keymaps.c	8.1 (Berkeley) 6/10/93
 */
/*
 * Copyright (c) 1988 University of Utah.
 *
 * This code is derived from software contributed to Berkeley by
 * the Systems Programming Group of the University of Utah Computer
 * Science Department.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * from: Utah $Hdr: hil_keymaps.c 1.1 90/07/09$
 *
 *	@(#)hil_keymaps.c	8.1 (Berkeley) 6/10/93
 */

/*
 * Keymaps for various HP-HIL keyboard layouts.  These tables apply only to
 * keyboards in "cooked" mode.  Currently only one is supported as an ITE
 * keyboard.
 *
 * Maps are indexed by cooked keycode and contain the ASCII character for
 * that keycode.  The map-set used depends on the keyboard "language".  The
 * map used within that set depends on the shift/control status that is
 * returned by the hardware along with the keycode.  If an entry is NUL for
 * a key in the appropriate unshifted, shifted, control, or control-shifted
 * table, then a single "string" table is consulted.  In this fashion, a
 * multi- character sequence can be returned for a key press.  Note that
 * control/shift status have no effect on multi-character lookup (i.e. there
 * is only one string table per set, not four).
 *
 * Someday we could allow user-definable keymaps, but we would have to come up
 * with a better format (at least externally).  This format takes up lots of
 * space.  Having keymaps for all 18 or so HP supported layouts would be bad
 * news.
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: hil_keymaps.c,v 1.11 2003/11/17 14:37:59 tsutsui Exp $");

#include <sys/param.h>
#include <hp300/dev/kbdmap.h>

char	us_keymap[] = {
	'\0',	'`',	'\\',	ESC,	'\0',	DEL,	'\0',	'\0',
	'\n',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\n',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\b',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	ESC,	'\r',	'\0',	'\n',	'0',	'.',	',',	'+',
	'1',	'2',	'3',	'-',	'4',	'5',	'6',	'*',
	'7',	'8',	'9',	'/',	'E',	'(',	')',	'^',
	'1',	'2',	'3',	'4',	'5',	'6',	'7',	'8',
	'9',	'0',	'-',	'=',	'[',	']',	';',	'\'',
	',',	'.',	'/',	'\040',	'o',	'p',	'k',	'l',
	'q',	'w',	'e',	'r',	't',	'y',	'u',	'i',
	'a',	's',	'd',	'f',	'g',	'h',	'j',	'm',
	'z',	'x',	'c',	'v',	'b',	'n',	'\0',	'\0'
};

char	us_shiftmap[] = {
	'\0',	'~',	'|',	DEL,	'\0',	DEL,	'\0',	'\0',
	'\n',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\n',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	DEL,	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	ESC,	'\r',	'\0',	'\n',	'0',	'.',	',',	'+',
	'1',	'2',	'3',	'-',	'4',	'5',	'6',	'*',
	'7',	'8',	'9',	'/',	'`',	'|',	'\\',	'~',
	'!',	'@',	'#',	'$',	'%',	'^',	'&',	'*',
	'(',	')',	'_',	'+',	'{',	'}',	':',	'\"',
	'<',	'>',	'?',	'\040',	'O',	'P',	'K',	'L',
	'Q',	'W',	'E',	'R',	'T',	'Y',	'U',	'I',
	'A',	'S',	'D',	'F',	'G',	'H',	'J',	'M',
	'Z',	'X',	'C',	'V',	'B',	'N',	'\0',	'\0'
};

char	us_ctrlmap[] = {
	'\0',	'`',	'\034',	ESC,	'\0',	DEL,	'\0',	'\0',
	'\n',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\n',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\b',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	ESC,	'\r',	'\0',	'\n',	'0',	'.',	',',	'+',
	'1',	'2',	'3',	'-',	'4',	'5',	'6',	'*',
	'7',	'8',	'9',	'/',	'E',	'(',	')',	'\036',
	'1',	'2',	'3',	'4',	'5',	'6',	'7',	'8',
	'9',	'0',	'-',	'=',	'\033',	'\035',	';',	'\'',
	',',	'.',	'/',	'\040',	'\017',	'\020',	'\013',	'\014',
	'\021',	'\027',	'\005',	'\022',	'\024',	'\031',	'\025',	'\011',
	'\001',	'\023',	'\004',	'\006',	'\007',	'\010',	'\012',	'\015',
	'\032',	'\030',	'\003',	'\026',	'\002',	'\016',	'\0',	'\0'
};

char	us_ctrlshiftmap[] = {
	'\0',	'~',	'|',	DEL,	'\0',	DEL,	'\0',	'\0',
	'\n',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\n',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	DEL,	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	ESC,	'\r',	'\0',	'\n',	'0',	'.',	',',	'+',
	'1',	'2',	'3',	'-',	'4',	'5',	'6',	'*',
	'7',	'8',	'9',	'/',	'`',	'|',	'\034',	'~',
	'!',	'\000',	'#',	'$',	'%',	'\036',	'&',	'*',
	'(',	')',	'\037',	'+',	'{',	'}',	':',	'\"',
	'<',	'>',	'?',	'\040',	'\017',	'\020',	'\013',	'\014',
	'\021',	'\027',	'\005',	'\022',	'\024',	'\031',	'\025',	'\011',
	'\001',	'\023',	'\004',	'\006',	'\007',	'\010',	'\012',	'\015',
	'\032',	'\030',	'\003',	'\026',	'\002',	'\016',	'\0',	'\0'
};

char	*us_stringmap[] = {
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	"\033V","\033h",
	"\033U",'\0',	'\0',	'\0',	'\0',	'\0',	"\033K","\033J",
	'\0',	'\0',	'\0',	"\033p","\033q","\033t","\033u","\033v",
	"\033r","\033s","\033B","\033A","\033w",'\0',	"\033D","\033C",
	"\033L","\033M",'\0',	'\0',	"\033P",'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0'
};

#ifdef UK_KEYBOARD
char	uk_keymap[] = {
	'\0',	'`',	'<',	ESC,	'\0',	DEL,	'\0',	'\0',
	'\n',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\n',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\b',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	ESC,	'\r',	'\0',	'\n',	'0',	'.',	',',	'+',
	'1',	'2',	'3',	'-',	'4',	'5',	'6',	'*',
	'7',	'8',	'9',	'/',	'E',	'(',	')',	'^',
	'1',	'2',	'3',	'4',	'5',	'6',	'7',	'8',
	'9',	'0',	'+',	'\'',	'[',	']',	'*',	'\\',
	',',	'.',	'-',	'\040',	'o',	'p',	'k',	'l',
	'q',	'w',	'e',	'r',	't',	'y',	'u',	'i',
	'a',	's',	'd',	'f',	'g',	'h',	'j',	'm',
	'z',	'x',	'c',	'v',	'b',	'n',	'\0',	'\0'
};

char	uk_shiftmap[] = {
	'\0',	'~',	'>',	DEL,	'\0',	DEL,	'\0',	'\0',
	'\n',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\n',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	DEL,	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	ESC,	'\r',	'\0',	'\n',	'0',	'.',	',',	'+',
	'1',	'2',	'3',	'-',	'4',	'5',	'6',	'*',
	'7',	'8',	'9',	'/',	'`',	'|',	'\\',	'~',
	'!',	'\"',	'#',	'$',	'%',	'&',	'^',	'(',
	')',	'=',	'?',	'/',	'{',	'}',	'@',	'|',
	';',	':',	'_',	'\040',	'O',	'P',	'K',	'L',
	'Q',	'W',	'E',	'R',	'T',	'Y',	'U',	'I',
	'A',	'S',	'D',	'F',	'G',	'H',	'J',	'M',
	'Z',	'X',	'C',	'V',	'B',	'N',	'\0',	'\0'
};

char	uk_ctrlmap[] = {
	'\0',	'`',	'<',	ESC,	'\0',	DEL,	'\0',	'\0',
	'\n',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\n',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\b',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	ESC,	'\r',	'\0',	'\n',	'0',	'.',	',',	'+',
	'1',	'2',	'3',	'-',	'4',	'5',	'6',	'*',
	'7',	'8',	'9',	'/',	'E',	'(',	')',	'\036',
	'1',	'2',	'3',	'4',	'5',	'6',	'7',	'8',
	'9',	'0',	'+',	'\'',	'\033',	'\035',	'*',	'\034',
	',',	'.',	'/',	'\040',	'\017',	'\020',	'\013',	'\014',
	'\021',	'\027',	'\005',	'\022',	'\024',	'\031',	'\025',	'\011',
	'\001',	'\023',	'\004',	'\006',	'\007',	'\010',	'\012',	'\015',
	'\032',	'\030',	'\003',	'\026',	'\002',	'\016',	'\0',	'\0'
};

char	uk_ctrlshiftmap[] = {
	'\0',	'~',	'>',	DEL,	'\0',	DEL,	'\0',	'\0',
	'\n',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\n',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	DEL,	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	ESC,	'\r',	'\0',	'\n',	'0',	'.',	',',	'+',
	'1',	'2',	'3',	'-',	'4',	'5',	'6',	'*',
	'7',	'8',	'9',	'/',	'`',	'|',	'\034',	'~',
	'!',	'\"',	'#',	'$',	'%',	'&',	'\036',	'(',
	')',	'=',	'?',	'/',	'{',	'}',	'\000',	'|',
	';',	':',	'\037',	'\040',	'\017',	'\020',	'\013',	'\014',
	'\021',	'\027',	'\005',	'\022',	'\024',	'\031',	'\025',	'\011',
	'\001',	'\023',	'\004',	'\006',	'\007',	'\010',	'\012',	'\015',
	'\032',	'\030',	'\003',	'\026',	'\002',	'\016',	'\0',	'\0'
};
#endif

#ifdef SE_KEYBOARD
char	se_keymap[] = {
	'\0',	'<',	'\'',	ESC,	'\0',	DEL,	'\0',	'\0',
	'\n',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\n',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\b',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	ESC,	'\r',	'\0',	'\n',	'0',	'.',	',',	'+',
	'1',	'2',	'3',	'-',	'4',	'5',	'6',	'*',
	'7',	'8',	'9',	'/',	'E',	'(',	')',	'^',
	'1',	'2',	'3',	'4',	'5',	'6',	'7',	'8',
	'9',	'0',	'+',	'`',	'}',	'~',	'|',	'{',
	',',	'.',	'-',	'\040',	'o',	'p',	'k',	'l',
	'q',	'w',	'e',	'r',	't',	'y',	'u',	'i',
	'a',	's',	'd',	'f',	'g',	'h',	'j',	'm',
	'z',	'x',	'c',	'v',	'b',	'n',	'\0',	'\0'
};

char	se_shiftmap[] = {
	'\0',	'>',	'*',	DEL,	'\0',	DEL,	'\0',	'\0',
	'\n',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\n',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	DEL,	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	ESC,	'\r',	'\0',	'\n',	'0',	'.',	',',	'+',
	'1',	'2',	'3',	'-',	'4',	'5',	'6',	'*',
	'7',	'8',	'9',	'-',	'`',	'*',	'\\',	'>',
	'!',	'\"',	'#',	'$',	'%',	'&',	'/',	'(',
	')',	'=',	'?',	'@',	']',	'^',	'\\',	'[',
	';',	':',	'_',	'\040',	'O',	'P',	'K',	'L',
	'Q',	'W',	'E',	'R',	'T',	'Y',	'U',	'I',
	'A',	'S',	'D',	'F',	'G',	'H',	'J',	'M',
	'Z',	'X',	'C',	'V',	'B',	'N',	'\0',	'\0'
};

char	se_ctrlmap[] = {
	'\0',	'`',	'\034',	ESC,	'\0',	DEL,	'\0',	'\0',
	'\n',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\n',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\b',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	ESC,	'\r',	'\0',	'\n',	'0',	'.',	',',	'+',
	'1',	'2',	'3',	'-',	'4',	'5',	'6',	'*',
	'7',	'8',	'9',	'/',	'E',	'(',	')',	'\036',
	'1',	'2',	'3',	'4',	'5',	'6',	'7',	'8',
	'9',	'0',	'-',	'=',	'\033',	'\035',	';',	'\'',
	',',	'.',	'/',	'\040',	'\017',	'\020',	'\013',	'\014',
	'\021',	'\027',	'\005',	'\022',	'\024',	'\031',	'\025',	'\011',
	'\001',	'\023',	'\004',	'\006',	'\007',	'\010',	'\012',	'\015',
	'\032',	'\030',	'\003',	'\026',	'\002',	'\016',	'\0',	'\0'
};

char	se_ctrlshiftmap[] = {
	'\0',	'~',	'|',	DEL,	'\0',	DEL,	'\0',	'\0',
	'\n',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\n',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\t',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	DEL,	'\0',
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',
	ESC,	'\r',	'\0',	'\n',	'0',	'.',	',',	'+',
	'1',	'2',	'3',	'-',	'4',	'5',	'6',	'*',
	'7',	'8',	'9',	'/',	'`',	'|',	'\034',	'~',
	'!',	'\000',	'#',	'$',	'%',	'\036',	'&',	'*',
	'(',	')',	'\037',	'+',	'{',	'}',	':',	'\"',
	'<',	'>',	'?',	'\040',	'\017',	'\020',	'\013',	'\014',
	'\021',	'\027',	'\005',	'\022',	'\024',	'\031',	'\025',	'\011',
	'\001',	'\023',	'\004',	'\006',	'\007',	'\010',	'\012',	'\015',
	'\032',	'\030',	'\003',	'\026',	'\002',	'\016',	'\0',	'\0'
};
#endif

/*
 * The keyboard map table.
 * Lookup is by hardware returned language code.
 */
struct kbdmap kbd_map[] = {
	{ KBD_US, "US ASCII",
	    us_keymap, us_shiftmap, us_ctrlmap, us_ctrlshiftmap, us_stringmap },

#ifdef UK_KEYBOARD
	{ KBD_UK,  "United Kingdom",
	    uk_keymap, uk_shiftmap, uk_ctrlmap, uk_ctrlshiftmap, us_stringmap },
#endif

#ifdef SE_KEYBOARD
	{ KBD_SE,  "Swedish",
	    se_keymap, se_shiftmap, se_ctrlmap, se_ctrlshiftmap, us_stringmap },
#endif

	{ 0,  NULL, NULL,  NULL,  NULL,  NULL, NULL },
};
