/*	$NetBSD: linux_errno.c,v 1.12 2001/11/13 02:08:49 lukem Exp $	*/

/*-
 * Copyright (c) 1995 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Frank van der Linden.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: linux_errno.c,v 1.12 2001/11/13 02:08:49 lukem Exp $");

#include <compat/linux/common/linux_errno.h>

/*
 * This list is used to translate NetBSD errnos to linux errnos
 * when returning from a system call. (NetBSD system call->linux program)
 */
const int native_to_linux_errno[] = {
	0,
	LINUX_SCERR_SIGN LINUX_EPERM,
	LINUX_SCERR_SIGN LINUX_ENOENT,
	LINUX_SCERR_SIGN LINUX_ESRCH,
	LINUX_SCERR_SIGN LINUX_EINTR,
	LINUX_SCERR_SIGN LINUX_EIO,
	LINUX_SCERR_SIGN LINUX_ENXIO,
	LINUX_SCERR_SIGN LINUX_E2BIG,
	LINUX_SCERR_SIGN LINUX_ENOEXEC,
	LINUX_SCERR_SIGN LINUX_EBADF,
	LINUX_SCERR_SIGN LINUX_ECHILD,
	LINUX_SCERR_SIGN LINUX_EDEADLK,
	LINUX_SCERR_SIGN LINUX_ENOMEM,
	LINUX_SCERR_SIGN LINUX_EACCES,
	LINUX_SCERR_SIGN LINUX_EFAULT,
	LINUX_SCERR_SIGN LINUX_ENOTBLK,
	LINUX_SCERR_SIGN LINUX_EBUSY,
	LINUX_SCERR_SIGN LINUX_EEXIST,
	LINUX_SCERR_SIGN LINUX_EXDEV,
	LINUX_SCERR_SIGN LINUX_ENODEV,
	LINUX_SCERR_SIGN LINUX_ENOTDIR,
	LINUX_SCERR_SIGN LINUX_EISDIR,
	LINUX_SCERR_SIGN LINUX_EINVAL,
	LINUX_SCERR_SIGN LINUX_ENFILE,
	LINUX_SCERR_SIGN LINUX_EMFILE,
	LINUX_SCERR_SIGN LINUX_ENOTTY,
	LINUX_SCERR_SIGN LINUX_ETXTBSY,
	LINUX_SCERR_SIGN LINUX_EFBIG,
	LINUX_SCERR_SIGN LINUX_ENOSPC,
	LINUX_SCERR_SIGN LINUX_ESPIPE,
	LINUX_SCERR_SIGN LINUX_EROFS,
	LINUX_SCERR_SIGN LINUX_EMLINK,
	LINUX_SCERR_SIGN LINUX_EPIPE,
	LINUX_SCERR_SIGN LINUX_EDOM,
	LINUX_SCERR_SIGN LINUX_ERANGE,
	LINUX_SCERR_SIGN LINUX_EAGAIN,
	LINUX_SCERR_SIGN LINUX_EINPROGRESS,
	LINUX_SCERR_SIGN LINUX_EALREADY,
	LINUX_SCERR_SIGN LINUX_ENOTSOCK,
	LINUX_SCERR_SIGN LINUX_EDESTADDRREQ,
	LINUX_SCERR_SIGN LINUX_EMSGSIZE,
	LINUX_SCERR_SIGN LINUX_EPROTOTYPE,
	LINUX_SCERR_SIGN LINUX_ENOPROTOOPT,
	LINUX_SCERR_SIGN LINUX_EPROTONOSUPPORT,
	LINUX_SCERR_SIGN LINUX_ESOCKTNOSUPPORT,
	LINUX_SCERR_SIGN LINUX_EOPNOTSUPP,
	LINUX_SCERR_SIGN LINUX_EPFNOSUPPORT,
	LINUX_SCERR_SIGN LINUX_EAFNOSUPPORT,
	LINUX_SCERR_SIGN LINUX_EADDRINUSE,
	LINUX_SCERR_SIGN LINUX_EADDRNOTAVAIL,
	LINUX_SCERR_SIGN LINUX_ENETDOWN,
	LINUX_SCERR_SIGN LINUX_ENETUNREACH,
	LINUX_SCERR_SIGN LINUX_ENETRESET,
	LINUX_SCERR_SIGN LINUX_ECONNABORTED,
	LINUX_SCERR_SIGN LINUX_ECONNRESET,
	LINUX_SCERR_SIGN LINUX_ENOBUFS,
	LINUX_SCERR_SIGN LINUX_EISCONN,
	LINUX_SCERR_SIGN LINUX_ENOTCONN,
	LINUX_SCERR_SIGN LINUX_ESHUTDOWN,
	LINUX_SCERR_SIGN LINUX_ETOOMANYREFS,
	LINUX_SCERR_SIGN LINUX_ETIMEDOUT,
	LINUX_SCERR_SIGN LINUX_ECONNREFUSED,
	LINUX_SCERR_SIGN LINUX_ELOOP,
	LINUX_SCERR_SIGN LINUX_ENAMETOOLONG,
	LINUX_SCERR_SIGN LINUX_EHOSTDOWN,
	LINUX_SCERR_SIGN LINUX_EHOSTUNREACH,
	LINUX_SCERR_SIGN LINUX_ENOTEMPTY,
	LINUX_SCERR_SIGN LINUX_ENOSYS,		/* not mapped (EPROCLIM) */
	LINUX_SCERR_SIGN LINUX_EUSERS,
	LINUX_SCERR_SIGN LINUX_EDQUOT,
	LINUX_SCERR_SIGN LINUX_ESTALE,
	LINUX_SCERR_SIGN LINUX_EREMOTE,
	LINUX_SCERR_SIGN LINUX_ENOSYS,		/* not mapped (EBADRPC) */
	LINUX_SCERR_SIGN LINUX_ENOSYS,		/* not mapped (ERPCMISMATCH) */
	LINUX_SCERR_SIGN LINUX_ENOSYS,		/* not mapped (EPROGUNAVAIL) */
	LINUX_SCERR_SIGN LINUX_ENOSYS,		/* not mapped (EPROGMISMATCH) */
	LINUX_SCERR_SIGN LINUX_ENOSYS,		/* not mapped (EPROCUNAVAIL) */
	LINUX_SCERR_SIGN LINUX_ENOLCK,
	LINUX_SCERR_SIGN LINUX_ENOSYS,
	LINUX_SCERR_SIGN LINUX_ENOSYS,		/* not mapped (EFTYPE) */
	LINUX_SCERR_SIGN LINUX_ENOSYS,		/* not mapped (EAUTH) */
	LINUX_SCERR_SIGN LINUX_ENOSYS,		/* not mapped (ENEEDAUTH) */
	LINUX_SCERR_SIGN LINUX_EIDRM,
	LINUX_SCERR_SIGN LINUX_ENOMSG,		/* 83 */

	/*
	 * The rest of the list consists of errors that only
	 * Linux has. They can be used to map them on to
	 * themselves, so Linux emulating syscalls can return
	 * these values.
	 */

	LINUX_SCERR_SIGN LINUX_ECHRNG,
	LINUX_SCERR_SIGN LINUX_EL2NSYNC,
	LINUX_SCERR_SIGN LINUX_EL3HLT,
	LINUX_SCERR_SIGN LINUX_EL3RST,
	LINUX_SCERR_SIGN LINUX_ELNRNG,
	LINUX_SCERR_SIGN LINUX_EUNATCH,
	LINUX_SCERR_SIGN LINUX_ENOCSI,
	LINUX_SCERR_SIGN LINUX_EL2HLT,
	LINUX_SCERR_SIGN LINUX_EBADE,
	LINUX_SCERR_SIGN LINUX_EBADR,
	LINUX_SCERR_SIGN LINUX_EXFULL,
	LINUX_SCERR_SIGN LINUX_ENOANO,
	LINUX_SCERR_SIGN LINUX_EBADRQC,
	LINUX_SCERR_SIGN LINUX_EBADSLT,
	LINUX_SCERR_SIGN LINUX_EDEADLOCK,
	LINUX_SCERR_SIGN LINUX_EBFONT,
	LINUX_SCERR_SIGN LINUX_ENOSTR,
	LINUX_SCERR_SIGN LINUX_ENODATA,
	LINUX_SCERR_SIGN LINUX_ETIME,
	LINUX_SCERR_SIGN LINUX_ENOSR,
	LINUX_SCERR_SIGN LINUX_ENONET,
	LINUX_SCERR_SIGN LINUX_ENOPKG,
	LINUX_SCERR_SIGN LINUX_ENOLINK,
	LINUX_SCERR_SIGN LINUX_EADV,
	LINUX_SCERR_SIGN LINUX_ESRMNT,
	LINUX_SCERR_SIGN LINUX_ECOMM,
	LINUX_SCERR_SIGN LINUX_EPROTO,
	LINUX_SCERR_SIGN LINUX_EMULTIHOP,
	LINUX_SCERR_SIGN LINUX_EDOTDOT,
	LINUX_SCERR_SIGN LINUX_EBADMSG,
	LINUX_SCERR_SIGN LINUX_EOVERFLOW,
	LINUX_SCERR_SIGN LINUX_ENOTUNIQ,
	LINUX_SCERR_SIGN LINUX_EBADFD,
	LINUX_SCERR_SIGN LINUX_EREMCHG,
	LINUX_SCERR_SIGN LINUX_ELIBACC,
	LINUX_SCERR_SIGN LINUX_ELIBBAD,
	LINUX_SCERR_SIGN LINUX_ELIBSCN,
	LINUX_SCERR_SIGN LINUX_ELIBMAX,
	LINUX_SCERR_SIGN LINUX_ELIBEXEC,
	LINUX_SCERR_SIGN LINUX_EILSEQ,
	LINUX_SCERR_SIGN LINUX_ERESTART,
	LINUX_SCERR_SIGN LINUX_ESTRPIPE,
	LINUX_SCERR_SIGN LINUX_EUCLEAN,
	LINUX_SCERR_SIGN LINUX_ENOTNAM,
	LINUX_SCERR_SIGN LINUX_ENAVAIL,
	LINUX_SCERR_SIGN LINUX_EISNAM,
	LINUX_SCERR_SIGN LINUX_EREMOTEIO,
};
