\ #if FICL_WANT_LOCALS
\ ** ficl/softwords/jhlocal.fr
\ ** stack comment style local syntax...
\ { a b c | cleared -- d e }
\ variables before the "|" are initialized in reverse order
\ from the stack. Those after the "|" are zero initialized.
\ Anything between "--" and "}" is treated as comment
\ Uses locals...
\ locstate: 0 = looking for | or -- or }}
\           1 = found |
\           2 = found --
\           3 = found }
\           4 = end of line
\
\ $FreeBSD: src/sys/boot/ficl/softwords/jhlocal.fr,v 1.1.6.1 2000/07/06 23:51:46 obrien Exp $

hide
0 constant zero

: ?--   ( c-addr u -- c-addr u flag )
    2dup s" --" compare 0= ;
: ?}    ( c-addr u -- c-addr u flag )
    2dup s" }"  compare 0= ;
: ?|    ( c-addr u -- c-addr u flag )
    2dup s" |"  compare 0= ;

\ examine name and push true if it's a 2local
\ (starts with '2'), false otherwise. 
: ?2loc ( c-addr u -- c-addr n flag )
    over c@ [char] 2 = if true else false endif ;

: ?delim   ( c-addr u -- state | c-addr u 0 )
    ?|  if  2drop 1 exit endif
    ?-- if  2drop 2 exit endif
    ?}  if  2drop 3 exit endif
    dup 0= 
        if  2drop 4 exit endif
    0
;

set-current

: {
    0 dup locals| locstate |
    
    \ stack locals until we hit a delimiter
    begin
        parse-word      \ ( nLocals c-addr u )
        ?delim dup to locstate
    0= while
        rot 1+          \ ( c-addr u ... c-addr u nLocals )
    repeat

    \ now unstack the locals
    0 ?do 
	    ?2loc if (2local) else (local) endif 
	loop   \ ( )

    \ zero locals until -- or }
    locstate 1 = if
        begin
            parse-word
            ?delim dup to locstate
        0= while
		    ?2loc if 
			    postpone zero postpone zero  (2local)
			else
                postpone zero  (local)
		    endif
        repeat
    endif

    0 0 (local)

    \ toss words until }
    locstate 2 = if
        begin
            parse-word
            ?delim dup to locstate
        0= while
            2drop
        repeat
    endif

    locstate 3 <> abort" syntax error in { } local line"
; immediate compile-only

previous 
\ #endif

