/*	BSDI stats_inet.h,v 2.5 2001/04/12 20:20:10 dab Exp	*/

static struct stats ip_stat[] = {
	{ { offsetof(struct ipstat, ips_total) },
	  S_FMT1, FMT(FMT_Q " total pkt%s rcvd") },
	{ { offsetof(struct ipstat, ips_badsum) },
	  S_FMT1, FMT(FMT_Q " bad header cksum%s") },
	{ { offsetof(struct ipstat, ips_toosmall) },
	  S_FMT_5, FMT(FMT_Q " w/size smaller than minimum") },
	{ { offsetof(struct ipstat, ips_tooshort) },
	  S_FMT_5, FMT(FMT_Q " w/data size < data length") },
	{ { offsetof(struct ipstat, ips_badhlen) },
	  S_FMT_5, FMT(FMT_Q " w/header length < data size") },
	{ { offsetof(struct ipstat, ips_badlen) },
	  S_FMT_5, FMT(FMT_Q " w/data length < header length") },
	{ { offsetof(struct ipstat, ips_badoptions) },
	  S_FMT_5, FMT(FMT_Q " w/bad options") },
	{ { offsetof(struct ipstat, ips_badvers) },
	  S_FMT_5, FMT(FMT_Q " w/incorrect version number") },
	{ { offsetof(struct ipstat, ips_badsrcintf) },
	  S_FMT_5, FMT(FMT_Q " w/bad source intf") },
	{ { offsetof(struct ipstat, ips_fragments) },
	  S_FMT1, FMT(FMT_Q " fragment%s rcvd") },
	{ { offsetof(struct ipstat, ips_fragdropped) },
	  S_FMT1, FMT(FMT_Q " fragment%s dropped (dup or no bufs)") },
	{ { offsetof(struct ipstat, ips_fragtimeout) },
	  S_FMT1, FMT(FMT_Q " fragment%s dropped after timeout") },
	{ { offsetof(struct ipstat, ips_fragoverflow) },
	  S_FMT1, FMT(FMT_Q " fragmented pkt%s dropped: overflow") },
	{ { offsetof(struct ipstat, ips_rfc1858) },
	  S_FMT1, FMT(FMT_Q " fragmented pkt%s dropped: flags not in first fragment") },
	{ { offsetof(struct ipstat, ips_rejected) },
	  S_FMT1, FMT(FMT_Q " pkt%s dropped: rejected by IP filter") },
	{ { offsetof(struct ipstat, ips_reassembled) },
	  S_FMT1, FMT(FMT_Q " pkt%s reassembled ok") },
	{ { offsetof(struct ipstat, ips_delivered) },
	  S_FMT1, FMT(FMT_Q " pkt%s for this host") },
	{ { offsetof(struct ipstat, ips_noproto) },
	  S_FMT1, FMT(FMT_Q " pkt%s for unknown/unsupported proto") },
	{ { offsetof(struct ipstat, ips_forward) },
	  S_FMT1, FMT(FMT_Q " pkt%s forwarded") },
	{ { offsetof(struct ipstat, ips_cantforward) },
	  S_FMT1, FMT(FMT_Q " pkt%s not forwardable") },
	{ { offsetof(struct ipstat, ips_redirectsent) },
	  S_FMT1, FMT(FMT_Q " redirect%s sent") },
	{ { offsetof(struct ipstat, ips_localout) },
	  S_FMT1, FMT(FMT_Q " pkt%s sent from this host") },
	{ { offsetof(struct ipstat, ips_rawout) },
	  S_FMT1, FMT(FMT_Q " pkt%s sent w/fabricated ip header") },
	{ { offsetof(struct ipstat, ips_odropped) },
	  S_FMT1, FMT(FMT_Q " output pkt%s dropped: no bufs, etc.") },
	{ { offsetof(struct ipstat, ips_noroute) },
	  S_FMT1, FMT(FMT_Q " output pkt%s dropped: no route") },
	{ { offsetof(struct ipstat, ips_fragmented) },
	  S_FMT1, FMT(FMT_Q " output dgram%s fragmented") },
	{ { offsetof(struct ipstat, ips_ofragments) },
	  S_FMT1, FMT(FMT_Q " fragment%s created") },
	{ { offsetof(struct ipstat, ips_cantfrag) },
	  S_FMT1, FMT(FMT_Q " dgram%s that can't be fragmented") },
	{ { offsetof(struct ipstat, ips_cantfrag) },
	  S_FMT1, FMT(FMT_Q " dgram%s that can't be fragmented") },
	{ { offsetof(struct ipstat, ips_nogif) },
	  S_FMT1, FMT(FMT_Q " tunneling packet%s that can't find gif") },
	{ { offsetof(struct ipstat, ips_badaddr) },
	  S_FMT1, FMT(FMT_Q " datagram%s with bad address in header") },
	{ { 0 } }
};


static struct stats tcp_stat[] = {
	{ { offsetof(struct tcpstat, tcps_sndtotal) },
	  S_FMT1, FMT(FMT_Q " pkt%s sent") },
	{ { offsetof(struct tcpstat, tcps_sndpack),
	    offsetof(struct tcpstat, tcps_sndbyte) },
	  S_FMT2, FMT_I(FMT_Q " data pkt%s (" FMT_Q " byte%s)") },
	{ { offsetof(struct tcpstat, tcps_sndrexmitpack),
	    offsetof(struct tcpstat, tcps_sndrexmitbyte) },
	  S_FMT2, FMT_I(FMT_Q " data pkt%s (" FMT_Q " byte%s) rexmitted") },
	{ { offsetof(struct tcpstat, tcps_sndrexmitfast) },
	  S_FMT1, FMT_I(FMT_Q " fast rexmit%s") },
	{ { offsetof(struct tcpstat, tcps_sndacks),
	    offsetof(struct tcpstat, tcps_delack) },
	  S_FMT1_5, FMT_I(FMT_Q " ack-only pkt%s (" FMT_Q " delayed)") },
	{ { offsetof(struct tcpstat, tcps_sndurg) },
	  S_FMT1, FMT_I(FMT_Q " URG only pkt%s") },
	{ { offsetof(struct tcpstat, tcps_sndprobe) },
	  S_FMT1, FMT_I(FMT_Q " window probe pkt%s") },
	{ { offsetof(struct tcpstat, tcps_sndwinup) },
	  S_FMT1, FMT_I(FMT_Q " window update pkt%s") },
	{ { offsetof(struct tcpstat, tcps_sndctrl) },
	  S_FMT1, FMT_I(FMT_Q " control pkt%s") },
	{ { offsetof(struct tcpstat, tcps_rcvtotal) },
	  S_FMT1, FMT(FMT_Q " pkt%s rcvd") },
	{ { offsetof(struct tcpstat, tcps_rcvackpack),
	    offsetof(struct tcpstat, tcps_rcvackbyte) },
	  S_FMT2, FMT_I(FMT_Q " ack%s (for " FMT_Q " byte%s)") },
	{ { offsetof(struct tcpstat, tcps_rcvdupack) },
	  S_FMT1, FMT_I(FMT_Q " dup ack%s") },
	{ { offsetof(struct tcpstat, tcps_rcvacktoomuch) },
	  S_FMT1, FMT_I(FMT_Q " ack%s for unsent data") },
	{ { offsetof(struct tcpstat, tcps_rcvpack),
	    offsetof(struct tcpstat, tcps_rcvbyte) },
	  S_FMT2, FMT_I(FMT_Q " pkt%s (" FMT_Q " byte%s) rcvd in-sequence") },
	{ { offsetof(struct tcpstat, tcps_rcvduppack),
	    offsetof(struct tcpstat, tcps_rcvdupbyte) },
	  S_FMT2, FMT_I(FMT_Q " completely dup pkt%s (" FMT_Q " byte%s)") },
	{ { offsetof(struct tcpstat, tcps_pawsdrop) },
	  S_FMT1, FMT_I(FMT_Q " old dup pkt%s") },
	{ { offsetof(struct tcpstat, tcps_rcvpartduppack),
	    offsetof(struct tcpstat, tcps_rcvpartdupbyte) },
	  S_FMT2, FMT_I(FMT_Q " pkt%s w/some dup data (" FMT_Q " byte%s duped)") },
	{ { offsetof(struct tcpstat, tcps_rcvoopack),
	    offsetof(struct tcpstat, tcps_rcvoobyte) },
	  S_FMT2, FMT_I(FMT_Q " out-of-order pkt%s (" FMT_Q " byte%s)") },
	{ { offsetof(struct tcpstat, tcps_rcvpackafterwin),
	    offsetof(struct tcpstat, tcps_rcvbyteafterwin) },
	  S_FMT2, FMT_I(FMT_Q " pkt%s (" FMT_Q " byte%s) of data after window") },
	{ { offsetof(struct tcpstat, tcps_rcvwinprobe) },
	  S_FMT1, FMT_I(FMT_Q " window probe%s") },
	{ { offsetof(struct tcpstat, tcps_rcvwinupd) },
	  S_FMT1, FMT_I(FMT_Q " window update pkt%s") },
	{ { offsetof(struct tcpstat, tcps_rcvafterclose) },
	  S_FMT1, FMT_I(FMT_Q " pkt%s rcvd after close") },
	{ { offsetof(struct tcpstat, tcps_rcvbadsum) },
	  S_FMT1, FMT_I(FMT_Q " dropped: bad cksum%s") },
	{ { offsetof(struct tcpstat, tcps_rcvbadoff) },
	  S_FMT1, FMT_I(FMT_Q " dropped: bad header offset field%s") },
	{ { offsetof(struct tcpstat, tcps_rcvshort) },
	  S_FMT_5, FMT_I(FMT_Q " dropped: pkt too short") },
	{ { offsetof(struct tcpstat, tcps_rcvmemdrop) },
	  S_FMT1, FMT_I(FMT_Q " dropped: no memory") },
	{ { offsetof(struct tcpstat, tcps_connattempt) },
	  S_FMT1, FMT(FMT_Q " connection request%s") },
	{ { offsetof(struct tcpstat, tcps_accepts) },
	  S_FMT1, FMT(FMT_Q " connection accept%s") },
	{ { offsetof(struct tcpstat, tcps_badsyn) },
	  S_FMT1, FMT(FMT_Q " bad connection attempt%s") },
	{ { offsetof(struct tcpstat, tcps_connects) },
	  S_FMT1, FMT(FMT_Q " connection%s established (including accepts)") },
	{ { offsetof(struct tcpstat, tcps_closed),
	    offsetof(struct tcpstat, tcps_drops) },
	  S_FMT2, FMT(FMT_Q " connection%s closed (including " FMT_Q " drop%s)") },
	{ { offsetof(struct tcpstat, tcps_conndrops) },
	  S_FMT1, FMT(FMT_Q " embryonic connection%s dropped") },
	{ { offsetof(struct tcpstat, tcps_rttupdated),
	    offsetof(struct tcpstat, tcps_segstimed) },
	  S_FMT2, FMT(FMT_Q " segment%s updted rtt (of " FMT_Q " attempt%s)") },
	{ { offsetof(struct tcpstat, tcps_rexmttimeo) },
	  S_FMT1, FMT(FMT_Q " rexmit timeout%s") },
	{ { offsetof(struct tcpstat, tcps_timeoutdrop) },
	  S_FMT1, FMT_I(FMT_Q " connection%s dropped by rexmit timeout") },
	{ { offsetof(struct tcpstat, tcps_persisttimeo) },
	  S_FMT1, FMT(FMT_Q " persist timeout%s") },
	{ { offsetof(struct tcpstat, tcps_persistdrop) },
	  S_FMT1, FMT(FMT_Q " connection%s timed out in persist") },
	{ { offsetof(struct tcpstat, tcps_keeptimeo) },
	  S_FMT1, FMT(FMT_Q " keepalive timeout%s") },
	{ { offsetof(struct tcpstat, tcps_keepprobe) },
	  S_FMT1, FMT_I(FMT_Q " keepalive probe%s sent") },
	{ { offsetof(struct tcpstat, tcps_keepdrops) },
	  S_FMT1, FMT_I(FMT_Q " connection%s dropped by keepalive") },
	{ { offsetof(struct tcpstat, tcps_droppedsyn) },
	  S_FMT1, FMT_I(FMT_Q " SYN%s dropped: queue or memory full") },
	{ { offsetof(struct tcpstat, tcps_predack) },
	  S_FMT1, FMT(FMT_Q " correct ACK header prediction%s") },
	{ { offsetof(struct tcpstat, tcps_preddat) },
	  S_FMT1, FMT(FMT_Q " correct data pkt header prediction%s") },
	{ { offsetof(struct tcpstat, tcps_pcbcachemiss) },
	  S_FMT1ES, FMT(FMT_Q " PCB cache miss%s") },
	{ { offsetof(struct tcpstat, tcps_sc_added) },
	  S_FMT_5, FMT(FMT_Q " SYN cache entries added") },
	{ { offsetof(struct tcpstat, tcps_sc_completed) },
	  S_FMT_5, FMT_I(FMT_Q " completed") },
	{ { offsetof(struct tcpstat, tcps_sc_aborted) },
	  S_FMT_5, FMT_I(FMT_Q " aborted (no space to build PCB)") },
	{ { offsetof(struct tcpstat, tcps_sc_timed_out) },
	  S_FMT_5, FMT_I(FMT_Q " timed out") },
	{ { offsetof(struct tcpstat, tcps_sc_overflowed) },
	  S_FMT_5, FMT_I(FMT_Q " dropped: overflow") },
	{ { offsetof(struct tcpstat, tcps_sc_bucketoverflow) },
	  S_FMT_5, FMT_I(FMT_Q " dropped: bucket overflow") },
	{ { offsetof(struct tcpstat, tcps_sc_reset) },
	  S_FMT_5, FMT_I(FMT_Q " dropped: RST") },
	{ { offsetof(struct tcpstat, tcps_sc_unreach) },
	  S_FMT_5, FMT_I(FMT_Q " dropped: ICMP unreachable") },
	{ { offsetof(struct tcpstat, tcps_sc_dupesyn) },
	  S_FMT1, FMT_I(FMT_Q " dup SYN%s rcvd for existing cache entries") },
	{ { offsetof(struct tcpstat, tcps_sc_dropped) },
	  S_FMT1, FMT_I(FMT_Q " SYN%s dropped (no route or no space)") },
	{ { 0 } }
};

static struct stats udp_stat[] = {
	{ { offsetof(struct udpstat, udps_ipackets) },
	  S_FMT1, FMT(FMT_Q " dgram%s rcvd") },
	{ { offsetof(struct udpstat, udps_hdrops) },
	  S_FMT_5, FMT(FMT_Q " w/incomplete header") },
	{ { offsetof(struct udpstat, udps_badlen) },
	  S_FMT_5, FMT(FMT_Q " w/bad data length field") },
	{ { offsetof(struct udpstat, udps_badsum) },
	  S_FMT_5, FMT(FMT_Q " w/bad cksum") },
	{ { offsetof(struct udpstat, udps_nosum) },
	  S_FMT_5, FMT(FMT_Q " w/no cksum") },
	{ { offsetof(struct udpstat, udps_noport) },
	  S_FMT_5, FMT(FMT_Q " dropped: no socket") },
	{ { offsetof(struct udpstat, udps_noportbcast) },
	  S_FMT1, FMT(FMT_Q " bcast/mcast dgram%s dropped: no socket") },
	{ { offsetof(struct udpstat, udps_fullsock) },
	  S_FMT_5, FMT(FMT_Q " dropped: socket full") },
	{ { (u_long)&udps_delivered },
	  S_FMT1 | S_FMT_DIRECT, FMT(FMT_Q " dgram%s delivered") },
	{ { offsetof(struct udpstat, udpps_pcbcachemiss) },
	  S_FMT1ES, FMT(FMT_Q " PCB cache miss%s") },
	{ { offsetof(struct udpstat, udps_opackets) },
	  S_FMT1, FMT(FMT_Q " dgram%s output") },
	{ { 0 } }
};


static struct stats icmp_stat[] = {
	{ { offsetof(struct icmpstat, icps_error) },
	  S_FMT1, FMT(FMT_Q " call%s to icmp_error") },
	{ { offsetof(struct icmpstat, icps_oldicmp) },
	  S_FMT1, FMT(FMT_Q " err%s not sent: old msg was icmp err") },
	{ { offsetof(struct icmpstat, icps_oldshort) },
	  S_FMT1, FMT(FMT_Q " err%s not sent: old ip too short") },
	{ { (u_long)&icmps_sent },
	  S_FMT1|S_FMT_DIRECT, FMT(FMT_Q " pkts sent") },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_ECHOREPLY]) },
	  S_FMT1IES|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " echo repl%s"), ICMP_ECHOREPLY },
	{ { offsetof(struct icmpstat, icps_outhist[1]) },
	  S_FMT_5|S_FMT_FLAG1|S_FMT_SKIPZERO, NULL, 1 },
	{ { offsetof(struct icmpstat, icps_outhist[2]) },
	  S_FMT_5|S_FMT_FLAG1|S_FMT_SKIPZERO, NULL, 2 },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_UNREACH]) },
	  S_FMT1|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " destination unreachable%s"), ICMP_UNREACH },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_SOURCEQUENCH]) },
	  S_FMT1ES|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " source quench%s"), ICMP_SOURCEQUENCH },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_REDIRECT]) },
	  S_FMT1|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " routing redirect%s"), ICMP_REDIRECT },
	{ { offsetof(struct icmpstat, icps_outhist[6]) },
	  S_FMT_5|S_FMT_FLAG1|S_FMT_SKIPZERO, NULL, 6 },
	{ { offsetof(struct icmpstat, icps_outhist[7]) },
	  S_FMT_5|S_FMT_FLAG1|S_FMT_SKIPZERO, NULL, 7 },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_ECHO]) },
	  S_FMT1|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " echo%s"), ICMP_ECHO },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_ROUTERADVERT]) },
	  S_FMT1|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " router advertisment%s"), ICMP_ROUTERADVERT },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_ROUTERSOLICIT]) },
	  S_FMT1|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " router solicitation%s"), ICMP_ROUTERSOLICIT },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_TIMXCEED]) },
	  S_FMT1|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " time exceeded%s"), ICMP_TIMXCEED },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_PARAMPROB]) },
	  S_FMT1|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " parameter problem%s"), ICMP_PARAMPROB },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_TSTAMP]) },
	  S_FMT1|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " time stamp%s"), ICMP_TSTAMP },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_TSTAMPREPLY])},
	  S_FMT1IES|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " time stamp repl%s"), ICMP_TSTAMPREPLY },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_IREQ]) },
	  S_FMT1|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " info request%s"), ICMP_IREQ },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_IREQREPLY]) },
	  S_FMT1IES|S_FMT_FLAG1|S_FMT_SKIPZERO,FMT_I(FMT_Q " info request repl%s"), ICMP_IREQREPLY },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_MASKREQ]) },
	  S_FMT1|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " address mask request%s"), ICMP_MASKREQ },
	{ { offsetof(struct icmpstat, icps_outhist[ICMP_MASKREPLY]) },
	  S_FMT1IES|S_FMT_FLAG1|S_FMT_SKIPZERO, FMT_I(FMT_Q " address mask repl%s"), ICMP_MASKREPLY },
	{ { offsetof(struct icmpstat, icps_badcode) },
	    S_FMT1, FMT(FMT_Q " msg%s w/bad code fields") },
	{ { offsetof(struct icmpstat, icps_tooshort) },
	    S_FMT1, FMT(FMT_Q " msg%s < minimum length") },
	{ { offsetof(struct icmpstat, icps_checksum) },
	    S_FMT1, FMT(FMT_Q " msg%s w/bad cksum") },
	{ { offsetof(struct icmpstat, icps_badlen) },
	    S_FMT1, FMT(FMT_Q " msg%s w/bad length") },
	{ { (u_long)&icmps_received },
	  S_FMT1|S_FMT_DIRECT, FMT(FMT_Q " pkts rcvd") },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_ECHOREPLY]) },
	  S_FMT_FLAG1, NULL, ICMP_ECHOREPLY },
	{ { offsetof(struct icmpstat, icps_inhist[1]) },
	  S_FMT_FLAG1, NULL, 1 },
	{ { offsetof(struct icmpstat, icps_inhist[2]) },
	  S_FMT_FLAG1, NULL, 2 },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_UNREACH]) },
	  S_FMT_FLAG1, NULL, ICMP_UNREACH },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_SOURCEQUENCH]) },
	  S_FMT_FLAG1, NULL, ICMP_SOURCEQUENCH },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_REDIRECT]) },
	  S_FMT_FLAG1, NULL, ICMP_REDIRECT },
	{ { offsetof(struct icmpstat, icps_inhist[6]) },
	  S_FMT_FLAG1, NULL, 6 },
	{ { offsetof(struct icmpstat, icps_inhist[7]) },
	  S_FMT_FLAG1, NULL, 7 },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_ECHO]) },
	  S_FMT_FLAG1, NULL, ICMP_ECHO },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_ROUTERADVERT]) },
	  S_FMT_FLAG1, NULL, ICMP_ROUTERADVERT },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_ROUTERSOLICIT]) },
	  S_FMT_FLAG1, NULL, ICMP_ROUTERSOLICIT },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_TIMXCEED]) },
	  S_FMT_FLAG1, NULL, ICMP_TIMXCEED },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_PARAMPROB]) },
	  S_FMT_FLAG1, NULL, ICMP_PARAMPROB },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_TSTAMP]) },
	  S_FMT_FLAG1, NULL, ICMP_TSTAMP },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_TSTAMPREPLY])},
	  S_FMT_FLAG1, NULL, ICMP_TSTAMPREPLY },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_IREQ]) },
	  S_FMT_FLAG1, NULL, ICMP_IREQ },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_IREQREPLY]) },
	  S_FMT_FLAG1, NULL, ICMP_IREQREPLY },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_MASKREQ]) },
	  S_FMT_FLAG1, NULL, ICMP_MASKREQ },
	{ { offsetof(struct icmpstat, icps_inhist[ICMP_MASKREPLY]) },
	  S_FMT_FLAG1, NULL, ICMP_MASKREPLY },
	{ { offsetof(struct icmpstat, icps_reflect) },
	    S_FMT1, FMT(FMT_Q " msg response%s generated") },
	{ { offsetof(struct icmpstat, icps_bmcastecho) },
	    S_FMT1, FMT(FMT_Q " broadcast echo request%s ignored") },
	{ { offsetof(struct icmpstat, icps_bogusfrag) },
	    S_FMT1, FMT(FMT_Q " invalid frag needed msg%s") },
	{ { offsetof(struct icmpstat, icps_badaddr) },
	    S_FMT1ES, FMT(FMT_Q " invalid return address%s") },
	{ { offsetof(struct icmpstat, icps_noroute) },
	    S_FMT1, FMT(FMT_Q " no return route%s") },
	{ { 0 } }
};

static void
icmp_stat_init(void) {
	struct stats *sp;
	char buf[LINE_MAX];
	const char *msgs[ICMP_MAXTYPE + 1];
	u_int flags[ICMP_MAXTYPE + 1];

	memset(msgs, 0, sizeof(msgs));
	memset(flags, 0, sizeof(flags));
	for (sp = icmp_stat; sp->s_flags != 0; sp++) {
		if ((sp->s_flags & S_FMT_FLAG1) == 0)
			continue;
		if (sp->s_fmt != NULL) {
			msgs[sp->s_aux] = sp->s_fmt;
			flags[sp->s_aux] = sp->s_flags;
		} else if (msgs[sp->s_aux] == NULL) {
			(void)snprintf(buf, sizeof(buf), FMT_I("%s type #%u"),
			    FMT_Q, sp->s_aux);
			msgs[sp->s_aux] = sp->s_fmt = strdup(buf);
			flags[sp->s_aux] = sp->s_flags;
		} else {
			sp->s_fmt = msgs[sp->s_aux];
			sp->s_flags = flags[sp->s_aux];
		}
		sp->s_aux = 0;
	}
}

static struct stats igmp_stat[] = {
	{ { offsetof(struct igmpstat, igps_rcv_total) },
	    S_FMT1, FMT(FMT_Q " msg%s rcvd") },
        { { offsetof(struct igmpstat, igps_rcv_tooshort) },
	    S_FMT1, FMT(FMT_Q " msg%s rcvd w/too few bytes") },
        { { offsetof(struct igmpstat, igps_rcv_badsum) },
	    S_FMT1, FMT(FMT_Q " msg%s rcvd w/bad cksum") },
        { { offsetof(struct igmpstat, igps_rcv_queries) },
	    S_FMT1IES, FMT(FMT_Q " mbrship quer%s rcvd") },
        { { offsetof(struct igmpstat, igps_rcv_badqueries) },
	    S_FMT1IES, FMT(FMT_Q " mbrship quer%s rcvd w/bad data") },
        { { offsetof(struct igmpstat, igps_rcv_reports) },
	    S_FMT1, FMT(FMT_Q " mbrship report%s rcvd") },
        { { offsetof(struct igmpstat, igps_rcv_badreports) },
	    S_FMT1, FMT(FMT_Q " mbrship report%s rcvd w/bad data")},
        { { offsetof(struct igmpstat, igps_rcv_ourreports) },
	    S_FMT1, FMT(FMT_Q " mbrship report%s rcvd for joined groups") },
        { { offsetof(struct igmpstat, igps_snd_reports) },
	    S_FMT1, FMT(FMT_Q " mbrship report%s sent") },
	{ { 0 } }
};

