/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/*	BSDI route.c,v 2.11 1996/09/12 13:33:48 jch Exp	*/

/*
 * Copyright (c) 1983, 1988, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char sccsid[] = "@(#)route.c	8.5 (Berkeley) 11/8/94";
#endif /* not lint */

#include <sys/param.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/mbuf.h>

#include <net/if.h>
#include <net/if_token.h>
#include <net/if_dl.h>
#include <net/if_types.h>
#define  KERNEL
#include <net/route.h>
#undef KERNEL
#include <netinet/in.h>

#include <netns/ns.h>

#include <sys/sysctl.h>

#include <irs.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <err.h>
#include "netstat.h"

#define kget(p, d) (kread((u_long)(p), (char *)&(d), sizeof (d)))

/*
 * Definitions for showing gateway flags.
 */
struct bits {
	short	b_mask;
	char	b_val;
} bits[] = {
	{ RTF_UP,	'U' },
	{ RTF_GATEWAY,	'G' },
	{ RTF_HOST,	'H' },
	{ RTF_REJECT,	'R' },
	{ RTF_DYNAMIC,	'D' },
	{ RTF_MODIFIED,	'M' },
	{ RTF_DONE,	'd' }, /* Completed -- for routing messages only */
	{ RTF_MASK,	'm' }, /* Mask Present -- for routing messages only */
	{ RTF_CLONING,	'C' },
	{ RTF_XRESOLVE,	'X' },
	{ RTF_LLINFO,	'L' },
	{ RTF_STATIC,	'S' },
	{ RTF_BLACKHOLE,'B' },
	{ RTF_CLONED,	'c' },
	{ RTF_PROTO1,	'1' },
	{ RTF_PROTO2,	'2' },
	{ 0 }
};

static union {
	struct	sockaddr u_sa;
	u_short	u_data[128];
} pt_u;

int	do_rtent = 0;
struct	rtentry rtentry;
struct	radix_node rnode;
struct	radix_mask rmask;

static struct sockaddr *kgetsa __P((struct sockaddr *));
static void p_tree __P((struct radix_node *));
static void p_rtnode __P(());
static void np_rtentry __P((struct rt_msghdr *));
static void p_sockaddr __P((struct sockaddr *, struct sockaddr *, int, int));
static void p_flags __P((int, char *));
static void p_rtentry __P((struct rtentry *));

/*
 * Print routing tables.
 */
void
routepr(rtree)
	u_long rtree;
{
	struct radix_node_head *rnh, head;
	struct rt_msghdr *rtm;
	size_t needed;
	int i;
	int mib[] = { CTL_NET, PF_ROUTE, NET_ROUTE_TABLE, AF_UNSPEC, NET_RT_DUMP, 0 };
	char *buf, *next, *lim;

	printf("Routing tables\n");

	if (kflag == 0 && Aflag == 0) {
		if (sysctl(mib, sizeof(mib)/sizeof(*mib), NULL, &needed,
		    NULL, 0) < 0)
			err(1, "route-sysctl-estimate");
		if ((buf = malloc(needed)) == 0) {
			printf("out of space\n");
			return;
		}
		if (sysctl(mib, sizeof(mib)/sizeof(*mib), buf, &needed,
		    NULL, 0) < 0)
			err(1, "sysctl of routing table");
		lim  = buf + needed;
		for (next = buf; next < lim; next += rtm->rtm_msglen) {
			rtm = (struct rt_msghdr *)next;
			np_rtentry(rtm);
		}
		return;
	}

	if (rtree == 0) {
		printf("rt_tables: symbol not in namelist\n");
		return;
	}
	kget(rtree, rt_tables);
	for (i = 0; i <= AF_MAX; i++) {
		if ((rnh = rt_tables[i]) == 0)
			continue;
		kget(rnh, head);
		if (i == AF_UNSPEC) {
			if (Aflag && af == 0) {
				printf("Netmasks:\n");
				p_tree(head.rnh_treetop);
			}
		} else if (af == AF_UNSPEC || af == i) {
			pr_family(i);
			do_rtent = 1;
			pr_rthdr();
			p_tree(head.rnh_treetop);
		}
	}
}

/*
 * Print address family header before a section of the routing table.
 */
void
pr_family(family)
	int family;
{
	char *afname;

	switch (family) {
	case AF_INET:
		afname = "Internet";
		break;
#ifdef INET6
	case AF_INET6:
		afname = "Internet6";
		break;
#endif /* INET6 */
	case AF_NS:
		afname = "XNS";
		break;
	case AF_ISO:
		afname = "ISO";
		break;
	case AF_CCITT:
		afname = "X.25";
		break;
	default:
		afname = NULL;
		break;
	}
	if (afname)
		printf("\n%s:\n", afname);
	else
		printf("\nProtocol Family %d:\n", family);
}

/* column widths; each followed by one space */
#ifndef INET6
#define	WID_DST		19	/* width of destination column */
#define	WID_GW		18	/* width of gateway column */
#else
#define	WID_DST		(nflag ? 33 : 19)	/* width of destination column */
#define	WID_GW		(nflag ? 29 : 18)	/* width of gateway column */
#endif

/*
 * Print header for routing table columns.
 */
void
pr_rthdr()
{

	if (Aflag)
		printf("%-8.8s ","Address");
	if (lflag)
		printf("%-*.*s %-*.*s %-6.6s %6.6s %8.8s  %s\n",
		    WID_DST, WID_DST, "Destination",
		    WID_GW, WID_GW, "Gateway",
		    "Flags", "Refs", "Use", "Intface");
	else
		printf("%-*.*s %-*.*s %-6.6s %s\n",
		    WID_DST, WID_DST, "Destination",
		    WID_GW, WID_GW, "Gateway",
		    "Flags", "Intface");
}

static struct sockaddr *
kgetsa(dst)
	register struct sockaddr *dst;
{
	kget(dst, pt_u.u_sa);
	if (pt_u.u_sa.sa_len > sizeof (pt_u.u_sa))
		kread((u_long)dst, (char *)pt_u.u_data, pt_u.u_sa.sa_len);
	return (&pt_u.u_sa);
}

static void
p_tree(rn)
	struct radix_node *rn;
{

again:
	kget(rn, rnode);
	if (rnode.rn_b < 0) {
		if (Aflag)
			printf("%-8lx ", (u_long)rn);
		if (rnode.rn_flags & RNF_ROOT) {
			if (Aflag)
				printf("(root node)%s",
				    rnode.rn_dupedkey ? " =>\n" : "\n");
		} else if (do_rtent) {
			kget(rn, rtentry);
			p_rtentry(&rtentry);
			if (Aflag)
				p_rtnode();
		} else {
			p_sockaddr(kgetsa((struct sockaddr *)rnode.rn_key),
			    NULL, 0, 44);
			putchar('\n');
		}
		if ((rn = rnode.rn_dupedkey))
			goto again;
	} else {
		if (Aflag && do_rtent) {
			printf("%-8lx ", (u_long)rn);
			p_rtnode();
		}
		rn = rnode.rn_r;
		p_tree(rnode.rn_l);
		p_tree(rn);
	}
}

char	nbuf[20];

static void
p_rtnode()
{
	struct radix_mask *rm = rnode.rn_mklist;

	if (rnode.rn_b < 0) {
		if (rnode.rn_mask) {
			printf("\t  mask ");
			p_sockaddr(kgetsa((struct sockaddr *)rnode.rn_mask),
				   NULL, 0, -1);
		} else if (rm == 0)
			return;
	} else {
		sprintf(nbuf, "(%d)", rnode.rn_b);
		printf("%6.6s %8lx : %8lx", nbuf,
		    (u_long)rnode.rn_l, (u_long)rnode.rn_r);
	}
	while (rm) {
		kget(rm, rmask);
		sprintf(nbuf, " %d refs, ", rmask.rm_refs);
		printf(" mk = %8lx {(%d),%s",
		    (u_long)rm, -1 - rmask.rm_b,
		    rmask.rm_refs ? nbuf : " ");
		if (rmask.rm_flags & RNF_NORMAL) {
			struct radix_node rnode_aux;
			printf(" <normal>, ");
			kget(rmask.rm_leaf, rnode_aux);
			p_sockaddr(
			    kgetsa((struct sockaddr *)rnode_aux.rn_mask),
			    NULL, 0, -1);
		} else
		    p_sockaddr(kgetsa((struct sockaddr *)rmask.rm_mask),
			NULL, 0, -1);
		putchar('}');
		if ((rm = rmask.rm_mklist))
			printf(" ->");
	}
	putchar('\n');
}

#define ROUNDUP(a) \
	((a) > 0 ? (1 + (((a) - 1) | (sizeof(long) - 1))) : sizeof(long))
#define ADVANCE(s) (s = (struct sockaddr *) (ROUNDUP((s)->sa_len) + (caddr_t) sa))
static void
np_rtentry(rtm)
	register struct rt_msghdr *rtm;
{
	register struct sockaddr *sa = (struct sockaddr *)(rtm + 1);
#ifdef notdef
	static int masks_done, banner_printed;
#endif
	static int old_af;
	int af = 0;

#ifdef notdef
	/* for the moment, netmasks are skipped over */
	if (!banner_printed) {
		printf("Netmasks:\n");
		banner_printed = 1;
	}
	if (masks_done == 0) {
		if (rtm->rtm_addrs != RTA_DST ) {
			masks_done = 1;
			af = sa->sa_family;
		}
	} else
#endif
		af = sa->sa_family;
	if (af != old_af) {
		pr_family(af);
		pr_rthdr();
		old_af = af;
	}
	if (rtm->rtm_addrs == RTA_DST) {
		p_sockaddr(sa, NULL, 0, 36);
		p_flags(rtm->rtm_flags, "%-6.6s ");
		printf("%6d %8qu ", rtm->rtm_refcnt, (u_quad_t)rtm->rtm_use);
	} else {
	        struct sockaddr *addr, *gate, *mask, *ifaddr = (struct sockaddr *) 0;

		/* Destination */
		if (rtm->rtm_addrs & RTA_DST) {
			addr = sa;
		} else {
			addr = 0;
		}

		/* Gateway */
		if (rtm->rtm_addrs & RTA_GATEWAY) {
			ADVANCE(sa);
			gate = sa;
		} else {
			gate = 0;
		}

		/* Netmask */
		if (rtm->rtm_addrs & RTA_NETMASK) {
			ADVANCE(sa);
#if 0
			if (sa->sa_len && sa->sa_family == addr->sa_family)
				mask = sa;
			else
				mask = 0;
#else
			mask = sa->sa_len ? sa : 0;
#endif
		} else {
			mask = 0;
		}

		if (rtm->rtm_addrs & RTA_GENMASK) {
			ADVANCE(sa);
		}

		/* Print what we have so far */
		p_sockaddr(addr, mask, rtm->rtm_flags, WID_DST);
		p_sockaddr(gate, NULL, RTF_HOST, WID_GW);
		p_flags(rtm->rtm_flags, "%-6.6s ");
		printf("%6d %8qu ", rtm->rtm_refcnt, (u_quad_t)rtm->rtm_use);

		if (rtm->rtm_addrs & RTA_IFP) {
			register struct sockaddr_dl *sdl;

			ADVANCE(sa);
			sdl = (struct sockaddr_dl *) sa;
			if (sdl->sdl_nlen) {
				printf(" %.*s",
				       sdl->sdl_nlen,
				       sdl->sdl_data);
			}
		}

		if (rtm->rtm_addrs & RTA_IFA) {
			ADVANCE(sa);
			if (aflag) {
				ifaddr = sa;
			}
		}

		if (rtm->rtm_addrs & RTA_AUTHOR) {
			ADVANCE(sa);
		}

		if (rtm->rtm_addrs & RTA_BRD) {
			ADVANCE(sa);
			if (aflag) {
				ifaddr = sa;
			}
		}
		if (ifaddr) {
			printf(" ");
			p_sockaddr(sa, 0, RTF_HOST, -1);
		}
	}
	putchar('\n');
}

static void
p_sockaddr(sa, mask, flags, width)
	struct sockaddr *sa, *mask;
	int flags, width;
{
	char workbuf[128], *cplim;
	register char *cp = workbuf;

	switch(sa->sa_family) {
	case AF_INET:
	    {
		register struct sockaddr_in *sinp = (struct sockaddr_in *)sa;

		if (sinp->sin_addr.s_addr == INADDR_ANY)
			cp = "default";
		else if (flags & RTF_HOST)
			cp = routename(sinp->sin_addr.s_addr);
		else if (mask)
			cp = netname(sinp->sin_addr.s_addr,
			  ntohl(((struct sockaddr_in *)mask)->sin_addr.s_addr));
		else
			cp = netname(sinp->sin_addr.s_addr, 0L);
		break;
	    }

#ifdef INET6
	case AF_INET6:
	    {
		struct sockaddr_in6 *sa6 = (struct sockaddr_in6 *)sa;
		struct in6_addr *in6 = &sa6->sin6_addr;

		/*
		 * XXX: This is a special workaround for KAME kernels.
		 * sin6_scope_id field of SA should be set in the future.
		 */
		if (IN6_IS_ADDR_LINKLOCAL(in6) ||
		    IN6_IS_ADDR_MC_LINKLOCAL(in6) ||
		    IN6_IS_ADDR_MC_NODELOCAL(in6)) {
		    /* XXX: override is ok? */
		    sa6->sin6_scope_id = (u_int32_t)ntohs(*(u_short *)&in6->s6_addr[2]);
		    *(u_short *)&in6->s6_addr[2] = 0;
		}

		if (flags & RTF_HOST) {
		    cp = routename6(sa6);
		}
		else if (mask)
		    cp = netname6(sa6,
				  &(((struct sockaddr_in6 *)mask)->sin6_addr));
		else
		    cp = netname6(sa6, NULL);
		break;
	    }
#endif /* INET6 */

	case AF_NS:
		cp = ns_print(sa);
		break;

	case AF_LINK:
	    {
		register struct sockaddr_dl *sdl = (struct sockaddr_dl *)sa;

		if (sdl->sdl_nlen == 0 && sdl->sdl_alen == 0 &&
		    sdl->sdl_slen == 0)
			(void) sprintf(workbuf, "link#%d", sdl->sdl_index);
		else switch (sdl->sdl_type) {
		case IFT_ETHER:
		case IFT_FDDI:
		    {
			register int i;
			register u_char *lla = (u_char *)sdl->sdl_data +
			    sdl->sdl_nlen;

			cplim = "";
			for (i = 0; i < sdl->sdl_alen; i++, lla++) {
				cp += sprintf(cp, "%s%x", cplim, *lla);
				cplim = ":";
			}
			cp = workbuf;
			break;
		    }
		case IFT_ISO88025:
		    {
			int i;
			int nseg;
			struct token_max_hdr *addr;

			addr = (struct token_max_hdr *)(sdl->sdl_data +
			    sdl->sdl_nlen);
			for (i=0; i<ISO88025_ADDR_LEN; i++)
				cp += sprintf(cp, "%x:", 
				    addr->hdr.token_dhost[i]);
			*--cp = NULL;
			if (!HAS_ROUTE(addr))
				goto addr_done;
			nseg = addr->rif.rcf0 & RCF0_LEN_MASK;
			if (nseg <= 2) 
				goto addr_done;
			nseg = (nseg >> 1) - 1;
			if ((addr->rif.rcf1 & RCF1_DIRECTION) != 0)
				cp += sprintf(cp, "/r");
			else
				cp += sprintf(cp, "/f");
			for (i = 0; i < nseg; i++)
				cp += sprintf(cp, ":%x",
				    ntohs(addr->rif.rseg[i]));
addr_done:		cp = workbuf;
			break;
		    }
		default:
			cp = link_ntoa(sdl);
			break;
		}
		break;
	    }

	default:
	    {
		register u_char *s = (u_char *)sa->sa_data, *slim;

		slim =  sa->sa_len + (u_char *) sa;
		cplim = cp + sizeof(workbuf) - 6;
		cp += sprintf(cp, "(%d)", sa->sa_family);
		while (s < slim && cp < cplim) {
			cp += sprintf(cp, " %02x", *s++);
			if (s < slim)
			    cp += sprintf(cp, "%02x", *s++);
		}
		cp = workbuf;
	    }
	}
	if (width < 0 )
		printf("%s ", cp);
	else {
		if (nflag)
			printf("%-*s ", width, cp);
		else
			printf("%-*.*s ", width, width, cp);
	}
}

static void
p_flags(f, format)
	register int f;
	char *format;
{
	char name[33], *flags;
	register struct bits *p = bits;

	for (flags = name; p->b_mask; p++)
		if (p->b_mask & f)
			*flags++ = p->b_val;
	*flags = '\0';
	printf(format, name);
}

static void
p_rtentry(rt)
	register struct rtentry *rt;
{
	static struct ifnet ifnet, *lastif;
	static char name[16];
	register struct sockaddr *sa;
#ifndef INET6
	struct sockaddr addr, mask;
#else
	struct sockaddr_in6 addr, mask;
#endif

	if (!(sa = kgetsa(rt_key(rt))))
		bzero(&addr, sizeof addr);
	else
		bcopy(sa, &addr, sizeof addr);
	if (!rt_mask(rt) || !(sa = kgetsa(rt_mask(rt))))
		bzero(&mask, sizeof mask);
	else
		bcopy(sa, &mask, sizeof mask);
	p_sockaddr((struct sockaddr *)&addr, (struct sockaddr *)&mask,
		rt->rt_flags, WID_DST);
	p_sockaddr(kgetsa(rt->rt_gateway), NULL, RTF_HOST, WID_GW);
	p_flags(rt->rt_flags, "%-6.6s ");
	if (lflag)
		printf("%6d %8qu ", rt->rt_refcnt, (u_quad_t)rt->rt_use);
	if (rt->rt_ifp) {
		if (rt->rt_ifp != lastif) {
			kget(rt->rt_ifp, ifnet);
			kread((u_long)ifnet.if_name, name, 16);
			lastif = rt->rt_ifp;
		}
		printf(" %.15s%d", name, ifnet.if_unit);
		if (aflag) {
			static struct ifaddr ifaddr, *lastifa;
			struct sockaddr *ifa;

			if (rt->rt_ifa != lastifa) {
				kget(rt->rt_ifa, ifaddr);
				ifa = (ifnet.if_flags & IFF_POINTOPOINT) ?
				    kgetsa(ifaddr.ifa_dstaddr) :
					kgetsa(ifaddr.ifa_addr);
				if (ifa) {
					putchar(' ');
					p_sockaddr(ifa, NULL, RTF_HOST, -1);
				}
			}
		}

	}
	printf("%s\n", rt->rt_nodes[0].rn_dupedkey ? " =>" : "");
}

char *
routename(in)
	u_long in;
{
	register char *cp;
	static char line[MAXHOSTNAMELEN + 1];
	struct hostent *hp;
	static char domain[MAXHOSTNAMELEN + 1];
	static int first = 1;

	if (first) {
		first = 0;
		if (gethostname(domain, MAXHOSTNAMELEN) == 0 &&
		    (cp = index(domain, '.')))
			(void) strcpy(domain, cp + 1);
		else
			domain[0] = 0;
	}
	cp = 0;
	if (!nflag) {
		hp = gethostbyaddr((char *)&in, sizeof (struct in_addr),
			AF_INET);
		if (hp) {
			if ((cp = index(hp->h_name, '.')) &&
			    !strcmp(cp + 1, domain))
				*cp = 0;
			cp = hp->h_name;
		}
	}
	if (cp)
		strncpy(line, cp, sizeof(line) - 1);
	else {
#define C(x)	((x) & 0xff)
		in = ntohl(in);
		sprintf(line, "%lu.%lu.%lu.%lu",
		    C(in >> 24), C(in >> 16), C(in >> 8), C(in));
	}
	return (line);
}

static u_long
forgemask(a)
	u_long a;
{
	u_long m;

	if (IN_CLASSA(a))
		m = IN_CLASSA_NET;
	else if (IN_CLASSB(a))
		m = IN_CLASSB_NET;
	else
		m = IN_CLASSC_NET;
	return (m);
}

static void
domask(dst, addr, mask)
	char *dst;
	u_long addr, mask;
{
	register int b, i;

	if (!mask || (forgemask(addr) == mask)) {
		*dst = '\0';
		return;
	}
	i = 0;
	for (b = 0; b < 32; b++)
		if (mask & (1 << b)) {
			register int bb;

			i = b;
			for (bb = b+1; bb < 32; bb++)
				if (!(mask & (1 << bb))) {
					i = -1;	/* noncontig */
					break;
				}
			break;
		}
	if (i == -1)
		sprintf(dst, "&0x%lx", mask);
	else
		sprintf(dst, "/%d", 32-i);
}

/*
 * Return the name of the network whose address is given.
 * The address is assumed to be that of a net or subnet, not a host.
 */
char *
netname(in, mask)
	u_long in, mask;
{
	static struct irs_acc *irs_gen;
	static struct irs_nw *irs_nw;
	static char line[MAXHOSTNAMELEN + 1];
	struct nwent *np;
	u_long net, omask;
	register u_long i;
	int subnetshift, maskbits;
	u_char addr[4];

	if (irs_gen == NULL)
		irs_gen = irs_gen_acc("");
	if (irs_gen && irs_nw == NULL)
		irs_nw = (*irs_gen->nw_map)(irs_gen);
	i = ntohl(in);
	omask = mask;
	np = NULL;
	*line = 0;
	if (!nflag && i && irs_nw) {
		if (mask == 0) {
			switch (mask = forgemask(i)) {
			case IN_CLASSA_NET:
				subnetshift = 8;
				break;
			case IN_CLASSB_NET:
				subnetshift = 8;
				break;
			case IN_CLASSC_NET:
				subnetshift = 4;
				break;
			default:
				abort();
			}
			/*
			 * If there are more bits than the standard mask
			 * would suggest, subnets must be in use.
			 * Guess at the subnet mask, assuming reasonable
			 * width subnet fields.
			 */
			while (i &~ mask)
				mask = (long)mask >> subnetshift;
		}
		net = i & mask;
		addr[0] = (0xFF000000 & net) >> 24;
		addr[1] = (0x00FF0000 & net) >> 16;
		addr[2] = (0x0000FF00 & net) >> 8;
		addr[3] = (0x000000FF & net);
		for (maskbits = 32; !(mask & 1); mask >>= 1)
			maskbits--;
		np = (*irs_nw->byaddr)(irs_nw, addr, maskbits, AF_INET);
	}
	if (np != NULL)
		strncat(line, np->n_name, sizeof(line) - 1);
	else if ((i & 0xffffff) == 0)
		sprintf(line, "%lu", C(i >> 24));
	else if ((i & 0xffff) == 0)
		sprintf(line, "%lu.%lu", C(i >> 24) , C(i >> 16));
	else if ((i & 0xff) == 0)
		sprintf(line, "%lu.%lu.%lu", C(i >> 24), C(i >> 16), C(i >> 8));
	else
		sprintf(line, "%lu.%lu.%lu.%lu", C(i >> 24),
			C(i >> 16), C(i >> 8), C(i));
	domask(line+strlen(line), i, omask);
	return (line);
}

#ifdef INET6
#if 0
static void
trimdomain(cp)
	char *cp;
{
	static char domain[MAXHOSTNAMELEN + 1];
	static int first = 1;
	char *s;

	if (first) {
		first = 0;
		if (gethostname(domain, MAXHOSTNAMELEN) == 0 &&
		    (s = strchr(domain, '.')))
			(void) strcpy(domain, s + 1);
		else
			domain[0] = 0;
	}

	if (domain[0]) {
		while ((cp = strchr(cp, '.'))) {
			if (!strcasecmp(cp + 1, domain)) {
				*cp = 0;	/* hit it */
				break;
			} else {
				cp++;
			}
		}
	}
}
#endif

char *
netname6(sa6, mask)
	struct sockaddr_in6 *sa6;
	struct in6_addr *mask;
{
	static char line[MAXHOSTNAMELEN + 1];
	u_char *p = (u_char *)mask;
	u_char *q;
	u_char *lim;
	int masklen, illegal = 0;
#ifdef NI_WITHSCOPEID
	int flag = NI_WITHSCOPEID;
#else
	int flag = 0;
#endif
	struct sockaddr_in6 sin6;

	sin6 = *sa6;
	q = (u_char *)&sin6.sin6_addr;

	if (mask) {
		for (masklen = 0, lim = p + 16; p < lim; p++) {
			switch (*p) {
			 case 0xff:
				 masklen += 8;
				 break;
			 case 0xfe:
				 masklen += 7;
				 break;
			 case 0xfc:
				 masklen += 6;
				 break;
			 case 0xf8:
				 masklen += 5;
				 break;
			 case 0xf0:
				 masklen += 4;
				 break;
			 case 0xe0:
				 masklen += 3;
				 break;
			 case 0xc0:
				 masklen += 2;
				 break;
			 case 0x80:
				 masklen += 1;
				 break;
			 case 0x00:
				 break;
			 default:
				 illegal ++;
				 break;
			}
			if (illegal)
				*q = 0;
			else
				*q &= *p;
			q++;
		}
		if (illegal)
			fprintf(stderr, "illegal prefixlen\n");
	}
	else
		masklen = 128;

	if (masklen == 0 && IN6_IS_ADDR_UNSPECIFIED(&sin6.sin6_addr))
		return("default");

	if (nflag)
		flag |= NI_NUMERICHOST;
	getnameinfo((struct sockaddr *)&sin6, sin6.sin6_len, line, sizeof(line),
		    NULL, 0, flag);

	if (nflag)
		sprintf(&line[strlen(line)], "/%d", masklen);

	return line;
}

char *
routename6(sa6)
	struct sockaddr_in6 *sa6;
{
	static char line[MAXHOSTNAMELEN + 1];
#ifdef NI_WITHSCOPEID
	int flag = NI_WITHSCOPEID;
#else
	int flag = 0;
#endif
	int error;
	/* use local variable for safety */
	struct sockaddr_in6 sa6_local;

	memset(&sa6_local, 0, sizeof(sa6_local));
	sa6_local.sin6_family = AF_INET6;
	sa6_local.sin6_len = sizeof(struct sockaddr_in6);
	sa6_local.sin6_addr = sa6->sin6_addr;
	sa6_local.sin6_scope_id = sa6->sin6_scope_id;

	if (nflag)
		flag |= NI_NUMERICHOST;

	error = getnameinfo((struct sockaddr *)&sa6_local, sa6_local.sin6_len,
			    line, sizeof(line), NULL, 0, flag);

	if (error)
		strcpy(line, "invalid");

	return line;
}
#endif /*INET6*/

/*
 * Print routing statistics
 */
void
rt_stats(off)
	u_long off;
{
	struct rtstat rts;
	int mib[] = { CTL_NET, PF_ROUTE, NET_ROUTE_STATS };

	if (skread("routing statistics", mib, sizeof(mib)/sizeof(*mib),
	    off, &rts, sizeof(rts)))
		return;

	printf("routing:\n");
	printf("\t%qu bad routing redirect%s\n",
		(u_quad_t)rts.rts_badredirect, PLURAL(rts.rts_badredirect));
	printf("\t%qu dynamically created route%s\n",
		(u_quad_t)rts.rts_dynamic, PLURAL(rts.rts_dynamic));
	printf("\t%qu new gateway%s due to redirects\n",
		(u_quad_t)rts.rts_newgateway, PLURAL(rts.rts_newgateway));
	printf("\t%qu destination%s found unreachable\n",
		(u_quad_t)rts.rts_unreach, PLURAL(rts.rts_unreach));
	printf("\t%qu use%s of a wildcard route\n",
		(u_quad_t)rts.rts_wildcard, PLURAL(rts.rts_wildcard));
}
short ns_nullh[] = {0,0,0};
short ns_bh[] = {-1,-1,-1};

char *
ns_print(sa)
	register struct sockaddr *sa;
{
	register struct sockaddr_ns *sns = (struct sockaddr_ns*)sa;
	struct ns_addr work;
	union { union ns_net net_e; u_long long_e; } net;
	u_short port;
	static char mybuf[50], cport[10], chost[25];
	char *host = "";
	register char *p; register u_char *q;

	work = sns->sns_addr;
	port = ntohs(work.x_port);
	work.x_port = 0;
	net.net_e  = work.x_net;
	if (ns_nullhost(work) && net.long_e == 0) {
		if (port ) {
			sprintf(mybuf, "*.%xH", port);
			upHex(mybuf);
		} else
			sprintf(mybuf, "*.*");
		return (mybuf);
	}

	if (bcmp(ns_bh, work.x_host.c_host, 6) == 0) {
		host = "any";
	} else if (bcmp(ns_nullh, work.x_host.c_host, 6) == 0) {
		host = "*";
	} else {
		q = work.x_host.c_host;
		sprintf(chost, "%02x%02x%02x%02x%02x%02xH",
			q[0], q[1], q[2], q[3], q[4], q[5]);
		for (p = chost; *p == '0' && p < chost + 12; p++)
			continue;
		host = p;
	}
	if (port)
		sprintf(cport, ".%xH", htons(port));
	else
		*cport = 0;

	sprintf(mybuf,"%xH.%s%s", (u_int32_t)ntohl(net.long_e), host, cport);
	upHex(mybuf);
	return(mybuf);
}

char *
ns_phost(sa)
	struct sockaddr *sa;
{
	register struct sockaddr_ns *sns = (struct sockaddr_ns *)sa;
	struct sockaddr_ns work;
	static union ns_net ns_zeronet;
	char *p;

	work = *sns;
	work.sns_addr.x_port = 0;
	work.sns_addr.x_net = ns_zeronet;

	p = ns_print((struct sockaddr *)&work);
	if (strncmp("0H.", p, 3) == 0) p += 3;
	return(p);
}

void
upHex(p0)
	char *p0;
{
	register char *p = p0;
	for (; *p; p++) switch (*p) {

	case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
		*p += ('A' - 'a');
	}
}
