/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/*	BSDI if.c,v 2.6 1996/11/20 22:42:08 jch Exp	*/

/*
 * Copyright (c) 1983, 1988, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char sccsid[] = "@(#)if.c	8.2 (Berkeley) 2/21/94";
#endif /* not lint */

#include <sys/types.h>
#include <sys/protosw.h>
#include <sys/socket.h>

#include <net/if.h>
#include <net/if_types.h>
#include <net/if_dl.h>
#include <netinet/in.h>
#include <netinet/in_var.h>
#include <netinet/if_ether.h>
#include <netns/ns.h>
#include <netns/ns_if.h>
#include <netiso/iso.h>
#include <netiso/iso_var.h>
#include <arpa/inet.h>

#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "netstat.h"

#define	YES	1
#define	NO	0

static void sidewaysintpr __P((u_int, u_long));
static void catchalarm __P((int));

#ifdef INET6
extern char *netname6 __P((struct sockaddr_in6 *, struct in6_addr *));
static char ntop_buf[INET6_ADDRSTRLEN];
#endif

/*
 * Print a description of the network interfaces.
 */
void
if_stats(ifnetaddr, pfunc)
	u_long ifnetaddr;
	void (*pfunc)(char *);
{
	struct ifnet ifnet;
	union {
		struct ifaddr ifa;
		struct in_ifaddr in;
		struct ns_ifaddr ns;
		struct iso_ifaddr iso;
	} ifaddr;
	u_long ifaddraddr;
	char name[64];

	if (ifnetaddr == 0) {
		printf("ifnet: symbol not defined\n");
		return;
	}

	if (kread(ifnetaddr, (char *)&ifnetaddr, sizeof ifnetaddr))
		return;

    	ifaddraddr = 0;
    	name[0] = 0;
	while (ifnetaddr || ifaddraddr) {
		register char *cp;

		name[0] = 0;

		if (ifaddraddr == 0) {
			if (kread(ifnetaddr, (char *)&ifnet, sizeof ifnet) ||
			    kread((u_long)ifnet.if_name, name, sizeof(name)))
				return;
			name[sizeof(name)-4] = '\0';
			ifnetaddr = (u_long)ifnet.if_next;

			if (interface != 0 && (strcmp(name, interface) != 0 ||
			    unit != ifnet.if_unit))
				continue;
			cp = index(name, '\0');
			cp += sprintf(cp, "%d", ifnet.if_unit);

			if (pfunc) {
				(*pfunc)(name);
				continue;
			}

			if ((ifnet.if_flags&IFF_UP) == 0)
				*cp++ = '*';
			*cp = '\0';
			break;
		} else {
			if (kread(ifaddraddr, (char *)&ifaddr, sizeof ifaddr)) {
				ifaddraddr = 0;
				continue;
			}
			ifaddraddr = (u_long)ifaddr.ifa.ifa_next;
		}
    	}
	if (pfunc)
	    return;
    	if (!name[0])
	    return;

	printf("%s:\n", name);
	printf("	%lu maximum transmission unit [MTU]\n", ifnet.if_mtu);
	printf("	%lu routing metric (external only)\n", ifnet.if_metric);
	printf("	%lu linespeed (serial)\n", ifnet.if_baudrate);
	printf("	%qu packets received on interface\n",
	    (u_quad_t)ifnet.if_ipackets);
	printf("	%qu input errors on interface\n",
	    (u_quad_t)ifnet.if_ierrors);
	printf("	%qu packets sent on interface\n",
	    (u_quad_t)ifnet.if_opackets);
	printf("	%qu output errors on interface\n",
	    (u_quad_t)ifnet.if_oerrors);
	printf("	%qu collisions on csma interfaces\n",
	    (u_quad_t)ifnet.if_collisions);
	printf("	%qu total number of octets received\n",
	    (u_quad_t)ifnet.if_ibytes);
	printf("	%qu total number of octets sent\n",
	    (u_quad_t)ifnet.if_obytes);
	printf("	%qu packets received via multicast\n",
	    (u_quad_t)ifnet.if_imcasts);
	printf("	%qu packets sent via multicast\n",
	    (u_quad_t)ifnet.if_omcasts);
	printf("	%qu packets dropped on input, this interface\n",
	    (u_quad_t)ifnet.if_iqdrops);
	printf("	%qu packets destined for unsupported protocol\n",
	    (u_quad_t)ifnet.if_noproto);
}

/*
 * Return a printable string representation of an Ethernet address.
 */
char *etherprint(enaddr)
	char enaddr[6];
{
	static char string[18];
	unsigned char *en = (unsigned char *)enaddr;

	sprintf(string, "%02x:%02x:%02x:%02x:%02x:%02x",
		en[0], en[1], en[2], en[3], en[4], en[5] );
	string[17] = '\0';
	return(string);
}

/*
 * Print a description of the network interfaces.
 */
void
intpr(intrvl, ifnetaddr)
	int intrvl;
	u_long ifnetaddr;
{
	struct ifnet ifnet;
	union {
		struct ifaddr ifa;
		struct in_ifaddr in;
#ifdef INET6
		struct in6_ifaddr in6;
#endif
		struct ns_ifaddr ns;
		struct iso_ifaddr iso;
	} ifaddr;
	u_long ifaddraddr, ifaddrfound, ifnetfound;
	struct sockaddr *sa = NULL;
	struct sockaddr_in *sinp;
#ifdef INET6
	struct sockaddr_in6 *sin6;
#endif
	char name[16];
	u_long pifaddr;
	struct ifnet pifnet;
	char pifname[16+2];

	if (ifnetaddr == 0) {
		printf("ifnet: symbol not defined\n");
		return;
	}
	if (intrvl) {
		sidewaysintpr((unsigned)intrvl, ifnetaddr);
		return;
	}
	if (kread(ifnetaddr, (char *)&ifnetaddr, sizeof ifnetaddr))
		return;
	printf("%-5.5s %-5.5s %-11.11s %-17.17s %9.9s %5.5s %9.9s %5.5s",
		"Name", "Mtu", "Network", "Address", "Ipkts", "Ierrs",
		"Opkts", "Oerrs");
	printf(" %5s", "Coll");
	if (tflag)
		printf(" %s", "Time");
	if (dflag)
		printf(" %s", "Drop");
	putchar('\n');
	ifaddraddr = 0;
	pifaddr = 0;
	ifnetfound = 0;
	while (ifnetaddr || ifaddraddr) {
		register char *cp;
		int n, m;

		ifnetfound = ifnetaddr;
		if (ifaddraddr == 0 && pifaddr) {
			cp = pifname;
			*cp++ = '-';
			*cp++ = '>';
			if (kread(pifaddr, (char *)&pifnet,
			    sizeof pifnet) ||
			    kread((u_long)pifnet.if_name, cp, 16))
				return;
			cp[15] = '\0';
			cp = index(pifname, '\0');
			cp += sprintf(cp, "%d", pifnet.if_unit);
			if ((pifnet.if_flags&IFF_UP) == 0)
				*cp++ = '*';
			*cp = '\0';
		} else if (ifaddraddr == 0) {
			if (kread(ifnetaddr, (char *)&ifnet, sizeof ifnet) ||
			    kread((u_long)ifnet.if_name, name, 16))
				return;
			name[15] = '\0';
			ifnetaddr = (u_long)ifnet.if_next;
			if (interface != 0 && (strcmp(name, interface) != 0 ||
			    unit != ifnet.if_unit))
				continue;
			cp = index(name, '\0');
			cp += sprintf(cp, "%d", ifnet.if_unit);
			if ((ifnet.if_flags&IFF_UP) == 0)
				*cp++ = '*';
			*cp = '\0';
			ifaddraddr = (u_long)ifnet.if_addrlist;
			pifaddr = (u_long)ifnet.if_pif;
		}
		printf("%-5.5s %-5lu ", name, ifnet.if_mtu);
		ifaddrfound = ifaddraddr;
		if (ifaddraddr == 0) {
			printf("%-11.11s ", pifaddr ? pifname : "none");
			printf("%-17.17s ", pifaddr ? "" : "none");
			pifaddr = 0;
		} else {
			if (kread(ifaddraddr, (char *)&ifaddr, sizeof ifaddr)) {
				ifaddraddr = 0;
				continue;
			}
#define CP(x) ((char *)(x))
			cp = (CP(ifaddr.ifa.ifa_addr) - CP(ifaddraddr)) +
				CP(&ifaddr); sa = (struct sockaddr *)cp;
			switch (sa->sa_family) {
			case AF_UNSPEC:
				printf("%-11.11s ", "none");
				printf("%-17.17s ", "none");
				break;
			case AF_INET:
				sinp = (struct sockaddr_in *)sa;
#ifdef notdef
				/* can't use inet_makeaddr because kernel
				 * keeps nets unshifted.
				 */
				in = inet_makeaddr(ifaddr.in.ia_subnet,
					INADDR_ANY);
				printf("%-11.11s ", netname(in.s_addr,
				    ifaddr.in.ia_subnetmask));
#else
				printf("%-11.11s ",
				    netname(htonl(ifaddr.in.ia_subnet),
				    ifaddr.in.ia_subnetmask));
#endif
				printf("%-17.17s ",
				    routename(sinp->sin_addr.s_addr));
				break;
#ifdef INET6
			case AF_INET6:
				sin6 = (struct sockaddr_in6 *)sa;
				cp = netname6(&ifaddr.in6.ia_addr,
						&ifaddr.in6.ia_prefixmask.sin6_addr);
				n = lflag ? (strlen(cp) > 11 ? strlen(cp) : 11)
					  : 11;
				printf("%-*.*s ", n, n, cp);
				inet_ntop(AF_INET6, &sin6->sin6_addr,
				    ntop_buf, sizeof(ntop_buf));
				cp = ntop_buf;
				n = lflag ? (strlen(cp) > 17 ? strlen(cp) : 17)
					  : 17;
				printf("%-*.*s ", n, n, cp);
				break;
#endif /* INET6 */
			case AF_NS:
				{
				struct sockaddr_ns *sns =
					(struct sockaddr_ns *)sa;
				u_long net;
				char netnum[8];

				*(union ns_net *) &net = sns->sns_addr.x_net;
				sprintf(netnum, "%xH", (u_int32_t)ntohl(net));
				upHex(netnum);
				printf("ns:%-8s ", netnum);
				printf("%-17s ",
				    ns_phost((struct sockaddr *)sns));
				}
				break;
			case AF_LINK:
				{
				    struct sockaddr_dl *sdl =
					(struct sockaddr_dl *)sa;
				    cp = (char *)LLADDR(sdl);
				    n = sdl->sdl_alen;
				    m = printf("<link%d>", sdl->sdl_index);
				    printf("%*s", 12 - m, "");
				}

				switch (ifnet.if_type) {
				case IFT_ETHER:
				case IFT_ISO88025:
				case IFT_FDDI:
				    printf("%-17.17s ", etherprint(cp));
				    break;
				default:
				    m = 0;
				    while (--n >= 0)
					    m += printf("%x%c", *cp++ & 0xff,
							n > 0 ? '.' : ' ');
				    m = 18 - m;
				    while (m-- > 0)
					    putchar(' ');
				}
				break;
			default:
				m = printf("(%d)", sa->sa_family);
				for (cp = sa->sa_len + (char *)sa;
					--cp > sa->sa_data && (*cp == 0);) {}
				n = cp - sa->sa_data + 1;
				cp = sa->sa_data;
				while (--n >= 0)
					m += printf("%x%c", *cp++ & 0xff,
						    n > 0 ? '.' : ' ');
				m = 30 - m;
				while (m-- > 0)
					putchar(' ');
				break;
			}
			ifaddraddr = (u_long)ifaddr.ifa.ifa_next;
		}
		printf("%9qu %5qu %9qu %5qu %5qu",
		    ifnet.if_ipackets, ifnet.if_ierrors,
		    ifnet.if_opackets, ifnet.if_oerrors,
		    ifnet.if_collisions);
		if (tflag)
			printf(" %3d", ifnet.if_timer);
		if (dflag)
			printf(" %3d", ifnet.if_snd.ifq_drops);
		putchar('\n');

		if (aflag && ifaddrfound) {
			/*
			 * print any internet multicast addresses
			 */
			switch (sa->sa_family) {
			case AF_INET:
			    {
				u_long multiaddr;
				struct in_multi inm;

				multiaddr = (u_long)ifaddr.in.ia_multiaddrs;
				while (multiaddr != 0) {
					kread(multiaddr, (char *)&inm,
						sizeof inm);
					multiaddr = (u_long)inm.inm_next;
					printf("%23s %-19.19s\n", "",
					       routename(inm.inm_addr.s_addr));
				}
				break;
			    }

#ifdef INET6
			case AF_INET6:
			    {
				u_long multiaddr;
				struct in6_multi in6m;

				multiaddr = (u_long)ifaddr.in6.ia6_multiaddrs.lh_first;
				while (multiaddr != 0) {
					kread(multiaddr, (char *)&in6m,
						sizeof in6m);
					multiaddr = (u_long)in6m.in6m_entry.le_next;
					inet_ntop(AF_INET6, &in6m.in6m_sa.sin6_addr,
					    ntop_buf, sizeof(ntop_buf));
					cp = ntop_buf;
					n = lflag ? (strlen(cp) > 19 ? strlen(cp) : 19)
						  : 19;
					printf("%23s %-*.*s\n", "", n, n, cp);
				}
				break;
			    }
#endif

			default:
				break;

			case AF_LINK:
			    /*
			     * print link-level addresses
			     */
			    switch (ifnet.if_type) {
				u_long multiaddr;
				struct ether_multi enm;
				struct arpcom ac;

			    case IFT_ETHER:
			    case IFT_FDDI:
			    case IFT_ISO88025:
				kread(ifnetfound, (char *)&ac, sizeof(ac));
				multiaddr = (u_long)ac.ac_multiaddrs;
				while (multiaddr != 0) {
					kread(multiaddr, (char *)&enm,
						sizeof enm);
					multiaddr = (u_long)enm.enm_next;
					printf("%23s %s", "",
						etherprint(&enm.enm_addrlo));
					if (bcmp(&enm.enm_addrlo,
						 &enm.enm_addrhi, 6) != 0)
						printf(" to %s",
						etherprint(&enm.enm_addrhi));
					printf("\n");
				}
				break;
			    }
			    break;
			}
		}
	}
}

#define	MAXIF	10
struct	iftot {
	char		ift_name[IFNAMSIZ];		/* interface name */
	u_quad_t	ift_ip;			/* input packets (or bytes) */
	u_quad_t	ift_ie;			/* input errors */
	u_quad_t	ift_op;			/* output packets (or bytes) */
	u_quad_t	ift_oe;			/* output errors */
	u_quad_t	ift_co;			/* collisions */
	u_quad_t	ift_dr;			/* drops */
} iftot[MAXIF];

u_char	signalled;			/* set if alarm goes off "early" */

/*
 * Print a running summary of interface statistics.
 * Repeat display every interval seconds, showing statistics
 * collected over that interval.  Assumes that interval is non-zero.
 * First line printed at top of screen is always cumulative.
 */
static void
sidewaysintpr(intrvl, off)
	unsigned intrvl;
	u_long off;
{
	struct ifnet ifnet;
	u_long firstifnet;
	register struct iftot *ip, *total;
	register int line;
	struct iftot *lastif, *sum, *interesting;
	int oldmask;

	if (kread(off, (char *)&firstifnet, sizeof (u_long)))
		return;
	lastif = iftot;
	sum = iftot + MAXIF - 1;
	total = sum - 1;
	interesting = NULL;
	for (off = firstifnet, ip = iftot; off;) {
		char *cp;

		if (kread(off, (char *)&ifnet, sizeof ifnet))
			break;
		if (kread((u_long)ifnet.if_name, ip->ift_name, sizeof(ip->ift_name)))
			break;
		if (interface && strcmp(ip->ift_name, interface) == 0 &&
		    unit == ifnet.if_unit)
			interesting = ip;
		else if (interesting == NULL && (ifnet.if_flags & IFF_UP))
			interesting = ip;
		ip->ift_name[sizeof(ip->ift_name) - 1] = '\0';
		cp = index(ip->ift_name, '\0');
		sprintf(cp, "%d)", ifnet.if_unit);
		ip++;
		if (ip >= iftot + MAXIF - 2)
			break;
		off = (u_long) ifnet.if_next;
	}
	lastif = ip;

	/* If no interesting interface was found, use the first */
	if (interesting == NULL)
		interesting = iftot;

	(void)signal(SIGALRM, catchalarm);
	signalled = NO;
	(void)alarm(intrvl);
banner:
	printf("   input    (%-8.8s output       ", interesting->ift_name);
	if (lastif - iftot > 0) {
		if (tflag)
			printf("     ");
		if (dflag)
			printf("      ");
		printf("      input   (Total)    output");
	}
	for (ip = iftot; ip < iftot + MAXIF; ip++) {
		ip->ift_ip = 0;
		ip->ift_ie = 0;
		ip->ift_op = 0;
		ip->ift_oe = 0;
		ip->ift_co = 0;
		ip->ift_dr = 0;
	}
	putchar('\n');
	printf("%9.9s %5.5s %9.9s %5.5s %5.5s ",
	    bflag ? "bytes" : "packets", "errs", 
	    bflag ? "bytes" : "packets", "errs", "colls");
	if (dflag)
		printf("%5.5s ", "drops");
	if (tflag)
		printf(" %4.4s", "time");
	if (lastif - iftot > 0)
		printf("%9.9s %5.5s %9.9s %5.5s %5.5s",
		    bflag ? "bytes" : "packets", "errs",
		    bflag ? "bytes" : "packets", "errs", "colls");
	if (dflag)
		printf(" %5.5s", "drops");
	putchar('\n');
	fflush(stdout);
	line = 0;
loop:
	sum->ift_ip = 0;
	sum->ift_ie = 0;
	sum->ift_op = 0;
	sum->ift_oe = 0;
	sum->ift_co = 0;
	sum->ift_dr = 0;
	for (off = firstifnet, ip = iftot; off && ip < lastif; ip++) {
		if (kread(off, (char *)&ifnet, sizeof ifnet)) {
			off = 0;
			continue;
		}
		if (ip == interesting) {
			printf("%9qu %5qu %9qu %5qu %5qu",
			    (u_quad_t)((bflag ? ifnet.if_ibytes : ifnet.if_ipackets) - ip->ift_ip),
			    (u_quad_t)(ifnet.if_ierrors - ip->ift_ie),
			    (u_quad_t)((bflag ? ifnet.if_obytes : ifnet.if_opackets) - ip->ift_op),
			    (u_quad_t)(ifnet.if_oerrors - ip->ift_oe),
			    (u_quad_t)(ifnet.if_collisions - ip->ift_co));
			if (dflag)
				printf(" %5qu",
				    (u_quad_t)ifnet.if_snd.ifq_drops - ip->ift_dr);
			if (tflag)
				printf(" %4d", ifnet.if_timer);
		}
		ip->ift_ip = bflag ? ifnet.if_ibytes : ifnet.if_ipackets;
		ip->ift_ie = ifnet.if_ierrors;
		ip->ift_op = bflag ? ifnet.if_obytes : ifnet.if_opackets;
		ip->ift_oe = ifnet.if_oerrors;
		ip->ift_co = ifnet.if_collisions;
		ip->ift_dr = ifnet.if_snd.ifq_drops;
		sum->ift_ip += ip->ift_ip;
		sum->ift_ie += ip->ift_ie;
		sum->ift_op += ip->ift_op;
		sum->ift_oe += ip->ift_oe;
		sum->ift_co += ip->ift_co;
		sum->ift_dr += ip->ift_dr;
		off = (u_long) ifnet.if_next;
	}
	if (lastif - iftot > 0) {
		printf(" %9qu %5qu %9qu %5qu %5qu",
			sum->ift_ip - total->ift_ip,
			sum->ift_ie - total->ift_ie,
			sum->ift_op - total->ift_op,
			sum->ift_oe - total->ift_oe,
			sum->ift_co - total->ift_co);
		if (dflag)
			printf(" %5qu", sum->ift_dr - total->ift_dr);
	}
	*total = *sum;
	putchar('\n');
	fflush(stdout);
	line++;
	oldmask = sigblock(sigmask(SIGALRM));
	if (! signalled) {
		sigpause(0);
	}
	sigsetmask(oldmask);
	signalled = NO;
	(void)alarm(intrvl);
	if (line == 21)
		goto banner;
	goto loop;
	/*NOTREACHED*/
}

/*
 * Called if an interval expires before sidewaysintpr has completed a loop.
 * Sets a flag to not wait for the alarm.
 */
static void
catchalarm(signo)
	int signo;
{
	signalled = YES;
}
