#! /bin/sh
#
# bsdi's build script for KAME buildlab.  may not be useful for normal usage.
# $KAME: build.sh,v 1.3 2001/07/31 00:42:13 suz Exp $
#

echo the script is only for KAME buildlab, it is not useful in general
exit 1

#tool & archive locations
scriptdir=/usr/home/buildlab
sys_tgz=${scriptdir}/sys.tar.gz
ppp_tgz=${scriptdir}/ppp.tar.gz
sysctl_tgz=${scriptdir}/sysctl.tar.gz

#don't need to change below
PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/contrib/bin:/usr/local/bin:/sbin:/usr/sbin:/usr/local/sbin
DATE=`date '+%Y%m%d'`
hostname=`hostname`
hosttop=`echo $hostname | sed -e 's/\..*//'`
PKG=kame-${DATE}-bsdi3-snap.tgz
kamedir=${scriptdir}/kame
bsdidir=${kamedir}/bsdi3

prepare() {
#fetch snapshot
	(cd ${scriptdir}; fetch -p ftp://ftp.kame.net/pub/kame/snap/${PKG})
	rm -rf ${kamedir}
	(cd ${scriptdir}; gzip -cd ${PKG} | gtar xf -)

#extract bsdi source
	(cd ${bsdidir}; gzip -cd ${sys_tgz} | gtar xf -)
	(cd ${bsdidir}/sys; patch -f -p3 < ../sys.diff)

	(cd ${bsdidir}/sbin; gzip -cd ${sysctl_tgz} | gtar xf -)
	(cd ${bsdidir}/sbin/sysctl; patch -f -p4 < ../sysctl.diff)

	(cd ${bsdidir}/usr.bin; gzip -cd ${ppp_tgz} | gtar xf -)
	(cd ${bsdidir}/usr.bin/ppp; patch -f -p4 < ../ppp.diff)

	(cd /usr/include; rm -rf *; cp -r ../include.clean/* .; chmod u+w ../include)
}

build() {
	uname -a
	echo -n '${.TARGET} started at '
	date

	(cd ${kamedir}; make TARGET=bsdi3 prepare)


	#build kernel
	(cd ${bsdidir}; make includes)
	(cd ${bsdidir}/sys/i386/conf; /usr/sbin/config GENERIC.v6)
	(cd ${bsdidir}/sys/compile/GENERIC.v6; make depend; make)
	if [ $? -ne 0 ]; then
		return;
	fi

	#build apps
	(cd ${bsdidir}; make install-includes; make)
	if [ $? -ne 0 ]; then
		return;
	fi
	touch /var/tmp/done.$$
}


#preparation
prepare

#actual compilation
build 2>&1 | tee /var/tmp/autobuild.$$ | mail -s "$hostname autobuild at $date" $hosttop@buildlab.kame.net

#check result
if [ ! -f /var/tmp/done.$$ ]; then
	 mail -s "autobuild failure: $hostname around $date" buildlab@kame.net << EOF
autobuild on $hostname seem to have failed.
started: $date
finished: `date`
result URL: http://master.buildlab.kame.net/$hosttop/
EOF
fi
rm /var/tmp/autobuild.$$
rm /var/tmp/done.$$
