/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: defs.h,v 1.5 2000/05/16 16:22:33 fujisawa Exp $
 */

/*
 *
 */

#define	ERROR			(-1)
#define	SAME			(0)

#ifndef TRUE
#define	TRUE			(1)
#define	FALSE			(~TRUE)
#endif

#define	LONG			(1)
#define	SHORT			(2)

#define	ROUNDUP(x)		roundup(x, sizeof(void *))

#ifndef roundup						/* comes from <sys/param.h> */
#define	roundup(x, y)		((((x)+((y)-1))/(y))*(y))  /* to any y */
#define	roundup2(x, y)		(((x)+((y)-1))&(~((y)-1))) /* if y is powers of two */
#endif


#define	isDebug(d)		(u_debug & (d))
extern	u_int	u_debug;


/* Bit assign for _debug						*/
#define	D_LEXTOKEN		0x00000001
#define	D_YYDEBUG		0x00000010
#define	D_SHOWROUTE		0x00000100
#define	D_SHOWCSLOT		0x00000200
#define	D_DUMPIOCTL		0x00010000
#define	D_NOSOCKET		0x01000000
