/*
 * Copyright (C) 1998 Specialix International.
 *
 * Download code for SI/XIO/SX host cards.
 *
 * Redistribution and use in binary forms (this file is a binary form),
 * with or without modification, are permitted provided that the following
 * conditions are met:
 * 1. Redistributions in binary form must reproduce the above copyright
 *    notices, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 2. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Specialix International.
 * 3. The name of Specialix International may not be used to endorse or
 *    promote products derived from this software without specific prior
 *    written permission.
 * 4. No attempt is made to decompile, reverse engineer or otherwise
 *    discover the source code of the contents of this file. The source
 *    code is regarded as an unpublished trade secret held by Specialix
 *    International.
 *
 * THIS SOFTWARE IS PROVIDED BY ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHORS BE LIABLE.
 *
 * $FreeBSD: src/sys/i386/isa/si3_t225.c,v 1.1.4.1 1999/03/31 23:57:10 nsayer Exp $
 */

/* SI3_T225.C Version, Bootstrap and Download Code Arrays... */

char *si3_t225_ident = "%W%";

/* SI3_T225 embedded version... 

	Copyright (c) Specialix International Ltd 1996-1998.
	JET.BIN Version 3.0.4 Created Oct  5 1998 @ 10:41:48

*/

unsigned char si3_t225_bootstrap[] =
{
	0x28,0x20,0x21,0x02,0x60,0x0a
};
int si3_t225_bsize = sizeof(si3_t225_bootstrap);

unsigned short si3_t225_bootloadaddr = 0x8000 - sizeof(si3_t225_bootstrap);

unsigned char si3_t225_download[] =
{
	0x00,0x00,0x2C,0x4B,0x00,0x00,0x00,0x00,	/* 0000: ..,K.... */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 0008: ........ */
	0x24,0xF2,0x21,0xF8,0x24,0xF2,0x21,0xFC,	/* 0010: $!$! */
	0x22,0xF9,0x25,0xF7,0x46,0x23,0xFC,0xD4,	/* 0018: "%F# */
	0x40,0x31,0xD1,0x21,0x20,0x20,0x20,0x40,	/* 0020: @1!   @ */
	0x71,0xF4,0xD2,0x23,0x4B,0xD3,0x73,0x72,	/* 0028: q#Ksr */
	0x71,0x24,0xFA,0x74,0x23,0xFC,0x2F,0x2F,	/* 0030: q$t#.. */
	0x2F,0x4E,0xF6,0x20,0x20,0x22,0x04,0x4D,	/* 0038: .N  ".M */
	0x6F,0x6E,0x20,0x4F,0x63,0x74,0x20,0x20,	/* 0040: on Oct   */
	0x35,0x20,0x31,0x30,0x3A,0x34,0x31,0x3A,	/* 0048: 5 10:41: */
	0x35,0x34,0x20,0x31,0x39,0x39,0x38,0x0A,	/* 0050: 54 1998. */
	0x00,0x6A,0x65,0x74,0x2E,0x65,0x70,0x72,	/* 0058: .jet.epr */
	0x00,0x20,0x20,0x22,0xB0,0x21,0x12,0xDD,	/* 0060: .  "!. */
	0x24,0xF2,0x21,0xF8,0x24,0xF2,0x21,0xFC,	/* 0068: $!$! */
	0x22,0xF9,0x25,0xF8,0x40,0xDE,0x4B,0xDF,	/* 0070: "%@K */
	0x24,0xF2,0x7E,0x24,0xF2,0xFA,0xE0,0x1E,	/* 0078: $~$. */
	0x4B,0x22,0xF1,0x40,0x25,0xF4,0x22,0x46,	/* 0080: K"@%"F */
	0x21,0xFB,0xD0,0x24,0xF2,0xD1,0x24,0x4B,	/* 0088: !$$K */
	0x21,0xFB,0xD2,0x72,0x84,0x21,0xD0,0x72,	/* 0090: !r!r */
	0x30,0x21,0x70,0xF2,0x21,0xD1,0x21,0x71,	/* 0098: 0!p!!q */
	0xD2,0x1B,0xD3,0x7D,0xD4,0x40,0xD5,0x1C,	/* 00A0: .}@. */
	0xD6,0x19,0xD7,0x1A,0xD8,0x21,0x70,0xF6,	/* 00A8: ..!p */
	0x60,0xBC,0x7D,0x27,0x88,0xDD,0x22,0x40,	/* 00B0: `}'"@ */
	0x21,0xFB,0xD0,0x44,0x24,0xF2,0xFA,0xD1,	/* 00B8: !D$ */
	0x24,0xF2,0xD2,0x7B,0x83,0x60,0x4C,0x24,	/* 00C0: ${`L$ */
	0xF6,0x21,0x71,0xF2,0xD3,0x7D,0xD4,0x24,	/* 00C8: !q}$ */
	0xF2,0xD5,0x7A,0x7D,0xF2,0xD6,0x79,0x73,	/* 00D0: z}ys */
	0xF2,0xF6,0x21,0xF5,0x20,0x6E,0x03,0x00,	/* 00D8: ! n.. */
	0x00,0x20,0x61,0xBF,0x40,0xD1,0x40,0xDF,	/* 00E0: . a@@ */
	0x21,0x76,0x67,0x88,0xDE,0x40,0x21,0x74,	/* 00E8: !vg@!t */
	0xE0,0x10,0x23,0x24,0x94,0x28,0x45,0x71,	/* 00F0: .#$(Eq */
	0xF4,0x22,0x2B,0xAD,0x71,0x46,0x24,0xF0,	/* 00F8: "+qF$ */
	0x21,0xD0,0x71,0x23,0x4F,0x24,0xF6,0xD5,	/* 0100: !q#O$ */
	0x21,0x70,0xC0,0x23,0xAF,0x7F,0xA7,0x7D,	/* 0108: !p#} */
	0xD6,0x76,0x75,0xF2,0xDD,0x02,0x7E,0xD6,	/* 0110: vu.~ */
	0x75,0xA6,0x75,0x76,0x10,0x22,0x2F,0x94,	/* 0118: uuv.". */
	0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,	/* 0120: @DAr$ */
	0x74,0x24,0xF6,0x21,0xA7,0x11,0x72,0x21,	/* 0128: t$!.r! */
	0x72,0xFA,0x41,0xFB,0x75,0xAE,0x76,0x27,	/* 0130: rAuv' */
	0x88,0xD0,0x70,0x21,0x75,0xF2,0x72,0x21,	/* 0138: p!ur! */
	0x72,0xFA,0x75,0xFB,0x12,0x22,0x45,0x22,	/* 0140: ru."E" */
	0xF1,0x22,0x26,0x07,0x21,0x70,0xC2,0x22,	/* 0148: "&.!p" */
	0x25,0xA7,0x75,0xC0,0xA7,0x41,0xDF,0x40,	/* 0150: %uA@ */
	0xD4,0x22,0x24,0x0C,0x75,0xC9,0xA7,0x41,	/* 0158: "$.uɧA */
	0xDF,0x40,0xD4,0x22,0x24,0x02,0x75,0xC7,	/* 0160: @"$.u */
	0xA7,0x41,0xDF,0x40,0xD4,0x22,0x23,0x08,	/* 0168: A@"#. */
	0x75,0xC1,0xA7,0x40,0xDF,0x40,0xD4,0x22,	/* 0170: u@@" */
	0x22,0x0E,0x75,0xC2,0x22,0xA7,0x41,0xD0,	/* 0178: ".u"A */
	0x70,0x21,0xAF,0x10,0x22,0x2B,0x92,0x71,	/* 0180: p!."+q */
	0x28,0xC2,0xA4,0x70,0x81,0xD0,0x08,0x71,	/* 0188: (¤p.q */
	0x28,0xC3,0xA4,0x70,0x60,0x8F,0xD0,0x70,	/* 0190: (äp`p */
	0xA7,0x11,0x7C,0x21,0x72,0xFA,0x41,0xFB,	/* 0198: .|!rA */
	0x62,0x0E,0x22,0x20,0x03,0x75,0xC4,0xAC,	/* 01A0: b." .uĬ */
	0x1D,0x10,0x22,0x23,0x9D,0x7D,0x21,0x77,	/* 01A8: .."#}!w */
	0xE0,0x21,0x2F,0x04,0x75,0xC6,0xA9,0x21,	/* 01B0: !..uƩ! */
	0x79,0x10,0x22,0x22,0x9D,0x21,0x2E,0x08,	/* 01B8: y.""!.. */
	0x75,0xCB,0xA9,0x21,0x78,0x10,0x22,0x22,	/* 01C0: u˩!x."" */
	0x91,0x21,0x2D,0x0C,0x75,0xC8,0xAC,0x1D,	/* 01C8: !-.uȬ. */
	0x10,0x22,0x21,0x96,0x7D,0x21,0x78,0xE0,	/* 01D0: ."!}!x */
	0x21,0x2C,0x0D,0x75,0xCA,0xAC,0x1D,0x10,	/* 01D8: !,.uʬ.. */
	0x22,0x20,0x97,0x7D,0x21,0x79,0xE0,0x21,	/* 01E0: " }!y! */
	0x2B,0x0E,0x75,0xCC,0x2C,0xAB,0x40,0xD6,	/* 01E8: +.u,@ */
	0x40,0xDA,0x40,0xD8,0x7E,0xD7,0x41,0xD6,	/* 01F0: @@~A */
	0x10,0x22,0x23,0x9D,0x23,0x4F,0x71,0xF9,	/* 01F8: ."##Oq */
	0xC0,0xD6,0x76,0x22,0xA8,0x41,0x7A,0xF2,	/* 0200: v"Az */
	0xDA,0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,	/* 0208: @DAr$ */
	0xF1,0x74,0x24,0xF6,0xA7,0x11,0x72,0x21,	/* 0210: t$.r! */
	0x72,0xFA,0x41,0xFB,0x12,0x21,0x44,0x22,	/* 0218: rA.!D" */
	0xF1,0x10,0x22,0x21,0x94,0x23,0x4F,0x71,	/* 0220: ."!#Oq */
	0xF9,0xC0,0xD6,0x62,0x05,0x71,0x23,0x4F,	/* 0228: b.q#O */
	0x24,0xF6,0xD5,0x7A,0x40,0xF9,0x23,0xA3,	/* 0230: $z@# */
	0x75,0xA6,0x75,0x77,0x10,0x21,0x2D,0x94,	/* 0238: uuw.!- */
	0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,	/* 0240: @DAr$ */
	0x74,0x24,0xF6,0x21,0xA7,0x11,0x72,0x21,	/* 0248: t$!.r! */
	0x72,0xFA,0x41,0xFB,0x75,0xAE,0x77,0x27,	/* 0250: rAuw' */
	0x88,0xD0,0x70,0x21,0x75,0xF2,0x72,0x21,	/* 0258: p!ur! */
	0x72,0xFA,0x75,0xFB,0x12,0x22,0x45,0x22,	/* 0260: ru."E" */
	0xF1,0x24,0x0C,0x41,0xD6,0x76,0x21,0xAF,	/* 0268: $.Av! */
	0x75,0x77,0x10,0x21,0x29,0x9E,0x77,0x75,	/* 0270: uw.!)wu */
	0xF2,0xD7,0x78,0x75,0xF2,0xD8,0x10,0x21,	/* 0278: xu.! */
	0x2B,0x97,0x23,0x4F,0x71,0xF9,0xD6,0x71,	/* 0280: +#Oqq */
	0x23,0x4F,0x24,0xF6,0xD5,0x62,0x0E,0x40,	/* 0288: #O$b.@ */
	0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,0x74,	/* 0290: DAr$t */
	0x24,0xF6,0x21,0xA6,0x72,0x21,0x72,0xFA,	/* 0298: $!r!r */
	0x78,0xFE,0x78,0xAE,0x7E,0x27,0x88,0xD0,	/* 02A0: xx~' */
	0x70,0x21,0x75,0xF2,0x72,0x21,0x72,0xFA,	/* 02A8: p!ur!r */
	0x78,0xFB,0x12,0x22,0x44,0x22,0xF1,0x2E,	/* 02B0: x."D". */
	0x0F,0x75,0xCD,0x22,0xAC,0x40,0xD6,0x7A,	/* 02B8: .u"@z */
	0xD7,0x77,0x22,0xA1,0x10,0x21,0x27,0x91,	/* 02C0: w".!' */
	0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,	/* 02C8: @DAr$ */
	0x74,0x24,0xF6,0xA7,0x11,0x72,0x21,0x72,	/* 02D0: t$.r!r */
	0xFA,0x41,0xFB,0x12,0x21,0x44,0x22,0xF1,	/* 02D8: A.!D" */
	0x16,0x22,0x41,0x22,0xF1,0x40,0xDA,0x2B,	/* 02E0: ."A"@+ */
	0x0F,0x75,0xCE,0x2B,0xAB,0x40,0xD0,0x40,	/* 02E8: .u+@@ */
	0xD2,0x40,0xD3,0x41,0xD0,0x70,0x22,0xA7,	/* 02F0: @Ap" */
	0x73,0x72,0x46,0x23,0xF6,0xD2,0xD3,0x10,	/* 02F8: srF#. */
	0x21,0x23,0x96,0x71,0x23,0x4F,0x24,0xF6,	/* 0300: !#q#O$ */
	0x21,0xFD,0xD8,0xD9,0x40,0x72,0x78,0x23,	/* 0308: !@rx# */
	0xF7,0xD2,0x73,0x79,0x23,0xF7,0xD3,0x2C,	/* 0310: sy#, */
	0x40,0x71,0xF9,0xC0,0xD0,0x62,0x06,0x28,	/* 0318: @qb.( */
	0x20,0x40,0xD6,0x40,0xD7,0x73,0x77,0xF9,	/* 0320:  @@sw */
	0xC0,0xAB,0x73,0x77,0xF4,0xC0,0xA7,0x41,	/* 0328: swA */
	0x72,0x76,0x24,0xFF,0xF0,0xC0,0x27,0xA0,	/* 0330: rv$' */
	0x73,0x77,0xF9,0xC0,0xAB,0x73,0x77,0xF4,	/* 0338: swsw */
	0xC0,0xA7,0x41,0x72,0x76,0x24,0xFF,0xF0,	/* 0340: Arv$ */
	0xC0,0x25,0xAD,0x40,0x72,0x76,0x24,0xFF,	/* 0348: %@rv$ */
	0xD8,0x73,0x77,0x24,0xFF,0xD9,0x79,0x40,	/* 0350: sw$y@ */
	0xF9,0xC0,0xAC,0x79,0xC0,0xAA,0x41,0x78,	/* 0358: yAx */
	0x27,0x2F,0x2F,0x4F,0x24,0xFF,0xF0,0xC0,	/* 0360: '..O$ */
	0x21,0xAF,0x76,0xD0,0x2F,0x4F,0x70,0x24,	/* 0368: !v.Op$ */
	0xF2,0xF2,0x27,0x2F,0x2F,0x4F,0xF0,0x24,	/* 0370: '..O$ */
	0x94,0x40,0x76,0x27,0x2F,0x2F,0x4F,0x23,	/* 0378: @v'..O# */
	0xF7,0xD6,0x77,0x40,0x23,0xF7,0xD7,0x21,	/* 0380: w@#! */
	0x0D,0x76,0xDB,0x40,0x72,0x76,0x24,0xFF,	/* 0388: .v@rv$ */
	0xD8,0x73,0x77,0x24,0xFF,0xD9,0x78,0xD0,	/* 0390: sw$x */
	0x2F,0x4F,0x7B,0x24,0xF2,0xF2,0x70,0xF0,	/* 0398: .O{$p */
	0x21,0x9B,0x72,0xD6,0x73,0xD7,0x66,0x00,	/* 03A0: !rsf. */
	0x0A,0x75,0xDC,0x41,0x7C,0x24,0xF1,0x74,	/* 03A8: .uA|$t */
	0x24,0xFB,0xD4,0x10,0x28,0x93,0x62,0x23,	/* 03B0: $.(b# */
	0x0C,0x21,0xB1,0x22,0xF0,0x60,0xBE,0x41,	/* 03B8: .!"`A */
	0xD0,0x70,0xD1,0x75,0x73,0x23,0xFB,0x74,	/* 03C0: pus#t */
	0x71,0xF9,0x21,0xAB,0x70,0x74,0x71,0xF4,	/* 03C8: q!ptq */
	0xF9,0xA4,0x74,0x71,0xF4,0xD0,0x73,0x71,	/* 03D0: tqsq */
	0x73,0xF2,0x70,0x24,0xFA,0x71,0x70,0xF2,	/* 03D8: sp$qp */
	0xD1,0x70,0x70,0xF2,0xD0,0x61,0x00,0xB2,	/* 03E0: ppa. */
	0x22,0xF0,0x40,0xD3,0x40,0x72,0xE0,0x41,	/* 03E8: "@@rA */
	0xD3,0x73,0x21,0xAE,0x72,0x30,0x46,0x24,	/* 03F0: s!r0F$ */
	0xF1,0x72,0xE0,0x71,0x23,0x9B,0x71,0x31,	/* 03F8: rq#q1 */
	0x23,0x4F,0x24,0xF6,0x72,0x30,0xF2,0x72,	/* 0400: #O$r0r */
	0xE0,0x2C,0x40,0x71,0x31,0xF9,0xC0,0xD3,	/* 0408: ,@q1 */
	0x62,0x0F,0x22,0xF0,0x60,0xBE,0x74,0x27,	/* 0410: b."`t' */
	0x88,0xD0,0x73,0x21,0x34,0x30,0xD1,0x71,	/* 0418: s!40q */
	0x73,0x21,0x33,0xF2,0x70,0x73,0x21,0x35,	/* 0420: s!3ps!5 */
	0xF2,0x75,0x24,0xFA,0x73,0x21,0x34,0x30,	/* 0428: u$s!40 */
	0x75,0xF5,0x73,0x21,0x34,0xE0,0xB2,0x22,	/* 0430: us!4" */
	0xF0,0x71,0x21,0x34,0x30,0x71,0x21,0x33,	/* 0438: q!40q!3 */
	0xF2,0xF1,0x71,0xE1,0x71,0x21,0x34,0x30,	/* 0440: qq!40 */
	0x81,0x71,0x21,0x34,0xE0,0x22,0xF0,0x8A,	/* 0448: q!4" */
	0xF0,0x0C,0x89,0x3C,0x00,0x00,0x07,0x00,	/* 0450: .<.... */
	0x00,0x08,0x00,0x00,0x00,0x81,0x00,0x80,	/* 0458: ...... */
	0xFF,0x7F,0xFF,0x7F,0xA4,0x8D,0x60,0x8D,	/* 0460: ` */
	0x26,0x8D,0xFF,0x80,0x00,0x00,0x02,0x00,	/* 0468: &.... */
	0x01,0x00,0x6E,0x00,0xE6,0x45,0xE7,0x45,	/* 0470: ..n.EE */
	0x10,0x00,0x06,0x00,0x34,0x81,0x00,0x00,	/* 0478: ....4.. */
	0xFF,0x80,0x00,0x00,0xFF,0x80,0x00,0x00,	/* 0480: .... */
	0xFF,0x80,0xFF,0x80,0x0C,0x8D,0x03,0x00,	/* 0488: ... */
	0x3C,0x02,0x00,0x02,0x00,0x11,0x00,0x5C,	/* 0490: <......\ */
	0x8D,0x02,0x00,0x12,0x00,0x26,0x8D,0x02,	/* 0498: ....&. */
	0x00,0x13,0x00,0xFF,0x80,0x60,0xBC,0x21,	/* 04A0: ...`! */
	0xF5,0x00,0x00,0x00,0x00,0x3C,0x45,0x00,	/* 04A8: ....<E. */
	0x00,0x86,0x38,0xC6,0x02,0x06,0x00,0xC6,	/* 04B0: .8... */
	0x83,0x00,0x00,0xFF,0x80,0x3C,0x01,0xD0,	/* 04B8: ..<. */
	0x83,0x00,0x08,0x0C,0x85,0xFF,0x80,0x0C,	/* 04C0: .... */
	0x8D,0x04,0x00,0x04,0x00,0x20,0x02,0x00,	/* 04C8: .... .. */
	0x11,0x00,0xA0,0x8D,0x02,0x00,0x12,0x00,	/* 04D0: ...... */
	0x60,0x8D,0x02,0x00,0x13,0x00,0xFF,0x80,	/* 04D8: `.... */
	0x02,0x00,0x04,0x00,0x9C,0x8D,0x00,0x00,	/* 04E0: ...... */
	0x00,0x00,0x60,0xBC,0x21,0xF5,0x8A,0x34,	/* 04E8: ..`!4 */
	0x89,0x06,0x5C,0x8D,0x26,0x8D,0xFF,0x80,	/* 04F0: .\& */
	0x8A,0xCB,0x06,0x89,0x06,0xA0,0x8D,0x60,	/* 04F8: ..` */
	0x8D,0xFF,0x80,0x86,0xF0,0x0C,0x8B,0xC4,	/* 0500: . */
	0xD4,0x3C,0x85,0x60,0xBC,0x75,0xD3,0x73,	/* 0508: <`us */
	0x27,0x3B,0x2C,0x48,0xF4,0x75,0x2D,0x96,	/* 0510: ';,Hu- */
	0xA5,0x28,0x4E,0x75,0x2F,0x99,0x26,0x44,	/* 0518: (Nu.&D */
	0xD0,0x73,0x51,0x73,0x75,0x29,0x91,0xA5,	/* 0520: sQsu) */
	0x28,0x41,0x75,0x2E,0x9A,0x73,0x31,0xD0,	/* 0528: (Au.s1 */
	0x26,0x44,0xD1,0x40,0xD2,0x25,0x24,0x4B,	/* 0530: &D@%$K */
	0x21,0xFB,0x73,0x30,0x75,0x23,0x29,0x26,	/* 0538: !s0u#)& */
	0x90,0xA5,0x29,0x44,0x75,0x2D,0x90,0x2C,	/* 0540: )Du-, */
	0x48,0xD0,0x73,0x53,0x73,0x52,0x75,0x26,	/* 0548: HsSsRu& */
	0x97,0xA5,0x28,0x45,0x75,0x2C,0x90,0x73,	/* 0550: (Eu,s */
	0x33,0xD0,0x2C,0x48,0xD1,0x40,0xD2,0x25,	/* 0558: 3,H@% */
	0x2C,0x49,0x21,0xFB,0x73,0x32,0x75,0x23,	/* 0560: ,I!s2u# */
	0x29,0x23,0x96,0xA5,0x28,0x45,0x75,0x2A,	/* 0568: )#(Eu* */
	0x96,0x75,0x24,0x25,0x9C,0x40,0xB4,0x22,	/* 0570: u$%@" */
	0xF0,0x03,0x00,0x02,0x00,0x01,0x00,0x00,	/* 0578: ....... */
	0x00,0xA4,0x00,0x71,0xD2,0x72,0x61,0x4F,	/* 0580: ..qraO */
	0x21,0xFB,0x44,0x23,0x2F,0x21,0x94,0x22,	/* 0588: !D#.!" */
	0xF0,0x60,0xBE,0x73,0x58,0xD0,0x41,0x74,	/* 0590: `sXAt */
	0x70,0x60,0x3E,0x24,0xFF,0xF0,0x21,0xA3,	/* 0598: p`>$! */
	0x70,0x30,0x74,0x70,0x30,0xF2,0x70,0xE0,	/* 05A0: p0tp0p */
	0x70,0x60,0x3E,0x74,0xF4,0x70,0x60,0xEE,	/* 05A8: p`>tp` */
	0xB2,0x22,0xF0,0x24,0xF2,0xB2,0x22,0xF0,	/* 05B0: "$" */
	0x60,0xBF,0x75,0xC0,0xA4,0x24,0x20,0x40,	/* 05B8: `u$ @ */
	0xD5,0x21,0x40,0x72,0x63,0x9B,0x73,0xE0,	/* 05C0: !@rcs */
	0x75,0x72,0x63,0x95,0x74,0xE0,0x73,0x30,	/* 05C8: urcts0 */
	0x24,0xF2,0xF4,0x21,0xA5,0x74,0x30,0x24,	/* 05D0: $!t0$ */
	0xF2,0xF4,0xAF,0x75,0xD0,0x2A,0x45,0x74,	/* 05D8: u*Et */
	0x30,0x72,0x24,0x23,0x20,0x93,0x40,0xB1,	/* 05E0: 0r$# @ */
	0x22,0xF0,0x41,0xB1,0x22,0xF0,0x60,0xBE,	/* 05E8: "A"` */
	0x73,0x58,0xD0,0x74,0x73,0x24,0x20,0x2C,	/* 05F0: sXts$ , */
	0x92,0x25,0xFA,0x70,0xE0,0x24,0xF2,0xF4,	/* 05F8: %p$ */
	0x21,0xA0,0x74,0x70,0xE1,0x74,0x70,0x60,	/* 0600: !tptp` */
	0xEE,0x70,0x31,0x70,0x60,0xEF,0x40,0xB2,	/* 0608: p1p`@ */
	0x22,0xF0,0x28,0x4E,0xB2,0x22,0xF0,0x72,	/* 0610: "(N"r */
	0x21,0x20,0x40,0xE0,0x71,0x23,0x29,0x2E,	/* 0618: ! @q#). */
	0x93,0x22,0xF0,0x00,0x00,0x80,0x00,0x71,	/* 0620: "...q */
	0x58,0xD2,0x72,0x60,0x44,0x21,0xFB,0x41,	/* 0628: Xr`D!A */
	0x23,0x2E,0x26,0x9F,0x22,0xF0,0x20,0x43,	/* 0630: #.&" C */
	0x6F,0x70,0x79,0x72,0x69,0x67,0x68,0x74,	/* 0638: opyright */
	0x20,0x28,0x63,0x29,0x20,0x53,0x70,0x65,	/* 0640:  (c) Spe */
	0x63,0x69,0x61,0x6C,0x69,0x78,0x20,0x49,	/* 0648: cialix I */
	0x6E,0x74,0x65,0x72,0x6E,0x61,0x74,0x69,	/* 0650: nternati */
	0x6F,0x6E,0x61,0x6C,0x20,0x4C,0x74,0x64,	/* 0658: onal Ltd */
	0x20,0x31,0x39,0x39,0x36,0x2D,0x31,0x39,	/* 0660:  1996-19 */
	0x39,0x38,0x2E,0x0D,0x0A,0x4A,0x45,0x54,	/* 0668: 98...JET */
	0x2E,0x42,0x49,0x4E,0x20,0x56,0x65,0x72,	/* 0670: .BIN Ver */
	0x73,0x69,0x6F,0x6E,0x20,0x33,0x2E,0x30,	/* 0678: sion 3.0 */
	0x2E,0x34,0x20,0x43,0x72,0x65,0x61,0x74,	/* 0680: .4 Creat */
	0x65,0x64,0x20,0x4F,0x63,0x74,0x20,0x20,	/* 0688: ed Oct   */
	0x35,0x20,0x31,0x39,0x39,0x38,0x20,0x40,	/* 0690: 5 1998 @ */
	0x20,0x31,0x30,0x3A,0x34,0x31,0x3A,0x34,	/* 0698:  10:41:4 */
	0x38,0x00,0x04,0x03,0x20,0xCE,0x03,0x71,	/* 06A0: 8... .q */
	0x5A,0xD2,0x60,0x44,0x21,0xFB,0x72,0x42,	/* 06A8: Z`D!rB */
	0x24,0xFA,0x67,0x41,0x21,0xFB,0x72,0xE1,	/* 06B0: $gA!r */
	0x22,0xF0,0x20,0x61,0xBD,0x21,0x74,0x5C,	/* 06B8: " a!t\ */
	0xD9,0x40,0xDA,0x40,0xD8,0x28,0x40,0xD7,	/* 06C0: @@(@ */
	0x28,0x40,0xD2,0x40,0xD6,0x76,0x47,0x24,	/* 06C8: (@@vG$ */
	0xF1,0x27,0x20,0x20,0x40,0xFA,0xD4,0x40,	/* 06D0: '  @@ */
	0xD3,0x40,0xD1,0x71,0x44,0x24,0xF1,0x76,	/* 06D8: @qD$v */
	0x47,0x24,0xF1,0x27,0x20,0x20,0x40,0xFA,	/* 06E0: G$'  @ */
	0xFA,0x3D,0x2A,0x40,0x24,0xF6,0x2A,0x40,	/* 06E8: =*@$*@ */
	0xF4,0xC0,0xAE,0x71,0x41,0xF2,0xD1,0x41,	/* 06F0: qAA */
	0x44,0x71,0x24,0xFF,0xF0,0xC0,0xAB,0x62,	/* 06F8: Dq$b */
	0x0A,0x41,0xD8,0x41,0xD3,0x7A,0x41,0xF4,	/* 0700: .AAzA */
	0x27,0xAC,0x73,0xC0,0x21,0xA2,0x74,0x31,	/* 0708: 's!t1 */
	0x2F,0x4F,0x24,0xF6,0x2F,0x4F,0xF4,0x27,	/* 0710: .O$.O' */
	0xA9,0x41,0xDA,0x78,0x41,0xF4,0x26,0xAC,	/* 0718: AxA& */
	0x76,0x21,0xA8,0x72,0x51,0xF1,0x21,0x28,	/* 0720: v!rQ!( */
	0x40,0xF8,0x77,0x28,0x50,0xFA,0x25,0xFA,	/* 0728: @w(P% */
	0xD7,0x67,0x20,0x20,0x40,0x24,0xFB,0x72,	/* 0730: g  @$r */
	0xE0,0x77,0xD2,0x76,0x47,0x24,0xF1,0x27,	/* 0738: wvG$' */
	0x20,0x20,0x40,0xFA,0xD4,0x40,0x72,0xE0,	/* 0740:   @@r */
	0x76,0x72,0x83,0x23,0xFB,0x74,0x72,0xE3,	/* 0748: vr#tr */
	0x78,0x2B,0xA6,0x48,0x72,0x51,0x23,0xFB,	/* 0750: x+HrQ# */
	0x40,0x74,0x27,0xEF,0x40,0x74,0x26,0xE8,	/* 0758: @t'@t& */
	0x40,0x74,0x21,0xE8,0x44,0x74,0x27,0xEF,	/* 0760: @t!Dt' */
	0x40,0x74,0x26,0xE8,0x25,0x45,0x74,0x21,	/* 0768: @t&%Et! */
	0xE8,0x40,0x74,0x27,0xEF,0x74,0x21,0x38,	/* 0770: @t't!8 */
	0x2F,0x4F,0x24,0xF6,0x25,0x45,0xF4,0x22,	/* 0778: .O$%E" */
	0xAF,0x22,0x48,0xD1,0x22,0x0D,0x2F,0x4F,	/* 0780: "H"..O */
	0x21,0xB3,0x22,0xF0,0x2F,0x4F,0x21,0xB3,	/* 0788: !".O! */
	0x22,0xF0,0x78,0xC0,0xA4,0x20,0x7A,0x21,	/* 0790: "x z! */
	0xA1,0x67,0x21,0x2E,0x40,0x70,0xE0,0x21,	/* 0798: g!.@p! */
	0x28,0x40,0x70,0x21,0xE7,0x41,0x21,0xB3,	/* 07A0: (@p!A! */
	0x22,0xF0,0x2F,0x4F,0x21,0xB3,0x22,0xF0,	/* 07A8: ".O!" */
	0x24,0x48,0xD1,0x71,0x72,0x54,0x23,0xFB,	/* 07B0: $HqrT# */
	0x74,0x27,0x3F,0x2F,0x4F,0x24,0xF6,0x72,	/* 07B8: t'?.O$r */
	0x5F,0x23,0xFB,0x74,0x24,0x30,0x2F,0x4F,	/* 07C0: _#t$0.O */
	0x24,0xF6,0x72,0x21,0x8F,0x23,0xFB,0x44,	/* 07C8: $r!#D */
	0x74,0x27,0xEF,0x74,0x24,0x30,0x2F,0x4F,	/* 07D0: t't$0.O */
	0x24,0xF6,0x72,0x21,0x50,0x23,0xFB,0x72,	/* 07D8: $r!P#r */
	0x54,0xF1,0x24,0x48,0xF4,0xA8,0x79,0x32,	/* 07E0: T$Hy2 */
	0x41,0xF2,0x79,0xE2,0x21,0x02,0x74,0x23,	/* 07E8: Ay!.t# */
	0x39,0x43,0x24,0xF6,0x81,0x72,0x22,0x81,	/* 07F0: 9C$r" */
	0x23,0xFB,0x79,0x33,0x41,0xF2,0x79,0xE3,	/* 07F8: #y3Ay */
	0x74,0x21,0x74,0x21,0x20,0x2B,0x99,0x24,	/* 0800: t!t! +$ */
	0x0E,0x74,0x24,0x30,0x2F,0x4F,0x24,0xF6,	/* 0808: .t$0.O$ */
	0xD1,0x79,0x31,0x41,0xF2,0x79,0xE1,0x71,	/* 0810: y1Ayq */
	0x41,0x24,0xF6,0x21,0xA8,0x71,0x2A,0x4B,	/* 0818: A$!q*K */
	0xF4,0xA5,0x20,0x44,0xD1,0x03,0x20,0x4A,	/* 0820:  D. J */
	0xD1,0x71,0x72,0x54,0x23,0xFB,0x44,0x72,	/* 0828: qrT#Dr */
	0x51,0x23,0xFB,0x21,0x06,0x71,0x2A,0x4A,	/* 0830: Q#!.q*J */
	0xF4,0xA5,0x20,0x48,0xD1,0x03,0x20,0x4B,	/* 0838:  H. K */
	0xD1,0x71,0x72,0x54,0x23,0xFB,0x48,0x72,	/* 0840: qrT#Hr */
	0x51,0x23,0xFB,0x2F,0x4F,0x74,0x6F,0x40,	/* 0848: Q#.Oto@ */
	0x24,0xF6,0x28,0x40,0x24,0xFB,0xE0,0x77,	/* 0850: $(@$w */
	0x28,0x50,0xD3,0x76,0xAF,0x73,0x23,0x50,	/* 0858: (Pvs#P */
	0x67,0x20,0x20,0x40,0x24,0xFB,0x70,0xE0,	/* 0860: g  @$p */
	0x73,0x70,0x21,0xE7,0x40,0xD1,0x41,0x72,	/* 0868: sp!@Ar */
	0x51,0xF1,0x40,0x24,0xFF,0xF0,0xC0,0x21,	/* 0870: Q@$! */
	0x23,0xA7,0x73,0x25,0xFA,0xD0,0x71,0x72,	/* 0878: #s%qr */
	0x55,0xFA,0xE0,0x72,0x54,0xF1,0x70,0x53,	/* 0880: UrTpS */
	0x23,0xFB,0x21,0x40,0x70,0x57,0x23,0xFB,	/* 0888: #!@pW# */
	0x41,0x70,0x21,0x8F,0x23,0xFB,0x71,0x70,	/* 0890: Ap!#qp */
	0x87,0x23,0xFB,0x2F,0x4F,0x70,0x21,0x51,	/* 0898: #.Op!Q */
	0x23,0xFB,0x78,0x26,0xA0,0x21,0x2A,0x4F,	/* 08A0: #x&!*O */
	0x21,0xFB,0x1B,0x21,0x40,0x24,0xFA,0x74,	/* 08A8: !.!@$t */
	0x70,0xE1,0x41,0x71,0x43,0x24,0xFF,0xF0,	/* 08B0: pAqC$ */
	0xA8,0x74,0x27,0x3F,0x4F,0x24,0xF6,0xD5,	/* 08B8: t'?O$ */
	0x0B,0x74,0x27,0x3F,0x2F,0x4F,0x24,0xF6,	/* 08C0: .t'?.O$ */
	0x44,0x24,0xF0,0xD5,0x75,0x2F,0x4F,0x24,	/* 08C8: D$u.O$ */
	0xF6,0x25,0xFA,0xD5,0x70,0x21,0x52,0x23,	/* 08D0: %p!R# */
	0xFB,0x75,0x1B,0xF2,0xF1,0x70,0x21,0x53,	/* 08D8: u.p!S */
	0x23,0xFB,0x75,0x47,0x24,0xF6,0x45,0xF4,	/* 08E0: #uG$E */
	0xC0,0xAD,0x71,0xA5,0x71,0x44,0xF4,0xC0,	/* 08E8: qqD */
	0xA6,0x41,0x70,0x22,0x87,0x23,0xFB,0x4B,	/* 08F0: Ap"#K */
	0x70,0x21,0x5B,0x23,0xFB,0x4B,0x70,0x23,	/* 08F8: p![#Kp# */
	0x87,0x23,0xFB,0x27,0x0D,0x21,0x25,0x4F,	/* 0900: #'.!%O */
	0x21,0xFB,0x1B,0x48,0x24,0xFA,0x72,0x54,	/* 0908: !.H$rT */
	0xF1,0x48,0xF4,0x21,0xAD,0x72,0x54,0xF1,	/* 0910: H!rT */
	0x4B,0xF4,0x21,0xA6,0x71,0x1B,0xFA,0x30,	/* 0918: K!q.0 */
	0x48,0xF8,0x74,0xFA,0x70,0xE1,0x41,0x71,	/* 0920: HtpAq */
	0x1B,0xFA,0x30,0x24,0xF1,0x70,0x8F,0x23,	/* 0928: .0$p# */
	0xFB,0x0F,0x71,0x48,0xF8,0x74,0xFA,0x70,	/* 0930: .qHtp */
	0xE1,0x41,0x71,0x24,0xF1,0x70,0x8F,0x23,	/* 0938: Aq$p# */
	0xFB,0x71,0x41,0x24,0xF6,0xC0,0xAE,0x72,	/* 0940: qA$r */
	0x54,0xF1,0x44,0xF4,0xA8,0x72,0x54,0xF1,	/* 0948: TDrT */
	0x4A,0xF4,0xC0,0x22,0xAD,0x70,0x31,0xD5,	/* 0950: J"p1 */
	0x2E,0x40,0x75,0x61,0x4F,0x24,0xF6,0xE4,	/* 0958: .@uaO$ */
	0x40,0x75,0x61,0x4F,0x24,0xF6,0xE5,0x40,	/* 0960: @uaO$@ */
	0x75,0x61,0x4F,0x24,0xF6,0xE6,0x42,0x75,	/* 0968: uaO$Bu */
	0x61,0x4F,0x24,0xF6,0xE7,0x75,0x61,0x4F,	/* 0970: aO$uaO */
	0x24,0xF6,0x3E,0x40,0x75,0x61,0x4F,0x24,	/* 0978: $>@uaO$ */
	0xF6,0xED,0x77,0x67,0x20,0x20,0x40,0x24,	/* 0980: wg  @$ */
	0xFB,0x70,0xE2,0x73,0x21,0x28,0x50,0x25,	/* 0988: ps!(P% */
	0xFA,0xD3,0x23,0x50,0x67,0x20,0x20,0x40,	/* 0990: #Pg  @ */
	0x24,0xFB,0x70,0xE0,0x73,0x70,0x21,0xE7,	/* 0998: $psp! */
	0x71,0x41,0xF2,0xD1,0x41,0x72,0x51,0xF1,	/* 09A0: qAArQ */
	0x71,0x24,0xFF,0xF0,0xC0,0xA3,0x61,0x2C,	/* 09A8: q$a, */
	0x09,0x76,0x41,0xF2,0xD6,0x41,0x44,0x76,	/* 09B0: .vAADv */
	0x24,0xFF,0xF0,0xC0,0xA3,0x62,0x20,0x0D,	/* 09B8: $b . */
	0x67,0x21,0x2E,0x40,0x70,0xE0,0x21,0x28,	/* 09C0: g!.@p!( */
	0x40,0x70,0x21,0xE7,0x41,0x21,0xB3,0x22,	/* 09C8: @p!A!" */
	0xF0,0x60,0xBE,0x73,0x5C,0xD1,0x40,0x71,	/* 09D0: `s\@q */
	0xE0,0x27,0x20,0x20,0x40,0xD0,0x40,0x40,	/* 09D8: '  @@@ */
	0x73,0x23,0x2F,0x20,0x94,0x21,0x20,0x40,	/* 09E0: s#. ! @ */
	0xD0,0x40,0x27,0x2E,0x20,0x40,0x73,0x23,	/* 09E8: @'. @s# */
	0x2E,0x2F,0x96,0x24,0x40,0x71,0x30,0x81,	/* 09F0: ..$@q0 */
	0x23,0xFB,0x71,0x60,0x3E,0x71,0x30,0xE2,	/* 09F8: #q`>q0 */
	0x26,0x44,0x71,0x30,0xE1,0x73,0x63,0x2B,	/* 0A00: &Dq0sc+ */
	0x92,0x71,0x30,0x23,0xFB,0x71,0x30,0xF1,	/* 0A08: q0#q0 */
	0x41,0xF4,0xC0,0x23,0xA7,0x71,0x60,0x34,	/* 0A10: A#q`4 */
	0x73,0x23,0x2F,0x2B,0x96,0x28,0x40,0x54,	/* 0A18: s#.+(@T */
	0xF1,0x2F,0x40,0x24,0xF6,0x21,0xAA,0x41,	/* 0A20: .@$!A */
	0x71,0x33,0x40,0x24,0xFF,0xF0,0xC0,0xA4,	/* 0A28: q3@$ */
	0x71,0x32,0x21,0xA3,0x71,0x60,0x36,0x73,	/* 0A30: q2!q`6s */
	0x23,0x2F,0x27,0x99,0x73,0x2F,0x21,0x9A,	/* 0A38: #.'s.! */
	0x0B,0x73,0x22,0x2D,0x23,0x9D,0x05,0x73,	/* 0A40: .s"-#.s */
	0x22,0x20,0x21,0x93,0x21,0x20,0x40,0x30,	/* 0A48: " !! @0 */
	0x41,0xF2,0x21,0x20,0x40,0xE0,0x60,0x04,	/* 0A50: A! @`. */
	0x20,0xF0,0xD0,0x00,0xF0,0x00,0xC0,0x00,	/* 0A58:  ... */
	0x00,0xF0,0xD0,0xF0,0xF0,0x00,0xC0,0x00,	/* 0A60: ... */
	0x00,0x00,0x00,0x03,0x00,0x04,0x00,0x07,	/* 0A68: ........ */
	0x00,0x00,0x00,0x48,0x1F,0x71,0x5C,0xD2,	/* 0A70: ...H.q\ */
	0x72,0x60,0x44,0x21,0xFB,0x41,0x23,0x2A,	/* 0A78: r`D!A#* */
	0x22,0x91,0x22,0xF0,0x20,0x60,0xBC,0x75,	/* 0A80: "" `u */
	0x21,0x50,0xD1,0x71,0x60,0x3C,0x35,0x41,	/* 0A88: !Pq`<5A */
	0xF2,0x71,0x60,0x3C,0xE5,0x71,0x60,0x3C,	/* 0A90: q`<q`< */
	0x31,0x21,0xA1,0x40,0x23,0x2D,0x20,0x49,	/* 0A98: 1!@#- I */
	0x71,0x60,0x3C,0x31,0x21,0xFA,0x75,0x23,	/* 0AA0: q`<1!u# */
	0x25,0x24,0x9F,0x07,0x29,0x4C,0x75,0x23,	/* 0AA8: %$.)Lu# */
	0x25,0x24,0x97,0x21,0x28,0x40,0x25,0xFA,	/* 0AB0: %$!(@% */
	0xD0,0x53,0xF1,0x2F,0x40,0x24,0xF6,0xC0,	/* 0AB8: S.@$ */
	0x24,0xA2,0x70,0x57,0xF1,0xC0,0x22,0xAF,	/* 0AC0: $pW" */
	0x70,0x34,0x22,0x20,0x20,0x40,0x24,0xF6,	/* 0AC8: p4"  @$ */
	0x22,0xA5,0x70,0x5C,0xF1,0xD3,0x70,0x75,	/* 0AD0: "p\pu */
	0x22,0x29,0x2F,0x9D,0x25,0xFA,0xD2,0x73,	/* 0AD8: ").%s */
	0xF4,0x21,0xA4,0x72,0x70,0x5C,0x23,0xFB,	/* 0AE0: !rp\# */
	0x70,0x21,0x89,0xF1,0x42,0x24,0xFB,0x70,	/* 0AE8: p!B$p */
	0x21,0x89,0x23,0xFB,0x41,0x71,0xE1,0x70,	/* 0AF0: !#Aqp */
	0x21,0x37,0x25,0xFA,0xD0,0x21,0x28,0x40,	/* 0AF8: !7%!(@ */
	0xF4,0xA2,0x64,0x0E,0x71,0x31,0x71,0x32,	/* 0B00: d.q1q2 */
	0x24,0xFB,0x68,0xAF,0x41,0x71,0x60,0x3C,	/* 0B08: $hAq`< */
	0xE4,0x71,0x31,0x27,0x2C,0x28,0x40,0xE0,	/* 0B10: q1',(@ */
	0x71,0x60,0x3C,0x56,0xF1,0x81,0x71,0x60,	/* 0B18: q`<Vq` */
	0x3C,0x56,0x23,0xFB,0x40,0x71,0xE1,0x40,	/* 0B20: <V#@q@ */
	0x71,0xE2,0x6A,0x0F,0x20,0x61,0xBF,0x21,	/* 0B28: qj. a! */
	0x72,0x21,0x53,0xD9,0x28,0x40,0xD3,0x40,	/* 0B30: r!S(@@ */
	0xD2,0x24,0xF2,0x58,0x21,0x72,0x23,0x22,	/* 0B38: $X!r#" */
	0x2E,0x97,0x79,0x60,0x39,0x53,0xF1,0x81,	/* 0B40: .y`9S */
	0x79,0x60,0x39,0x53,0x23,0xFB,0x73,0xDA,	/* 0B48: y`9S#s */
	0x72,0xDF,0x73,0x33,0xD1,0x72,0x44,0xF8,	/* 0B50: rs3rD */
	0x71,0x27,0xEF,0x71,0x26,0x37,0x2F,0x4F,	/* 0B58: q'q&7.O */
	0x24,0xF6,0x25,0xFA,0xD5,0x41,0x24,0xF6,	/* 0B60: $%A$ */
	0x25,0x2E,0xA2,0x71,0x26,0x3B,0x2F,0x4F,	/* 0B68: %.q&;.O */
	0x24,0xF6,0xD4,0x71,0x26,0x38,0x2F,0x4F,	/* 0B70: $q&8.O */
	0x24,0xF6,0xD7,0x74,0x43,0x24,0xF6,0x71,	/* 0B78: $tC$q */
	0x26,0xE8,0x71,0x24,0x33,0x47,0x24,0xF6,	/* 0B80: &q$3G$ */
	0x25,0xFA,0xD6,0x43,0xF4,0x21,0x24,0xA4,	/* 0B88: %C!$ */
	0x76,0x47,0xF4,0xC0,0x25,0x2B,0xA6,0x40,	/* 0B90: vG%+@ */
	0xDB,0x72,0x74,0x43,0x24,0xF6,0x28,0xF1,	/* 0B98: rtC$( */
	0x73,0x55,0xFA,0x30,0xD6,0x71,0x26,0x32,	/* 0BA0: sU0q&2 */
	0x2F,0x4F,0x24,0xF6,0xD8,0x71,0x26,0x32,	/* 0BA8: .O$q&2 */
	0x2F,0x4F,0x24,0xF6,0x21,0xD0,0x78,0x48,	/* 0BB0: .O$!xH */
	0x24,0xF6,0x21,0xA0,0x76,0x21,0x89,0xF1,	/* 0BB8: $!v! */
	0x41,0x24,0xFB,0x76,0x21,0x89,0x23,0xFB,	/* 0BC0: A$v!# */
	0x41,0x79,0x60,0xEE,0x78,0x47,0x24,0xF6,	/* 0BC8: Ay`xG$ */
	0xAD,0x76,0x21,0x50,0xF1,0x28,0x40,0x24,	/* 0BD0: v!P(@$ */
	0xF6,0xA4,0x41,0x79,0x60,0xEE,0x78,0x41,	/* 0BD8: Ay`xA */
	0x24,0xF6,0xA8,0x76,0x21,0x3E,0x41,0xF2,	/* 0BE0: $v!>A */
	0x76,0x21,0xEE,0x78,0x42,0x24,0xF6,0xAA,	/* 0BE8: v!xB$ */
	0x76,0x21,0x3C,0x41,0xF2,0x76,0x21,0xEC,	/* 0BF0: v!<Av! */
	0x41,0xDB,0x78,0x44,0x24,0xF6,0xAA,0x76,	/* 0BF8: AxD$v */
	0x21,0x3D,0x41,0xF2,0x76,0x21,0xED,0x41,	/* 0C00: !=Av!A */
	0xDB,0x7B,0x25,0x23,0xA4,0x76,0x21,0x50,	/* 0C08: {%#v!P */
	0xF1,0x24,0x40,0x24,0xF6,0xA6,0x76,0x22,	/* 0C10: $@$v" */
	0x8B,0xF1,0x21,0xD0,0x76,0x55,0xF1,0xDB,	/* 0C18: !vU */
	0x76,0x8B,0xF1,0xDD,0x76,0x34,0xDE,0x7D,	/* 0C20: vv4} */
	0x7B,0x41,0xF2,0xF4,0x2F,0x4F,0x24,0xF6,	/* 0C28: {A.O$ */
	0x25,0xFA,0xDC,0x25,0x20,0xA3,0x21,0x70,	/* 0C30: %% !p */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0C38: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0x76,0x55,	/* 0C40: #{AvU */
	0x23,0xFB,0x7D,0x7B,0x41,0xF2,0x41,0xF2,	/* 0C48: #}{AA */
	0xF4,0x2F,0x4F,0x24,0xF6,0xD0,0x7E,0x48,	/* 0C50: .O$~H */
	0x24,0xF6,0x24,0x2E,0xA4,0x41,0x7C,0x23,	/* 0C58: $$.A|# */
	0x4F,0x24,0xFF,0xF0,0xC0,0x24,0x2D,0xA9,	/* 0C60: O$$- */
	0x41,0x24,0x40,0x70,0x24,0xFF,0xF0,0xC0,	/* 0C68: A$@p$ */
	0x24,0x2C,0xAE,0x7E,0x21,0x40,0x24,0xFB,	/* 0C70: $,~!@$ */
	0xDE,0x76,0x21,0x58,0xF1,0x48,0x24,0xF6,	/* 0C78: v!XH$ */
	0x22,0xA1,0x7E,0x22,0x40,0x24,0xF6,0xC0,	/* 0C80: "~"@$ */
	0x21,0xA9,0x71,0x35,0x2F,0x4F,0x24,0xF6,	/* 0C88: !q5.O$ */
	0xC0,0x21,0xA0,0x40,0xD0,0x21,0x20,0x40,	/* 0C90: !@! @ */
	0x76,0x21,0x72,0x21,0x29,0x24,0x98,0x22,	/* 0C98: v!r!)$" */
	0x42,0x71,0xE5,0x76,0x23,0x81,0xF1,0x28,	/* 0CA0: Bqv#( */
	0x40,0x24,0xF6,0xAD,0x40,0xD0,0x21,0x20,	/* 0CA8: @$@!  */
	0x20,0x40,0x76,0x21,0x72,0x21,0x29,0x22,	/* 0CB0:  @v!r!)" */
	0x9E,0x76,0x21,0x58,0xF1,0x24,0x40,0x24,	/* 0CB8: v!X$@$ */
	0xF6,0x24,0x27,0xAD,0x40,0xD0,0x22,0x20,	/* 0CC0: $'@"  */
	0x20,0x40,0x76,0x21,0x72,0x21,0x29,0x21,	/* 0CC8:  @v!r!)! */
	0x96,0x24,0x26,0x0D,0x72,0x74,0x43,0x24,	/* 0CD0: $&.rtC$ */
	0xF6,0x28,0xF1,0x73,0x55,0xFA,0x30,0x25,	/* 0CD8: (sU0% */
	0xFA,0xD6,0x22,0x87,0xF1,0xC0,0xAC,0x76,	/* 0CE0: "v */
	0x21,0x54,0xF1,0x41,0x24,0xFB,0x76,0x21,	/* 0CE8: !TA$v! */
	0x54,0x23,0xFB,0x76,0x55,0xF1,0xDB,0x76,	/* 0CF0: T#vUv */
	0x8B,0xF1,0xDD,0x76,0x34,0xDE,0x7D,0x7B,	/* 0CF8: v4}{ */
	0x41,0xF2,0xF4,0x2F,0x4F,0x24,0xF6,0xDC,	/* 0D00: A.O$ */
	0x41,0x79,0x60,0xEF,0x71,0x3E,0x2F,0x4F,	/* 0D08: Ay`q>.O */
	0x24,0xF6,0xD0,0x41,0x7C,0x70,0x24,0xFF,	/* 0D10: $A|p$ */
	0xF0,0xA3,0x7C,0xD8,0x02,0x70,0xD8,0x78,	/* 0D18: |.px */
	0x23,0x25,0xAB,0x70,0x78,0xF4,0xD0,0x78,	/* 0D20: #%pxx */
	0x41,0xF4,0xD8,0x41,0x22,0x40,0x78,0x24,	/* 0D28: AA"@x$ */
	0xFF,0xF0,0xC0,0x23,0x24,0xA3,0x78,0x42,	/* 0D30: #$xB */
	0x21,0xFB,0x28,0xF1,0xF6,0x23,0x22,0x03,	/* 0D38: !(#". */
	0x20,0x23,0x20,0x09,0x20,0x22,0x2E,0x0F,	/* 0D40:  # . ".. */
	0x20,0x22,0x2D,0x05,0x20,0x22,0x2B,0x0B,	/* 0D48:  "-. "+. */
	0x20,0x22,0x2A,0x01,0x20,0x22,0x28,0x07,	/* 0D50:  "*. "(. */
	0x20,0x22,0x26,0x0D,0x20,0x22,0x25,0x03,	/* 0D58:  "&. "%. */
	0x20,0x22,0x23,0x09,0x20,0x22,0x21,0x0F,	/* 0D60:  "#. "!. */
	0x20,0x22,0x20,0x05,0x20,0x21,0x2E,0x0B,	/* 0D68:  " . !.. */
	0x20,0x21,0x2D,0x01,0x20,0x21,0x2B,0x07,	/* 0D70:  !-. !+. */
	0x20,0x21,0x29,0x0D,0x20,0x21,0x28,0x03,	/* 0D78:  !). !(. */
	0x20,0x21,0x26,0x09,0x20,0x21,0x24,0x0F,	/* 0D80:  !&. !$. */
	0x20,0x21,0x23,0x05,0x20,0x21,0x21,0x0B,	/* 0D88:  !#. !!. */
	0x20,0x21,0x20,0x01,0x20,0x2E,0x08,0x20,	/* 0D90:  ! . ..  */
	0x20,0x2C,0x0E,0x20,0x20,0x2B,0x04,0x20,	/* 0D98:  ,.  +.  */
	0x20,0x29,0x0A,0x20,0x20,0x28,0x00,0x20,	/* 0DA0:  ).  (.  */
	0x20,0x26,0x06,0x20,0x20,0x24,0x0C,0x20,	/* 0DA8:  &.  $.  */
	0x20,0x23,0x02,0x20,0x20,0x21,0x08,0x20,	/* 0DB0:  #.  !.  */
	0x20,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0DB8:  q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0DC0: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0DC8: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0DD0: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0DD8: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0DE0: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0DE8: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 0DF0: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 0DF8: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0E00: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0E08: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0E10: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0E18: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0E20: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0E28: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0E30: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0E38: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0E40: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 0E48: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 0E50: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0E58: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0E60: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0E68: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0E70: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0E78: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0E80: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0E88: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0E90: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0E98: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 0EA0: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 0EA8: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0EB0: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0EB8: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0EC0: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0EC8: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0ED0: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0ED8: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0EE0: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0EE8: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0EF0: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 0EF8: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 0F00: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0F08: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0F10: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0F18: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0F20: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0F28: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0F30: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0F38: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0F40: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0F48: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 0F50: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 0F58: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0F60: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0F68: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0F70: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0F78: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0F80: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0F88: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0F90: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0F98: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0FA0: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 0FA8: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 0FB0: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0FB8: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0FC0: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0FC8: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0FD0: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0FD8: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0FE0: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0FE8: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0FF0: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0FF8: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 1000: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 1008: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 1010: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 1018: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 1020: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 1028: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 1030: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 1038: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 1040: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 1048: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 1050: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 1058: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 1060: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 1068: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 1070: +P#{A */
	0xDB,0x7B,0x76,0x55,0x23,0xFB,0x70,0x76,	/* 1078: {vU#pv */
	0x21,0x3F,0xF2,0x76,0x21,0xEF,0x70,0x25,	/* 1080: !?v!p% */
	0xFA,0x60,0x4F,0xF2,0xD0,0xAE,0x71,0x26,	/* 1088: `OЮq& */
	0x32,0x70,0x25,0xFA,0x60,0x4F,0xF2,0xD0,	/* 1090: 2p%`O */
	0xA3,0x20,0x60,0x02,0x7D,0x7B,0x41,0xF2,	/* 1098:  `.}{A */
	0xF4,0x2F,0x4F,0x24,0xF6,0xD0,0x7E,0x48,	/* 10A0: .O$~H */
	0x24,0xF6,0x27,0xAC,0x41,0x7C,0x23,0x4F,	/* 10A8: $'A|#O */
	0x24,0xFF,0xF0,0xC0,0x27,0xA2,0x41,0x24,	/* 10B0: $'A$ */
	0x40,0x70,0x24,0xFF,0xF0,0xC0,0x26,0xA8,	/* 10B8: @p$& */
	0x7E,0x21,0x40,0x24,0xFB,0xDE,0x76,0x21,	/* 10C0: ~!@$v! */
	0x58,0xF1,0x48,0x24,0xF6,0x22,0xAD,0x7E,	/* 10C8: XH$"~ */
	0x22,0x40,0x24,0xF6,0xC0,0x22,0xA5,0x71,	/* 10D0: "@$"q */
	0x35,0x2F,0x4F,0x24,0xF6,0xA8,0x7E,0x2C,	/* 10D8: 5.O$~, */
	0x40,0x24,0xFB,0xDE,0x21,0x06,0x40,0xD0,	/* 10E0: @$!.@ */
	0x21,0x20,0x40,0x76,0x21,0x72,0x21,0x24,	/* 10E8: ! @v!r!$ */
	0x2F,0x95,0x22,0x42,0x71,0xE5,0x7E,0x22,	/* 10F0: ."Bq~" */
	0x40,0x24,0xFB,0xDE,0x76,0x23,0x81,0xF1,	/* 10F8: @$v# */
	0x28,0x40,0x24,0xF6,0xAD,0x40,0xD0,0x21,	/* 1100: (@$@! */
	0x20,0x20,0x40,0x76,0x21,0x72,0x21,0x24,	/* 1108:   @v!r!$ */
	0x2D,0x95,0x76,0x21,0x58,0xF1,0x24,0x40,	/* 1110: -v!X$@ */
	0x24,0xF6,0xAD,0x40,0xD0,0x22,0x20,0x20,	/* 1118: $@"   */
	0x40,0x76,0x21,0x72,0x21,0x24,0x2B,0x9F,	/* 1120: @v!r!$+ */
	0x74,0x23,0x4F,0x24,0xF6,0x71,0x26,0xEB,	/* 1128: t#O$q& */
	0x77,0x71,0x26,0xE8,0x7E,0x76,0xE4,0x21,	/* 1130: wq&~v! */
	0x04,0x70,0x76,0x21,0x3F,0xF2,0x76,0x21,	/* 1138: .pv!?v! */
	0xEF,0x74,0x23,0x4F,0x24,0xF6,0x71,0x26,	/* 1140: t#O$q& */
	0xEB,0x77,0x71,0x26,0xE8,0x75,0x42,0x24,	/* 1148: wq&uB$ */
	0xF6,0x24,0x21,0xAD,0x71,0x26,0x3A,0x2F,	/* 1150: $!q&:. */
	0x4F,0x24,0xF6,0xD4,0x71,0x26,0x38,0x2F,	/* 1158: O$q&8. */
	0x4F,0x24,0xF6,0xD7,0x74,0x43,0x24,0xF6,	/* 1160: O$tC$ */
	0x71,0x26,0xE8,0x72,0x74,0x43,0x24,0xF6,	/* 1168: q&rtC$ */
	0x28,0xF1,0x73,0x55,0xFA,0x30,0x25,0xFA,	/* 1170: (sU0% */
	0xD0,0x22,0x87,0xF1,0xC0,0xAC,0x70,0x21,	/* 1178: "p! */
	0x54,0xF1,0x42,0x24,0xFB,0x70,0x21,0x54,	/* 1180: TB$p!T */
	0x23,0xFB,0x70,0x23,0x85,0xF1,0xAC,0x70,	/* 1188: #p#p */
	0x21,0x72,0x24,0x27,0x9F,0x70,0x34,0xD6,	/* 1190: !r$'p4 */
	0x23,0x2C,0x07,0x70,0x8D,0xF1,0xDE,0x70,	/* 1198: #,.pp */
	0x56,0xF1,0xD8,0x70,0x34,0x25,0xFA,0xD6,	/* 11A0: Vp4% */
	0x21,0x20,0x40,0x24,0xF6,0x21,0xA8,0x76,	/* 11A8: ! @$!v */
	0x61,0x2F,0x4F,0x24,0xF6,0x22,0x20,0x40,	/* 11B0: a.O$" @ */
	0x24,0xFB,0x60,0x4E,0x24,0xF6,0xD6,0x71,	/* 11B8: $`N$q */
	0x36,0x2F,0x49,0x24,0xF6,0x71,0xE6,0x7E,	/* 11C0: 6.I$q~ */
	0x78,0xF4,0x2F,0x4F,0x24,0xF6,0x25,0xFA,	/* 11C8: x.O$% */
	0xDC,0x23,0x28,0xA0,0x70,0x53,0xF1,0x24,	/* 11D0: #(pS$ */
	0x48,0xF4,0xA3,0x4C,0xDB,0x03,0x22,0x40,	/* 11D8: HL."@ */
	0xDB,0x7B,0xDD,0x41,0x7C,0x7D,0x24,0xFF,	/* 11E0: {A|}$ */
	0xF0,0xA3,0x7C,0xDB,0x02,0x7D,0xDB,0x76,	/* 11E8: |.}v */
	0x24,0x20,0x40,0x24,0xF6,0x25,0xA3,0x7B,	/* 11F0: $ @$%{ */
	0x23,0x20,0xA1,0x70,0x23,0x50,0x78,0x2F,	/* 11F8: # p#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x4A,0xF4,0x21,	/* 1200: O$J! */
	0xAD,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 1208: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 1210: q&xA */
	0xF2,0xD8,0x7B,0x60,0x4F,0xF2,0xDB,0x7D,	/* 1218: {`O} */
	0x60,0x4F,0xF2,0xDD,0x21,0x0E,0x41,0x42,	/* 1220: `O!.AB */
	0x7D,0x24,0xFF,0xF0,0x22,0x2C,0xAD,0x4D,	/* 1228: }$",M */
	0x71,0x26,0xE3,0x4A,0x71,0x26,0xE3,0x78,	/* 1230: q&Jq&x */
	0x41,0xF2,0xD8,0x7B,0x60,0x4F,0xF2,0xDB,	/* 1238: A{`O */
	0x7D,0x42,0xF4,0xDD,0x7B,0x22,0x2B,0xA4,	/* 1240: }B{"+ */
	0x64,0x01,0x7B,0x41,0xF4,0xDB,0x41,0x22,	/* 1248: d.{AA" */
	0x40,0x7B,0x24,0xFF,0xF0,0xC0,0x22,0x2A,	/* 1250: @{$"* */
	0xA3,0x7B,0x42,0x21,0xFB,0x28,0xF1,0xF6,	/* 1258: {B!( */
	0x22,0x28,0x08,0x20,0x22,0x27,0x03,0x20,	/* 1260: "(. "'.  */
	0x22,0x25,0x0E,0x20,0x22,0x24,0x09,0x20,	/* 1268: "%. "$.  */
	0x22,0x23,0x04,0x20,0x22,0x21,0x0F,0x20,	/* 1270: "#. "!.  */
	0x22,0x20,0x0A,0x20,0x21,0x2F,0x05,0x20,	/* 1278: " . !..  */
	0x21,0x2E,0x00,0x20,0x21,0x2C,0x0B,0x20,	/* 1280: !.. !,.  */
	0x21,0x2B,0x06,0x20,0x21,0x2A,0x01,0x20,	/* 1288: !+. !*.  */
	0x21,0x28,0x0C,0x20,0x21,0x27,0x07,0x20,	/* 1290: !(. !'.  */
	0x21,0x26,0x02,0x20,0x21,0x24,0x0D,0x20,	/* 1298: !&. !$.  */
	0x21,0x23,0x08,0x20,0x21,0x22,0x03,0x20,	/* 12A0: !#. !".  */
	0x21,0x20,0x0E,0x20,0x2F,0x0A,0x20,0x20,	/* 12A8: ! . ..   */
	0x2E,0x05,0x20,0x20,0x2D,0x00,0x20,0x20,	/* 12B0: ..  -.   */
	0x2B,0x0B,0x20,0x20,0x2A,0x06,0x20,0x20,	/* 12B8: +.  *.   */
	0x29,0x01,0x20,0x20,0x27,0x0C,0x20,0x20,	/* 12C0: ).  '.   */
	0x26,0x07,0x20,0x20,0x25,0x02,0x20,0x20,	/* 12C8: &.  %.   */
	0x23,0x0D,0x20,0x20,0x22,0x08,0x20,0x20,	/* 12D0: #.  ".   */
	0x21,0x03,0x20,0x20,0x70,0x23,0x50,0x78,	/* 12D8: !.  p#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,	/* 12E0: .O$q& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 12E8: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 12F0: x.O$q */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 12F8: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 1300: Px.O$ */
	0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 1308: q&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 1310: #Px.O$ */
	0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 1318: q&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 1320: p#Px.O$ */
	0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,	/* 1328: q&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 1330: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 1338: q&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 1340: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,	/* 1348: $q&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 1350: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 1358: O$q& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 1360: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,	/* 1368: .O$q& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 1370: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 1378: x.O$q */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 1380: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 1388: Px.O$ */
	0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 1390: q&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 1398: #Px.O$ */
	0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 13A0: q&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 13A8: p#Px.O$ */
	0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,	/* 13B0: q&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 13B8: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 13C0: q&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 13C8: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,	/* 13D0: $q&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 13D8: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 13E0: O$q& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 13E8: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,	/* 13F0: .O$q& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 13F8: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 1400: x.O$q */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 1408: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 1410: Px.O$ */
	0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 1418: q&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 1420: #Px.O$ */
	0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 1428: q&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 1430: p#Px.O$ */
	0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,	/* 1438: q&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 1440: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 1448: q&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 1450: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,	/* 1458: $q&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 1460: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 1468: O$q& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 1470: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,	/* 1478: .O$q& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 1480: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 1488: x.O$q */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 1490: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 1498: Px.O$ */
	0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 14A0: q&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 14A8: #Px.O$ */
	0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 14B0: q&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 14B8: p#Px.O$ */
	0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,	/* 14C0: q&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 14C8: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 14D0: q&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 14D8: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,	/* 14E0: $q&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 14E8: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 14F0: O$q& */
	0x78,0x41,0xF2,0xD8,0x7E,0x78,0x2F,0x4F,	/* 14F8: xA~x.O */
	0x24,0xF6,0xF4,0x2F,0x4F,0x24,0xF6,0xDB,	/* 1500: $.O$ */
	0x78,0x2F,0x4F,0x24,0xF6,0x70,0x56,0x23,	/* 1508: x.O$pV# */
	0xFB,0x41,0x7C,0x2C,0x40,0x24,0xFF,0xF0,	/* 1510: A|,@$ */
	0xC0,0xA9,0x41,0x2C,0x41,0x7B,0x24,0xFF,	/* 1518: A,A{$ */
	0xF0,0x22,0xA9,0x41,0x7C,0x24,0x40,0x24,	/* 1520: "A|$@$ */
	0xFF,0xF0,0xC0,0x23,0xA5,0x41,0x24,0x41,	/* 1528: #A$A */
	0x7B,0x24,0xFF,0xF0,0xC0,0x22,0xAB,0x76,	/* 1530: {$"v */
	0x28,0x20,0x40,0x24,0xF6,0x22,0xA3,0x76,	/* 1538: ( @$"v */
	0x68,0x2F,0x4F,0x24,0xF6,0xD6,0x41,0x79,	/* 1540: h.O$Ay */
	0x60,0xEE,0x21,0x06,0x76,0x28,0x20,0x40,	/* 1548: `!.v( @ */
	0x24,0xFB,0xD6,0x0E,0x76,0x60,0x4E,0x24,	/* 1550: $.v`N$ */
	0xF6,0xD6,0x71,0x36,0x2F,0x49,0x24,0xF6,	/* 1558: q6.I$ */
	0x71,0xE6,0x74,0x23,0x4F,0x24,0xF6,0x71,	/* 1560: qt#O$q */
	0x26,0xEA,0x77,0x71,0x26,0xE8,0x76,0x70,	/* 1568: &wq&vp */
	0xE4,0x75,0x44,0x24,0xF6,0x25,0xAE,0x71,	/* 1570: uD$%q */
	0x26,0x39,0x2F,0x4F,0x24,0xF6,0xD4,0x71,	/* 1578: &9.O$q */
	0x26,0x38,0x2F,0x4F,0x24,0xF6,0xD7,0x74,	/* 1580: &8.O$t */
	0x43,0x24,0xF6,0x71,0x26,0xE8,0x72,0x74,	/* 1588: C$q&rt */
	0x43,0x24,0xF6,0x28,0xF1,0x73,0x55,0xFA,	/* 1590: C$(sU */
	0x30,0x25,0xFA,0xD0,0x21,0x72,0x21,0x24,	/* 1598: 0%!r!$ */
	0x9C,0x70,0x21,0x72,0x22,0x2B,0x90,0x70,	/* 15A0: p!r"+p */
	0x22,0x87,0xF1,0xC0,0xAC,0x70,0x21,0x54,	/* 15A8: "p!T */
	0xF1,0x44,0x24,0xFB,0x70,0x21,0x54,0x23,	/* 15B0: D$p!T# */
	0xFB,0x41,0x79,0x60,0xEE,0x70,0x21,0x89,	/* 15B8: Ay`p! */
	0xF1,0x42,0x24,0xFB,0x70,0x21,0x89,0x23,	/* 15C0: B$p!# */
	0xFB,0x74,0x23,0x4F,0x24,0xF6,0x71,0x26,	/* 15C8: t#O$q& */
	0xE9,0x77,0x71,0x26,0xE8,0x73,0x89,0xF1,	/* 15D0: wq&s */
	0x71,0x27,0xEF,0x72,0x41,0xF2,0xD2,0x41,	/* 15D8: q'rAA */
	0x72,0x41,0x24,0xFF,0xF0,0xC0,0x21,0xA2,	/* 15E0: rA$! */
	0x40,0xD2,0x73,0x30,0xAA,0x73,0x30,0x27,	/* 15E8: @s0s0' */
	0x2F,0x2F,0x4F,0x24,0xF6,0xD3,0x03,0x28,	/* 15F0: ..O$.( */
	0x40,0xD3,0x75,0xC0,0xAE,0x73,0x7A,0xF4,	/* 15F8: @usz */
	0xC0,0x6A,0x24,0xAE,0x72,0x7F,0xF4,0xA3,	/* 1600: j$r */
	0x6A,0x24,0x07,0x40,0x27,0x28,0x20,0x40,	/* 1608: j$.@'( @ */
	0xE0,0x6A,0x22,0x05,0x60,0xBE,0x74,0x32,	/* 1610: j".`t2 */
	0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x33,0xD1,	/* 1618: '..O$3 */
	0x74,0x23,0x85,0xF1,0xD0,0x43,0x70,0xF9,	/* 1620: t#Cp */
	0x21,0xA0,0x70,0x2B,0xAD,0x70,0x41,0xF4,	/* 1628: !p+pA */
	0x21,0xAA,0x70,0x42,0xF4,0xC0,0x2B,0xA2,	/* 1630: !pB+ */
	0x23,0x0A,0x70,0x43,0xF4,0x2A,0xAB,0x70,	/* 1638: #.pC*p */
	0x44,0xF4,0x25,0xAA,0x70,0x45,0xF4,0xC0,	/* 1640: D%pE */
	0x2A,0xA0,0x27,0x0A,0x71,0x35,0x2F,0x4F,	/* 1648: *'.q5.O */
	0x24,0xF6,0xC0,0x29,0xA5,0x71,0x39,0x22,	/* 1650: $)q9" */
	0x40,0x24,0xF6,0xC0,0x21,0xA0,0x71,0x39,	/* 1658: @$!q9 */
	0x2F,0x4F,0x24,0xF6,0x22,0x40,0x24,0xFB,	/* 1660: .O$"@$ */
	0x71,0xE9,0x24,0x4E,0x71,0xE5,0x42,0x74,	/* 1668: q$NqBt */
	0x23,0x85,0x23,0xFB,0x71,0x35,0x2F,0x4F,	/* 1670: ##q5.O */
	0x24,0xF6,0xC0,0x26,0xAD,0x40,0x71,0x26,	/* 1678: $&@q& */
	0xE3,0x28,0x41,0x71,0x26,0xE3,0x74,0x34,	/* 1680: (Aq&t4 */
	0x60,0x4E,0x24,0xF6,0x74,0xE4,0x71,0x36,	/* 1688: `N$tq6 */
	0x2F,0x49,0x24,0xF6,0x71,0xE6,0x43,0x74,	/* 1690: .I$qCt */
	0x23,0x85,0x23,0xFB,0x24,0x0C,0x71,0x35,	/* 1698: ##$.q5 */
	0x2F,0x4F,0x24,0xF6,0xC0,0x24,0xA3,0x71,	/* 16A0: .O$$q */
	0x39,0x22,0x40,0x24,0xF6,0xC0,0x21,0xA0,	/* 16A8: 9"@$! */
	0x71,0x39,0x2F,0x4F,0x24,0xF6,0x22,0x40,	/* 16B0: q9.O$"@ */
	0x24,0xFB,0x71,0xE9,0x24,0x4E,0x71,0xE5,	/* 16B8: $q$Nq */
	0x45,0x74,0x23,0x85,0x23,0xFB,0x71,0x35,	/* 16C0: Et##q5 */
	0x2F,0x4F,0x24,0xF6,0xC0,0x21,0xAB,0x40,	/* 16C8: .O$!@ */
	0x71,0x26,0xE3,0x28,0x43,0x71,0x26,0xE3,	/* 16D0: q&(Cq& */
	0x71,0x39,0x2D,0x4F,0x24,0xF6,0x71,0xE9,	/* 16D8: q9-O$q */
	0x24,0x4E,0x71,0xE5,0x40,0x74,0x23,0x85,	/* 16E0: $Nq@t# */
	0x23,0xFB,0xB2,0x22,0xF0,0x60,0xBF,0x73,	/* 16E8: #"`s */
	0x31,0x25,0xFA,0xD0,0x35,0x2F,0x4F,0x24,	/* 16F0: 1%5.O$ */
	0xF6,0x21,0xA0,0x73,0x22,0x50,0xF1,0x21,	/* 16F8: !s"P! */
	0x40,0x24,0xFB,0x73,0x22,0x50,0x23,0xFB,	/* 1700: @$s"P# */
	0xB1,0x22,0xF0,0x73,0x22,0x50,0xF1,0x61,	/* 1708: "s"Pa */
	0x4F,0x24,0xF6,0x73,0x22,0x50,0x23,0xFB,	/* 1710: O$s"P# */
	0x73,0x21,0x58,0xF1,0x21,0x40,0x24,0xF6,	/* 1718: s!X!@$ */
	0x24,0xA4,0x70,0x26,0x3C,0x21,0x40,0x24,	/* 1720: $p&<!@$ */
	0xF6,0x21,0xAD,0x73,0x22,0x50,0xF1,0x41,	/* 1728: !s"PA */
	0x24,0xF6,0x24,0xAC,0x21,0x48,0x70,0xE5,	/* 1730: $$!Hp */
	0x73,0x22,0x50,0xF1,0x60,0x4E,0x24,0xF6,	/* 1738: s"P`N$ */
	0x73,0x22,0x50,0x23,0xFB,0xB1,0x22,0xF0,	/* 1740: s"P#" */
	0x73,0x22,0x50,0xF1,0x41,0x24,0xF6,0x23,	/* 1748: s"PA$# */
	0xF2,0x22,0xAD,0x21,0x44,0x70,0xE5,0x73,	/* 1750: "!Dps */
	0x22,0x50,0xF1,0x41,0x24,0xFB,0x73,0x22,	/* 1758: "PA$s" */
	0x50,0x23,0xFB,0xB1,0x22,0xF0,0x73,0x22,	/* 1760: P#"s" */
	0x50,0xF1,0x41,0x24,0xF6,0x21,0xA1,0x21,	/* 1768: PA$!! */
	0x48,0x70,0xE5,0x73,0x22,0x50,0xF1,0x60,	/* 1770: Hps"P` */
	0x4E,0x24,0xF6,0x73,0x22,0x50,0x23,0xFB,	/* 1778: N$s"P# */
	0xB1,0x22,0xF0,0x60,0xBF,0x41,0x73,0x26,	/* 1780: "`As& */
	0xE6,0x43,0x73,0x26,0xE8,0x40,0x73,0x27,	/* 1788: Cs&@s' */
	0xE4,0x42,0x73,0x26,0xE8,0x40,0x73,0x27,	/* 1790: Bs&@s' */
	0xE4,0x41,0x73,0x26,0xE8,0x40,0x73,0x27,	/* 1798: As&@s' */
	0xE4,0x40,0x73,0x26,0xE8,0x40,0x73,0x27,	/* 17A0: @s&@s' */
	0xE4,0x43,0x73,0x26,0xE8,0x40,0x73,0x27,	/* 17A8: Cs&@s' */
	0xEA,0x42,0x73,0x26,0xE8,0x40,0x73,0x27,	/* 17B0: Bs&@s' */
	0xEA,0x41,0x73,0x26,0xE8,0x40,0x73,0x27,	/* 17B8: As&@s' */
	0xEA,0x40,0x73,0x26,0xE8,0x40,0x73,0x27,	/* 17C0: @s&@s' */
	0xEA,0x44,0x73,0x26,0xE8,0x2A,0x48,0x73,	/* 17C8: Ds&*Hs */
	0x26,0xED,0x40,0x73,0x26,0xEE,0x40,0x73,	/* 17D0: &@s&@s */
	0x26,0xEF,0x41,0x73,0x26,0xEC,0x43,0x73,	/* 17D8: &As&Cs */
	0x26,0xE6,0x43,0x73,0x26,0xE6,0x43,0x73,	/* 17E0: &Cs&Cs */
	0x26,0xE6,0x44,0x73,0x26,0xE8,0x2A,0x48,	/* 17E8: &Ds&*H */
	0x73,0x26,0xED,0x22,0x40,0x73,0x26,0xEE,	/* 17F0: s&"@s& */
	0x40,0x73,0x26,0xEF,0x43,0x73,0x26,0xE6,	/* 17F8: @s&Cs& */
	0x43,0x73,0x26,0xE6,0x43,0x73,0x26,0xE6,	/* 1800: Cs&Cs& */
	0x40,0x73,0x26,0xEC,0x40,0xD0,0x43,0x73,	/* 1808: @s&@Cs */
	0x26,0xE6,0x70,0x81,0xD0,0x21,0x40,0x70,	/* 1810: &p!@p */
	0xF9,0xA2,0x60,0x02,0x44,0x73,0x26,0xE8,	/* 1818: `.Ds& */
	0x40,0x73,0x26,0xED,0x22,0x40,0x73,0x26,	/* 1820: @s&"@s& */
	0xEE,0x43,0x73,0x26,0xEF,0x41,0x73,0x26,	/* 1828: Cs&As& */
	0xEC,0x43,0x73,0x26,0xE6,0x43,0x73,0x26,	/* 1830: Cs&Cs& */
	0xE6,0x43,0x73,0x26,0xE6,0x43,0x73,0x26,	/* 1838: Cs&Cs& */
	0xE6,0x40,0x73,0x26,0xEC,0x40,0x73,0x26,	/* 1840: @s&@s& */
	0xE6,0x40,0x73,0x26,0xE8,0x26,0x44,0x72,	/* 1848: @s&&Dr */
	0x22,0x27,0x2A,0x96,0xB1,0x22,0xF0,0x60,	/* 1850: "'*"` */
	0xBE,0x40,0xD0,0x74,0x31,0xD1,0x74,0x87,	/* 1858: @t1t */
	0xF1,0x74,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 1860: t2'..O$ */
	0xF6,0x89,0x23,0xFB,0x74,0x87,0xF1,0x71,	/* 1868: #tq */
	0x27,0xEF,0x74,0x87,0xF1,0x43,0x24,0xF6,	/* 1870: 'tC$ */
	0x71,0x26,0xE8,0x71,0x26,0x3C,0x2F,0x4F,	/* 1878: q&q&<.O */
	0x24,0xF6,0x74,0x21,0x53,0xF1,0x24,0xF6,	/* 1880: $t!S$ */
	0x25,0xFA,0xD1,0x28,0x40,0x24,0xF6,0xA5,	/* 1888: %(@$ */
	0x70,0x44,0x24,0xFB,0xD0,0x71,0x22,0x40,	/* 1890: pD$q"@ */
	0x24,0xF6,0xA6,0x70,0x24,0x40,0x24,0xFB,	/* 1898: $p$@$ */
	0xD0,0x71,0x21,0x40,0x24,0xF6,0xA6,0x70,	/* 18A0: q!@$p */
	0x22,0x40,0x24,0xFB,0xD0,0x71,0x24,0x40,	/* 18A8: "@$q$@ */
	0x24,0xF6,0xA5,0x70,0x42,0x24,0xFB,0xD0,	/* 18B0: $pB$ */
	0x70,0x74,0x5C,0x23,0xFB,0xB2,0x22,0xF0,	/* 18B8: pt\#" */
	0x60,0xBD,0x40,0xD1,0x71,0x44,0xF8,0x75,	/* 18C0: `@qDu */
	0x27,0xEF,0x71,0x74,0x61,0x2B,0x94,0x71,	/* 18C8: 'qta+q */
	0xAF,0x75,0x27,0x3F,0x2F,0x4F,0x24,0xF6,	/* 18D0: u'?.O$ */
	0x44,0x24,0xF0,0xD2,0x75,0x27,0x3F,0x0A,	/* 18D8: D$u'?. */
	0x75,0x27,0x3F,0x47,0x24,0xF6,0xD2,0x75,	/* 18E0: u'?G$u */
	0x27,0x3F,0x72,0x45,0xF4,0xA5,0x40,0x75,	/* 18E8: '?rE@u */
	0x24,0xEB,0x05,0x28,0x40,0x75,0x24,0xEB,	/* 18F0: $.(@u$ */
	0x2C,0x43,0x75,0x27,0xEE,0x40,0xD0,0x70,	/* 18F8: ,Cu'@p */
	0x75,0x26,0xE8,0x70,0xC0,0x22,0xA0,0x72,	/* 1900: u&p"r */
	0x45,0xF4,0xC0,0x21,0xAA,0x40,0x75,0x27,	/* 1908: E!@u' */
	0xE6,0x24,0x44,0x75,0x24,0x30,0x2F,0x4F,	/* 1910: $Du$0.O */
	0x24,0xF6,0xF9,0xA6,0x24,0x42,0x75,0x27,	/* 1918: $$Bu' */
	0xE2,0x05,0x21,0x4F,0x75,0x27,0xE2,0x70,	/* 1920: .!Ou'p */
	0x81,0xD0,0x44,0x70,0xF9,0xA3,0x20,0x63,	/* 1928: Dp c */
	0x0E,0x40,0x75,0x21,0xE8,0x40,0x75,0x26,	/* 1930: .@u!@u& */
	0xEC,0x40,0x75,0x26,0xED,0x75,0x35,0x2F,	/* 1938: @u&u5. */
	0x4F,0x24,0xF6,0xAA,0x75,0x35,0x2F,0x4F,	/* 1940: O$u5.O */
	0x24,0xF6,0xA3,0x20,0x60,0x06,0x71,0x81,	/* 1948: $ `.q */
	0xD1,0x42,0x71,0xF9,0xA2,0x69,0x0D,0xB3,	/* 1950: Bqi. */
	0x22,0xF0,0x60,0xBB,0x76,0x21,0x53,0xD4,	/* 1958: "`v!S */
	0x21,0x28,0x40,0xD1,0x41,0x27,0x28,0x28,	/* 1960: !(@A'(( */
	0x40,0xE0,0x74,0x60,0x39,0x87,0xF1,0x81,	/* 1968: @t`9 */
	0x74,0x60,0x39,0x87,0x23,0xFB,0x41,0x27,	/* 1970: t`9#A' */
	0x28,0x28,0x40,0xE0,0x71,0x21,0x37,0xD1,	/* 1978: ((@q!7 */
	0x40,0x27,0x28,0x28,0x40,0xE0,0x71,0x57,	/* 1980: @'((@qW */
	0xF1,0x25,0xFA,0xD0,0xAC,0x70,0x74,0xFA,	/* 1988: %Ьpt */
	0x30,0xD2,0x71,0x76,0x2F,0x24,0x99,0x62,	/* 1990: 0qv.$b */
	0xA1,0x71,0x31,0xD3,0x71,0x34,0xD2,0x70,	/* 1998: q1q4p */
	0xC0,0x24,0xA7,0x72,0x41,0x24,0xF6,0xC0,	/* 19A0: $rA$ */
	0x24,0xA0,0x71,0x8D,0xF1,0x71,0x56,0xF1,	/* 19A8: $qqV */
	0xF4,0x23,0xA7,0x72,0x41,0x24,0xFB,0x25,	/* 19B0: #rA$% */
	0xFA,0xD2,0x71,0xE4,0x71,0x87,0xF1,0x71,	/* 19B8: qqq */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 19C0: 2'..O$ */
	0x23,0xFB,0x71,0x87,0xF1,0x73,0x27,0xEF,	/* 19C8: #qs' */
	0x71,0x87,0xF1,0x43,0x24,0xF6,0x73,0x26,	/* 19D0: qC$s& */
	0xE8,0x73,0x36,0x2F,0x4F,0x24,0xF6,0x44,	/* 19D8: s6.O$D */
	0x24,0xFB,0x73,0xE6,0x41,0x71,0x22,0x89,	/* 19E0: $sAq" */
	0x23,0xFB,0x72,0x21,0x40,0x24,0xF6,0x2D,	/* 19E8: #r!@$- */
	0xA8,0x72,0x28,0x40,0x24,0xF6,0x24,0xA0,	/* 19F0: r(@$$ */
	0x71,0x87,0xF1,0x71,0x32,0x27,0x2F,0x2F,	/* 19F8: qq2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x71,0x87,	/* 1A00: O$#q */
	0xF1,0x73,0x27,0xEF,0x71,0x87,0xF1,0x43,	/* 1A08: s'qC */
	0x24,0xF6,0x73,0x26,0xE8,0x73,0x35,0x2F,	/* 1A10: $s&s5. */
	0x4F,0x24,0xF6,0xC0,0x2A,0xA8,0x40,0xD0,	/* 1A18: O$*@ */
	0x21,0x20,0x40,0x71,0x76,0x2B,0x2B,0x9F,	/* 1A20: ! @qv++ */
	0x22,0x42,0x73,0xE5,0x72,0x22,0x40,0x24,	/* 1A28: "Bsr"@$ */
	0xFB,0x6C,0x4F,0x24,0xF6,0xD2,0x28,0x0E,	/* 1A30: lO$(. */
	0x41,0x71,0x55,0xF1,0x71,0x8B,0xF1,0xFC,	/* 1A38: AqUq */
	0x2F,0x4F,0x24,0xF6,0x24,0x40,0xF0,0x24,	/* 1A40: .O$$@$ */
	0xFF,0xF0,0xC0,0x27,0xA9,0x71,0x87,0xF1,	/* 1A48: 'q */
	0x71,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 1A50: q2'..O$ */
	0x89,0x23,0xFB,0x71,0x87,0xF1,0x73,0x27,	/* 1A58: #qs' */
	0xEF,0x71,0x87,0xF1,0x43,0x24,0xF6,0x73,	/* 1A60: qC$s */
	0x26,0xE8,0x73,0x35,0x2F,0x4F,0x24,0xF6,	/* 1A68: &s5.O$ */
	0xC0,0x25,0xA3,0x71,0x21,0x58,0xF1,0x48,	/* 1A70: %q!XH */
	0x24,0xF6,0x21,0xA6,0x21,0x20,0x40,0xD0,	/* 1A78: $!! @ */
	0x21,0x20,0x40,0x71,0x76,0x2B,0x25,0x9F,	/* 1A80: ! @qv+% */
	0x22,0x41,0x73,0xE5,0x72,0x66,0x4F,0x24,	/* 1A88: "AsrfO$ */
	0xF6,0xD2,0x71,0x23,0x81,0xF1,0x28,0x40,	/* 1A90: q#(@ */
	0x24,0xF6,0xAE,0x21,0x20,0x20,0x40,0xD0,	/* 1A98: $!  @ */
	0x21,0x20,0x20,0x40,0x71,0x76,0x2B,0x23,	/* 1AA0: !  @qv+# */
	0x9E,0x71,0x21,0x58,0xF1,0x24,0x40,0x24,	/* 1AA8: q!X$@$ */
	0xF6,0xAE,0x22,0x20,0x20,0x40,0xD0,0x22,	/* 1AB0: "  @" */
	0x20,0x20,0x40,0x71,0x76,0x2B,0x22,0x97,	/* 1AB8:   @qv+" */
	0x72,0x61,0x4F,0x24,0xF6,0xD2,0x72,0x71,	/* 1AC0: raO$rq */
	0xE4,0x71,0x22,0x50,0xF1,0x21,0x40,0x24,	/* 1AC8: q"P!@$ */
	0xF6,0x22,0xA2,0x71,0x87,0xF1,0x71,0x32,	/* 1AD0: "qq2 */
	0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,	/* 1AD8: '..O$# */
	0xFB,0x71,0x87,0xF1,0x73,0x27,0xEF,0x71,	/* 1AE0: qs'q */
	0x87,0xF1,0x43,0x24,0xF6,0x73,0x26,0xE8,	/* 1AE8: C$s& */
	0x71,0x76,0x64,0x2F,0x98,0x61,0x27,0x02,	/* 1AF0: qvd.a'. */
	0x60,0xBB,0x77,0x31,0xD1,0x77,0x34,0xD2,	/* 1AF8: `w1w4 */
	0x77,0x87,0xF1,0x77,0x32,0x27,0x2F,0x2F,	/* 1B00: ww2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x77,0x87,	/* 1B08: O$#w */
	0xF1,0x71,0x27,0xEF,0x77,0x87,0xF1,0x43,	/* 1B10: q'wC */
	0x24,0xF6,0x71,0x26,0xE8,0x77,0x21,0x8F,	/* 1B18: $q&w! */
	0xF1,0x23,0xA4,0x77,0x32,0x27,0x2F,0x2F,	/* 1B20: #w2'.. */
	0x4F,0x24,0xF6,0xD0,0x77,0x87,0xF1,0x43,	/* 1B28: O$wC */
	0xF9,0x21,0xA0,0x70,0x21,0x8D,0xF1,0x81,	/* 1B30: !p! */
	0x70,0x21,0x8D,0x23,0xFB,0x22,0x44,0x71,	/* 1B38: p!#"Dq */
	0x27,0xEF,0x0C,0x70,0x5E,0xF1,0x81,0x70,	/* 1B40: '.p^p */
	0x5E,0x23,0xFB,0x48,0x71,0x27,0xEF,0x40,	/* 1B48: ^#Hq'@ */
	0x77,0x21,0x8F,0x23,0xFB,0x24,0x09,0x77,	/* 1B50: w!#$.w */
	0x21,0x58,0xF1,0x42,0x24,0xF6,0xA8,0x71,	/* 1B58: !XB$q */
	0x3B,0x44,0x24,0xF6,0xC0,0x23,0xA2,0x77,	/* 1B60: ;D$#w */
	0x21,0x59,0xF1,0x21,0x40,0x24,0xF6,0xA9,	/* 1B68: !Y!@$ */
	0x71,0x26,0x3C,0x24,0x40,0x24,0xF6,0x22,	/* 1B70: q&<$@$" */
	0xA0,0x77,0x21,0x58,0xF1,0x21,0x40,0x24,	/* 1B78: w!X!@$ */
	0xF6,0xA8,0x71,0x26,0x3C,0x21,0x40,0x24,	/* 1B80: q&<!@$ */
	0xF6,0xAF,0x72,0x22,0x20,0x40,0x24,0xF6,	/* 1B88: r" @$ */
	0xC0,0xA7,0x20,0x77,0x22,0x85,0xF1,0x21,	/* 1B90:  w"! */
	0xA3,0x72,0x62,0x2F,0x4F,0x24,0xF6,0xD2,	/* 1B98: rb.O$ */
	0x71,0x35,0x2F,0x4F,0x24,0xF6,0x22,0xA3,	/* 1BA0: q5.O$" */
	0x40,0xB5,0x22,0xF0,0x72,0x21,0x20,0x40,	/* 1BA8: @"r! @ */
	0x24,0xFB,0x41,0x24,0xFB,0x77,0xE4,0x77,	/* 1BB0: $A$ww */
	0x22,0x87,0xF1,0xA7,0x20,0x28,0x44,0x71,	/* 1BB8: " (Dq */
	0xE6,0x05,0x20,0x29,0x42,0x71,0xE6,0x41,	/* 1BC0: . )BqA */
	0xB5,0x22,0xF0,0x77,0x22,0x85,0xF1,0x21,	/* 1BC8: "w"! */
	0xA6,0x77,0x22,0x87,0xF1,0x24,0x27,0xA8,	/* 1BD0: w"$' */
	0x40,0x71,0x21,0xE5,0x40,0x71,0x21,0xE6,	/* 1BD8: @q!@q! */
	0x21,0x48,0x71,0xE5,0x24,0x26,0x0D,0x41,	/* 1BE0: !Hq$&.A */
	0x77,0x22,0x85,0x23,0xFB,0x77,0x22,0x87,	/* 1BE8: w"#w" */
	0xF1,0x22,0xA4,0x71,0x24,0x30,0x2F,0x4F,	/* 1BF0: "q$0.O */
	0x24,0xF6,0x24,0x42,0xF4,0xA6,0x21,0x4F,	/* 1BF8: $$B!O */
	0x71,0x27,0xE2,0x09,0x40,0x71,0x27,0xE6,	/* 1C00: q'.@q' */
	0x24,0x42,0x71,0x27,0xE2,0x22,0x40,0x77,	/* 1C08: $Bq'"@w */
	0x21,0x55,0x23,0xFB,0x22,0x24,0x02,0x71,	/* 1C10: !U#"$.q */
	0x24,0x30,0x2F,0x4F,0x24,0xF6,0x24,0x42,	/* 1C18: $0.O$$B */
	0xF4,0xA7,0x2C,0x2F,0x44,0x21,0xFB,0xD3,	/* 1C20: ,.D! */
	0x06,0x2C,0x2B,0x45,0x21,0xFB,0xD3,0x77,	/* 1C28: .,+E!w */
	0x5B,0xF1,0x4F,0x24,0xF6,0xD0,0x77,0x53,	/* 1C30: [O$wS */
	0xF1,0x24,0x48,0xF4,0xC0,0xAA,0x70,0x4F,	/* 1C38: $HpO */
	0xF4,0xC0,0xA5,0x77,0x23,0x83,0xF1,0xD0,	/* 1C40: w# */
	0x77,0x53,0xF1,0x24,0x48,0xF4,0xC0,0xA9,	/* 1C48: wS$H */
	0x41,0x21,0x4E,0x70,0x24,0xFF,0xF0,0xC0,	/* 1C50: A!Np$ */
	0xAF,0x77,0x53,0xF1,0x24,0x48,0xF4,0xAD,	/* 1C58: wS$H */
	0x41,0x70,0x4D,0x24,0xFF,0xF0,0xC0,0xA5,	/* 1C60: ApM$ */
	0x77,0x21,0x5B,0xF1,0xD0,0x21,0x41,0x70,	/* 1C68: w![!Ap */
	0xF9,0x21,0xA0,0x70,0x22,0xAB,0x70,0x43,	/* 1C70: !p"pC */
	0xF4,0x22,0xA6,0x70,0x44,0xF4,0xC0,0x22,	/* 1C78: "pD" */
	0xA7,0x21,0x0E,0x21,0x43,0x70,0xF9,0xAE,	/* 1C80: !.!Cp */
	0x70,0x21,0x41,0xF4,0x21,0xA3,0x70,0x21,	/* 1C88: p!A!p! */
	0x42,0xF4,0xC0,0x21,0xA3,0x0B,0x70,0x21,	/* 1C90: B!.p! */
	0x43,0xF4,0xA6,0x70,0x21,0x44,0xF4,0xC0,	/* 1C98: Cp!D */
	0xA7,0x4C,0x77,0x21,0x55,0x23,0xFB,0x07,	/* 1CA0: Lw!U#. */
	0x22,0x40,0x77,0x21,0x55,0x23,0xFB,0x70,	/* 1CA8: "@w!U#p */
	0x73,0x28,0xF1,0x30,0x71,0x27,0xE2,0x70,	/* 1CB0: s(0q'p */
	0x73,0x28,0xF1,0x31,0x71,0x27,0xE6,0x77,	/* 1CB8: s(1q'w */
	0x22,0x8D,0xF1,0x2F,0x40,0x24,0xF6,0x77,	/* 1CC0: ".@$w */
	0x5B,0xF1,0x4F,0x24,0xF6,0x24,0xFB,0x77,	/* 1CC8: [O$$w */
	0x22,0x8D,0x23,0xFB,0x77,0x23,0x83,0xF1,	/* 1CD0: "#w# */
	0x77,0x21,0x5B,0x23,0xFB,0x77,0x5B,0xF1,	/* 1CD8: w![#w[ */
	0x44,0x24,0xF0,0xD0,0x77,0x53,0xF1,0x24,	/* 1CE0: D$wS$ */
	0x48,0xF4,0xC0,0xAB,0x70,0x4F,0xF4,0xC0,	/* 1CE8: HpO */
	0xA6,0x20,0x77,0x21,0x5A,0xF1,0xD0,0x77,	/* 1CF0:  w!Zw */
	0x53,0xF1,0x24,0x48,0xF4,0xC0,0xAA,0x41,	/* 1CF8: S$HA */
	0x21,0x4E,0x70,0x24,0xFF,0xF0,0xC0,0x21,	/* 1D00: !Np$! */
	0xA0,0x77,0x53,0xF1,0x24,0x48,0xF4,0xAE,	/* 1D08: wS$H */
	0x41,0x70,0x4D,0x24,0xFF,0xF0,0xC0,0xA6,	/* 1D10: ApM$ */
	0x20,0x77,0x23,0x87,0xF1,0xD0,0x70,0x73,	/* 1D18:  w#ps */
	0x28,0xF1,0x30,0x71,0x27,0xE8,0x70,0x73,	/* 1D20: (0q'ps */
	0x28,0xF1,0x31,0x71,0x27,0xEC,0x77,0x22,	/* 1D28: (1q'w" */
	0x8D,0xF1,0x4F,0x24,0xF6,0x77,0x5B,0xF1,	/* 1D30: O$w[ */
	0x2F,0x40,0x24,0xF6,0x24,0xFB,0x77,0x22,	/* 1D38: .@$$w" */
	0x8D,0x23,0xFB,0x77,0x21,0x5A,0xF1,0x77,	/* 1D40: #w!Zw */
	0x23,0x87,0x23,0xFB,0x40,0x77,0x21,0xEC,	/* 1D48: ##@w! */
	0x40,0x77,0x21,0xED,0x40,0x77,0x21,0xEE,	/* 1D50: @w!@w! */
	0x40,0x77,0x21,0xEF,0x77,0x21,0x8D,0xF1,	/* 1D58: @w!w! */
	0x71,0x21,0xEA,0x77,0x5F,0xF1,0x71,0x21,	/* 1D60: q!w_q! */
	0xEB,0x77,0x21,0x8B,0xF1,0x71,0x21,0xEC,	/* 1D68: w!q! */
	0x77,0x5E,0xF1,0x71,0x21,0xED,0x40,0x77,	/* 1D70: w^q!@w */
	0x21,0x89,0x23,0xFB,0x77,0x5A,0xF1,0x25,	/* 1D78: !#wZ% */
	0xFA,0xD0,0x77,0x23,0x81,0x23,0xFB,0x70,	/* 1D80: w##p */
	0x43,0x24,0xF6,0xD3,0x70,0x21,0x40,0x24,	/* 1D88: C$p!@$ */
	0xF6,0xC0,0x22,0xA0,0x70,0x48,0x24,0xF6,	/* 1D90: "pH$ */
	0xA9,0x20,0x73,0x22,0x40,0x24,0xFB,0xD3,	/* 1D98:  s"@$ */
	0x07,0x20,0x73,0x24,0x40,0x24,0xFB,0xD3,	/* 1DA0: . s$@$ */
	0x70,0x44,0x24,0xF6,0xA7,0x20,0x73,0x28,	/* 1DA8: pD$ s( */
	0x40,0x24,0xFB,0xD3,0x77,0x5D,0xF1,0x28,	/* 1DB0: @$w]( */
	0x40,0x24,0xF6,0xA3,0x20,0x07,0x20,0x73,	/* 1DB8: @$ . s */
	0x21,0x40,0x24,0xFB,0xD3,0x77,0x21,0x85,	/* 1DC0: !@$w! */
	0xF1,0x25,0xFA,0xD0,0x77,0x21,0x59,0x23,	/* 1DC8: %w!Y# */
	0xFB,0x70,0x4F,0x24,0xF6,0x4F,0xF4,0xA3,	/* 1DD0: pO$O */
	0x20,0x06,0x20,0x73,0x48,0x24,0xFB,0xD3,	/* 1DD8:  . sH$ */
	0x73,0x71,0xE8,0x40,0xD3,0x70,0x28,0x40,	/* 1DE0: sq@p(@ */
	0x24,0xF6,0xA7,0x20,0x73,0x21,0x40,0x24,	/* 1DE8: $ s!@$ */
	0xFB,0xD3,0x73,0x71,0xE9,0x77,0x53,0xF1,	/* 1DF0: sqwS */
	0x24,0x48,0xF4,0xA6,0x20,0x48,0x71,0xEA,	/* 1DF8: $H Hq */
	0x05,0x20,0x28,0x44,0x71,0xEA,0x77,0x21,	/* 1E00: . (Dqw! */
	0x50,0xF1,0x25,0xFA,0xD0,0x77,0x22,0x81,	/* 1E08: P%w" */
	0x23,0xFB,0x77,0x5D,0xF1,0x77,0x21,0x58,	/* 1E10: #w]w!X */
	0x23,0xFB,0x70,0x28,0x40,0x24,0xF6,0xA5,	/* 1E18: #p(@$ */
	0x20,0x40,0xD3,0x21,0x06,0x70,0x48,0x24,	/* 1E20:  @!.pH$ */
	0xF6,0xA5,0x20,0x42,0xD3,0x0D,0x20,0x70,	/* 1E28:  B. p */
	0x44,0x24,0xF6,0xA5,0x20,0x44,0xD3,0x03,	/* 1E30: D$ D. */
	0x20,0x43,0xD3,0x70,0x41,0x24,0xF6,0xA9,	/* 1E38:  CpA$ */
	0x20,0x73,0x21,0x48,0x24,0xFB,0xD3,0x0D,	/* 1E40:  s!H$. */
	0x20,0x70,0x42,0x24,0xF6,0xC0,0xA6,0x20,	/* 1E48:  pB$  */
	0x73,0x48,0x24,0xFB,0xD3,0x73,0x71,0x21,	/* 1E50: sH$sq! */
	0xEE,0x40,0xD3,0x77,0x5D,0xF1,0x44,0x24,	/* 1E58: @w]D$ */
	0xF6,0x22,0xA9,0x77,0x22,0x87,0xF1,0xAD,	/* 1E60: "w" */
	0x20,0x71,0x24,0x30,0x2F,0x4F,0x24,0xF6,	/* 1E68:  q$0.O$ */
	0x24,0x42,0xF4,0xAF,0x20,0x72,0x64,0x2F,	/* 1E70: $B rd. */
	0x4F,0x24,0xF6,0xD2,0x73,0x42,0x24,0xFB,	/* 1E78: O$sB$ */
	0xD3,0x21,0x00,0x72,0x24,0x20,0x40,0x24,	/* 1E80: !.r$ @$ */
	0xFB,0xD2,0x08,0x20,0x72,0x64,0x2F,0x4F,	/* 1E88: . rd.O */
	0x24,0xF6,0xD2,0x77,0x21,0x51,0xF1,0x2F,	/* 1E90: $w!Q. */
	0x4F,0xF4,0xAE,0x20,0x77,0x22,0x87,0xF1,	/* 1E98: O w" */
	0xC0,0xA7,0x20,0x73,0x28,0x40,0x24,0xFB,	/* 1EA0:  s(@$ */
	0xD3,0x73,0x71,0x21,0xEF,0x77,0x22,0x87,	/* 1EA8: sq!w" */
	0xF1,0x22,0xA7,0x77,0x22,0x87,0xF1,0x21,	/* 1EB0: "w"! */
	0x28,0xA7,0x71,0x24,0x30,0x2F,0x4F,0x24,	/* 1EB8: (q$0.O$ */
	0xF6,0x24,0x42,0xF4,0x21,0x27,0xAA,0x77,	/* 1EC0: $B!'w */
	0x5D,0xF1,0x44,0x24,0xF6,0x21,0x27,0xA1,	/* 1EC8: ]D$!' */
	0x72,0x24,0x20,0x40,0x24,0xFB,0xD2,0x21,	/* 1ED0: r$ @$! */
	0x26,0x07,0x40,0xD4,0x40,0xD3,0x40,0xD0,	/* 1ED8: &.@@@ */
	0x77,0x5D,0xF1,0x48,0x24,0xF6,0xA7,0x70,	/* 1EE0: w]H$p */
	0x21,0x20,0x40,0x24,0xFB,0xD0,0x77,0x5A,	/* 1EE8: ! @$wZ */
	0xF1,0x28,0x40,0x24,0xF6,0xAA,0x70,0x21,	/* 1EF0: (@$p! */
	0x20,0x20,0x40,0x24,0xFB,0xD0,0x21,0x08,	/* 1EF8:   @$!. */
	0x73,0x21,0x20,0x20,0x40,0x24,0xFB,0xD3,	/* 1F00: s!  @$ */
	0x77,0x21,0x87,0xF1,0x41,0x24,0xF6,0xA8,	/* 1F08: w!A$ */
	0x74,0x21,0x20,0x20,0x40,0x24,0xFB,0xD4,	/* 1F10: t!  @$ */
	0x77,0x5D,0xF1,0x24,0x40,0x24,0xF6,0xAA,	/* 1F18: w]$@$ */
	0x70,0x22,0x20,0x20,0x40,0x24,0xFB,0xD0,	/* 1F20: p"  @$ */
	0x21,0x08,0x73,0x22,0x20,0x20,0x40,0x24,	/* 1F28: !.s"  @$ */
	0xFB,0xD3,0x77,0x21,0x87,0xF1,0x42,0x24,	/* 1F30: w!B$ */
	0xF6,0xA8,0x74,0x22,0x20,0x20,0x40,0x24,	/* 1F38: t"  @$ */
	0xFB,0xD4,0x77,0x5D,0xF1,0x42,0x24,0xF6,	/* 1F40: w]B$ */
	0x21,0xA2,0x77,0x5D,0xF1,0x41,0x24,0xF6,	/* 1F48: !w]A$ */
	0xA6,0x70,0x42,0x24,0xFB,0xD0,0x05,0x70,	/* 1F50: pB$.p */
	0x41,0x24,0xFB,0xD0,0x77,0x21,0x85,0xF1,	/* 1F58: A$w! */
	0x21,0x40,0x24,0xF6,0xA6,0x70,0x21,0x40,	/* 1F60: !@$p!@ */
	0x24,0xFB,0xD0,0x77,0x5D,0xF1,0x21,0x40,	/* 1F68: $w]!@ */
	0x24,0xF6,0xA6,0x70,0x22,0x40,0x24,0xFB,	/* 1F70: $p"@$ */
	0xD0,0x23,0x21,0x23,0x43,0x77,0x76,0x26,	/* 1F78: #!#Cwv& */
	0x26,0x95,0x74,0xD0,0x73,0x77,0x76,0x28,	/* 1F80: &tswv( */
	0x2B,0x9A,0x77,0x5D,0xF1,0x22,0x40,0x24,	/* 1F88: +w]"@$ */
	0xF6,0x23,0xA4,0x77,0x76,0x67,0x2B,0x9F,	/* 1F90: #wvg+ */
	0x77,0x21,0x85,0xF1,0x21,0x40,0x24,0xF6,	/* 1F98: w!!@$ */
	0xA4,0x2B,0x40,0xD0,0x03,0x2F,0x40,0xD0,	/* 1FA0: +@..@ */
	0x77,0x21,0x53,0xF1,0x70,0x24,0xF6,0x25,	/* 1FA8: w!Sp$% */
	0xFA,0xD0,0x71,0x21,0xE6,0x71,0x21,0x35,	/* 1FB0: q!q!5 */
	0x4F,0x24,0xF6,0x70,0x60,0x40,0x24,0xF6,	/* 1FB8: O$p`@$ */
	0x24,0xFB,0x71,0x21,0xE5,0x21,0x03,0x22,	/* 1FC0: $q!!." */
	0x44,0x77,0x5C,0x23,0xFB,0x40,0x71,0x21,	/* 1FC8: Dw\#@q! */
	0xE6,0x71,0x21,0x35,0x4F,0x24,0xF6,0x71,	/* 1FD0: q!5O$q */
	0x21,0xE5,0x72,0x60,0x44,0x24,0xF6,0xD2,	/* 1FD8: !r`D$ */
	0x77,0x5D,0xF1,0x42,0x24,0xF6,0xA5,0x72,	/* 1FE0: w]B$r */
	0x42,0x24,0xFB,0xD2,0x77,0x5D,0xF1,0x48,	/* 1FE8: B$w]H */
	0x24,0xF6,0xA5,0x72,0x48,0x24,0xFB,0xD2,	/* 1FF0: $rH$ */
	0x77,0x5D,0xF1,0x41,0x24,0xF6,0xA5,0x72,	/* 1FF8: w]A$r */
	0x41,0x24,0xFB,0xD2,0x72,0x62,0x2F,0x2F,	/* 2000: A$rb.. */
	0x4F,0x24,0xF6,0xD2,0x77,0x5D,0xF1,0x22,	/* 2008: O$w]" */
	0x40,0x24,0xF6,0xA8,0x72,0x22,0x20,0x20,	/* 2010: @$r"   */
	0x40,0x24,0xFB,0xD2,0x77,0x5A,0xF1,0x28,	/* 2018: @$wZ( */
	0x40,0x24,0xF6,0xA5,0x72,0x48,0x24,0xFB,	/* 2020: @$rH$ */
	0xD2,0x77,0x5D,0xF1,0x24,0x40,0x24,0xF6,	/* 2028: w]$@$ */
	0xA5,0x72,0x48,0x24,0xFB,0xD2,0x72,0x48,	/* 2030: rH$rH */
	0x24,0xF6,0xA6,0x72,0x6F,0x4F,0x24,0xF6,	/* 2038: $roO$ */
	0xD2,0x42,0x71,0x22,0xE1,0x24,0x4E,0x71,	/* 2040: Bq"$Nq */
	0xE5,0x72,0x77,0xE4,0x40,0xB5,0x22,0xF0,	/* 2048: rw@" */
	0x21,0x4A,0x71,0xE5,0x72,0x60,0x4E,0x24,	/* 2050: !Jqr`N$ */
	0xF6,0x77,0xE4,0x29,0x40,0x71,0xE6,0x40,	/* 2058: w)@q@ */
	0x77,0x22,0x85,0x23,0xFB,0x77,0x57,0xF1,	/* 2060: w"#wW */
	0x44,0xF4,0xA6,0x40,0x77,0x57,0x23,0xFB,	/* 2068: D@wW# */
	0x03,0x77,0x76,0x98,0x41,0x76,0x21,0xE1,	/* 2070: .wvAv! */
	0x40,0xB5,0x22,0xF0,0x60,0xBF,0x73,0x31,	/* 2078: @"`s1 */
	0xD0,0x73,0x87,0xF1,0x73,0x32,0x27,0x2F,	/* 2080: ss2'. */
	0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,0x73,	/* 2088: .O$#s */
	0x87,0xF1,0x70,0x27,0xEF,0x73,0x87,0xF1,	/* 2090: p's */
	0x43,0x24,0xF6,0x70,0x26,0xE8,0x70,0x26,	/* 2098: C$p&p& */
	0x3C,0x28,0x40,0x24,0xF6,0xA9,0x40,0x73,	/* 20A0: <(@$@s */
	0x57,0x23,0xFB,0x41,0x72,0x21,0xE1,0x40,	/* 20A8: W#Ar!@ */
	0xB1,0x22,0xF0,0x72,0x71,0x22,0x20,0x95,	/* 20B0: "rq"  */
	0xA3,0x40,0x22,0xF0,0x72,0x8D,0xF1,0x72,	/* 20B8: @"rr */
	0x56,0xF1,0xF4,0xA3,0x41,0x22,0xF0,0x72,	/* 20C0: VA"r */
	0x71,0x28,0x93,0x40,0x22,0xF0,0x60,0xBE,	/* 20C8: q(@"` */
	0x74,0x31,0xD0,0x74,0x87,0xF1,0x74,0x32,	/* 20D0: t1tt2 */
	0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,	/* 20D8: '..O$# */
	0xFB,0x74,0x87,0xF1,0x70,0x27,0xEF,0x74,	/* 20E0: tp't */
	0x87,0xF1,0x43,0x24,0xF6,0x70,0x26,0xE8,	/* 20E8: C$p& */
	0x74,0x23,0x85,0xF1,0xD1,0x43,0x71,0xF9,	/* 20F0: t#Cq */
	0xAD,0x71,0x21,0xA0,0x71,0x41,0xF4,0x21,	/* 20F8: q!qA! */
	0xA1,0x71,0x42,0xF4,0xAD,0x06,0x71,0x43,	/* 2100: qB.qC */
	0xF4,0x21,0xAD,0x71,0x41,0x74,0x23,0x85,	/* 2108: !qAt# */
	0x23,0xFB,0x74,0x34,0x41,0x24,0xFB,0x74,	/* 2110: #t4A$t */
	0xE4,0x70,0x36,0x2F,0x4F,0x24,0xF6,0x42,	/* 2118: p6.O$B */
	0x24,0xFB,0x70,0xE6,0x40,0xB2,0x22,0xF0,	/* 2120: $p@" */
	0x74,0x57,0xF1,0x4C,0xF4,0xC0,0xA6,0x21,	/* 2128: tWL! */
	0x42,0x74,0x57,0x23,0xFB,0x40,0xB2,0x22,	/* 2130: BtW#@" */
	0xF0,0x72,0x71,0x21,0x27,0x9F,0xC0,0xA5,	/* 2138: rq!' */
	0x40,0x72,0x57,0x23,0xFB,0x40,0x22,0xF0,	/* 2140: @rW#@" */
	0x40,0x22,0xF0,0x41,0x22,0xF0,0x60,0xBD,	/* 2148: @"A"` */
	0x75,0x31,0xD1,0x75,0x87,0xF1,0x75,0x32,	/* 2150: u1uu2 */
	0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,	/* 2158: '..O$# */
	0xFB,0x75,0x87,0xF1,0x71,0x27,0xEF,0x75,	/* 2160: uq'u */
	0x87,0xF1,0x43,0x24,0xF6,0x71,0x26,0xE8,	/* 2168: C$q& */
	0x75,0x74,0x21,0x24,0x98,0xA4,0x40,0xB3,	/* 2170: ut!$@ */
	0x22,0xF0,0x71,0x35,0x2F,0x4F,0x24,0xF6,	/* 2178: "q5.O$ */
	0xA4,0x40,0xB3,0x22,0xF0,0x75,0x21,0x8F,	/* 2180: @"u! */
	0xF1,0xC0,0x24,0xAA,0x75,0x32,0x27,0x2F,	/* 2188: $u2'. */
	0x2F,0x4F,0x24,0xF6,0xD0,0x75,0x34,0x22,	/* 2190: .O$u4" */
	0x20,0x40,0x24,0xF6,0x26,0xA7,0x75,0x87,	/* 2198:  @$&u */
	0xF1,0x43,0xF9,0x21,0xAB,0x70,0x21,0x8D,	/* 21A0: C!p! */
	0xF1,0x60,0x8F,0x25,0xFA,0x70,0x21,0x8D,	/* 21A8: `%p! */
	0x23,0xFB,0x2F,0x4F,0x24,0xF6,0xC0,0x21,	/* 21B0: #.O$! */
	0xAD,0x24,0x44,0x71,0x27,0xEF,0x21,0x06,	/* 21B8: $Dq'!. */
	0x70,0x5E,0xF1,0x60,0x8F,0x25,0xFA,0x70,	/* 21C0: p^`%p */
	0x5E,0x23,0xFB,0x2F,0x4F,0x24,0xF6,0xC0,	/* 21C8: ^#.O$ */
	0xA5,0x21,0x40,0x71,0x27,0xEF,0x40,0x75,	/* 21D0: !@q'@u */
	0x8D,0x23,0xFB,0x40,0x75,0x55,0x23,0xFB,	/* 21D8: #@uU# */
	0x40,0x75,0x56,0x23,0xFB,0x40,0x75,0x8B,	/* 21E0: @uV#@u */
	0x23,0xFB,0x40,0x75,0x22,0x89,0x23,0xFB,	/* 21E8: #@u"# */
	0x75,0x34,0x62,0x2F,0x4F,0x24,0xF6,0x75,	/* 21F0: u4b.O$u */
	0xE4,0x75,0x22,0x87,0xF1,0x27,0xA3,0x21,	/* 21F8: u"'! */
	0x44,0x71,0xE5,0x29,0x09,0x75,0x22,0x89,	/* 2200: Dq).u" */
	0xF1,0x22,0xA5,0x75,0x34,0x21,0x20,0x40,	/* 2208: "u4! @ */
	0x24,0xF6,0x22,0xA7,0x75,0x22,0x50,0xF1,	/* 2210: $"u"P */
	0x41,0x24,0xF6,0x25,0xA1,0x21,0x48,0x71,	/* 2218: A$%!Hq */
	0xE5,0x75,0x22,0x50,0xF1,0x60,0x4E,0x24,	/* 2220: u"P`N$ */
	0xF6,0x75,0x22,0x50,0x23,0xFB,0x23,0x0E,	/* 2228: u"P##. */
	0x75,0x34,0x22,0x20,0x40,0x24,0xFB,0x75,	/* 2230: u4" @$u */
	0xE4,0x23,0x03,0x75,0x34,0x21,0x20,0x40,	/* 2238: #.u4! @ */
	0x24,0xFB,0x75,0xE4,0x40,0x75,0x8D,0x23,	/* 2240: $u@u# */
	0xFB,0x40,0x75,0x56,0x23,0xFB,0x75,0x22,	/* 2248: @uV#u" */
	0x87,0xF1,0xAC,0x75,0x34,0x41,0x24,0xFB,	/* 2250: u4A$ */
	0x75,0xE4,0x28,0x44,0x71,0xE6,0x0B,0x75,	/* 2258: u(Dq.u */
	0x34,0x41,0x24,0xFB,0x75,0xE4,0x29,0x42,	/* 2260: 4A$u)B */
	0x71,0xE6,0x28,0x42,0x71,0xE5,0x40,0xB3,	/* 2268: q(Bq@ */
	0x22,0xF0,0x75,0x21,0x87,0xF1,0x41,0x24,	/* 2270: "u!A$ */
	0xF6,0xC0,0xAB,0x40,0xD0,0x21,0x20,0x20,	/* 2278: @!   */
	0x40,0x75,0x74,0x25,0x2B,0x9E,0x75,0x21,	/* 2280: @ut%+u! */
	0x87,0xF1,0x42,0x24,0xF6,0xC0,0xAB,0x40,	/* 2288: B$@ */
	0xD0,0x22,0x20,0x20,0x40,0x75,0x74,0x25,	/* 2290: "  @ut% */
	0x2A,0x9A,0x28,0x40,0x71,0xE5,0x75,0x34,	/* 2298: *(@qu4 */
	0x60,0x4E,0x24,0xF6,0x75,0xE4,0x40,0x71,	/* 22A0: `N$u@q */
	0xE6,0x41,0x75,0x21,0x8F,0x23,0xFB,0x21,	/* 22A8: Au!#! */
	0x40,0x75,0x57,0x23,0xFB,0x41,0x74,0x21,	/* 22B0: @uW#At! */
	0xE1,0x40,0xB3,0x22,0xF0,0x60,0xBE,0x74,	/* 22B8: @"`t */
	0x31,0xD0,0x74,0x87,0xF1,0x74,0x32,0x27,	/* 22C0: 1tt2' */
	0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,	/* 22C8: ..O$# */
	0x74,0x87,0xF1,0x70,0x27,0xEF,0x74,0x87,	/* 22D0: tp't */
	0xF1,0x43,0x24,0xF6,0x70,0x26,0xE8,0x74,	/* 22D8: C$p&t */
	0x23,0x85,0xF1,0xD1,0x43,0x71,0xF9,0xA5,	/* 22E0: #Cq */
	0x71,0x24,0xA0,0x71,0x0E,0x71,0x43,0xF4,	/* 22E8: q$q.qC */
	0xAA,0x71,0x44,0xF4,0x21,0xAF,0x71,0x45,	/* 22F0: qD!qE */
	0xF4,0x21,0xAA,0x74,0x53,0xF1,0x24,0x48,	/* 22F8: !tS$H */
	0xF4,0xC0,0xAC,0x70,0x35,0x2F,0x4F,0x24,	/* 2300: p5.O$ */
	0xF6,0xC0,0xAA,0x28,0x42,0x70,0xE5,0x44,	/* 2308: (BpD */
	0x74,0x23,0x85,0x23,0xFB,0x74,0x34,0x41,	/* 2310: t##t4A */
	0x24,0xFB,0x74,0xE4,0x70,0x36,0x2F,0x4F,	/* 2318: $tp6.O */
	0x24,0xF6,0x42,0x24,0xFB,0x70,0xE6,0x41,	/* 2320: $B$pA */
	0xB2,0x22,0xF0,0x40,0xB2,0x22,0xF0,0x60,	/* 2328: "@"` */
	0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,0x73,	/* 2330: s1ss */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 2338: 2'..O$ */
	0x23,0xFB,0x73,0x87,0xF1,0x70,0x27,0xEF,	/* 2340: #sp' */
	0x73,0x87,0xF1,0x43,0x24,0xF6,0x70,0x26,	/* 2348: sC$p& */
	0xE8,0x73,0x22,0x87,0xF1,0xC0,0xA8,0x70,	/* 2350: s"p */
	0x3B,0x2F,0x4B,0x24,0xF6,0x70,0xEB,0x40,	/* 2358: ;.K$p@ */
	0x73,0x57,0x23,0xFB,0x41,0x72,0x21,0xE1,	/* 2360: sW#Ar! */
	0x40,0xB1,0x22,0xF0,0x60,0xBF,0x73,0x31,	/* 2368: @"`s1 */
	0xD0,0x73,0x87,0xF1,0x73,0x32,0x27,0x2F,	/* 2370: ss2'. */
	0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,0x73,	/* 2378: .O$#s */
	0x87,0xF1,0x70,0x27,0xEF,0x73,0x87,0xF1,	/* 2380: p's */
	0x43,0x24,0xF6,0x70,0x26,0xE8,0x70,0x35,	/* 2388: C$p&p5 */
	0x2F,0x4F,0x24,0xF6,0xA4,0x40,0xB1,0x22,	/* 2390: .O$@" */
	0xF0,0x73,0x8D,0xF1,0x73,0x56,0x23,0xFB,	/* 2398: ssV# */
	0x28,0x42,0x70,0xE5,0x73,0x72,0x67,0x97,	/* 23A0: (Bpsrg */
	0x40,0xB1,0x22,0xF0,0x72,0x8B,0xF1,0x72,	/* 23A8: @"rr */
	0x55,0x23,0xFB,0x41,0x71,0x21,0xE1,0x40,	/* 23B0: U#Aq!@ */
	0x72,0x57,0x23,0xFB,0x40,0x22,0xF0,0x60,	/* 23B8: rW#@"` */
	0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,0x73,	/* 23C0: s1ss */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 23C8: 2'..O$ */
	0x23,0xFB,0x73,0x87,0xF1,0x70,0x27,0xEF,	/* 23D0: #sp' */
	0x73,0x87,0xF1,0x43,0x24,0xF6,0x70,0x26,	/* 23D8: sC$p& */
	0xE8,0x73,0x22,0x87,0xF1,0xC0,0xAB,0x70,	/* 23E0: s"p */
	0x3B,0x2F,0x4F,0x24,0xF6,0x44,0x24,0xFB,	/* 23E8: ;.O$D$ */
	0x70,0xEB,0x41,0x72,0x21,0xE1,0x40,0x73,	/* 23F0: pAr!@s */
	0x57,0x23,0xFB,0x40,0xB1,0x22,0xF0,0x60,	/* 23F8: W#@"` */
	0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,0x73,	/* 2400: s1ss */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 2408: 2'..O$ */
	0x23,0xFB,0x73,0x87,0xF1,0x70,0x27,0xEF,	/* 2410: #sp' */
	0x73,0x87,0xF1,0x43,0x24,0xF6,0x70,0x26,	/* 2418: sC$p& */
	0xE8,0x74,0x70,0x26,0xEF,0x4F,0x72,0x21,	/* 2420: tp&Or! */
	0x2B,0x2C,0x9F,0x70,0x26,0x3F,0x2F,0x4F,	/* 2428: +,p&?.O */
	0x24,0xF6,0x75,0x24,0xF6,0x21,0xAA,0x40,	/* 2430: $u$!@ */
	0x70,0x26,0xEF,0x4F,0x72,0x21,0x2B,0x2B,	/* 2438: p&Or!++ */
	0x99,0x70,0x26,0x3F,0x2F,0x4F,0x24,0xF6,	/* 2440: p&?.O$ */
	0x75,0x24,0xF6,0xA9,0x76,0x81,0xB1,0x22,	/* 2448: u$v" */
	0xF0,0x76,0xB1,0x22,0xF0,0x40,0xB1,0x22,	/* 2450: v"@" */
	0xF0,0x60,0xBC,0x76,0x31,0xD2,0x40,0xD3,	/* 2458: `v1@ */
	0x76,0x87,0xF1,0x76,0x32,0x27,0x2F,0x2F,	/* 2460: vv2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x76,0x87,	/* 2468: O$#v */
	0xF1,0x72,0x27,0xEF,0x76,0x87,0xF1,0x43,	/* 2470: r'vC */
	0x24,0xF6,0x72,0x26,0xE8,0x76,0x22,0x87,	/* 2478: $r&v" */
	0xF1,0xC0,0xA2,0x4E,0xD3,0x73,0xC0,0xAB,	/* 2480: Ns */
	0x22,0x40,0xD0,0x49,0xD1,0x41,0x76,0x75,	/* 2488: "@IAvu */
	0x69,0x9D,0xD3,0x73,0xC0,0xAB,0x21,0x40,	/* 2490: is!@ */
	0xD0,0x4B,0xD1,0x44,0x76,0x75,0x6A,0x9F,	/* 2498: KDvuj */
	0xD3,0x72,0x26,0x3F,0x28,0x40,0x24,0xF6,	/* 24A0: r&?(@$ */
	0x25,0xFA,0xD1,0xC0,0xA7,0x4E,0xD3,0x71,	/* 24A8: %Nq */
	0x76,0x5C,0x23,0xFB,0x73,0xC0,0x23,0xA4,	/* 24B0: v\#s# */
	0x48,0xD0,0x42,0x72,0x26,0xEF,0x4F,0x75,	/* 24B8: HBr&Ou */
	0x21,0x2B,0x23,0x96,0x40,0x72,0x26,0xEF,	/* 24C0: !+#@r& */
	0x4F,0x75,0x21,0x2B,0x22,0x9C,0x72,0x26,	/* 24C8: Ou!+"r& */
	0x3F,0x28,0x40,0x24,0xF6,0x25,0xFA,0xD1,	/* 24D0: ?(@$% */
	0xAA,0x73,0xC0,0xA2,0x70,0xD3,0x71,0x76,	/* 24D8: spqv */
	0x5C,0x23,0xFB,0x70,0x60,0x8F,0x25,0xFA,	/* 24E0: \#p`% */
	0xD0,0xA2,0x63,0x0E,0x73,0xC0,0x23,0xA6,	/* 24E8: Тc.s# */
	0x42,0x72,0x26,0xEF,0x4F,0x75,0x21,0x2B,	/* 24F0: Br&Ou!+ */
	0x20,0x90,0x40,0x72,0x26,0xEF,0x22,0x27,	/* 24F8:  @r&"' */
	0x21,0x40,0xD0,0x72,0x26,0x3F,0x2F,0x4F,	/* 2500: !@r&?.O */
	0x24,0xF6,0x25,0xFA,0xD1,0x24,0x40,0x24,	/* 2508: $%$@$ */
	0xF6,0xC0,0xA9,0x70,0x60,0x8F,0x25,0xFA,	/* 2510: p`% */
	0xD0,0xA2,0x61,0x07,0x70,0xC0,0xA7,0x71,	/* 2518: Тa.pq */
	0x76,0x5C,0x23,0xFB,0x4D,0xD3,0x4F,0x75,	/* 2520: v\#MOu */
	0x21,0x2A,0x2C,0x9E,0x42,0x72,0x26,0xEF,	/* 2528: !*,Br& */
	0x4F,0x75,0x21,0x2A,0x2C,0x94,0x40,0x72,	/* 2530: Ou!*,@r */
	0x26,0xEF,0x28,0x42,0x72,0xE5,0x73,0x76,	/* 2538: &(Brsv */
	0x21,0x54,0x23,0xFB,0x73,0xA4,0x45,0x72,	/* 2540: !T#sEr */
	0x26,0xEF,0x40,0x76,0x57,0x23,0xFB,0x40,	/* 2548: &@vW#@ */
	0xB4,0x22,0xF0,0x21,0x40,0x72,0x71,0x9F,	/* 2550: "!@rq */
	0x22,0xF0,0x42,0x72,0x71,0x99,0x22,0xF0,	/* 2558: "Brq" */
	0x28,0x40,0x72,0x71,0x92,0x22,0xF0,0x60,	/* 2560: (@rq"` */
	0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,0x73,	/* 2568: s1ss */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 2570: 2'..O$ */
	0x23,0xFB,0x73,0x87,0xF1,0x70,0x27,0xEF,	/* 2578: #sp' */
	0x73,0x87,0xF1,0x43,0x24,0xF6,0x70,0x26,	/* 2580: sC$p& */
	0xE8,0x74,0x46,0x24,0xF6,0xA7,0x73,0x34,	/* 2588: tF$s4 */
	0x41,0x24,0xFB,0x73,0xE4,0x70,0x36,0x2F,	/* 2590: A$sp6. */
	0x4F,0x24,0xF6,0x74,0x24,0xFB,0x70,0xE6,	/* 2598: O$t$p */
	0x41,0x72,0x21,0xE1,0x40,0x73,0x57,0x23,	/* 25A0: Ar!@sW# */
	0xFB,0x40,0xB1,0x22,0xF0,0x60,0xBF,0x73,	/* 25A8: @"`s */
	0x31,0xD0,0x73,0x87,0xF1,0x73,0x32,0x27,	/* 25B0: 1ss2' */
	0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,	/* 25B8: ..O$# */
	0x73,0x87,0xF1,0x70,0x27,0xEF,0x73,0x87,	/* 25C0: sp's */
	0xF1,0x43,0x24,0xF6,0x70,0x26,0xE8,0x73,	/* 25C8: C$p&s */
	0x34,0x60,0x4E,0x24,0xF6,0x73,0xE4,0x40,	/* 25D0: 4`N$s@ */
	0x70,0xE6,0x41,0x72,0x21,0xE1,0x40,0x73,	/* 25D8: pAr!@s */
	0x57,0x23,0xFB,0x40,0xB1,0x22,0xF0,0x60,	/* 25E0: W#@"` */
	0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,0x73,	/* 25E8: s1ss */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 25F0: 2'..O$ */
	0x23,0xFB,0x73,0x87,0xF1,0x70,0x27,0xEF,	/* 25F8: #sp' */
	0x73,0x87,0xF1,0x43,0x24,0xF6,0x70,0x26,	/* 2600: sC$p& */
	0xE8,0x74,0x41,0x24,0xF6,0x23,0xA0,0x75,	/* 2608: tA$#u */
	0x41,0x24,0xF6,0x21,0xAA,0x70,0x39,0x2F,	/* 2610: A$!p9. */
	0x4F,0x24,0xF6,0x24,0x40,0x24,0xFB,0x70,	/* 2618: O$$@$p */
	0xE9,0x70,0x3A,0x2F,0x4F,0x24,0xF6,0x23,	/* 2620: p:.O$# */
	0x40,0x24,0xFB,0x70,0xEA,0x21,0x00,0x70,	/* 2628: @$p!.p */
	0x39,0x2B,0x4F,0x24,0xF6,0x70,0xE9,0x70,	/* 2630: 9+O$pp */
	0x3A,0x2C,0x4F,0x24,0xF6,0x70,0xEA,0x74,	/* 2638: :,O$pt */
	0x42,0x24,0xF6,0x21,0xAA,0x75,0x42,0x24,	/* 2640: B$!uB$ */
	0xF6,0xAD,0x70,0x39,0x2F,0x4F,0x24,0xF6,	/* 2648: p9.O$ */
	0x28,0x40,0x24,0xFB,0x70,0xE9,0x08,0x70,	/* 2650: (@$p.p */
	0x39,0x27,0x4F,0x24,0xF6,0x70,0xE9,0x74,	/* 2658: 9'O$pt */
	0x21,0x40,0x24,0xF6,0x21,0xAA,0x75,0x21,	/* 2660: !@$!u! */
	0x40,0x24,0xF6,0xAC,0x70,0x39,0x2F,0x4F,	/* 2668: @$p9.O */
	0x24,0xF6,0x42,0x24,0xFB,0x70,0xE9,0x08,	/* 2670: $B$p. */
	0x70,0x39,0x2F,0x4D,0x24,0xF6,0x70,0xE9,	/* 2678: p9.M$p */
	0x74,0x22,0x40,0x24,0xF6,0xAD,0x73,0x22,	/* 2680: t"@$s" */
	0x50,0xF1,0x21,0x40,0x24,0xFB,0x73,0x22,	/* 2688: P!@$s" */
	0x50,0x23,0xFB,0x73,0x53,0xF1,0x24,0x48,	/* 2690: P#sS$H */
	0xF4,0x23,0xA2,0x74,0x21,0x20,0x20,0x40,	/* 2698: #t!  @ */
	0x24,0xF6,0x21,0x24,0xAB,0x73,0x21,0x52,	/* 26A0: $!$s!R */
	0xF1,0x48,0x24,0xF6,0x21,0x22,0xAE,0x75,	/* 26A8: H$!"u */
	0x21,0x20,0x20,0x40,0x24,0xF6,0x21,0x21,	/* 26B0: !  @$!! */
	0xA4,0x70,0x21,0x35,0x2F,0x40,0x24,0xF6,	/* 26B8: p!5.@$ */
	0x49,0x24,0xFB,0x70,0x21,0xE5,0x42,0x70,	/* 26C0: I$p!Bp */
	0x26,0xED,0x21,0x22,0x03,0x70,0x21,0x35,	/* 26C8: &!".p!5 */
	0x2F,0x40,0x24,0xF6,0x4F,0x24,0xFB,0x70,	/* 26D0: .@$O$p */
	0x21,0xE5,0x74,0x21,0x20,0x40,0x24,0xF6,	/* 26D8: !t! @$ */
	0x22,0xA1,0x75,0x21,0x20,0x40,0x24,0xF6,	/* 26E0: "u! @$ */
	0x20,0xAF,0x70,0x21,0x3F,0x2F,0x4F,0x24,	/* 26E8:  p!?.O$ */
	0xF6,0x48,0x24,0xFB,0x70,0x21,0xEF,0x0B,	/* 26F0: H$p!. */
	0x20,0x70,0x21,0x3F,0x2F,0x47,0x24,0xF6,	/* 26F8:  p!?.G$ */
	0x70,0x21,0xEF,0x74,0x21,0x20,0x20,0x40,	/* 2700: p!t!  @ */
	0x24,0xF6,0x25,0xAB,0x73,0x21,0x52,0xF1,	/* 2708: $%s!R */
	0x48,0x24,0xF6,0x22,0xAC,0x75,0x21,0x20,	/* 2710: H$"u!  */
	0x20,0x40,0x24,0xF6,0x21,0xA0,0x70,0x21,	/* 2718:  @$!p! */
	0x3F,0x2F,0x4B,0x24,0xF6,0x70,0x21,0xEF,	/* 2720: ?.K$p! */
	0x42,0x70,0x26,0xED,0x23,0x09,0x70,0x21,	/* 2728: Bp&#.p! */
	0x3F,0x2F,0x4F,0x24,0xF6,0x44,0x24,0xFB,	/* 2730: ?.O$D$ */
	0x70,0x21,0xEF,0x40,0x70,0x26,0xED,0x22,	/* 2738: p!@p&" */
	0x06,0x75,0x21,0x20,0x20,0x40,0x24,0xF6,	/* 2740: .u!  @$ */
	0x21,0xA1,0x70,0x39,0x2F,0x4F,0x24,0xF6,	/* 2748: !p9.O$ */
	0x44,0x24,0xFB,0x70,0xE9,0x41,0x70,0x26,	/* 2750: D$pAp& */
	0xEC,0x0D,0x20,0x70,0x39,0x2F,0x4B,0x24,	/* 2758: . p9.K$ */
	0xF6,0x70,0xE9,0x40,0x70,0x26,0xEC,0x74,	/* 2760: p@p&t */
	0x22,0x20,0x20,0x40,0x24,0xF6,0x2D,0xA1,	/* 2768: "  @$- */
	0x73,0x21,0x52,0xF1,0x48,0x24,0xF6,0x22,	/* 2770: s!RH$" */
	0xA8,0x75,0x22,0x20,0x20,0x40,0x24,0xF6,	/* 2778: u"  @$ */
	0x21,0xA1,0x70,0x39,0x2F,0x4F,0x24,0xF6,	/* 2780: !p9.O$ */
	0x44,0x24,0xFB,0x70,0xE9,0x41,0x70,0x26,	/* 2788: D$pAp& */
	0xEC,0x2A,0x0E,0x70,0x39,0x2F,0x4B,0x24,	/* 2790: *.p9.K$ */
	0xF6,0x70,0xE9,0x40,0x70,0x26,0xEC,0x2A,	/* 2798: p@p&* */
	0x00,0x75,0x22,0x20,0x20,0x40,0x24,0xF6,	/* 27A0: .u"  @$ */
	0x21,0xA0,0x70,0x21,0x3F,0x2F,0x4B,0x24,	/* 27A8: !p!?.K$ */
	0xF6,0x70,0x21,0xEF,0x42,0x70,0x26,0xED,	/* 27B0: p!Bp& */
	0x28,0x07,0x70,0x21,0x3F,0x2F,0x4F,0x24,	/* 27B8: (.p!?.O$ */
	0xF6,0x44,0x24,0xFB,0x70,0x21,0xEF,0x40,	/* 27C0: D$p!@ */
	0x70,0x26,0xED,0x27,0x04,0x70,0x21,0x35,	/* 27C8: p&'.p!5 */
	0x2F,0x40,0x24,0xF6,0x70,0x21,0xE5,0x40,	/* 27D0: .@$p!@ */
	0x70,0x26,0xED,0x21,0x03,0x75,0x21,0x20,	/* 27D8: p&!.u!  */
	0x20,0x40,0x24,0xF6,0xA7,0x20,0x41,0x70,	/* 27E0:  @$ Ap */
	0x26,0xEC,0x05,0x20,0x40,0x70,0x26,0xEC,	/* 27E8: &. @p& */
	0x74,0x22,0x20,0x20,0x40,0x24,0xF6,0x24,	/* 27F0: t"  @$$ */
	0xA8,0x73,0x21,0x52,0xF1,0x48,0x24,0xF6,	/* 27F8: s!RH$ */
	0x21,0xA5,0x75,0x22,0x20,0x20,0x40,0x24,	/* 2800: !u"  @$ */
	0xF6,0xA7,0x20,0x41,0x70,0x26,0xEC,0x23,	/* 2808:  Ap&# */
	0x00,0x40,0x70,0x26,0xEC,0x22,0x0A,0x75,	/* 2810: .@p&".u */
	0x22,0x20,0x20,0x40,0x24,0xF6,0x21,0xA3,	/* 2818: "  @$! */
	0x70,0x21,0x35,0x2F,0x40,0x24,0xF6,0x49,	/* 2820: p!5.@$I */
	0x24,0xFB,0x70,0x21,0xE5,0x42,0x70,0x26,	/* 2828: $p!Bp& */
	0xED,0x0F,0x20,0x70,0x21,0x35,0x2F,0x40,	/* 2830: . p!5.@ */
	0x24,0xF6,0x70,0x21,0xE5,0x40,0x70,0x26,	/* 2838: $p!@p& */
	0xED,0xB1,0x22,0xF0,0x60,0xBF,0x73,0x31,	/* 2840: "`s1 */
	0xD0,0x73,0x87,0xF1,0x73,0x32,0x27,0x2F,	/* 2848: ss2'. */
	0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,0x73,	/* 2850: .O$#s */
	0x87,0xF1,0x70,0x27,0xEF,0x73,0x87,0xF1,	/* 2858: p's */
	0x43,0x24,0xF6,0x70,0x26,0xE8,0x74,0x21,	/* 2860: C$p&t! */
	0x20,0x20,0x40,0x24,0xF6,0x23,0xA1,0x73,	/* 2868:   @$#s */
	0x21,0x52,0xF1,0x48,0x24,0xF6,0x21,0xA5,	/* 2870: !RH$! */
	0x75,0x21,0x20,0x20,0x40,0x24,0xF6,0xA7,	/* 2878: u!  @$ */
	0x20,0x42,0x70,0x26,0xED,0x21,0x09,0x40,	/* 2880:  Bp&!.@ */
	0x70,0x26,0xED,0x21,0x03,0x75,0x21,0x20,	/* 2888: p&!.u!  */
	0x20,0x40,0x24,0xF6,0xA7,0x20,0x41,0x70,	/* 2890:  @$ Ap */
	0x26,0xEC,0x05,0x20,0x40,0x70,0x26,0xEC,	/* 2898: &. @p& */
	0x74,0x22,0x20,0x20,0x40,0x24,0xF6,0x23,	/* 28A0: t"  @$# */
	0xA4,0x73,0x21,0x52,0xF1,0x48,0x24,0xF6,	/* 28A8: s!RH$ */
	0x21,0xA7,0x75,0x22,0x20,0x20,0x40,0x24,	/* 28B0: !u"  @$ */
	0xF6,0xA8,0x20,0x41,0x70,0x26,0xEC,0xB1,	/* 28B8:  Ap& */
	0x22,0xF0,0x40,0x70,0x26,0xEC,0xB1,0x22,	/* 28C0: "@p&" */
	0xF0,0x75,0x22,0x20,0x20,0x40,0x24,0xF6,	/* 28C8: u"  @$ */
	0xA8,0x20,0x42,0x70,0x26,0xED,0xB1,0x22,	/* 28D0:  Bp&" */
	0xF0,0x40,0x70,0x26,0xED,0xB1,0x22,0xF0,	/* 28D8: @p&" */
	0x76,0xF6,0x20,0x82,0x00,0x04,0x00,0x16,	/* 28E0: v .... */
	0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x41,	/* 28E8: ...A...A */
	0x00,0x04,0x00,0x82,0x00,0x03,0x00,0x41,	/* 28F0: ......A */
	0x00,0x03,0x00,0x82,0x00,0x02,0x00,0x4E,	/* 28F8: ......N */
	0x00,0x02,0x00,0x41,0x00,0x02,0x00,0x82,	/* 2900: ...A... */
	0x00,0x01,0x00,0x57,0x00,0x02,0x00,0x41,	/* 2908: ...W...A */
	0x00,0x01,0x00,0x82,0x00,0x00,0x00,0x2B,	/* 2910: ......+ */
	0x00,0x00,0x00,0xA3,0x00,0x04,0x00,0x1B,	/* 2918: ....... */
	0x00,0x00,0x00,0x51,0x00,0x00,0x00,0x51,	/* 2920: ...Q...Q */
	0x00,0x04,0x00,0xA3,0x00,0x03,0x00,0x51,	/* 2928: ......Q */
	0x00,0x03,0x00,0xA3,0x00,0x02,0x00,0x62,	/* 2930: ......b */
	0x00,0x02,0x00,0x51,0x00,0x02,0x00,0xA3,	/* 2938: ...Q... */
	0x00,0x01,0x00,0x6D,0x00,0x02,0x00,0x51,	/* 2940: ...m...Q */
	0x00,0x01,0x00,0xA3,0x00,0x00,0x00,0x36,	/* 2948: ......6 */
	0x00,0x00,0x00,0x36,0x00,0x05,0x00,0x1B,	/* 2950: ...6.... */
	0x00,0x05,0x00,0x0D,0x00,0x05,0x00,0xF4,	/* 2958: ....... */
	0x00,0x04,0x00,0x6F,0x00,0x04,0x00,0x5B,	/* 2960: ...o...[ */
	0x00,0x04,0x00,0xF4,0x00,0x03,0x00,0x6D,	/* 2968: ......m */
	0x00,0x01,0x00,0x38,0x00,0x00,0x00,0x31,	/* 2970: ...8...1 */
	0x00,0x00,0x00,0x29,0x00,0x00,0x00,0x62,	/* 2978: ...)...b */
	0x00,0x05,0x00,0x53,0x00,0x05,0x00,0xD9,	/* 2980: ...S... */
	0x00,0x00,0x00,0x30,0x00,0x05,0x00,0x6D,	/* 2988: ...0...m */
	0x00,0x00,0x00,0x25,0x00,0x23,0x00,0x21,	/* 2990: ...%.#.! */
	0x00,0x1F,0x00,0x1D,0x00,0x1B,0x00,0x19,	/* 2998: ........ */
	0x00,0x17,0x00,0x15,0x00,0x13,0x00,0x11,	/* 29A0: ........ */
	0x00,0x0F,0x00,0x0D,0x00,0x0B,0x00,0x09,	/* 29A8: ........ */
	0x00,0x07,0x00,0x05,0x00,0x03,0x00,0x01,	/* 29B0: ........ */
	0x00,0x00,0x00,0x0E,0x0B,0x71,0x21,0x53,	/* 29B8: .....q!S */
	0xD2,0x64,0x2E,0x47,0x21,0xFB,0x72,0x22,	/* 29C0: d.G!r" */
	0xE6,0x64,0x29,0x42,0x21,0xFB,0x72,0x22,	/* 29C8: d)B!r" */
	0xE4,0x64,0x28,0x44,0x21,0xFB,0x72,0x22,	/* 29D0: d(D!r" */
	0xE2,0x64,0x27,0x45,0x21,0xFB,0x72,0x22,	/* 29D8: d'E!r" */
	0xE0,0x65,0x27,0x43,0x21,0xFB,0x72,0x21,	/* 29E0: e'C!r! */
	0xEE,0x66,0x2D,0x41,0x21,0xFB,0x72,0x21,	/* 29E8: f-A!r! */
	0xEC,0x66,0x2B,0x46,0x21,0xFB,0x72,0x21,	/* 29F0: f+F!r! */
	0xEA,0x66,0x26,0x4E,0x21,0xFB,0x72,0x21,	/* 29F8: f&N!r! */
	0xE8,0x66,0x22,0x49,0x21,0xFB,0x72,0x21,	/* 2A00: f"I!r! */
	0xE6,0x68,0x24,0x40,0x21,0xFB,0x72,0x21,	/* 2A08: h$@!r! */
	0xE4,0x68,0x23,0x45,0x21,0xFB,0x72,0x21,	/* 2A10: h#E!r! */
	0xE2,0x68,0x22,0x4A,0x21,0xFB,0x72,0x21,	/* 2A18: h"J!r! */
	0xE0,0x68,0x21,0x43,0x21,0xFB,0x72,0xEE,	/* 2A20: h!C!r */
	0x69,0x2A,0x41,0x21,0xFB,0x72,0xEC,0x69,	/* 2A28: i*A!ri */
	0x27,0x4F,0x21,0xFB,0x72,0xEA,0x6F,0x2B,	/* 2A30: 'O!ro+ */
	0x4D,0x21,0xFB,0x72,0xE8,0x69,0x23,0x4A,	/* 2A38: M!ri#J */
	0x21,0xFB,0x72,0xE6,0x6F,0x2A,0x4F,0x21,	/* 2A40: !ro*O! */
	0xFB,0x72,0xE4,0x6F,0x2A,0x48,0x21,0xFB,	/* 2A48: ro*H! */
	0x72,0xE2,0x72,0x6C,0x4C,0x21,0xFB,0x21,	/* 2A50: rrlL!! */
	0x44,0x21,0x2A,0x24,0x96,0x22,0xF0,0x60,	/* 2A58: D!*$"` */
	0xBD,0x74,0x23,0x5A,0xD1,0x21,0x28,0x40,	/* 2A60: t#Z!(@ */
	0xD0,0x71,0x62,0x32,0x87,0xF1,0x81,0x71,	/* 2A68: qb2q */
	0x62,0x32,0x87,0x23,0xFB,0x74,0x2B,0x95,	/* 2A70: b2#t+ */
	0x70,0x57,0xF1,0x25,0xFA,0xD2,0xAE,0x72,	/* 2A78: pW%Үr */
	0x71,0x62,0x59,0xFA,0x30,0xD2,0x70,0x74,	/* 2A80: qbY0pt */
	0x2A,0x23,0x9A,0x29,0xAA,0x70,0x31,0xD2,	/* 2A88: *#)p1 */
	0x70,0x34,0x41,0x24,0xF6,0xC0,0x23,0xAE,	/* 2A90: p4A$# */
	0x70,0x8D,0xF1,0x70,0x56,0xF1,0xF4,0x23,	/* 2A98: ppV# */
	0xA5,0x70,0x34,0x41,0x24,0xFB,0x70,0xE4,	/* 2AA0: p4A$p */
	0x70,0x87,0xF1,0x70,0x32,0x27,0x2F,0x2F,	/* 2AA8: pp2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x70,0x87,	/* 2AB0: O$#p */
	0xF1,0x72,0x27,0xEF,0x70,0x87,0xF1,0x43,	/* 2AB8: r'pC */
	0x24,0xF6,0x72,0x26,0xE8,0x72,0x36,0x2F,	/* 2AC0: $r&r6. */
	0x4F,0x24,0xF6,0x44,0x24,0xFB,0x72,0xE6,	/* 2AC8: O$D$r */
	0x41,0x70,0x22,0x89,0x23,0xFB,0x70,0x34,	/* 2AD0: Ap"#p4 */
	0x21,0x40,0x24,0xF6,0x21,0xAC,0x41,0x70,	/* 2AD8: !@$!Ap */
	0x55,0xF1,0x70,0x8B,0xF1,0xFC,0x2F,0x4F,	/* 2AE0: Up.O */
	0x24,0xF6,0x22,0x40,0xF0,0x24,0xFF,0xF0,	/* 2AE8: $"@$ */
	0xC0,0xA8,0x70,0x34,0x61,0x4F,0x24,0xF6,	/* 2AF0: p4aO$ */
	0x70,0xE4,0x70,0x22,0x50,0xF1,0x21,0x40,	/* 2AF8: pp"P!@ */
	0x24,0xF6,0x22,0xA3,0x70,0x87,0xF1,0x70,	/* 2B00: $"pp */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 2B08: 2'..O$ */
	0x23,0xFB,0x70,0x87,0xF1,0x72,0x27,0xEF,	/* 2B10: #pr' */
	0x70,0x87,0xF1,0x43,0x24,0xF6,0x72,0x26,	/* 2B18: pC$r& */
	0xE8,0x70,0x74,0x61,0x2B,0x2C,0x96,0x70,	/* 2B20: pta+,p */
	0x21,0x37,0xD0,0x6C,0x0C,0x60,0xB4,0x7D,	/* 2B28: !7l.`} */
	0x23,0x5A,0xD6,0x76,0x30,0xD4,0x76,0x31,	/* 2B30: #Zv0v1 */
	0xD1,0x74,0x33,0xD0,0x71,0x44,0xF8,0x70,	/* 2B38: t3qDp */
	0x27,0xEF,0x70,0x26,0x37,0x2F,0x4F,0x24,	/* 2B40: 'p&7.O$ */
	0xF6,0x25,0xFA,0xD3,0x41,0x24,0xF6,0x25,	/* 2B48: %A$% */
	0x21,0xA9,0x70,0x26,0x3B,0x2F,0x4F,0x24,	/* 2B50: !p&;.O$ */
	0xF6,0x25,0xFA,0xD2,0x43,0x24,0xF6,0x70,	/* 2B58: %C$p */
	0x26,0xE8,0x71,0x72,0x43,0x24,0xF6,0x28,	/* 2B60: &qrC$( */
	0xF1,0x74,0x55,0xFA,0x30,0xD5,0x70,0x24,	/* 2B68: tU0p$ */
	0x33,0x47,0x24,0xF6,0x43,0xF4,0x2C,0xAB,	/* 2B70: 3G$C, */
	0x40,0xD9,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2B78: @p&2.O$ */
	0xF6,0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2B80: p&2.O$ */
	0xF6,0xDB,0x78,0x48,0x24,0xF6,0x21,0xA0,	/* 2B88: xH$! */
	0x75,0x21,0x89,0xF1,0x41,0x24,0xFB,0x75,	/* 2B90: u!A$u */
	0x21,0x89,0x23,0xFB,0x41,0x76,0x62,0xE7,	/* 2B98: !#Avb */
	0x78,0x47,0x24,0xF6,0xAD,0x75,0x21,0x50,	/* 2BA0: xG$u!P */
	0xF1,0x28,0x40,0x24,0xF6,0xA4,0x41,0x76,	/* 2BA8: (@$Av */
	0x62,0xE7,0x78,0x41,0x24,0xF6,0xA8,0x75,	/* 2BB0: bxA$u */
	0x21,0x3E,0x41,0xF2,0x75,0x21,0xEE,0x78,	/* 2BB8: !>Au!x */
	0x42,0x24,0xF6,0xAA,0x75,0x21,0x3C,0x41,	/* 2BC0: B$u!<A */
	0xF2,0x75,0x21,0xEC,0x41,0xD9,0x78,0x44,	/* 2BC8: u!AxD */
	0x24,0xF6,0xAA,0x75,0x21,0x3D,0x41,0xF2,	/* 2BD0: $u!=A */
	0x75,0x21,0xED,0x41,0xD9,0x79,0x24,0x28,	/* 2BD8: u!Ay$( */
	0xA2,0x75,0x21,0x50,0xF1,0x24,0x40,0x24,	/* 2BE0: u!P$@$ */
	0xF6,0xA5,0x75,0x22,0x8B,0xF1,0xDB,0x75,	/* 2BE8: u"u */
	0x55,0xF1,0xD8,0x75,0x8B,0xF1,0x25,0xFA,	/* 2BF0: Uu% */
	0xD9,0x78,0x81,0xFC,0x2F,0x4F,0x24,0xF6,	/* 2BF8: x.O$ */
	0x25,0xFA,0xDA,0x24,0x25,0xA5,0x7B,0x78,	/* 2C00: %$%{x */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2C08: .O$u+P */
	0x23,0xFB,0x78,0x81,0x75,0x55,0x23,0xFB,	/* 2C10: #xuU# */
	0x79,0x78,0x81,0x81,0xFC,0x2F,0x4F,0x24,	/* 2C18: yx.O$ */
	0xF6,0xD7,0x75,0x34,0x48,0x24,0xF6,0x24,	/* 2C20: u4H$$ */
	0x23,0xA9,0x7A,0x21,0x4F,0xF9,0x24,0x23,	/* 2C28: #z!O$# */
	0xA2,0x22,0x40,0x77,0xF9,0x24,0x22,0xAB,	/* 2C30: "@w$" */
	0x75,0x34,0x21,0x40,0x24,0xFB,0x75,0xE4,	/* 2C38: u4!@$u */
	0x24,0x22,0x00,0x75,0x34,0x21,0x40,0x24,	/* 2C40: $".u4!@$ */
	0xF6,0xC0,0x24,0x20,0xA0,0x75,0x22,0x87,	/* 2C48: $ u" */
	0xF1,0xC0,0xAC,0x75,0x21,0x54,0xF1,0x41,	/* 2C50: u!TA */
	0x24,0xFB,0x75,0x21,0x54,0x23,0xFB,0x75,	/* 2C58: $u!T#u */
	0x55,0xF1,0xD8,0x75,0x8B,0xF1,0x25,0xFA,	/* 2C60: Uu% */
	0xD9,0x78,0x81,0xFC,0x2F,0x4F,0x24,0xF6,	/* 2C68: x.O$ */
	0xDA,0x70,0x3E,0x2F,0x4F,0x24,0xF6,0xD7,	/* 2C70: p>.O$ */
	0x7A,0x77,0xF9,0xA3,0x77,0xDB,0x02,0x7A,	/* 2C78: zww.z */
	0xDB,0x77,0x7B,0x2F,0x4F,0x24,0xF6,0xFC,	/* 2C80: w{.O$ */
	0x2F,0x4F,0x24,0xF6,0xD7,0x7B,0x2F,0x4F,	/* 2C88: .O${.O */
	0x24,0xF6,0x41,0xF4,0xDB,0x41,0x22,0x40,	/* 2C90: $AA"@ */
	0x7B,0x24,0xFF,0xF0,0xC0,0x23,0x26,0xA3,	/* 2C98: {$#& */
	0x7B,0x42,0x21,0xFB,0x28,0xF1,0xF6,0x23,	/* 2CA0: {B!(# */
	0x24,0x02,0x20,0x23,0x22,0x07,0x20,0x23,	/* 2CA8: $. #". # */
	0x20,0x0C,0x20,0x22,0x2F,0x01,0x20,0x22,	/* 2CB0:  . ".. " */
	0x2D,0x06,0x20,0x22,0x2B,0x0B,0x20,0x22,	/* 2CB8: -. "+. " */
	0x2A,0x00,0x20,0x22,0x28,0x05,0x20,0x22,	/* 2CC0: *. "(. " */
	0x26,0x0A,0x20,0x22,0x24,0x0F,0x20,0x22,	/* 2CC8: &. "$. " */
	0x23,0x04,0x20,0x22,0x21,0x09,0x20,0x21,	/* 2CD0: #. "!. ! */
	0x2F,0x0E,0x20,0x21,0x2E,0x03,0x20,0x21,	/* 2CD8: .. !.. ! */
	0x2C,0x08,0x20,0x21,0x2A,0x0D,0x20,0x21,	/* 2CE0: ,. !*. ! */
	0x29,0x02,0x20,0x21,0x27,0x07,0x20,0x21,	/* 2CE8: ). !'. ! */
	0x25,0x0C,0x20,0x21,0x24,0x01,0x20,0x21,	/* 2CF0: %. !$. ! */
	0x22,0x06,0x20,0x21,0x20,0x0B,0x20,0x2F,	/* 2CF8: ". ! . . */
	0x01,0x20,0x20,0x2D,0x06,0x20,0x20,0x2B,	/* 2D00: .  -.  + */
	0x0B,0x20,0x20,0x2A,0x00,0x20,0x20,0x28,	/* 2D08: .  *.  ( */
	0x05,0x20,0x20,0x26,0x0A,0x20,0x20,0x24,	/* 2D10: .  &.  $ */
	0x0F,0x20,0x20,0x23,0x04,0x20,0x20,0x21,	/* 2D18: .  #.  ! */
	0x09,0x20,0x20,0x78,0xDB,0x78,0x81,0xD8,	/* 2D20: .  xx */
	0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 2D28: p&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2D30: .O$u+P */
	0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,	/* 2D38: #xxp */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 2D40: &2.O${. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2D48: O$u+P# */
	0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,	/* 2D50: xxp& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 2D58: 2.O${.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2D60: $u+P# */
	0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,	/* 2D68: xxp&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 2D70: .O${.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,	/* 2D78: u+P#x */
	0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,	/* 2D80: xp&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 2D88: O${.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,	/* 2D90: u+P#x */
	0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,	/* 2D98: xp&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,	/* 2DA0: ${.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,	/* 2DA8: +P#xx */
	0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2DB0: p&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2DB8: {.O$u+ */
	0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,	/* 2DC0: P#xx */
	0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2DC8: p&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2DD0: {.O$u+P */
	0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,	/* 2DD8: #xx */
	0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 2DE0: p&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2DE8: .O$u+P */
	0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,	/* 2DF0: #xxp */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 2DF8: &2.O${. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2E00: O$u+P# */
	0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,	/* 2E08: xxp& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 2E10: 2.O${.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2E18: $u+P# */
	0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,	/* 2E20: xxp&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 2E28: .O${.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,	/* 2E30: u+P#x */
	0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,	/* 2E38: xp&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 2E40: O${.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,	/* 2E48: u+P#x */
	0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,	/* 2E50: xp&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,	/* 2E58: ${.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,	/* 2E60: +P#xx */
	0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2E68: p&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2E70: {.O$u+ */
	0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,	/* 2E78: P#xx */
	0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2E80: p&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2E88: {.O$u+P */
	0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,	/* 2E90: #xx */
	0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 2E98: p&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2EA0: .O$u+P */
	0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,	/* 2EA8: #xxp */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 2EB0: &2.O${. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2EB8: O$u+P# */
	0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,	/* 2EC0: xxp& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 2EC8: 2.O${.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2ED0: $u+P# */
	0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,	/* 2ED8: xxp&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 2EE0: .O${.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,	/* 2EE8: u+P#x */
	0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,	/* 2EF0: xp&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 2EF8: O${.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,	/* 2F00: u+P#x */
	0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,	/* 2F08: xp&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,	/* 2F10: ${.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,	/* 2F18: +P#xx */
	0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2F20: p&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2F28: {.O$u+ */
	0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,	/* 2F30: P#xx */
	0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2F38: p&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2F40: {.O$u+P */
	0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,	/* 2F48: #xx */
	0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 2F50: p&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2F58: .O$u+P */
	0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,	/* 2F60: #xxp */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 2F68: &2.O${. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2F70: O$u+P# */
	0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,	/* 2F78: xxp& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 2F80: 2.O${.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2F88: $u+P# */
	0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,	/* 2F90: xxp&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 2F98: .O${.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,	/* 2FA0: u+P#x */
	0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,	/* 2FA8: xp&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 2FB0: O${.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,	/* 2FB8: u+P#x */
	0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,	/* 2FC0: xp&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,	/* 2FC8: ${.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,	/* 2FD0: +P#xx */
	0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2FD8: p&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2FE0: {.O$u+ */
	0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,	/* 2FE8: P#xx */
	0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2FF0: p&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2FF8: {.O$u+P */
	0xF2,0x23,0xFB,0x78,0x75,0x55,0x23,0xFB,	/* 3000: #xuU# */
	0x77,0x75,0x21,0x3F,0xF2,0x75,0x21,0xEF,	/* 3008: wu!?u! */
	0x77,0x77,0x60,0x8F,0xD7,0x2F,0x4F,0x24,	/* 3010: ww`.O$ */
	0xF6,0x21,0xA0,0x70,0x26,0x32,0x77,0x77,	/* 3018: !p&2ww */
	0x60,0x8F,0xD7,0x2F,0x4F,0x24,0xF6,0xA3,	/* 3020: `.O$ */
	0x20,0x60,0x00,0x79,0x78,0x81,0xFC,0x2F,	/* 3028:  `.yx. */
	0x4F,0x24,0xF6,0xD7,0x75,0x34,0x48,0x24,	/* 3030: O$u4H$ */
	0xF6,0x21,0xA2,0x7A,0x21,0x4F,0xF9,0xAD,	/* 3038: !z!O */
	0x22,0x40,0x77,0xF9,0xA8,0x75,0x34,0x21,	/* 3040: "@wu4! */
	0x40,0x24,0xFB,0x75,0xE4,0x41,0x76,0x62,	/* 3048: @$uAvb */
	0xE8,0x72,0x23,0x4F,0x24,0xF6,0x70,0x26,	/* 3050: r#O$p& */
	0xEB,0x21,0x00,0x77,0x75,0x21,0x3F,0xF2,	/* 3058: !.wu!? */
	0x75,0x21,0xEF,0x72,0x23,0x4F,0x24,0xF6,	/* 3060: u!r#O$ */
	0x70,0x26,0xEB,0x73,0x42,0x24,0xF6,0x23,	/* 3068: p&sB$# */
	0x2B,0xAE,0x70,0x26,0x3A,0x2F,0x4F,0x24,	/* 3070: +p&:.O$ */
	0xF6,0x25,0xFA,0xD2,0x43,0x24,0xF6,0x70,	/* 3078: %C$p */
	0x26,0xE8,0x71,0x72,0x43,0x24,0xF6,0x28,	/* 3080: &qrC$( */
	0xF1,0x74,0x55,0xFA,0x30,0x25,0xFA,0xD5,	/* 3088: tU0% */
	0x22,0x87,0xF1,0xC0,0xAC,0x75,0x21,0x54,	/* 3090: "u!T */
	0xF1,0x42,0x24,0xFB,0x75,0x21,0x54,0x23,	/* 3098: B$u!T# */
	0xFB,0x75,0x23,0x85,0xF1,0xA9,0x75,0x7D,	/* 30A0: u#u} */
	0x61,0x25,0x26,0x98,0x23,0x27,0x09,0x75,	/* 30A8: a%&#'.u */
	0x8D,0xF1,0xD9,0x75,0x56,0xF1,0xD8,0x75,	/* 30B0: uVu */
	0x34,0x21,0x20,0x40,0x24,0xF6,0x22,0xA2,	/* 30B8: 4! @$" */
	0x75,0x34,0x61,0x2F,0x4F,0x24,0xF6,0x75,	/* 30C0: u4a.O$u */
	0xE4,0x75,0x34,0x22,0x20,0x40,0x24,0xFB,	/* 30C8: u4" @$ */
	0x75,0xE4,0x75,0x34,0x60,0x4E,0x24,0xF6,	/* 30D0: uu4`N$ */
	0x75,0xE4,0x70,0x36,0x2F,0x49,0x24,0xF6,	/* 30D8: up6.I$ */
	0x70,0xE6,0x79,0x78,0xFC,0x2F,0x4F,0x24,	/* 30E0: pyx.O$ */
	0xF6,0x25,0xFA,0xD7,0x75,0x21,0x55,0xF1,	/* 30E8: %u!U */
	0xF9,0xA6,0x75,0x21,0x55,0xF1,0xDA,0x02,	/* 30F0: u!U. */
	0x77,0xDA,0x7A,0x2F,0x4F,0x24,0xF6,0x41,	/* 30F8: wz.O$A */
	0xF4,0xDA,0x41,0x22,0x40,0x7A,0x24,0xFF,	/* 3100: A"@z$ */
	0xF0,0xC0,0x22,0x2C,0xA3,0x7A,0x42,0x21,	/* 3108: ",zB! */
	0xFB,0x28,0xF1,0xF6,0x22,0x2A,0x07,0x20,	/* 3110: ("*.  */
	0x22,0x29,0x01,0x20,0x22,0x27,0x0B,0x20,	/* 3118: "). "'.  */
	0x22,0x26,0x05,0x20,0x22,0x24,0x0F,0x20,	/* 3120: "&. "$.  */
	0x22,0x23,0x09,0x20,0x22,0x22,0x03,0x20,	/* 3128: "#. "".  */
	0x22,0x20,0x0D,0x20,0x21,0x2F,0x07,0x20,	/* 3130: " . !..  */
	0x21,0x2E,0x01,0x20,0x21,0x2C,0x0B,0x20,	/* 3138: !.. !,.  */
	0x21,0x2B,0x05,0x20,0x21,0x29,0x0F,0x20,	/* 3140: !+. !).  */
	0x21,0x28,0x09,0x20,0x21,0x27,0x03,0x20,	/* 3148: !(. !'.  */
	0x21,0x25,0x0D,0x20,0x21,0x24,0x07,0x20,	/* 3150: !%. !$.  */
	0x21,0x23,0x01,0x20,0x21,0x21,0x0B,0x20,	/* 3158: !#. !!.  */
	0x21,0x20,0x05,0x20,0x2F,0x00,0x20,0x20,	/* 3160: ! . ..   */
	0x2D,0x0A,0x20,0x20,0x2C,0x04,0x20,0x20,	/* 3168: -.  ,.   */
	0x2A,0x0E,0x20,0x20,0x29,0x08,0x20,0x20,	/* 3170: *.  ).   */
	0x28,0x02,0x20,0x20,0x26,0x0C,0x20,0x20,	/* 3178: (.  &.   */
	0x25,0x06,0x20,0x20,0x24,0x00,0x20,0x20,	/* 3180: %.  $.   */
	0x22,0x0A,0x20,0x20,0x21,0x04,0x20,0x20,	/* 3188: ".  !.   */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3190: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3198: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 31A0: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 31A8: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 31B0: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 31B8: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 31C0: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 31C8: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 31D0: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 31D8: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 31E0: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 31E8: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 31F0: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 31F8: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 3200: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 3208: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 3210: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3218: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3220: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3228: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 3230: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3238: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 3240: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 3248: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 3250: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 3258: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3260: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3268: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3270: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 3278: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3280: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 3288: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 3290: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 3298: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 32A0: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 32A8: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 32B0: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 32B8: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 32C0: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 32C8: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 32D0: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 32D8: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 32E0: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 32E8: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 32F0: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 32F8: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3300: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 3308: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3310: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 3318: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 3320: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 3328: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 3330: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3338: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3340: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3348: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 3350: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3358: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 3360: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 3368: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 3370: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 3378: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3380: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3388: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3390: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 3398: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 33A0: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 33A8: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 33B0: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 33B8: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 33C0: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 33C8: O$p& */
	0x79,0x78,0xFC,0x2F,0x4F,0x24,0xF6,0xD9,	/* 33D0: yx.O$ */
	0x78,0x75,0x56,0x23,0xFB,0x77,0x2C,0x40,	/* 33D8: xuV#w,@ */
	0xF9,0x21,0xA0,0x2C,0x41,0x79,0xF9,0xAB,	/* 33E0: !,Ay */
	0x75,0x34,0x28,0x20,0x40,0x24,0xFB,0x75,	/* 33E8: u4( @$u */
	0xE4,0x22,0x01,0x77,0x24,0x40,0xF9,0x21,	/* 33F0: ".w$@! */
	0xAB,0x24,0x41,0x79,0xF9,0x21,0xA5,0x75,	/* 33F8: $Ay!u */
	0x34,0x28,0x20,0x40,0x24,0xF6,0xAD,0x75,	/* 3400: 4( @$u */
	0x34,0x68,0x2F,0x4F,0x24,0xF6,0x75,0xE4,	/* 3408: 4h.O$u */
	0x41,0x76,0x62,0xE7,0x79,0xC0,0x21,0xA0,	/* 3410: Avby! */
	0x75,0x34,0x60,0x4E,0x24,0xF6,0x75,0xE4,	/* 3418: u4`N$u */
	0x70,0x36,0x2F,0x49,0x24,0xF6,0x70,0xE6,	/* 3420: p6.I$p */
	0x72,0x23,0x4F,0x24,0xF6,0x70,0x26,0xEA,	/* 3428: r#O$p& */
	0x73,0x44,0x24,0xF6,0x25,0xA3,0x70,0x26,	/* 3430: sD$%p& */
	0x39,0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xD2,	/* 3438: 9.O$% */
	0x43,0x24,0xF6,0x70,0x26,0xE8,0x71,0x72,	/* 3440: C$p&qr */
	0x43,0x24,0xF6,0x28,0xF1,0x74,0x55,0xFA,	/* 3448: C$(tU */
	0x30,0x25,0xFA,0xD5,0x7D,0x61,0x22,0x29,	/* 3450: 0%}a") */
	0x94,0x75,0x7D,0x61,0x23,0x2F,0x98,0x75,	/* 3458: u}a#.u */
	0x22,0x87,0xF1,0xC0,0xAC,0x75,0x21,0x54,	/* 3460: "u!T */
	0xF1,0x44,0x24,0xFB,0x75,0x21,0x54,0x23,	/* 3468: D$u!T# */
	0xFB,0x41,0x76,0x62,0xE7,0x75,0x21,0x89,	/* 3470: Avbu! */
	0xF1,0x42,0x24,0xFB,0x75,0x21,0x89,0x23,	/* 3478: B$u!# */
	0xFB,0x72,0x23,0x4F,0x24,0xF6,0x70,0x26,	/* 3480: r#O$p& */
	0xE9,0x71,0x81,0x2F,0x4F,0x24,0xF6,0x25,	/* 3488: q.O$% */
	0xFA,0xD1,0x41,0xF9,0x21,0xA2,0x40,0xD1,	/* 3490: A!@ */
	0x74,0x30,0xAA,0x74,0x30,0x27,0x2F,0x2F,	/* 3498: t0t0'.. */
	0x4F,0x24,0xF6,0xD4,0x03,0x28,0x40,0xD4,	/* 34A0: O$.(@ */
	0x73,0xC0,0x21,0xA0,0x74,0x76,0x30,0xF4,	/* 34A8: s!tv0 */
	0xC0,0x69,0x28,0xA5,0x71,0x76,0x31,0xF4,	/* 34B0: i(qv1 */
	0xA3,0x69,0x27,0x0D,0x74,0x76,0xE0,0x71,	/* 34B8: i'.tvq */
	0x76,0xE1,0xBC,0x22,0xF0,0x76,0xF6,0x80,	/* 34C0: v"v */
	0x20,0x4A,0x08,0x71,0x23,0x5A,0xD2,0x60,	/* 34C8:  J.q#Z` */
	0x44,0x21,0xFB,0x72,0x41,0x24,0xFA,0x22,	/* 34D0: D!rA$" */
	0xF0,0x60,0xBF,0x73,0x31,0x21,0x20,0x20,	/* 34D8: `s1!   */
	0x40,0x24,0xFB,0x25,0xFA,0xD0,0x21,0x40,	/* 34E0: @$%!@ */
	0x24,0xF6,0x21,0xA2,0x70,0x61,0x4F,0x24,	/* 34E8: $!paO$ */
	0xF6,0x3D,0x2F,0x4F,0x24,0xF6,0x23,0xF2,	/* 34F0: =.O$# */
	0x41,0x24,0xF0,0xB1,0x22,0xF0,0x70,0x61,	/* 34F8: A$"pa */
	0x4F,0x24,0xF6,0x3D,0x2F,0x4F,0x24,0xF6,	/* 3500: O$=.O$ */
	0x23,0xF2,0x41,0x24,0xF1,0xB1,0x22,0xF0,	/* 3508: #A$" */
	0x60,0xBE,0x74,0x31,0x21,0x20,0x20,0x40,	/* 3510: `t1!  @ */
	0x24,0xFB,0xD1,0x74,0x32,0x27,0x2F,0x2F,	/* 3518: $t2'.. */
	0x4F,0x24,0xF6,0xD0,0x75,0x41,0xF4,0xAF,	/* 3520: O$uA */
	0x74,0x8F,0xF1,0x23,0xF2,0x70,0x52,0xF1,	/* 3528: t#pR */
	0x24,0xF6,0x70,0x52,0x23,0xFB,0x0C,0x70,	/* 3530: $pR#.p */
	0x52,0xF1,0x74,0x8F,0xF1,0x24,0xFB,0x70,	/* 3538: Rt$p */
	0x52,0x23,0xFB,0x70,0x52,0xF1,0x23,0xF2,	/* 3540: R#pR# */
	0x71,0x6F,0x40,0x24,0xF6,0x28,0x40,0x24,	/* 3548: qo@$(@$ */
	0xFB,0xE0,0xB2,0x22,0xF0,0x60,0xB8,0x7A,	/* 3550: "`z */
	0x31,0x21,0x20,0x20,0x40,0x24,0xFB,0xD2,	/* 3558: 1!  @$ */
	0x7A,0x55,0xF1,0xD4,0x7A,0x8B,0xF1,0xD6,	/* 3560: zUz */
	0x74,0x76,0xFC,0x2F,0x4F,0x24,0xF6,0xD7,	/* 3568: tv.O$ */
	0x7C,0x30,0xD3,0x7A,0x22,0x81,0xF1,0xD5,	/* 3570: |0z" */
	0x40,0xD1,0x24,0x40,0x72,0xE2,0x72,0x33,	/* 3578: @$@rr3 */
	0x2F,0x4F,0x24,0xF6,0x7A,0x22,0x83,0xF1,	/* 3580: .O$z" */
	0x24,0xF6,0x25,0xFA,0xD0,0xC0,0x23,0xAD,	/* 3588: $%# */
	0x7B,0x28,0x40,0x24,0xF6,0x23,0xA6,0x75,	/* 3590: {(@$#u */
	0x41,0x24,0xF6,0xA4,0x41,0xD1,0x22,0x0D,	/* 3598: A$A". */
	0x75,0x42,0x24,0xF6,0x21,0xA4,0x7A,0x21,	/* 35A0: uB$!z! */
	0x89,0xF1,0x41,0x24,0xFB,0x7A,0x21,0x89,	/* 35A8: A$z! */
	0x23,0xFB,0x41,0x79,0x21,0xE1,0x41,0xD1,	/* 35B0: #Ay!A */
	0x21,0x03,0x74,0xD1,0x74,0x81,0xD4,0x40,	/* 35B8: !.tt@ */
	0x71,0x2F,0x4F,0x24,0xF6,0x7A,0x2B,0x50,	/* 35C0: q.O$z+P */
	0xF2,0x23,0xFB,0x41,0xD1,0x73,0x42,0x24,	/* 35C8: #AsB$ */
	0xF6,0x26,0xAF,0x73,0x44,0x24,0xF6,0xAE,	/* 35D0: &sD$ */
	0x73,0x41,0x24,0xF6,0xC0,0x21,0xAB,0x7A,	/* 35D8: sA$!z */
	0x58,0xF1,0x70,0xF4,0x21,0xA4,0x7A,0x58,	/* 35E0: Xp!zX */
	0xF1,0x70,0xF4,0xC0,0x23,0xA6,0x7A,0x21,	/* 35E8: p#z! */
	0x81,0xF1,0x70,0xF4,0x22,0xAE,0x41,0xD1,	/* 35F0: p"A */
	0x22,0x0A,0x73,0x60,0x4B,0x24,0xF6,0x25,	/* 35F8: ".s`K$% */
	0xFA,0xD3,0x24,0x25,0x40,0x24,0xF6,0xC0,	/* 3600: $%@$ */
	0xAA,0x7A,0x31,0x21,0x20,0x20,0x40,0x24,	/* 3608: z1!  @$ */
	0xFB,0x7A,0xE1,0x7A,0x58,0xF1,0x70,0xF4,	/* 3610: zzXp */
	0xA9,0x7A,0x21,0x81,0xF1,0x70,0xF4,0xC0,	/* 3618: z!p */
	0xA3,0x20,0x41,0xD1,0x7A,0x21,0x81,0xF1,	/* 3620:  Az! */
	0x70,0xF4,0xC0,0x21,0xA5,0x71,0xC0,0x21,	/* 3628: p!q! */
	0xA1,0x73,0x44,0x24,0xFB,0xD3,0x7A,0x31,	/* 3630: sD$z1 */
	0x61,0x2F,0x2F,0x4F,0x24,0xF6,0x7A,0xE1,	/* 3638: a..O$z */
	0x41,0xD1,0x7B,0x27,0x40,0x24,0xF6,0x26,	/* 3640: A{'@$& */
	0xA4,0x71,0xC0,0x26,0xA0,0x73,0x67,0x20,	/* 3648: q&sg  */
	0x20,0x40,0x24,0xF6,0x25,0xA7,0x75,0x48,	/* 3650:  @$%uH */
	0x24,0xF6,0xA5,0x20,0x41,0xD1,0x27,0x0D,	/* 3658: $ A'. */
	0x75,0x44,0x24,0xF6,0x23,0xA2,0x2F,0x4F,	/* 3660: uD$#.O */
	0x74,0x2F,0x4F,0x24,0xF6,0x7A,0x2B,0x50,	/* 3668: t.O$z+P */
	0xF2,0x23,0xFB,0x40,0x74,0x81,0x2F,0x4F,	/* 3670: #@t.O */
	0x24,0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,	/* 3678: $z+P# */
	0x74,0x81,0x81,0x25,0xFA,0xD1,0x81,0xD4,	/* 3680: t%с */
	0x70,0x71,0x2F,0x4F,0x24,0xF6,0x7A,0x2B,	/* 3688: pq.O$z+ */
	0x50,0xF2,0x23,0xFB,0x41,0xD1,0x24,0x05,	/* 3690: P#A$. */
	0x74,0xD1,0x74,0x81,0xD4,0x40,0x71,0x2F,	/* 3698: tt@q. */
	0x4F,0x24,0xF6,0x7A,0x2B,0x50,0xF2,0x23,	/* 36A0: O$z+P# */
	0xFB,0x41,0xD1,0x23,0x00,0x70,0x2F,0x4F,	/* 36A8: A#.p.O */
	0xF4,0xC0,0x22,0xA9,0x75,0x44,0x24,0xF6,	/* 36B0: "uD$ */
	0x22,0xA3,0x2F,0x4F,0x74,0x2F,0x4F,0x24,	/* 36B8: ".Ot.O$ */
	0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,0x74,	/* 36C0: z+P#t */
	0x81,0x25,0xFA,0xD1,0x81,0xD4,0x2F,0x4F,	/* 36C8: %с.O */
	0x71,0x2F,0x4F,0x24,0xF6,0x7A,0x2B,0x50,	/* 36D0: q.O$z+P */
	0xF2,0x23,0xFB,0x41,0xD1,0x71,0xC0,0x22,	/* 36D8: #Aq" */
	0xA6,0x41,0x74,0x76,0xFC,0x2F,0x4F,0x24,	/* 36E0: Atv.O$ */
	0xF6,0x2F,0x4E,0xF0,0x24,0xFF,0xF0,0xC0,	/* 36E8: .N$ */
	0x21,0xA5,0x74,0xD1,0x74,0x81,0xD4,0x70,	/* 36F0: !ttp */
	0x71,0x2F,0x4F,0x24,0xF6,0x7A,0x2B,0x50,	/* 36F8: q.O$z+P */
	0xF2,0x23,0xFB,0x41,0x79,0x21,0xE2,0x72,	/* 3700: #Ay!r */
	0x31,0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xDB,	/* 3708: 1.O$% */
	0x41,0x24,0xF6,0xA3,0x61,0x26,0x01,0x2C,	/* 3710: A$a&., */
	0x40,0x77,0xF9,0x25,0xAB,0x41,0x74,0x76,	/* 3718: @w%Atv */
	0xFC,0x2F,0x4F,0x24,0xF6,0x2B,0x4F,0x24,	/* 3720: .O$+O$ */
	0xFF,0xF0,0xC0,0x24,0xAB,0x73,0x48,0x24,	/* 3728: $sH$ */
	0xF6,0x24,0xA5,0x7A,0x21,0x58,0xF1,0x48,	/* 3730: $z!XH */
	0x24,0xF6,0x21,0xAE,0x73,0x22,0x40,0x24,	/* 3738: $!s"@$ */
	0xF6,0xA8,0x73,0x64,0x4F,0x24,0xF6,0xD3,	/* 3740: sdO$ */
	0x21,0x00,0x73,0x2D,0x40,0x24,0xFB,0xD3,	/* 3748: !.s-@$ */
	0x7A,0x31,0x61,0x2F,0x2F,0x4F,0x24,0xF6,	/* 3750: z1a..O$ */
	0x7A,0xE1,0x7A,0x23,0x81,0xF1,0x28,0x40,	/* 3758: zz#(@ */
	0x24,0xF6,0x21,0xA4,0x29,0x40,0x72,0xE2,	/* 3760: $!)@r */
	0x73,0x21,0x40,0x24,0xFB,0xD3,0x7A,0x31,	/* 3768: s!@$z1 */
	0x61,0x2F,0x2F,0x4F,0x24,0xF6,0x7A,0xE1,	/* 3770: a..O$z */
	0x74,0x7A,0x55,0x23,0xFB,0x73,0x7C,0xE0,	/* 3778: tzU#s| */
	0xB8,0x22,0xF0,0x60,0xB8,0x79,0x23,0x5C,	/* 3780: "`y#\ */
	0xD5,0x21,0x28,0x40,0xD1,0x71,0x21,0x37,	/* 3788: !(@q!7 */
	0x25,0xFA,0xD1,0x57,0xF1,0x25,0xFA,0xD0,	/* 3790: %W% */
	0xAC,0x70,0x75,0xFA,0x30,0xD0,0x71,0x79,	/* 3798: pu0qy */
	0x25,0x24,0x9D,0x61,0xA8,0x71,0x31,0x25,	/* 37A0: %$aq1% */
	0xFA,0xD2,0x21,0x20,0x20,0x40,0x24,0xF6,	/* 37A8: !  @$ */
	0x27,0xAB,0x72,0x31,0x2F,0x4F,0x24,0xF6,	/* 37B0: 'r1.O$ */
	0x25,0xFA,0xD3,0x44,0x24,0xF6,0x25,0xAA,	/* 37B8: %D$% */
	0x71,0x56,0xF1,0xD0,0x71,0x8D,0xF1,0x70,	/* 37C0: qVqp */
	0xF4,0x25,0xFA,0xD6,0x24,0xAC,0x70,0x71,	/* 37C8: %$pq */
	0x23,0x50,0xF2,0xF1,0x72,0xE3,0x70,0x41,	/* 37D0: #PrpA */
	0xF2,0x71,0x56,0x23,0xFB,0x76,0x23,0x4F,	/* 37D8: qV#v#O */
	0x24,0xF6,0xC0,0x23,0xA5,0x76,0x2F,0x4F,	/* 37E0: $#v.O */
	0x24,0xF6,0x2C,0x40,0xF4,0x22,0xA2,0x76,	/* 37E8: $,@"v */
	0x2F,0x4F,0x24,0xF6,0x24,0x40,0xF4,0xC0,	/* 37F0: .O$$@ */
	0x22,0xA0,0x71,0x34,0x28,0x20,0x40,0x24,	/* 37F8: "q4( @$ */
	0xF6,0x21,0xA7,0x71,0x34,0x68,0x2F,0x4F,	/* 3800: !q4h.O */
	0x24,0xF6,0x71,0xE4,0x41,0x75,0x62,0xE5,	/* 3808: $qAub */
	0x09,0x71,0x34,0x28,0x20,0x40,0x24,0xFB,	/* 3810: .q4( @$ */
	0x71,0xE4,0x73,0x41,0x24,0xF6,0x21,0x25,	/* 3818: qsA$!% */
	0xA7,0x71,0x54,0xD0,0x73,0x71,0x79,0x62,	/* 3820: qTsqyb */
	0x22,0x9B,0x21,0x24,0x0B,0x71,0x34,0xD4,	/* 3828: "!$.q4 */
	0x72,0x21,0x20,0x20,0x40,0x24,0xFB,0x25,	/* 3830: r!  @$% */
	0xFA,0xD2,0x31,0x2F,0x4F,0x24,0xF6,0x25,	/* 3838: 1.O$% */
	0xFA,0xD3,0x44,0x24,0xF6,0x2C,0xA7,0x74,	/* 3840: D$,t */
	0x24,0x40,0x24,0xF6,0x22,0xA9,0x74,0x28,	/* 3848: $@$"t( */
	0x40,0x24,0xF6,0x21,0xA5,0x71,0x21,0x83,	/* 3850: @$!q! */
	0xF1,0x72,0xE3,0x74,0x22,0x40,0x24,0xFB,	/* 3858: rt"@$ */
	0x25,0xFA,0xD4,0x6C,0x4F,0x24,0xF6,0xD4,	/* 3860: %lO$ */
	0x2A,0x04,0x71,0x59,0xF1,0x72,0xE3,0x74,	/* 3868: *.qYrt */
	0x67,0x4F,0x24,0xF6,0xD4,0x29,0x07,0x74,	/* 3870: gO$).t */
	0x44,0x24,0xF6,0xC0,0x29,0xA0,0x71,0x56,	/* 3878: D$)qV */
	0xF1,0xD0,0x71,0x8D,0xF1,0x70,0xF4,0x25,	/* 3880: qp% */
	0xFA,0xD6,0x28,0xA2,0x70,0x71,0x23,0x50,	/* 3888: (pq#P */
	0xF2,0xF1,0x25,0xFA,0xD7,0x4A,0xF4,0xC0,	/* 3890: %J */
	0x22,0xAB,0x74,0x24,0x20,0x40,0x24,0xF6,	/* 3898: "t$ @$ */
	0x22,0xA3,0x74,0x21,0x20,0x40,0x24,0xF6,	/* 38A0: "t! @$ */
	0x21,0xA0,0x77,0x72,0xE3,0x74,0x61,0x2F,	/* 38A8: !wrta. */
	0x4F,0x24,0xF6,0xD4,0x70,0x41,0xF2,0xD0,	/* 38B0: O$pA */
	0x21,0x02,0x4D,0x72,0xE3,0x74,0x21,0x20,	/* 38B8: !.Mrt!  */
	0x40,0x24,0xFB,0xD4,0x07,0x77,0x72,0xE3,	/* 38C0: @$.wr */
	0x70,0x41,0xF2,0xD0,0x70,0x71,0x56,0x23,	/* 38C8: pApqV# */
	0xFB,0x76,0x23,0x4F,0x24,0xF6,0xC0,0x23,	/* 38D0: v#O$# */
	0xA5,0x76,0x2F,0x4F,0x24,0xF6,0x2C,0x40,	/* 38D8: v.O$,@ */
	0xF4,0x22,0xA2,0x76,0x2F,0x4F,0x24,0xF6,	/* 38E0: "v.O$ */
	0x24,0x40,0xF4,0xC0,0x22,0xA0,0x71,0x34,	/* 38E8: $@"q4 */
	0x28,0x20,0x40,0x24,0xF6,0x21,0xA7,0x71,	/* 38F0: ( @$!q */
	0x34,0x68,0x2F,0x4F,0x24,0xF6,0x71,0xE4,	/* 38F8: 4h.O$q */
	0x41,0x75,0x62,0xE5,0x09,0x71,0x34,0x28,	/* 3900: Aub.q4( */
	0x20,0x40,0x24,0xFB,0x71,0xE4,0x73,0x41,	/* 3908:  @$qsA */
	0x24,0xF6,0xA8,0x14,0xD0,0x73,0x71,0x79,	/* 3910: $.sqy */
	0x63,0x23,0x9A,0x74,0x21,0x40,0x24,0xF6,	/* 3918: c#t!@$ */
	0x25,0xA3,0x41,0x71,0x55,0xF1,0x71,0x8B,	/* 3920: %AqUq */
	0xF1,0xFC,0x2F,0x4F,0x24,0xF6,0x24,0x40,	/* 3928: .O$$@ */
	0xF0,0x24,0xFF,0xF0,0xC0,0x23,0xAE,0x74,	/* 3930: $#t */
	0x28,0x40,0x24,0xF6,0xA6,0x74,0x6C,0x4F,	/* 3938: (@$tlO */
	0x24,0xF6,0xD4,0x74,0x22,0x40,0x24,0xF6,	/* 3940: $t"@$ */
	0xA6,0x74,0x24,0x40,0x24,0xFB,0xD4,0x71,	/* 3948: t$@$q */
	0x23,0x81,0xF1,0x28,0x40,0x24,0xF6,0xA4,	/* 3950: #(@$ */
	0x28,0x40,0x72,0xE2,0x74,0x61,0x4F,0x24,	/* 3958: (@rtaO$ */
	0xF6,0x25,0xFA,0xD4,0x24,0x24,0x44,0x24,	/* 3960: %$$D$ */
	0xF6,0xC0,0xAA,0x71,0x31,0x21,0x20,0x20,	/* 3968: q1!   */
	0x40,0x24,0xFB,0x71,0xE1,0x74,0x71,0xE4,	/* 3970: @$qtq */
	0x61,0x21,0x02,0x60,0xBD,0x75,0x31,0x21,	/* 3978: a!.`u1! */
	0x20,0x20,0x40,0x24,0xFB,0xD1,0x75,0x34,	/* 3980:   @$u4 */
	0x25,0xFA,0xD2,0xD0,0x75,0x21,0x8F,0xF1,	/* 3988: %u! */
	0xA7,0x40,0x75,0x21,0x8F,0x23,0xFB,0x07,	/* 3990: @u!#. */
	0x71,0x31,0x48,0x24,0xF6,0x27,0xA4,0x75,	/* 3998: q1H$'u */
	0x57,0xF1,0x48,0xF4,0xC0,0x22,0xA0,0x75,	/* 39A0: WH"u */
	0x5A,0xF1,0x75,0x23,0x81,0xF1,0xF4,0xC0,	/* 39A8: Zu# */
	0x21,0xA5,0x75,0x21,0x85,0xF1,0x75,0x21,	/* 39B0: !u!u! */
	0x59,0xF1,0xF4,0xC0,0xAA,0x75,0x5B,0xF1,	/* 39B8: Yu[ */
	0x75,0x22,0x8D,0xF1,0xF4,0x23,0xA0,0x21,	/* 39C0: u"#! */
	0x4A,0x71,0xE2,0x75,0x5A,0xF1,0x71,0xE0,	/* 39C8: JquZq */
	0x75,0x21,0x85,0xF1,0x71,0xE0,0x75,0x5B,	/* 39D0: u!qu[ */
	0xF1,0x71,0xE1,0x75,0x5A,0xF1,0x75,0x23,	/* 39D8: quZu# */
	0x81,0x23,0xFB,0x75,0x21,0x85,0xF1,0x75,	/* 39E0: #u!u */
	0x21,0x59,0x23,0xFB,0x75,0x5B,0xF1,0x75,	/* 39E8: !Y#u[u */
	0x22,0x8D,0x23,0xFB,0x45,0x71,0xE2,0x75,	/* 39F0: "#Equ */
	0x21,0x87,0xF1,0x41,0x24,0xF6,0xAF,0x70,	/* 39F8: !A$p */
	0x21,0x40,0x24,0xF6,0x21,0xA1,0x75,0x5A,	/* 3A00: !@$!uZ */
	0xF1,0x28,0x40,0x24,0xF6,0xA9,0x29,0x40,	/* 3A08: (@$)@ */
	0x71,0xE2,0x08,0x40,0xB3,0x22,0xF0,0x28,	/* 3A10: q.@"( */
	0x40,0x71,0xE2,0x75,0x21,0x87,0xF1,0x42,	/* 3A18: @qu!B */
	0x24,0xF6,0xA7,0x41,0x75,0x74,0x65,0x2E,	/* 3A20: $Aute. */
	0x97,0x06,0x40,0x75,0x74,0x65,0x2E,0x90,	/* 3A28: .@ute. */
	0x40,0x75,0x21,0x89,0x23,0xFB,0x75,0x21,	/* 3A30: @u!#u! */
	0x8B,0xF1,0x75,0x58,0x23,0xFB,0x75,0x21,	/* 3A38: uX#u! */
	0x8D,0xF1,0x75,0x59,0x23,0xFB,0x75,0x5E,	/* 3A40: uY#u^ */
	0xF1,0x75,0x21,0x81,0x23,0xFB,0x75,0x5F,	/* 3A48: u!#u_ */
	0xF1,0x75,0x21,0x83,0x23,0xFB,0x75,0x21,	/* 3A50: u!#u! */
	0x50,0xF1,0x75,0x22,0x81,0x23,0xFB,0x75,	/* 3A58: Pu"#u */
	0x21,0x51,0xF1,0x75,0x22,0x83,0x23,0xFB,	/* 3A60: !Qu"# */
	0x75,0x5D,0xF1,0x75,0x21,0x58,0x23,0xFB,	/* 3A68: u]u!X# */
	0x70,0x60,0x44,0x24,0xF6,0xD0,0x75,0x5D,	/* 3A70: p`D$u] */
	0xF1,0x42,0x24,0xF6,0xA5,0x70,0x42,0x24,	/* 3A78: B$pB$ */
	0xFB,0xD0,0x75,0x5D,0xF1,0x48,0x24,0xF6,	/* 3A80: u]H$ */
	0xA5,0x70,0x48,0x24,0xFB,0xD0,0x75,0x5D,	/* 3A88: pH$u] */
	0xF1,0x41,0x24,0xF6,0xA5,0x70,0x41,0x24,	/* 3A90: A$pA$ */
	0xFB,0xD0,0x70,0x25,0x2B,0x2F,0x4F,0x24,	/* 3A98: p%+.O$ */
	0xF6,0xD0,0x75,0x5D,0xF1,0x44,0x24,0xF6,	/* 3AA0: u]D$ */
	0xA7,0x70,0x24,0x20,0x40,0x24,0xFB,0xD0,	/* 3AA8: p$ @$ */
	0x75,0x5D,0xF1,0x22,0x40,0x24,0xF6,0xA8,	/* 3AB0: u]"@$ */
	0x70,0x22,0x20,0x20,0x40,0x24,0xFB,0xD0,	/* 3AB8: p"  @$ */
	0x75,0x5D,0xF1,0x28,0x40,0x24,0xF6,0xA8,	/* 3AC0: u](@$ */
	0x70,0x67,0x20,0x20,0x40,0x24,0xFB,0xD0,	/* 3AC8: pg  @$ */
	0x75,0x5A,0xF1,0x28,0x40,0x24,0xF6,0xA5,	/* 3AD0: uZ(@$ */
	0x70,0x48,0x24,0xFB,0xD0,0x75,0x5D,0xF1,	/* 3AD8: pH$u] */
	0x24,0x40,0x24,0xF6,0xA5,0x70,0x48,0x24,	/* 3AE0: $@$pH$ */
	0xFB,0xD0,0x72,0x24,0x20,0x40,0x24,0xF6,	/* 3AE8: r$ @$ */
	0xAF,0x70,0x24,0x20,0x40,0x24,0xF6,0xC0,	/* 3AF0: p$ @$ */
	0xA7,0x70,0x61,0x2F,0x4F,0x24,0xF6,0xD0,	/* 3AF8: pa.O$ */
	0x72,0x42,0x24,0xF6,0xAC,0x70,0x42,0x24,	/* 3B00: rB$pB$ */
	0xF6,0xC0,0xA6,0x70,0x60,0x4B,0x24,0xF6,	/* 3B08: p`K$ */
	0xD0,0x75,0x23,0x81,0xF1,0x28,0x40,0x24,	/* 3B10: u#(@$ */
	0xF6,0xA5,0x70,0x48,0x24,0xFB,0xD0,0x70,	/* 3B18: pH$p */
	0x24,0x25,0x44,0x24,0xF6,0xAB,0x75,0x31,	/* 3B20: $%D$u1 */
	0x61,0x2F,0x2F,0x4F,0x24,0xF6,0x75,0xE1,	/* 3B28: a..O$u */
	0x0A,0x75,0x31,0x21,0x20,0x20,0x40,0x24,	/* 3B30: .u1!  @$ */
	0xFB,0x75,0xE1,0x22,0x44,0x75,0x5C,0x23,	/* 3B38: u"Du\# */
	0xFB,0x75,0x57,0xF1,0x44,0xF4,0xA6,0x40,	/* 3B40: uWD@ */
	0x75,0x57,0x23,0xFB,0x03,0x75,0x74,0x9B,	/* 3B48: uW#.ut */
	0x70,0x75,0xE4,0x41,0x74,0x21,0xE1,0x40,	/* 3B50: puAt!@ */
	0xB3,0x22,0xF0,0x72,0x71,0x66,0x27,0x99,	/* 3B58: "rqf' */
	0x44,0x24,0xF6,0xAA,0x40,0x72,0x57,0x23,	/* 3B60: D$@rW# */
	0xFB,0x41,0x71,0x21,0xE1,0x05,0x46,0x72,	/* 3B68: Aq!.Fr */
	0x57,0x23,0xFB,0x40,0x22,0xF0,0x60,0xBF,	/* 3B70: W#@"` */
	0x73,0x31,0x21,0x20,0x20,0x40,0x24,0xFB,	/* 3B78: s1!  @$ */
	0xD0,0x73,0x8D,0xF1,0x73,0x56,0xF1,0xF4,	/* 3B80: ssV */
	0xC0,0xAF,0x70,0x30,0x2F,0x4F,0x24,0xF6,	/* 3B88: p0.O$ */
	0xA8,0x73,0x72,0x23,0x95,0x40,0xB1,0x22,	/* 3B90: sr#@" */
	0xF0,0x41,0xB1,0x22,0xF0,0x26,0x40,0x72,	/* 3B98: A"&@r */
	0x31,0x21,0x20,0x20,0x40,0x24,0xFB,0xE2,	/* 3BA0: 1!  @$ */
	0x21,0x42,0x72,0x57,0x23,0xFB,0x40,0x22,	/* 3BA8: !BrW#@" */
	0xF0,0x27,0x45,0x72,0x31,0x21,0x20,0x20,	/* 3BB0: 'Er1!   */
	0x40,0x24,0xFB,0xE2,0x40,0x72,0x57,0x23,	/* 3BB8: @$@rW# */
	0xFB,0x40,0x22,0xF0,0x40,0x22,0xF0,0x40,	/* 3BC0: @"@"@ */
	0x22,0xF0,0x60,0xBF,0x73,0x31,0x21,0x20,	/* 3BC8: "`s1!  */
	0x20,0x40,0x24,0xFB,0xD0,0x40,0x73,0x56,	/* 3BD0:  @$@sV */
	0x23,0xFB,0x40,0x73,0x8D,0x23,0xFB,0x40,	/* 3BD8: #@s#@ */
	0x73,0x8B,0x23,0xFB,0x40,0x73,0x55,0x23,	/* 3BE0: s#@sU# */
	0xFB,0x73,0x21,0x59,0xF1,0x21,0x40,0x24,	/* 3BE8: s!Y!@$ */
	0xF6,0xAA,0x73,0x21,0x59,0xF1,0x61,0x4F,	/* 3BF0: s!YaO */
	0x24,0xF6,0x70,0xE0,0x70,0x31,0x48,0x24,	/* 3BF8: $pp1H$ */
	0xF6,0x23,0xAB,0x73,0x21,0x87,0xF1,0x41,	/* 3C00: #s!A */
	0x24,0xF6,0xC0,0xA4,0x29,0x40,0x70,0xE2,	/* 3C08: $)@p */
	0x73,0x21,0x87,0xF1,0x42,0x24,0xF6,0xC0,	/* 3C10: s!B$ */
	0xA6,0x40,0x73,0x72,0x67,0x2F,0x91,0x40,	/* 3C18: @srg.@ */
	0x73,0xE4,0x23,0x40,0x70,0xE2,0x22,0x40,	/* 3C20: s#@p"@ */
	0x70,0xE2,0x41,0x73,0x21,0x8F,0x23,0xFB,	/* 3C28: pAs!# */
	0x21,0x40,0x73,0x57,0x23,0xFB,0x41,0x72,	/* 3C30: !@sW#Ar */
	0x21,0xE1,0x40,0xB1,0x22,0xF0,0x40,0xB1,	/* 3C38: !@"@ */
	0x22,0xF0,0x72,0x34,0x46,0x24,0xF6,0x46,	/* 3C40: "r4F$F */
	0xF4,0xC0,0x21,0xAB,0x72,0x34,0x60,0x4B,	/* 3C48: !r4`K */
	0x24,0xF6,0x72,0xE4,0x72,0x34,0x24,0x25,	/* 3C50: $rr4$% */
	0x40,0x24,0xF6,0xC0,0xAA,0x72,0x31,0x21,	/* 3C58: @$r1! */
	0x20,0x20,0x40,0x24,0xFB,0x72,0xE1,0x40,	/* 3C60:   @$r@ */
	0x72,0x57,0x23,0xFB,0x41,0x71,0x21,0xE1,	/* 3C68: rW#Aq! */
	0x40,0x22,0xF0,0x60,0xBF,0x73,0x31,0x21,	/* 3C70: @"`s1! */
	0x20,0x20,0x40,0x24,0xFB,0xD0,0x73,0x8D,	/* 3C78:   @$s */
	0xF1,0x73,0x56,0x23,0xFB,0x73,0x34,0x68,	/* 3C80: sV#s4h */
	0x2F,0x4F,0x24,0xF6,0x73,0xE4,0x73,0x21,	/* 3C88: .O$ss! */
	0x59,0xF1,0x21,0x40,0x24,0xF6,0x21,0xA1,	/* 3C90: Y!@$! */
	0x73,0x72,0x67,0x23,0x9C,0x42,0x24,0xF6,	/* 3C98: srg#B$ */
	0xC0,0xA7,0x23,0x40,0x70,0xE2,0x44,0x70,	/* 3CA0: #@pDp */
	0xE2,0x73,0x72,0x66,0x95,0x40,0xB1,0x22,	/* 3CA8: srf@" */
	0xF0,0x72,0x8B,0xF1,0x72,0x55,0x23,0xFB,	/* 3CB0: rrU# */
	0x40,0x72,0x57,0x23,0xFB,0x41,0x71,0x21,	/* 3CB8: @rW#Aq! */
	0xE1,0x40,0x22,0xF0,0x72,0x34,0x42,0x24,	/* 3CC0: @"r4B$ */
	0xF6,0x21,0xA1,0x72,0x34,0x44,0x24,0xFB,	/* 3CC8: !r4D$ */
	0x72,0xE4,0x72,0x31,0x61,0x2F,0x2F,0x4F,	/* 3CD0: rr1a..O */
	0x24,0xF6,0x72,0xE1,0x40,0x72,0x57,0x23,	/* 3CD8: $r@rW# */
	0xFB,0x41,0x71,0x21,0xE1,0x40,0x22,0xF0,	/* 3CE0: Aq!@" */
	0x40,0x72,0x57,0x23,0xFB,0x40,0x22,0xF0,	/* 3CE8: @rW#@" */
	0x74,0xF6,0x20,0x1D,0x00,0x1B,0x00,0x19,	/* 3CF0: t ..... */
	0x00,0x17,0x00,0x15,0x00,0x13,0x00,0x11,	/* 3CF8: ........ */
	0x00,0x0F,0x00,0x0D,0x00,0x0B,0x00,0x09,	/* 3D00: ........ */
	0x00,0x07,0x00,0x05,0x00,0x03,0x00,0x01,	/* 3D08: ........ */
	0x00,0x00,0x00,0xF4,0x00,0x71,0x23,0x5C,	/* 3D10: ....q#\ */
	0xD2,0x63,0x4B,0x21,0xFB,0x72,0x21,0xEE,	/* 3D18: cK!r! */
	0x65,0x40,0x21,0xFB,0x72,0x21,0xEC,0x67,	/* 3D20: e@!r!g */
	0x46,0x21,0xFB,0x72,0x21,0xEA,0x6B,0x41,	/* 3D28: F!r!kA */
	0x21,0xFB,0x72,0x21,0xE8,0x6F,0x49,0x21,	/* 3D30: !r!oI! */
	0xFB,0x72,0x21,0xE6,0x61,0x28,0x49,0x21,	/* 3D38: r!a(I! */
	0xFB,0x72,0x21,0xE4,0x61,0x27,0x4E,0x21,	/* 3D40: r!a'N! */
	0xFB,0x72,0x21,0xE2,0x61,0x27,0x43,0x21,	/* 3D48: r!a'C! */
	0xFB,0x72,0x21,0xE0,0x61,0x25,0x48,0x21,	/* 3D50: r!a%H! */
	0xFB,0x72,0xEE,0x61,0x23,0x4D,0x21,0xFB,	/* 3D58: ra#M! */
	0x72,0xEC,0x61,0x20,0x4F,0x21,0xFB,0x72,	/* 3D60: ra O!r */
	0xEA,0x63,0x20,0x4D,0x21,0xFB,0x72,0xE8,	/* 3D68: c M!r */
	0x62,0x2E,0x46,0x21,0xFB,0x72,0xE6,0x64,	/* 3D70: b.F!rd */
	0x2F,0x4F,0x21,0xFB,0x72,0xE4,0x64,0x2F,	/* 3D78: .O!rd. */
	0x48,0x21,0xFB,0x72,0xE2,0x72,0x69,0x49,	/* 3D80: H!rriI */
	0x21,0xFB,0x21,0x40,0x27,0x21,0x94,0x22,	/* 3D88: !!@'!" */
	0xF0,0x60,0xBF,0x72,0x3A,0xD0,0x72,0x3A,	/* 3D90: `r:r: */
	0x72,0x3B,0x72,0x3B,0x26,0x2B,0x96,0x72,	/* 3D98: r;r;&+r */
	0x72,0x3B,0xD2,0xD3,0xB1,0x60,0xB8,0x79,	/* 3DA0: r;ӱ`y */
	0x25,0x5B,0xD5,0x7A,0x37,0x7A,0x35,0xF4,	/* 3DA8: %[z7z5 */
	0x75,0x21,0xEB,0x7A,0x37,0x75,0x21,0xEC,	/* 3DB0: u!z7u! */
	0x7A,0x3D,0x75,0x21,0xEF,0x7A,0x3C,0x75,	/* 3DB8: z=u!z<u */
	0x22,0xE0,0x41,0x75,0x22,0xE3,0x24,0x20,	/* 3DC0: "Au"$  */
	0x40,0x75,0x22,0xE4,0x7A,0x75,0x21,0xEE,	/* 3DC8: @u"zu! */
	0x75,0x21,0x55,0x79,0x2B,0x26,0x9E,0xC0,	/* 3DD0: u!Uy+& */
	0x22,0xA5,0x21,0xFE,0x75,0xEE,0x22,0xF2,	/* 3DD8: "!u" */
	0x75,0xED,0x75,0x16,0x44,0x24,0xFA,0x24,	/* 3DE0: uu.D$$ */
	0xF2,0xD0,0x24,0xF2,0xD1,0x40,0xD2,0x24,	/* 3DE8: $@$ */
	0xF2,0xD3,0x40,0xD4,0x16,0x41,0x79,0x63,	/* 3DF0: @.Ayc */
	0x27,0x21,0x90,0x79,0x2C,0x20,0x98,0xB8,	/* 3DF8: '!y,  */
	0x22,0xF0,0x20,0x00,0x20,0x01,0x00,0xD4,	/* 3E00: " . .. */
	0x01,0x71,0x25,0x5B,0xD2,0x60,0x42,0x21,	/* 3E08: .q%[`B! */
	0xFB,0x72,0xE0,0x72,0x61,0x4D,0x21,0xFB,	/* 3E10: rraM! */
	0x41,0x26,0x28,0x97,0x22,0xF0,0x20,0x74,	/* 3E18: A&(" t */
	0xD1,0x23,0x2F,0x05,0x74,0xD1,0x24,0x21,	/* 3E20: #..t$! */
	0x0C,0x11,0x72,0x42,0x23,0x2E,0x9A,0x71,	/* 3E28: ..rB#.q */
	0x22,0xF0,0x40,0xD1,0x11,0x72,0x41,0x23,	/* 3E30: "@.rA# */
	0x2D,0x9F,0x71,0x2F,0x4F,0x24,0xF6,0x22,	/* 3E38: -q.O$" */
	0xF0,0x13,0x72,0x42,0x23,0x2F,0x9E,0x22,	/* 3E40: .rB#." */
	0xF0,0x13,0x72,0x41,0x23,0x2F,0x96,0x22,	/* 3E48: .rA#." */
	0xF0,0x60,0xBE,0x73,0x26,0x3E,0xD0,0x40,	/* 3E50: `s&>@ */
	0xD1,0x73,0x27,0x36,0x24,0xF2,0xF4,0x21,	/* 3E58: s'6$! */
	0xA4,0x73,0x27,0x36,0x74,0xF9,0xC0,0xAD,	/* 3E60: s'6t */
	0x74,0x73,0x27,0x37,0xF9,0xC0,0xA6,0x41,	/* 3E68: ts'7A */
	0x47,0x73,0x2B,0x2B,0x9A,0x70,0x24,0xF2,	/* 3E70: Gs++p$ */
	0xF4,0x21,0xAB,0x70,0x32,0x74,0xF9,0xC0,	/* 3E78: !p2t */
	0xA9,0x70,0x33,0x70,0x32,0xF2,0x74,0xF9,	/* 3E80: p3p2t */
	0xC0,0xAA,0x70,0x30,0xD0,0x70,0x24,0xF2,	/* 3E88: p0p$ */
	0xF4,0xA4,0x61,0x07,0x41,0xD1,0x71,0xA6,	/* 3E90: a.Aq */
	0x41,0x47,0x73,0x2B,0x29,0x91,0xB2,0x22,	/* 3E98: AGs+)" */
	0xF0,0x60,0xBF,0x11,0xD0,0x72,0x26,0x3E,	/* 3EA0: `.r&> */
	0x24,0xF2,0xF4,0xC0,0x21,0xA0,0x21,0x25,	/* 3EA8: $!!% */
	0x46,0x21,0xFB,0x72,0x28,0xE0,0x22,0x26,	/* 3EB0: F!r("& */
	0x45,0x21,0xFB,0x72,0x28,0xE1,0x75,0x72,	/* 3EB8: E!r(ur */
	0x67,0x9F,0x76,0xA8,0x77,0x23,0xF4,0x21,	/* 3EC0: gvw#! */
	0x50,0x76,0xF9,0xA4,0x41,0xB1,0x22,0xF0,	/* 3EC8: PvA" */
	0x77,0x81,0xD7,0x73,0x24,0xF2,0xF4,0x26,	/* 3ED0: ws$& */
	0xAB,0x75,0x73,0xE2,0x76,0x73,0xE3,0x76,	/* 3ED8: usvsv */
	0x73,0x32,0xF5,0x60,0x5D,0x77,0x23,0xF4,	/* 3EE0: s2`]w# */
	0xFC,0x73,0xE4,0x74,0x73,0x34,0x60,0xEF,	/* 3EE8: sts4` */
	0x74,0x73,0xE6,0x2A,0x27,0x4B,0x21,0xFB,	/* 3EF0: ts*'K! */
	0x73,0x34,0xE0,0x70,0x31,0x73,0x34,0xE1,	/* 3EF8: s4p1s4 */
	0x73,0x73,0x34,0xE2,0x40,0xD0,0x77,0x60,	/* 3F00: ss4@w` */
	0x8F,0x40,0xF9,0x21,0xA5,0x70,0x18,0xFA,	/* 3F08: @!p. */
	0x30,0x70,0x83,0x73,0x34,0xFA,0xE0,0x70,	/* 3F10: 0ps4p */
	0x81,0xD0,0x77,0x60,0x8F,0x70,0xF9,0xA2,	/* 3F18: w`p */
	0x61,0x0B,0x77,0x73,0xE5,0x24,0xF2,0x81,	/* 3F20: a.ws$ */
	0x73,0xE7,0x72,0x25,0x5D,0x72,0x2D,0x99,	/* 3F28: sr%]r- */
	0x72,0x26,0x3E,0x73,0xE0,0x73,0x72,0x26,	/* 3F30: r&>ssr& */
	0xEE,0x72,0x25,0x5D,0x72,0x21,0x2E,0x90,	/* 3F38: r%]r!. */
	0x40,0xB1,0x22,0xF0,0x41,0xB1,0x22,0xF0,	/* 3F40: @"A" */
	0x60,0xBE,0x73,0x25,0x5D,0xD1,0x71,0x73,	/* 3F48: `s%]qs */
	0x2B,0x97,0x74,0x71,0x21,0x31,0xF4,0xAD,	/* 3F50: +tq!1 */
	0x71,0x21,0x31,0xD0,0x70,0x30,0x24,0xF2,	/* 3F58: q!1p0$ */
	0xF4,0x22,0xA2,0x21,0x00,0x71,0x21,0x31,	/* 3F60: "!.q!1 */
	0x30,0x71,0x21,0xE1,0x71,0x73,0x21,0x2A,	/* 3F68: 0q!qs!* */
	0x9F,0x40,0xB2,0x22,0xF0,0x70,0x30,0x74,	/* 3F70: @"p0t */
	0xF4,0xAB,0x70,0x30,0xD0,0x70,0x30,0x24,	/* 3F78: p0p0$ */
	0xF2,0xF4,0xA2,0x60,0x00,0x70,0x30,0x24,	/* 3F80: `.p0$ */
	0xF2,0xF4,0xAD,0x74,0x30,0x70,0xE0,0x71,	/* 3F88: t0pq */
	0x73,0x21,0x28,0x9C,0x40,0xB2,0x22,0xF0,	/* 3F90: s!(@" */
	0x71,0x73,0x21,0x28,0x93,0x41,0xB2,0x22,	/* 3F98: qs!(A" */
	0xF0,0x72,0x71,0x65,0x93,0xA6,0x41,0x48,	/* 3FA0: rqeAH */
	0x71,0x2A,0x28,0x93,0x22,0xF0,0x72,0x71,	/* 3FA8: q*("rq */
	0x66,0x96,0xA6,0x41,0x48,0x71,0x2A,0x27,	/* 3FB0: fAHq*' */
	0x96,0x72,0x71,0x23,0x2F,0x9D,0x22,0xF0,	/* 3FB8: rq#." */
	0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,	/* 3FC0: ........ */
	0x00,0x00,0x00,0x00,0x01,0x0A,0x00,0x08,	/* 3FC8: ........ */
	0x00,0x07,0x00,0x05,0x00,0x04,0x00,0x02,	/* 3FD0: ........ */
	0x00,0x01,0x00,0xAE,0x02,0x71,0x25,0x5D,	/* 3FD8: ....q%] */
	0xD2,0x62,0x4B,0x21,0xFB,0x72,0x4D,0x24,	/* 3FE0: bK!rM$ */
	0xFA,0x72,0x62,0x4F,0x21,0xFB,0x47,0x24,	/* 3FE8: rbO!G$ */
	0x2B,0x91,0x22,0xF0,0x20,0x72,0x22,0xFB,	/* 3FF0: +" r" */
	0x22,0xF0,0x22,0xF2,0x72,0xF2,0xD2,0x72,	/* 3FF8: ""rr */
	0x22,0xFB,0x22,0xF0,0x21,0xF5,0x22,0xF0,	/* 4000: ""!" */
	0x20,0x60,0xB8,0x40,0xD3,0x24,0xF2,0xD0,	/* 4008:  `@$ */
	0x24,0xF2,0xD1,0x21,0xFE,0x41,0xF4,0xA2,	/* 4010: $!A */
	0x28,0x01,0x41,0xD4,0x7A,0x33,0xC1,0xA6,	/* 4018: (.Az3 */
	0x40,0x7A,0xE3,0x40,0x22,0xA0,0x24,0xF2,	/* 4020: @z@"$ */
	0x24,0xF2,0xD6,0xD7,0x7A,0x34,0x24,0xF2,	/* 4028: $z4$ */
	0xF4,0xC0,0xA8,0x16,0x16,0x7A,0xE4,0x7A,	/* 4030: ..zz */
	0xE5,0x40,0xA7,0x16,0x7A,0x35,0xE1,0x16,	/* 4038: @.z5. */
	0x7A,0xE5,0x15,0x16,0x42,0xF7,0x41,0x7A,	/* 4040: z..BAz */
	0xE9,0x41,0x7A,0x30,0x40,0x24,0xFF,0xF0,	/* 4048: Az0@$ */
	0x21,0xA1,0x41,0xD3,0x7A,0x31,0x24,0xF2,	/* 4050: !Az1$ */
	0xF4,0x21,0xA0,0x10,0x7A,0x32,0xE1,0x10,	/* 4058: !.z2. */
	0x7A,0xE2,0x0E,0x7A,0x30,0x60,0x4F,0xF2,	/* 4060: z.z0`O */
	0x7A,0xE0,0x06,0x10,0x7A,0xE1,0x10,0x7A,	/* 4068: z..z.z */
	0xE2,0x40,0x7A,0xE9,0x7A,0x3A,0x24,0xF2,	/* 4070: @zz:$ */
	0xF4,0xA5,0x14,0x7A,0x5A,0x42,0xFB,0x41,	/* 4078: .zZBA */
	0xD5,0x7A,0x34,0x24,0xF2,0xF4,0xC0,0xA5,	/* 4080: z4$ */
	0x41,0x7A,0xE3,0x40,0xAC,0x7A,0x34,0x31,	/* 4088: Az@z41 */
	0x7A,0x34,0xD6,0x7A,0xE4,0x15,0x76,0x42,	/* 4090: z4z.vB */
	0xFB,0x27,0x0B,0x7A,0x36,0xC1,0xA7,0x20,	/* 4098: '.z6  */
	0x40,0x7A,0xE6,0x40,0x22,0xA2,0x24,0xF2,	/* 40A0: @z@"$ */
	0x24,0xF2,0xD6,0xD7,0x7A,0x37,0x24,0xF2,	/* 40A8: $z7$ */
	0xF4,0xC0,0xAA,0x20,0x16,0x16,0x7A,0xE7,	/* 40B0:  ..z */
	0x7A,0xE8,0x40,0xA8,0x20,0x16,0x7A,0x38,	/* 40B8: z@ .z8 */
	0xE1,0x16,0x7A,0xE8,0x15,0x16,0x42,0xF7,	/* 40C0: .z..B */
	0x7A,0x39,0xA6,0x20,0x14,0x7A,0x5A,0x42,	/* 40C8: z9 .zZB */
	0xF7,0x41,0x7A,0x30,0x40,0x24,0xFF,0xF0,	/* 40D0: Az0@$ */
	0x21,0xA1,0x41,0xD3,0x7A,0x31,0x24,0xF2,	/* 40D8: !Az1$ */
	0xF4,0x21,0xA1,0x10,0x7A,0x32,0xE1,0x10,	/* 40E0: !.z2. */
	0x7A,0xE2,0x0F,0x7A,0x30,0x60,0x4F,0xF2,	/* 40E8: z.z0`O */
	0x7A,0xE0,0x07,0x20,0x10,0x7A,0xE1,0x10,	/* 40F0: z. .z. */
	0x7A,0xE2,0x41,0xD5,0x7A,0x37,0x24,0xF2,	/* 40F8: zAz7$ */
	0xF4,0xC0,0xA7,0x20,0x41,0x7A,0xE6,0x40,	/* 4100:  Az@ */
	0xAD,0x20,0x7A,0x37,0x31,0x7A,0x37,0xD6,	/* 4108:  z71z7 */
	0x7A,0xE7,0x15,0x76,0x42,0xFB,0x73,0xA5,	/* 4110: z.vBs */
	0x20,0x12,0x10,0x42,0xF7,0xB8,0x22,0xF0,	/* 4118:  ..B" */
	0x60,0xBB,0x41,0xD0,0x21,0xFE,0x41,0xF4,	/* 4120: `A!A */
	0xA3,0x20,0x27,0x0B,0x77,0x33,0xC1,0xA7,	/* 4128:  '.w3 */
	0x20,0x40,0x77,0xE3,0x40,0x22,0xA2,0x24,	/* 4130:  @w@"$ */
	0xF2,0x24,0xF2,0xD2,0xD3,0x77,0x34,0x24,	/* 4138: $w4$ */
	0xF2,0xF4,0xC0,0xAA,0x20,0x12,0x12,0x77,	/* 4140:  ..w */
	0xE4,0x77,0xE5,0x40,0xA8,0x20,0x12,0x77,	/* 4148: w@ .w */
	0x35,0xE1,0x12,0x77,0xE5,0x11,0x12,0x42,	/* 4150: 5.w..B */
	0xF7,0x41,0x77,0xE9,0x77,0x31,0x24,0xF2,	/* 4158: Aww1$ */
	0xF4,0xAB,0x20,0x77,0x31,0xD1,0x77,0x31,	/* 4160:  w1w1 */
	0x31,0x77,0xE1,0x09,0x20,0x77,0x30,0x41,	/* 4168: 1w. w0A */
	0xF2,0x77,0xE0,0x05,0x20,0x10,0x71,0x42,	/* 4170: w. .qB */
	0xFB,0x40,0x77,0xE9,0x77,0x3A,0x24,0xF2,	/* 4178: @ww:$ */
	0xF4,0xA6,0x20,0x10,0x77,0x5A,0x42,0xFB,	/* 4180:  .wZB */
	0x41,0xD1,0x77,0x34,0x24,0xF2,0xF4,0xC0,	/* 4188: Aw4$ */
	0xA7,0x20,0x41,0x77,0xE3,0x40,0xAD,0x20,	/* 4190:  Aw@  */
	0x77,0x34,0x31,0x77,0x34,0xD2,0x77,0xE4,	/* 4198: w41w4w */
	0x11,0x72,0x42,0xFB,0xB5,0x22,0xF0,0x77,	/* 41A0: .rB"w */
	0x36,0xC1,0xA7,0x20,0x40,0x77,0xE6,0x40,	/* 41A8: 6 @w@ */
	0x22,0xA2,0x24,0xF2,0x24,0xF2,0xD3,0xD4,	/* 41B0: "$$ */
	0x77,0x37,0x24,0xF2,0xF4,0xC0,0xAA,0x20,	/* 41B8: w7$  */
	0x13,0x13,0x77,0xE7,0x77,0xE8,0x40,0xA8,	/* 41C0: ..ww@ */
	0x20,0x13,0x77,0x38,0xE1,0x13,0x77,0xE8,	/* 41C8:  .w8.w */
	0x12,0x13,0x42,0xF7,0x77,0x39,0xA6,0x20,	/* 41D0: ..Bw9  */
	0x11,0x77,0x5A,0x42,0xF7,0x77,0x31,0x24,	/* 41D8: .wZBw1$ */
	0xF2,0xF4,0xAB,0x20,0x77,0x31,0xD2,0x77,	/* 41E0:  w1w */
	0x31,0x31,0x77,0xE1,0x09,0x20,0x77,0x30,	/* 41E8: 11w. w0 */
	0x41,0xF2,0x77,0xE0,0x05,0x20,0x10,0x72,	/* 41F0: Aw. .r */
	0x42,0xFB,0x41,0xD2,0x77,0x37,0x24,0xF2,	/* 41F8: BAw7$ */
	0xF4,0xC0,0xA7,0x20,0x41,0x77,0xE6,0x40,	/* 4200:  Aw@ */
	0xAD,0x20,0x77,0x37,0x31,0x77,0x37,0xD3,	/* 4208:  w71w7 */
	0x77,0xE7,0x12,0x73,0x42,0xFB,0xB5,0x22,	/* 4210: w.sB" */
	0xF0,0x60,0xBF,0x22,0xF9,0x41,0x73,0x24,	/* 4218: `"As$ */
	0xF6,0x21,0xA5,0x72,0xD0,0x74,0x73,0x60,	/* 4220: !rts` */
	0x8F,0x10,0x25,0xF5,0x21,0x93,0x70,0x72,	/* 4228: .%!pr */
	0xF4,0xC0,0x41,0x24,0xFD,0x25,0xF5,0x04,	/* 4230: A$%. */
	0x74,0x73,0x72,0xF7,0x22,0xF9,0xB1,0x22,	/* 4238: tsr"" */
	0xF0,0x27,0x22,0x06,0x20,0x22,0xF9,0x41,	/* 4240: '". "A */
	0x72,0x24,0xF6,0xA9,0x73,0x72,0x60,0x8F,	/* 4248: r$sr` */
	0x71,0x25,0xF5,0x99,0x04,0x73,0x72,0x71,	/* 4250: q%.srq */
	0xFB,0x22,0xF9,0x22,0xF0,0x27,0x20,0x03,	/* 4258: ""' . */
	0x20,0x01,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,	/* 4260:  .. */
	0xFF,0xEF,0x7F,0x00,0x00,0x00,0x00,0x00,	/* 4268: ..... */
	0x00,0x00,0x00,0x0F,0x27,0x02,0x04,0x15,	/* 4270: ....'... */
	0x00,0x14,0x00,0x12,0x00,0x11,0x00,0x10,	/* 4278: ........ */
	0x00,0x0F,0x00,0x0E,0x00,0x0C,0x00,0x06,	/* 4280: ........ */
	0x00,0x66,0x00,0x71,0x26,0x58,0xD2,0x61,	/* 4288: .f.q&Xa */
	0x43,0x21,0xFB,0x72,0x22,0x8F,0x41,0x24,	/* 4290: C!r"A$ */
	0xFA,0x63,0x44,0x21,0xFB,0x72,0x82,0x21,	/* 4298: cD!r! */
	0x45,0x24,0xFA,0x72,0x63,0x4F,0x21,0xFB,	/* 42A0: E$rcO! */
	0x49,0x21,0x2F,0x97,0x22,0xF0,0x20,0x73,	/* 42A8: I!." s */
	0x72,0xE0,0x24,0xF2,0x72,0xE1,0x41,0x72,	/* 42B0: r$rAr */
	0xE3,0x24,0xF2,0x72,0xE4,0x41,0x72,0xE6,	/* 42B8: $rAr */
	0x24,0xF2,0x72,0xE7,0x40,0x72,0xE9,0x24,	/* 42C0: $r@r$ */
	0xF2,0x72,0xEA,0x22,0xF0,0x41,0x72,0x30,	/* 42C8: r"Ar0 */
	0x40,0x24,0xFF,0xF0,0xA8,0x40,0x21,0x4B,	/* 42D0: @$@!K */
	0xD2,0xD3,0x27,0x25,0x02,0x72,0x30,0x60,	/* 42D8: '%.r0` */
	0x4F,0xF2,0x72,0xE0,0x22,0xF0,0x72,0x30,	/* 42E0: Or"r0 */
	0x41,0xF2,0x72,0xE0,0x22,0xF0,0x20,0x46,	/* 42E8: Ar" F */
	0x01,0x71,0x28,0x50,0xD2,0x61,0x4D,0x21,	/* 42F0: .q(PaM! */
	0xFB,0x72,0xE1,0x63,0x4E,0x21,0xFB,0x72,	/* 42F8: rcN!r */
	0xE0,0x22,0xF0,0x60,0xBA,0x78,0x24,0xF2,	/* 4300: "`x$ */
	0xF4,0x24,0xA2,0x78,0x60,0x5E,0xD1,0x78,	/* 4308: $x`^x */
	0x41,0x24,0xF6,0xC0,0x22,0xA1,0x77,0x27,	/* 4310: A$"w' */
	0x3A,0x71,0xF9,0xC0,0x21,0xA9,0x77,0x27,	/* 4318: :q!w' */
	0x3C,0x71,0xF9,0x21,0xA2,0x71,0x30,0x24,	/* 4320: <q!q0$ */
	0xF2,0x81,0xF4,0xC0,0xAA,0x71,0x31,0x60,	/* 4328: q1` */
	0x4C,0x24,0xF6,0x71,0x31,0xF4,0xA6,0x41,	/* 4330: L$q1A */
	0x44,0x77,0x26,0x2F,0x92,0x77,0x28,0x52,	/* 4338: Dw&.w(R */
	0x25,0xFA,0xD4,0x30,0x25,0xFA,0xD5,0xD0,	/* 4340: %0% */
	0x77,0x28,0x33,0xD2,0x06,0xB6,0x22,0xF0,	/* 4348: w(3." */
	0x70,0x30,0xD0,0x70,0x72,0xF4,0xA7,0x71,	/* 4350: p0prq */
	0x70,0x30,0xF9,0xA2,0x60,0x02,0x70,0x30,	/* 4358: p0`.p0 */
	0x25,0xFA,0xD3,0x75,0xF4,0xA7,0x71,0x71,	/* 4360: %uqq */
	0x31,0xF2,0x73,0xF4,0xA5,0x73,0x71,0xE0,	/* 4368: 1ssq */
	0x21,0x06,0x73,0x72,0xF4,0xC0,0xA4,0x20,	/* 4370: !.sr  */
	0x71,0x74,0xE1,0x70,0x30,0x31,0x71,0x31,	/* 4378: qtp01q1 */
	0xF2,0x71,0xE1,0x70,0x30,0x30,0x71,0xE0,	/* 4380: qp00q */
	0x70,0x70,0x31,0xF2,0x71,0xF4,0x21,0xA0,	/* 4388: pp1q! */
	0x71,0x70,0xE0,0x71,0x30,0x74,0x30,0xF4,	/* 4390: qpq0t0 */
	0xC0,0x21,0xA7,0x71,0x74,0xE1,0x21,0x02,	/* 4398: !qt!. */
	0x71,0x31,0x70,0x31,0xF2,0x70,0xE1,0x71,	/* 43A0: q1p1pq */
	0x30,0x70,0xE0,0x70,0x30,0x74,0x30,0xF4,	/* 43A8: 0pp0t0 */
	0xA4,0x20,0xB6,0x22,0xF0,0x70,0x74,0xE1,	/* 43B0:  "pt */
	0xB6,0x22,0xF0,0x60,0xBE,0x73,0x28,0x52,	/* 43B8: "`s(R */
	0xD0,0x70,0x32,0x21,0xA8,0x70,0x60,0x3E,	/* 43C0: p2!p`> */
	0xD1,0x70,0x53,0x73,0x21,0x92,0x74,0x73,	/* 43C8: pSs!ts */
	0x6C,0x91,0x70,0x60,0x3F,0xD1,0x70,0x53,	/* 43D0: lp`?pS */
	0x73,0x96,0xB2,0x22,0xF0,0xB2,0x22,0xF0,	/* 43D8: s"" */
	0x75,0xF6,0x20,0x60,0xBE,0x73,0x28,0x52,	/* 43E0: u `s(R */
	0xD0,0x70,0x5E,0x25,0xFA,0x25,0xFA,0xD1,	/* 43E8: p^%% */
	0xE0,0x71,0x70,0xE0,0x71,0x70,0xE1,0x40,	/* 43F0: qpqp@ */
	0x71,0xE1,0x41,0x70,0x53,0x73,0x61,0x2A,	/* 43F8: qApSsa* */
	0x9E,0x74,0x70,0x60,0xEA,0x75,0x74,0xF2,	/* 4400: tp`ut */
	0x70,0x60,0xEB,0x41,0x70,0xE2,0x76,0xA8,	/* 4408: p`Apv */
	0x40,0x70,0x60,0xE3,0x74,0x70,0x60,0xE8,	/* 4410: @p`tp` */
	0xB2,0x22,0xF0,0x40,0x71,0x28,0xE4,0x22,	/* 4418: "@q(" */
	0xF0,0x0E,0x00,0x0D,0x00,0x0B,0x00,0x0A,	/* 4420: ....... */
	0x00,0x08,0x00,0x07,0x00,0x05,0x00,0x04,	/* 4428: ........ */
	0x00,0x01,0x00,0x00,0x00,0x6A,0x00,0x71,	/* 4430: .....j.q */
	0x28,0x52,0xD2,0x72,0x61,0x41,0x21,0xFB,	/* 4438: (RraA! */
	0x4A,0x26,0x90,0x22,0xF0,0x00,0x00,0x00,	/* 4440: J&"... */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 4448: ........ */
	0x00,0x00,0x00,0x00,0x00,0x60,0xBE,0x41,	/* 4450: .....`A */
	0x75,0x76,0x24,0xFF,0xF0,0x21,0xA7,0x74,	/* 4458: uv$!t */
	0xD0,0x75,0x74,0xF2,0xD1,0x71,0x70,0xF9,	/* 4460: utqp */
	0x21,0xA0,0x40,0x70,0xE0,0x70,0x51,0xD0,	/* 4468: !@ppQ */
	0x71,0x70,0xF9,0xA6,0x60,0x04,0x41,0xB2,	/* 4470: qp`.A */
	0x22,0xF0,0x73,0x21,0x9C,0xD0,0x70,0x30,	/* 4478: "s!p0 */
	0xAF,0x70,0x30,0x70,0xF2,0xD0,0x70,0x51,	/* 4480: p0ppQ */
	0xD1,0x73,0x99,0x70,0x30,0xA2,0x60,0x01,	/* 4488: sp0`. */
	0x40,0xB2,0x22,0xF0,0x75,0xF6,0x20,0xEA,	/* 4490: @"u  */
	0xC0,0x60,0x4A,0x21,0xFB,0x22,0xF0,0x7E,	/* 4498: `J!"~ */
	0x02,0x22,0xF0,0x71,0x60,0x8F,0xD1,0x71,	/* 44A0: ."q`q */
	0x60,0x4F,0xF9,0x21,0xA4,0x24,0xF2,0x71,	/* 44A8: `O!$q */
	0x72,0xFA,0x30,0x73,0xFA,0xE0,0x71,0x60,	/* 44B0: r0sq` */
	0x8F,0xD1,0x71,0x60,0x4F,0xF9,0xA2,0x61,	/* 44B8: q`Oa */
	0x0C,0x22,0xF0,0x60,0xB4,0x7D,0x29,0x52,	/* 44C0: ."`})R */
	0xD0,0x7E,0x7F,0x24,0xFB,0xAE,0x1E,0x2E,	/* 44C8: ~$.. */
	0x44,0x21,0xFB,0x23,0x2F,0x92,0xAB,0x60,	/* 44D0: D!#.` */
	0x4F,0xBC,0x22,0xF0,0x70,0x61,0x3A,0xBC,	/* 44D8: O"pa: */
	0x22,0xF0,0x40,0x7E,0x41,0x23,0xF7,0xD8,	/* 44E0: "@~A# */
	0x7F,0x40,0x23,0xF7,0xD9,0x78,0x60,0x4E,	/* 44E8: @#x`N */
	0x24,0xF6,0xD6,0x79,0xD7,0x2C,0x42,0x21,	/* 44F0: $y,B! */
	0xFB,0x16,0x14,0x22,0x24,0x9B,0x70,0x61,	/* 44F8: .."$pa */
	0x3E,0xDA,0x70,0x7D,0x21,0x2F,0x92,0x10,	/* 4500: >p}!.. */
	0xD3,0x70,0x61,0x33,0x21,0xA8,0x70,0x61,	/* 4508: pa3!pa */
	0x34,0x73,0xF9,0xC0,0xA6,0x73,0x70,0x61,	/* 4510: 4sspa */
	0x35,0xF9,0xA5,0x70,0x61,0x32,0xD1,0x02,	/* 4518: 5pa2. */
	0x73,0xD1,0x71,0x69,0x5A,0xD1,0x70,0x61,	/* 4520: sqiZpa */
	0x3A,0xD2,0x70,0x61,0x3B,0x21,0xFD,0xDA,	/* 4528: :pa;! */
	0xDB,0x70,0x61,0x3A,0x21,0xFD,0xD8,0xD9,	/* 4530: pa:! */
	0x40,0x7A,0x78,0x24,0xFF,0xD6,0x7B,0x79,	/* 4538: @zx${y */
	0x24,0xFF,0xD7,0x16,0x1E,0x23,0x28,0x90,	/* 4540: $..#( */
	0xC0,0x22,0xAA,0x70,0x61,0x3B,0x24,0xF2,	/* 4548: "pa;$ */
	0xF4,0x22,0xA2,0x70,0x61,0x33,0x22,0xAB,	/* 4550: "pa3" */
	0x71,0x21,0xFD,0xD8,0xD9,0x70,0x61,0x3A,	/* 4558: q!pa: */
	0x21,0xFD,0xD6,0xD7,0x40,0x78,0x76,0x24,	/* 4560: !@xv$ */
	0xFF,0xDA,0x79,0x77,0x24,0xFF,0xDB,0x1A,	/* 4568: yw$. */
	0x1E,0x23,0x25,0x94,0xAE,0x70,0x61,0x3F,	/* 4570: .#%pa? */
	0xD6,0x70,0x7D,0x21,0x27,0x9D,0x60,0x4F,	/* 4578: p}!'`O */
	0xBC,0x22,0xF0,0x75,0x74,0x41,0x23,0xF6,	/* 4580: "utA# */
	0xDA,0xDB,0x70,0x61,0x3A,0x21,0xFD,0xD6,	/* 4588: pa:! */
	0xD7,0x40,0x7A,0x76,0x23,0xF7,0xD8,0x7B,	/* 4590: @zv#{ */
	0x77,0x23,0xF7,0xD9,0x78,0x70,0x61,0xEA,	/* 4598: w#xpa */
	0x70,0x61,0x33,0xA6,0x70,0x61,0x3A,0x70,	/* 45A0: pa3pa:p */
	0x61,0xE4,0x70,0x61,0x3F,0xD6,0x70,0x7D,	/* 45A8: apa?p} */
	0x21,0x24,0x98,0x72,0xBC,0x22,0xF0,0x00,	/* 45B0: !$r". */
	0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x60,	/* 45B8: .......` */
	0xBD,0x75,0xD2,0x41,0x74,0x27,0x3F,0x75,	/* 45C0: uAt'?u */
	0x24,0xFF,0xF0,0xC0,0xA4,0x74,0x27,0x3F,	/* 45C8: $t'? */
	0xD5,0x75,0xD0,0x40,0x25,0xFA,0xD1,0x70,	/* 45D0: u@%p */
	0x74,0x61,0x2E,0x97,0x25,0xFA,0xD0,0x60,	/* 45D8: ta.%` */
	0x4F,0xF4,0xC0,0x22,0xA2,0x41,0x75,0x72,	/* 45E0: O"Aur */
	0x24,0xFF,0xF0,0xA5,0x24,0xF2,0xB3,0x22,	/* 45E8: $$" */
	0xF0,0x72,0x25,0xFA,0xD5,0xD0,0x40,0x25,	/* 45F0: r%@% */
	0xFA,0xD1,0x70,0x74,0x61,0x2C,0x94,0x25,	/* 45F8: pta,% */
	0xFA,0xD0,0x60,0x4F,0xF4,0x22,0xA4,0x75,	/* 4600: `O"u */
	0x70,0xE1,0x74,0x28,0x52,0x25,0xFA,0xD2,	/* 4608: pt(R% */
	0x31,0x25,0xFA,0x25,0xFA,0xD1,0x31,0xF2,	/* 4610: 1%%1 */
	0x70,0xF4,0x21,0xA4,0x70,0x71,0xE0,0x70,	/* 4618: p!pqp */
	0x72,0xE1,0x72,0x30,0x72,0x31,0xE0,0x70,	/* 4620: rr0r1p */
	0xB3,0x22,0xF0,0x24,0xF2,0xB3,0x22,0xF0,	/* 4628: "$" */
	0x75,0x71,0x31,0xF2,0x71,0xE1,0x72,0x31,	/* 4630: uq1qr1 */
	0xB3,0x22,0xF0,0x60,0xBB,0x40,0xD1,0x77,	/* 4638: "`@w */
	0x21,0xAB,0x77,0x52,0x60,0x4D,0xF4,0x60,	/* 4640: !wR`M` */
	0x4C,0x24,0xF6,0xD7,0x76,0x28,0x52,0x25,	/* 4648: L$v(R% */
	0xFA,0xD2,0x30,0x25,0xFA,0xD3,0x30,0xD0,	/* 4650: 0%0 */
	0x71,0xC0,0x25,0xAB,0x05,0x24,0xF2,0xB5,	/* 4658: q%.$ */
	0x22,0xF0,0x70,0x72,0x30,0xF4,0x23,0xAA,	/* 4660: "pr0# */
	0x41,0x77,0x70,0x31,0x24,0xFF,0xF0,0x22,	/* 4668: Awp1$" */
	0xAB,0x70,0x31,0x77,0xF4,0xAF,0x70,0x31,	/* 4670: p1wp1 */
	0x77,0xF4,0x70,0xE1,0x70,0x70,0x31,0xF2,	/* 4678: wppp1 */
	0xD0,0x77,0x70,0xE1,0x04,0x70,0x30,0x73,	/* 4680: wp.p0s */
	0xE0,0x24,0xF2,0x81,0x70,0xE0,0x70,0x72,	/* 4688: $ppr */
	0x31,0xF4,0xC0,0xA3,0x73,0x72,0xE1,0x70,	/* 4690: 1srp */
	0x52,0xD4,0x41,0xD1,0x70,0xD3,0x70,0x30,	/* 4698: RApp0 */
	0xD0,0x0B,0x77,0x76,0x6E,0x99,0x25,0xFA,	/* 46A0: .wvn% */
	0xD0,0x24,0xF2,0xF4,0xA5,0x71,0xC0,0xA7,	/* 46A8: $q */
	0x64,0x00,0x24,0xF2,0xB5,0x22,0xF0,0x74,	/* 46B0: d.$"t */
	0xB5,0x22,0xF0,0x60,0xBD,0x74,0x29,0x52,	/* 46B8: "`t)R */
	0xD1,0x71,0x60,0x32,0xC0,0x21,0xA1,0x71,	/* 46C0: q`2!q */
	0x61,0x3C,0x22,0xA8,0x40,0xD0,0x71,0x61,	/* 46C8: a<"@qa */
	0x39,0x71,0x61,0x38,0x74,0x62,0x20,0x9B,	/* 46D0: 9qa8tb  */
	0x71,0x61,0x3E,0xD0,0x71,0x60,0x53,0x74,	/* 46D8: qa>q`St */
	0x21,0x9B,0x75,0x74,0x6A,0x95,0xD0,0x71,	/* 46E0: !utjq */
	0x61,0x3F,0xD2,0x71,0x60,0x53,0x74,0x9F,	/* 46E8: a?q`St */
	0x70,0xB3,0x22,0xF0,0x24,0xF2,0xB3,0x22,	/* 46F0: p"$" */
	0xF0,0x7E,0xF6,0x7A,0xF6,0x74,0xF6,0x76,	/* 46F8: ~ztv */
	0xF6,0x01,0x00,0x00,0x00,0x00,0x00,0x01,	/* 4700: ....... */
	0x00,0x00,0x00,0x00,0x00,0x01,0x20,0x0A,	/* 4708: ...... . */
	0x00,0x08,0x00,0x07,0x00,0x05,0x00,0x04,	/* 4710: ........ */
	0x00,0x02,0x00,0x01,0x00,0xFE,0x02,0x71,	/* 4718: ......q */
	0x29,0x52,0xD2,0x62,0x4A,0x21,0xFB,0x72,	/* 4720: )RbJ!r */
	0x4D,0x24,0xFA,0x72,0x62,0x4F,0x21,0xFB,	/* 4728: M$rbO! */
	0x47,0x62,0x26,0x9F,0x22,0xF0,0x20,0x20,	/* 4730: Gb&"   */
	0x60,0xBB,0x78,0xD0,0x77,0x11,0x13,0x23,	/* 4738: `xw..# */
	0x94,0x11,0x76,0x44,0x24,0xFA,0xB5,0x22,	/* 4740: .vD$" */
	0xF0,0x60,0xBB,0x77,0x30,0x77,0x31,0x24,	/* 4748: `w0w1$ */
	0xF2,0xF4,0x24,0xFB,0xC0,0x21,0xA0,0x78,	/* 4750: $!x */
	0x30,0x60,0x4F,0xF4,0x78,0x31,0x60,0x4F,	/* 4758: 0`Ox1`O */
	0xF4,0x24,0xFB,0xC0,0xA2,0x21,0xF0,0x78,	/* 4760: $!x */
	0xD0,0x77,0x13,0x11,0x98,0x11,0x76,0x44,	/* 4768: w...vD */
	0x24,0xFA,0xB5,0x22,0xF0,0x60,0xB4,0x40,	/* 4770: $"`@ */
	0xDA,0x40,0xDB,0x24,0xF2,0x7F,0x31,0x24,	/* 4778: @$1$ */
	0xF6,0x21,0xA3,0x41,0xDA,0x40,0x40,0x7F,	/* 4780: !A@@ */
	0x30,0x24,0xFF,0xD8,0xD1,0x71,0x40,0x7F,	/* 4788: 0$q@ */
	0x31,0x24,0xFF,0xD9,0xD1,0x08,0x40,0xDA,	/* 4790: 1$.@ */
	0x7F,0x30,0xD8,0x7F,0x31,0xD9,0x24,0xF2,	/* 4798: 01$ */
	0x21,0x70,0x31,0x24,0xF6,0x21,0xA6,0x7A,	/* 47A0: !p1$!z */
	0xC0,0xDB,0x40,0x40,0x21,0x70,0x30,0x24,	/* 47A8: @@!p0$ */
	0xFF,0xD6,0xD1,0x71,0x40,0x21,0x70,0x31,	/* 47B0: q@!p1 */
	0x24,0xFF,0xD7,0xD1,0x0A,0x7A,0xDB,0x21,	/* 47B8: $.z! */
	0x70,0x30,0xD6,0x21,0x70,0x31,0xD7,0x16,	/* 47C0: p0!p1. */
	0xD0,0x18,0x12,0x14,0x22,0x9D,0x7B,0xAE,	/* 47C8: ..."{ */
	0x40,0x40,0x74,0x24,0xFF,0xD4,0xD1,0x71,	/* 47D0: @@t$q */
	0x40,0x75,0x24,0xFF,0xD5,0xD1,0x7A,0xAE,	/* 47D8: @u$z */
	0x40,0x40,0x72,0x24,0xFF,0xD2,0xD1,0x71,	/* 47E0: @@r$q */
	0x40,0x73,0x24,0xFF,0xD3,0xD1,0x14,0x7D,	/* 47E8: @s$.} */
	0x44,0x24,0xFA,0x12,0x7E,0x44,0x24,0xFA,	/* 47F0: D$.~D$ */
	0xBC,0x22,0xF0,0x60,0xB6,0x7E,0x30,0xC0,	/* 47F8: "`~0 */
	0xA8,0x7E,0x31,0xC0,0xA4,0x21,0xF0,0x2B,	/* 4800: ~1!+ */
	0x0B,0x7E,0x31,0xC0,0x21,0xAA,0x40,0x7D,	/* 4808: .~1!@} */
	0x31,0x7E,0x30,0x21,0xFA,0x7B,0xE1,0xD2,	/* 4810: 1~0!{ */
	0x72,0x7D,0x30,0x7E,0x30,0x21,0xFA,0x7B,	/* 4818: r}0~0!{ */
	0xE0,0x7C,0xE0,0x40,0x7C,0xE1,0x29,0x0C,	/* 4820: |@|). */
	0x7E,0x31,0x7E,0x30,0x21,0xF9,0xD4,0xD5,	/* 4828: ~1~0! */
	0xD6,0x76,0xC0,0xAA,0x40,0xD3,0x7D,0x31,	/* 4830: v@}1 */
	0xD2,0x7D,0x30,0xD1,0x21,0x01,0x40,0x7D,	/* 4838: }0!.@} */
	0x31,0x76,0x23,0xF6,0xD0,0xD3,0x7D,0x31,	/* 4840: 1v#}1 */
	0x7D,0x30,0x76,0x23,0xF6,0xD1,0xD2,0x40,	/* 4848: }0v#@ */
	0x7B,0xE1,0x73,0x75,0xF4,0xC0,0xA5,0x60,	/* 4850: {su` */
	0x4F,0x7B,0xE0,0x08,0x73,0x72,0x75,0x21,	/* 4858: O{.sru! */
	0xFA,0x7B,0xE0,0xD0,0x7B,0x30,0x24,0xA9,	/* 4860: {{0$ */
	0x40,0x74,0x7B,0x30,0x23,0xF1,0xD7,0xD8,	/* 4868: @t{0# */
	0x78,0x75,0x7B,0x30,0x23,0xF1,0xD8,0xD9,	/* 4870: xu{0# */
	0x40,0x71,0x77,0x24,0xFF,0xD1,0xD0,0x70,	/* 4878: @qw$p */
	0x72,0x78,0x24,0xFF,0xD2,0xD0,0x70,0x73,	/* 4880: rx$ps */
	0x79,0x24,0xFF,0xD3,0xD0,0x24,0xF2,0x73,	/* 4888: y$$s */
	0x24,0xF6,0x21,0xAD,0x7B,0x30,0x60,0x8F,	/* 4890: $!{0` */
	0x7B,0xE0,0x40,0x74,0x71,0x23,0xF7,0xD1,	/* 4898: {@tq# */
	0xD0,0x70,0x75,0x72,0x23,0xF7,0xD2,0xD0,	/* 48A0: pur# */
	0x70,0x40,0x73,0x23,0xF7,0xD3,0xD0,0x62,	/* 48A8: p@s#b */
	0x0C,0x76,0xC0,0xA7,0x71,0x7C,0xE0,0x72,	/* 48B0: .vq|r */
	0x7C,0xE1,0x09,0x72,0x71,0x76,0x23,0xF5,	/* 48B8: |.rqv# */
	0x7C,0xE0,0x7C,0xE1,0xBA,0x22,0xF0,0x20,	/* 48C0: ||"  */
	0x40,0xD3,0x71,0x31,0x72,0x31,0xF4,0xC0,	/* 48C8: @q1r1 */
	0xAF,0x24,0xF2,0x71,0x30,0x23,0xF3,0x24,	/* 48D0: $q0#$ */
	0xF2,0x72,0x30,0x23,0xF3,0xF9,0xD3,0x06,	/* 48D8: r0#. */
	0x71,0x31,0x72,0x31,0xF9,0xD3,0x73,0x22,	/* 48E0: q1r1s" */
	0xF0,0x60,0xBE,0x74,0xD1,0x76,0x25,0xA0,	/* 48E8: `tv% */
	0x41,0x21,0x40,0x76,0x24,0xFF,0xF0,0xA4,	/* 48F0: A!@v$ */
	0x21,0x40,0xD3,0x02,0x76,0xD3,0x40,0xD0,	/* 48F8: !@.v@ */
	0x73,0x40,0xF9,0x21,0xA0,0x75,0x70,0x74,	/* 4900: s@!upt */
	0xF2,0x23,0xFB,0x70,0x81,0xD0,0x73,0x70,	/* 4908: #psp */
	0xF9,0xA3,0x20,0x60,0x00,0x73,0xD5,0x76,	/* 4910:  `.sv */
	0x73,0xF4,0xD6,0x76,0x22,0xA2,0x41,0x75,	/* 4918: sv"Au */
	0x76,0x24,0xFF,0xF0,0xA5,0x20,0x75,0xD3,	/* 4920: v$ u */
	0x03,0x20,0x76,0xD3,0x74,0x75,0x74,0xF2,	/* 4928: . vtut */
	0x73,0x24,0xFA,0x73,0x75,0xF5,0xD5,0x76,	/* 4930: s$suv */
	0x73,0xF4,0xD6,0x76,0xA3,0x20,0x62,0x0E,	/* 4938: sv b. */
	0x71,0xB2,0x22,0xF0,0x20,0x70,0x72,0xE0,	/* 4940: q" pr */
	0x10,0x72,0xE1,0x40,0x22,0xF0,0x72,0x30,	/* 4948: .r@"r0 */
	0x72,0x31,0xE0,0x73,0xC0,0xA2,0x41,0xD3,	/* 4950: r1sA */
	0x73,0x72,0x31,0xE1,0x72,0x31,0x23,0xFC,	/* 4958: sr1r1# */
	0x71,0x22,0xF0,0x22,0xF9,0x72,0x31,0xF6,	/* 4960: q""r1 */
	0x22,0xF0,0x22,0xF9,0x72,0x31,0xF6,0x22,	/* 4968: ""r1" */
	0xF0,0x40,0x40,0x60,0xBB,0x73,0x36,0x73,	/* 4970: @@`s6s */
	0x34,0x60,0xEF,0x10,0x73,0x57,0x41,0xFB,	/* 4978: 4`.sWA */
	0x21,0xF5,0x20,0x60,0xBF,0x73,0x57,0x21,	/* 4980: ! `sW! */
	0xF2,0xD0,0x70,0x24,0xF2,0xF4,0xA4,0x40,	/* 4988: p$@ */
	0xB1,0x22,0xF0,0x41,0xB1,0x22,0xF0,0x72,	/* 4990: "A"r */
	0x71,0x61,0x98,0xA5,0x41,0x4B,0x71,0x28,	/* 4998: qaAKq( */
	0x9E,0x63,0x4E,0x21,0xFB,0x72,0x34,0xE0,	/* 49A0: cN!r4 */
	0x70,0x72,0xE1,0x72,0x34,0x21,0xFE,0x24,	/* 49A8: prr4!$ */
	0xFB,0x23,0xF9,0x22,0xF0,0x72,0x71,0x63,	/* 49B0: #"rqc */
	0x9A,0xA5,0x41,0x4B,0x71,0x27,0x90,0x64,	/* 49B8: AKq'd */
	0x40,0x21,0xFB,0x72,0x34,0xE0,0x70,0x72,	/* 49C0: @!r4pr */
	0xE1,0x72,0x34,0x60,0x4E,0x24,0xF6,0x23,	/* 49C8: r4`N$# */
	0xF9,0x22,0xF0,0x72,0x71,0x65,0x9C,0xA5,	/* 49D0: "rqe */
	0x41,0x4B,0x71,0x25,0x92,0x66,0x42,0x21,	/* 49D8: AKq%fB! */
	0xFB,0x72,0x34,0xE0,0x70,0x72,0xE1,0x72,	/* 49E0: r4prr */
	0x34,0x41,0x24,0xFB,0x23,0xF9,0x22,0xF0,	/* 49E8: 4A$#" */
	0x20,0x72,0xA5,0x72,0x71,0x27,0xE2,0x07,	/* 49F0:  rrq'. */
	0x22,0x27,0x20,0x4F,0x71,0x27,0xE2,0x72,	/* 49F8: "' Oq'r */
	0x71,0x27,0x50,0xD2,0xD3,0x6B,0x07,0x71,	/* 4A00: q'Pk.q */
	0x29,0x3D,0x24,0xF2,0xF4,0xA6,0x71,0x29,	/* 4A08: )=$q) */
	0x3D,0xD3,0x71,0x92,0x62,0x0B,0x77,0xF6,	/* 4A10: =qb.w */
	0x20,0x00,0x00,0x00,0x00,0x71,0x29,0x5D,	/* 4A18:  ....q)] */
	0xD2,0x72,0x60,0x43,0x21,0xFB,0x41,0x65,	/* 4A20: r`C!Ae */
	0x27,0x99,0x22,0xF0,0x20,0x21,0x02,0x60,	/* 4A28: '" !.` */
	0xBE,0x24,0xF2,0xD0,0x75,0xD1,0x24,0xF2,	/* 4A30: $u$ */
	0x24,0xF2,0x73,0x60,0x90,0xB2,0x22,0xF0,	/* 4A38: $s`" */
	0x20,0x25,0xF8,0x21,0xF0,0x22,0xF0,0x60,	/* 4A40:  %!"` */
	0xBA,0x40,0x21,0xFE,0xF4,0x21,0xAE,0x24,	/* 4A48: @!!$ */
	0xF2,0xD4,0x10,0xD5,0x4B,0x21,0xFB,0xD2,	/* 4A50: .K! */
	0x40,0x13,0x25,0xF2,0x23,0xF9,0x10,0x14,	/* 4A58: @.%#.. */
	0x41,0xFB,0x24,0xF3,0x11,0x41,0x24,0xF8,	/* 4A60: A$.A$ */
	0x24,0xF4,0x72,0x23,0xFC,0x79,0x7C,0x33,	/* 4A68: $r#y|3 */
	0xF2,0x7C,0xE3,0x77,0x7C,0xE6,0x78,0x7C,	/* 4A70: |w|x| */
	0xE7,0x40,0xD4,0x42,0xD5,0x74,0xC0,0xA4,	/* 4A78: @Bt */
	0x7C,0x39,0xD1,0x03,0x7C,0x3A,0xD1,0x71,	/* 4A80: |9.|:q */
	0x7A,0xF9,0x25,0xAB,0x24,0xF2,0x71,0x23,	/* 4A88: z%$q# */
	0xF3,0xD0,0x70,0x41,0x24,0xF0,0xD2,0x72,	/* 4A90: pA$r */
	0x24,0xF2,0xFA,0xD0,0x79,0x70,0x33,0xF2,	/* 4A98: $yp3 */
	0x70,0xE3,0x79,0x70,0x34,0xF2,0x70,0xE4,	/* 4AA0: pyp4p */
	0x74,0x23,0xA5,0x22,0x40,0x70,0x31,0x24,	/* 4AA8: t#"@p1$ */
	0xF6,0xC0,0x22,0xAC,0x42,0x70,0x31,0x24,	/* 4AB0: "Bp1$ */
	0xF6,0x21,0xA4,0x70,0x37,0x4A,0x21,0xFB,	/* 4AB8: !p7J! */
	0xF0,0xE0,0x70,0x34,0x70,0x37,0x23,0xFC,	/* 4AC0: p4p7# */
	0xD4,0xF6,0x70,0x23,0xFC,0x21,0x01,0x70,	/* 4AC8: p#!.p */
	0x34,0x70,0x37,0x60,0xEF,0x41,0x70,0x31,	/* 4AD0: 4p7`Ap1 */
	0x24,0xF6,0xC0,0x70,0x37,0xF2,0x23,0xF9,	/* 4AD8: $p7# */
	0x70,0x3E,0xD3,0x73,0xD1,0x65,0x00,0x14,	/* 4AE0: p>se.. */
	0x26,0x4F,0x22,0xF1,0x21,0xF5,0xB6,0x22,	/* 4AE8: &O"!" */
	0xF0,0x20,0x60,0xBA,0x77,0x3F,0xD0,0x24,	/* 4AF0:  `w?$ */
	0xF2,0x70,0x23,0xF3,0xD1,0x71,0x41,0x24,	/* 4AF8: p#qA$ */
	0xF0,0xD5,0x75,0x24,0xF2,0xFA,0xD4,0x74,	/* 4B00: u$t */
	0x39,0xD1,0x71,0x74,0x34,0xF9,0x24,0xAC,	/* 4B08: 9qt4$ */
	0x24,0xF2,0x71,0x23,0xF3,0xD0,0x70,0x41,	/* 4B10: $q#pA */
	0x24,0xF0,0xD2,0x72,0x24,0xF2,0xFA,0xD0,	/* 4B18: $r$ */
	0x22,0x40,0x70,0x31,0x24,0xF6,0xC0,0x22,	/* 4B20: "@p1$" */
	0xAC,0x42,0x70,0x31,0x24,0xF6,0x21,0xA4,	/* 4B28: Bp1$! */
	0x70,0x37,0x4A,0x21,0xFB,0xF0,0xE0,0x70,	/* 4B30: p7J!p */
	0x34,0x70,0x37,0x23,0xFC,0xD4,0xF6,0x70,	/* 4B38: 4p7#p */
	0x23,0xFC,0x21,0x01,0x70,0x34,0x70,0x37,	/* 4B40: #!.p4p7 */
	0x60,0xEF,0x41,0x70,0x31,0x24,0xF6,0xC0,	/* 4B48: `Ap1$ */
	0x70,0x37,0xF2,0x23,0xF9,0x70,0x3E,0xD3,	/* 4B50: p7#p> */
	0x73,0xD1,0x65,0x0E,0xB6,0x22,0xF0,0x64,	/* 4B58: se."d */
	0x24,0x2D,0x08,0x20,0x20,0x60,0x08      	/* 4B60: $-.  `.  */

};
int si3_t225_dsize = sizeof(si3_t225_download);		/* 0x4B67 (19303) */

unsigned short si3_t225_downloadaddr = 0x0000;

/* End of SI3_T225.C */
