/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* YIPS @(#)$Id: kmpstat.c,v 1.1.1.1.2.1.4.1 1998/10/05 08:35:00 itojun Exp $ */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>

#include <netinet/in.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "var.h"
#include "vmbuf.h"
#include "misc.h"
#include "schedule.h"
#include "isakmp.h"
#include "admin.h"
#include "debug.h"

struct admin_com com;
int port = PORT_ADMIN;
char *pname;
unsigned long debug = 0;

u_char *isakmp_pindex(isakmp_index *);

main(ac, av)
	int ac;
	char **av;
{
	int so;

	parse(ac, av);

	if ((so = Send()) < 0) exit(-1);

	Recv(so);
}

int
Send()
{
	struct sockaddr_in from, to;
	int so, len;

	if ((so = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
		perror("socket");
		goto err;
	}

	memset((char *)&from, 0, sizeof(from));
	from.sin_family = AF_INET;
	from.sin_port = htons((u_short)0);
	from.sin_addr.s_addr = htonl(0x7f000001);
	from.sin_len = sizeof(from);

	if (bind(so, (struct sockaddr *)&from, sizeof(from)) < 0) {
		perror("bind");
		goto err;
	}

	memset((char *)&to, 0, sizeof(to));
	to.sin_family = AF_INET;
	to.sin_port = htons((u_short)port);
	to.sin_addr.s_addr = htonl(0x7f000001);
	to.sin_len = sizeof(to);

	if ((len = sendto(so, (char *)&com, sizeof(com),
	                  0, (struct sockaddr *)&to, sizeof(to))) < 0) {
		perror("sendto");
		goto err;
	}

	return(so);

err:
	(void)close(so);
	return(-1);
}

int
Recv(so)
	int so;
{
	int len;
	char *recvbuf;
	struct sched *sc;
	struct isakmp_ph1 *ph1;
	int error = -1;

	if ((len = recv(so, (char *)&com, sizeof(com), MSG_PEEK)) < 0) {
		perror("recv");
		goto end;
	}

	if (len != sizeof(com)) {
		perror("invalid length");
		goto end;
	}

	if ((recvbuf = malloc(com.len)) == 0) {
		perror("malloc");
		goto end;
	}

	if ((len = recv(so, recvbuf, com.len, 0)) < 0) {
		perror("recv");
		goto end;
	}

	len -= sizeof(com);
	recvbuf += sizeof(com);

	switch (com.cmd) {
	case ADMIN_SHOW_SCHED:
		len /= sizeof(struct sched);
		sc = (struct sched *)recvbuf;

		/*      00000000 00 000000000 00 */
		printf("id       st tick      try\n");
		while (len-- > 0) {
			printf("%8s %2d %-8d %2d\n",
			    sched_pindex(&sc->index), sc->status,
			    sc->tick, sc->tick, sc->try);
			sc++;
		}
		break;

	case ADMIN_SHOW_SA:
		len /= sizeof(struct isakmp_ph1);
		ph1 = (struct isakmp_ph1 *)recvbuf;

		/*      0000000000000000:0000000000000000: 000000000 */
		printf("cookies                            ph2\n");
		while (len-- > 0) {
			printf("%s %d\n",
			    isakmp_pindex(&ph1->index), ph1->ph2tab.len);
			ph1++;
		}
		break;

	default:
		perror("unknown command");
		goto end;
	}

	error = 0;
end:
	(void)close(so);
	return(error);
}

char *command[] = {
"",
"reload",
"sched",
"sa",
""
};

Usage()
{
	printf("Usage: %s [-p (admin port)] -c (command)\n", pname);
	printf("  command: sched, sa, reload\n");
}

parse(ac, av)
	int ac;
	char **av;
{
	extern char *optarg;
	extern int optind;
	int c;
	int i;

	pname = *av;
	com.cmd = 0;

	while ((c = getopt(ac, av, "p:c:")) != EOF) {
		switch(c) {
		case 'p':
			port = atoi(optarg);
			break;

		case 'c':
			for (i = 1; strlen(command[i]) != 0; i++) {
				if (strcmp(command[i], optarg) == 0)
					com.cmd = i;
			}
			com.len = sizeof(com);
			break;

		default:
			Usage();
			exit(1);
			break;
		}
	}

	if (!com.cmd) {
		Usage();
		exit(1);
	}

	ac -= optind;
	av += optind;

	return(0);
}

u_char *
isakmp_pindex(index)
	isakmp_index *index;
{
	static char buf[64];
	u_char *p;
	int i, j;

	memset(buf, 0, sizeof(buf));

	/* copy index */
	p = (u_char *)index;
	for (j = 0, i = 0; i < sizeof(isakmp_index); i++) {
		sprintf((char *)&buf[j], "%02x", p[i]);
		j += 2;
		switch (i) {
		case 7: case 15:
			buf[j++] = ':';
		}
	}

	return(buf);
}

