/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    its contributors.
 * 4. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* YIPS @(#)$Id: pfkey.c,v 1.1.1.1.2.4.2.4 1998/09/14 11:56:34 sakane Exp $ */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>

#include <net/route.h>
#include <net/pfkeyv2.h>

#include <netinet/in.h>

#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "var.h"
#include "vmbuf.h"
#include "misc.h"
#include "schedule.h"
#include "pfkey.h"
#include "pfkey_lib.h"
#include "debug.h"

int sockP;
u_int pfkey_timer = 40;

/*
 * PF_KEY main routine
 * OUT:
 *	0: success
 *	-1: fail
 */
int
pfkey_main(buf)
	caddr_t buf;
{
	struct sadb_msg *msg = (struct sadb_msg *)buf;
	struct pfkey_st *pst;
	int error = -1;

	switch (msg->sadb_msg_type) {
	case SADB_ACQUIRE:
		if ((pst = pfkey_acquire(msg)) == 0) goto end;

		/* start isakmp initiation by using ident exchange */
		if (isakmp_pfkey(pst) < 0) goto end;
		break;

	case SADB_EXPIRE:
		if ((pst = pfkey_expire(msg)) == 0) goto end;

		/* start isakmp initiation by using ident exchange */
		if (isakmp_pfkey(pst) < 0) goto end;
		break;

	default:
		plog("pfkey_main", "command %d isn't supported.\n",
			msg->sadb_msg_type);
		goto end;
	}

end:
	return(error);
}

/*
 * PF_KEY packet handler
 */
int
pfkey_handler()
{
	caddr_t buf;
	int error = -1;

	if ((buf = (caddr_t)pfkey_recv()) == 0) {
		plog("pfkey_handler", "pfkey_recv (%s)\n", strerror(errno));
		goto end;
	}

	/* isakmp main routine */
	if (pfkey_main(buf) < 0) goto end;

	error = 0;
end:
	free(buf);
	return(error);
}

/*
 * PF_KEY initialization
 */
int
pfkey_init()
{
	if ((sockP = pfkey_open()) < 0)
		return(-1);

	if (pfkey_register(SADB_SATYPE_ESP) < 0) {
		pfkey_close();
		return(-1);
	}

	if (pfkey_register(SADB_SATYPE_AH) < 0) {
		pfkey_close();
		return(-1);
	}

	return(0);
}

