/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    its contributors.
 * 4. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* @(#)$Id: handler.h,v 1.1.1.1.2.3 1998/07/07 14:04:08 sakane Exp $ */

extern u_char *isakmp_pindex(isakmp_index *, msgid_t *);
extern void isakmp_close(void);
extern int isakmp_send(struct isakmp_ph1 *, vchar_t *);
extern int isakmp_resend_ph1(struct sched *);
extern int isakmp_timeout_ph1(struct sched *);
extern int isakmp_resend_ph2(struct sched *);
extern int isakmp_timeout_ph2(struct sched *);
extern int isakmp_expire(struct sched *);

extern struct isakmp_ph1 *isakmp_new_ph1(isakmp_index *);
extern int isakmp_free_ph1(struct isakmp_ph1 *);
extern struct isakmp_ph1 *isakmp_ph1byindex(isakmp_index *);
extern struct isakmp_ph1 *isakmp_ph1byindex0(isakmp_index *);
extern struct isakmp_ph1 *isakmp_ph1byaddr(struct sockaddr *);
extern struct isakmp_ph2 *isakmp_new_ph2(struct isakmp_ph1 *, msgid_t *);
extern int isakmp_free_ph2(struct isakmp_ph2 *);
extern struct isakmp_ph2 *isakmp_ph2bymsgid(struct isakmp_ph1 *, msgid_t *);

extern int isakmp_pfkey(struct pfkey_st *);

extern struct isakmp_conf *isakmp_cfbypeer(struct sockaddr *);
extern struct isakmp_conf *isakmp_cfbyaddr(struct sockaddr *, struct sockaddr *);

