/*
 * Copyright (C) 1998
 *	Sony Computer Science Laboratories Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY SONY CSL AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL SONY CSL OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: in_altq.h,v 1.1.6.2 1999/01/20 17:54:03 itojun Exp $
 */
#ifndef _NETINET_IN_ALTQ_H_
#define _NETINET_IN_ALTQ_H_

/*
 * flow info structure for internet protocol family.
 * (currently this is the only protocol family supported)
 */

struct flowinfo_in {
	u_char		fi_len;		/* sizeof(struct flowinfo_in) */
	u_char		fi_family;	/* AF_INET */
	u_int8_t	fi_proto;	/* IPPROTO_XXX */
	u_int8_t	fi_tos;		/* type-of-service */
	struct in_addr	fi_dst;		/* dest address */
	struct in_addr	fi_src;		/* src address */
	u_int16_t	fi_dport;	/* dest port */
	u_int16_t	fi_sport;	/* src port */
	u_int32_t	fi_gpi;		/* generalized port id for ipsec */
	u_int8_t	_pad[28];	/* unused */
};

#ifdef SIN6_LEN
struct flowinfo_in6 {
	u_char		fi_len;		/* sizeof(struct flowinfo_in6) */
	u_char		fi_family;	/* AF_INET6 */
	u_int8_t	fi_proto;	/* IPPROTO_XXX */
	u_int8_t	fi_tclass;	/* traffic class */
	u_int32_t	fi_flowlabel;	/* ipv6 flowlabel */
	u_int16_t	fi_dport;	/* dest port */
	u_int16_t	fi_sport;	/* src port */
	u_int32_t	fi_gpi;		/* generalized port id */
	struct in6_addr fi_dst;		/* dest address */
	struct in6_addr fi_src;		/* src address */
};
#endif /* INET6 */

#if defined(KERNEL) || defined(_KERNEL)
/*
 * flowinfo mask bits used by classifier
 */
/* for ipv4 */
#define FIMB4_PROTO	0x0001
#define FIMB4_TOS	0x0002
#define FIMB4_DADDR	0x0004
#define FIMB4_SADDR	0x0008
#define FIMB4_DPORT	0x0010
#define FIMB4_SPORT	0x0020
#define FIMB4_GPI	0x0040
#define FIMB4_ALL	0x007f
/* for ipv6 */
#define FIMB6_PROTO	0x0100
#define FIMB6_TCLASS	0x0200
#define FIMB6_DADDR	0x0400
#define FIMB6_SADDR	0x0800
#define FIMB6_DPORT	0x1000
#define FIMB6_SPORT	0x2000
#define FIMB6_GPI	0x4000
#define FIMB6_FLABEL	0x8000
#define FIMB6_ALL	0xff00

#define FIMB_ALL	(FIMB4_ALL|FIMB6_ALL)

#define FIMB4_PORTS	(FIMB4_DPORT|FIMB4_SPORT|FIMB4_GPI)
#define FIMB6_PORTS	(FIMB6_DPORT|FIMB6_SPORT|FIMB6_GPI)

#endif /* KERNEL */

#endif /* _NETINET_IN_ALTQ_H_ */
