/*
 * Copyright (C) 1997, 1998
 *	Sony Computer Science Laboratories Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY SONY CSL AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL SONY CSL OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: altq_afmap.h,v 1.1.6.2 1999/01/20 17:53:40 itojun Exp $
 */

#ifndef _NETINET_ALTQ_AFMAP_H_
#define _NETINET_ALTQ_AFMAP_H_

#include <sys/queue.h>

struct atm_flowmap {
	char		af_ifname[IFNAMSIZ];	/* if name, e.g. "en0" */
	u_int8_t	af_vpi;
	u_int16_t	af_vci;
	u_int32_t	af_pcr;			/* peek cell rate */
	struct flowinfo	af_flowinfo;

	/* statistics */
	u_int32_t	afs_packets;		/* total packet count */
	u_int32_t	afs_bytes;		/* total byte count */
};

/* set or get flowmap */
#define AFM_ADDFMAP	_IOWR('F', 1, struct atm_flowmap)
#define AFM_DELFMAP	_IOWR('F', 2, struct atm_flowmap)
#define AFM_CLEANFMAP	_IOWR('F', 3, struct atm_flowmap)
#define AFM_GETFMAP	_IOWR('F', 4, struct atm_flowmap)

#ifdef KERNEL

/* per flow information */
struct afm {
	LIST_ENTRY(afm) 	afm_list;
	u_int16_t		afm_vci;
	u_int8_t		afm_vpi;
	struct flowinfo_in	afm_flowinfo;

	/* statistics */
	u_int32_t		afms_packets;	/* total packet count */
	u_int32_t		afms_bytes;	/* total byte count */
};

/* per interface */
struct afm_head {
	LIST_ENTRY(afm_head) 	afh_chain;
	LIST_HEAD(, afm)	afh_head;
	struct ifnet		*afh_ifp;
};

struct afm	*afm_top __P((struct ifnet *));
int		afm_alloc __P((struct ifnet *));
int		afm_dealloc __P((struct ifnet *));
int		afm_add __P((struct ifnet *, struct atm_flowmap *));
int		afm_remove __P((struct afm *));
int		afm_removeall __P((struct ifnet *));
struct		afm *afm_lookup __P((struct ifnet *, int, int));
struct afm 	*afm_match __P((struct ifnet *, struct flowinfo *));

#endif /* KERNEL */

#endif /* _NETINET_ALTQ_AFMAP_H_ */
