/*
 * (C)opyright 1995 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include "var.h"
#include "misc.h"

#ifndef	lint
static	char	sccsid[] = "@(#)pripf.c	1.4 10/22/95 (C) 1995 Darren Reed";
#endif

extern	var_t	*varlist;


static	void	printaction(str, opt)
char	*str;
int	opt;
{
	int	bits = 0;

	if (str) {
		if (strstr(str, "block"))
			bits |= 1;
		if (strstr(str, "pass"))
			bits |= 2;
		if (strstr(str, "log"))
			bits |= 4;
		if (strstr(str, "body"))
			bits |= 8;
	}

#ifdef	DEBUG
	printf("printaction(%s,%d) = %#x\n", str, opt, bits);
#endif

	if (!(opt & 1)) {
		if (bits & 1)
				printf("block");
		else if (bits & 2)
				printf("pass");
	}
	if (opt & 2)
		printf(" quick");
	if ((!opt && ((bits & 7) == 4)) || (opt && (bits & 4))) {
		printf(" log");
		if (bits & 8)
			printf(" body");
	}
}


static	void	printopts(str)
char	*str;
{
	printf(" with");
	if (!strchr(str, ' ')) {
		printf(" %s", str);
		return;
	}
	printf(" %s", str);
}


void	printipf(lvl)
int	lvl;
{
	var_t	*v, *v2;
	char	*s;
	int	i, j, lastset = -1;

	for (i = 0; i < VA_MAX; ) {
		j = i;
		for (v = varlist; v; v = v->va_next) {
			if ((i == VA_ACTION) && v->va_action) {
				if (strchr(v->va_action, ' '))
					printaction(v->va_action, 0);
				else
					printf("%s", v->va_action);
				lastset = i++;
				break;
			}

			if ((i == VA_INOUT) && v->va_inout) {
				printf(" %s", v->va_inout);
				lastset = i++;
				break;
			}

			if ((i == VA_ON) && v->va_iface) {
				printf(" on %s", v->va_iface);
				lastset = i++;
				break;
			}

			if ((i == VA_LOG) && lvl)
				printaction(NULL, 2);
			if ((i == VA_LOG) && v->va_action) {
				printaction(v->va_action, 1);
				lastset = i++;;
			}

			if ((i == VA_PROTO) && v->va_proto) {
				printf(" proto %s", v->va_proto);
				lastset = i++;;
				break;
			}

			if ((i == VA_FHOST || i == VA_FNET) &&
			    (v->va_net[0] || v->va_host[0])) {
				if (v->va_net[0])
					printf(" from %s", v->va_net[0]);
				else
					printf(" from %s", v->va_host[0]);
				v2 = v;
				lastset = i++;;
				break;
			}

			if (((i == VA_FMASK) && v->va_mask[0]) && v2) {
				if ((lastset == VA_FNET) && v2->va_net[0]) {
					printf("/%s", v->va_mask[0]);
					lastset = i++;;
				}
				v2 = NULL;
				break;
			}

			if ((i == VA_FPORT) && v->va_port1[0]) {
				if (!v->va_portcmp[0])
					printf(" port = %s", v->va_port1[0]);
				else if (!v->va_port2[0])
					printf(" port %s %s",
						v->va_portcmp[0],
						v->va_port1[0]);
				else
					printf(" port %s %s %s",
						v->va_port1[0],
						v->va_portcmp[0],
						v->va_port2[0]);
				lastset = i++;;
				break;
			}

			if ((i == VA_THOST || i == VA_TNET) &&
			    (v->va_net[1] || v->va_host[1])) {
				if (v->va_net[1])
					printf(" to %s", v->va_net[1]);
				else
					printf(" to %s", v->va_host[1]);
				lastset = i++;;
				v2 = v;
				break;
			}

			if (((i == VA_TMASK) && v->va_mask[1]) && v2) {
				if ((lastset == VA_TNET) && v2->va_net[1]) {
					printf("/%s", v->va_mask[1]);
					lastset = i++;;
				}
				v2 = NULL;
				break;
			}

			if ((i == VA_TPORT) && v->va_port1[1]) {
				if (!v->va_portcmp[1])
					printf(" port = %s", v->va_port1[1]);
				else if (!v->va_port2[1])
					printf(" port %s %s",
						v->va_portcmp[1],
						v->va_port1[1]);
				else
					printf(" port %s %s %s",
						v->va_port1[1],
						v->va_portcmp[1],
						v->va_port2[1]);
				lastset = i++;;
				break;
			}

			if ((i == VA_FLAGS) && v->va_flags) {
				if (!strcasecmp(v->va_flags, "established"))
					s = "A/A";
				else if (!strcasecmp(v->va_flags, "opening"))
					s = "S/SA";
				else
					s = v->va_flags;
				printf(" flags %s", s);
				lastset = i++;;
				break;
			}

			if ((i == VA_IPOPTS) && v->va_opts) {
				printopts(v->va_opts);
				lastset = i++;;
				break;
			}
		}
		if (!v) {
			if ((i == VA_FNET) || (i == VA_FHOST))
				printf(" from any");
			else if ((i == VA_TNET) || (i == VA_THOST))
				printf(" to any");
			v2 = NULL;
		}
		if (i == j)
			i++;;
	}
	putchar('\n');
}


emitipf()
{
	var_t	*v;

	if (!(v = varlist) ||
	    ((v->va_policy & (VP_ACTION|VP_INOUT)) != (VP_ACTION|VP_INOUT)))
		return;
	printaction(v->va_action, 0);
	printf(" %s", strstr(v->va_inout, "in") ? "in" : "out");
	if ((v->va_policy & VP_INTERFACE) && v->va_iface)
		printf(" on %s", v->va_iface);
	printaction(v->va_action, 1);
	if ((v->va_policy & VP_PROTOCOL) && v->va_proto)
		printf(" proto %s", v->va_proto);
	printf(" all\n");
	clear_policy(v);
}
