/*
 * (C)opyright 1995 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 */
#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include "var.h"
#include "misc.h"

#ifndef	lint
static	char	sccsid[] = "@(#)main.c	1.12 12/17/95 (C) 1995 Darren Reed";
#endif

#if defined(sun) && (defined(__SVR4) || defined(__sysv__) || defined(__svr4__))
char	CPP[] =	"/usr/ccs/lib/cpp";
#else
# if BSD >= 199306
char	CPP[] =	"/usr/bin/cpp";
# else
char	CPP[] =	"/usr/lib/cpp";
# endif
#endif

extern	FILE	*yyin;
extern	char	*optarg;
#if BSD < 199306
extern	int	yylineno;
#else
extern	int	lineNum;
#endif
extern	int	state;

int	fl_target = FL_IPFILTER;
char	line[2048];
char	*keywords[] = {
			"define", "undef", "include", "line", "if", "ifdef",
			"elif", "ifndef", "else", "endif", NULL
};

extern	void	printipf(), emitipf();
extern	void	printipfwadm(), emitipfwadm();
extern	void	printipfw(), emitipfw();
extern	void	printcisco(), emitcisco();
extern	void	printipfirewall(), emitipfirewall();
extern	void	printscreend(), emitscreend();

target_t fltargets[] = {
	{ "ipfilter", FL_IPFILTER, printipf, emitipf },
	{ "ipfwadm", FL_IPFWADM, printipfwadm, emitipfwadm },
	{ "ipfw", FL_IPFW, printipfw, emitipfw },
	{ "cisco", FL_CISCO, printcisco, emitcisco },
	{ "ipfirewall", FL_IPFIREWALL, printipfirewall, emitipfirewall },
	{ "screend", FL_SCREEND, printscreend, emitscreend },
	{ NULL, 0, NULL }
};


void	usage(name)
char	*name;
{
	int	i;

	fprintf(stderr,
		"Usage: %s [-c cpp-path] [-t target lang.] [-f input file]\n",
		name);
	fprintf(stderr, "\t%s -v\n", name);
	fprintf(stderr, "Supported targets:\n");
	for (i = 0; fltargets[i].ft_name; i++)
		fprintf(stderr, "\t%s\n", fltargets[i].ft_name);
	exit(1);
}


void	yyerror(msg)
char	*msg;
{
#if BSD < 199306
	synerr("-%s @%d (%d)\n", msg, yylineno - 6, state);
#else
	synerr("-%s @%d (%d)\n", msg, lineNum - 6, state);
#endif
}


emit_policy()
{
	target_t *ta;

	for (ta = fltargets; ta->ft_name; ta++)
		if (ta->ft_type == fl_target)
			break;
	if (ta)
		call_emitpolicy(ta->ft_emitpolicy);
}


void	printrule(lvl)
int	lvl;
{
	target_t *ta;

	for (ta = fltargets; ta->ft_name; ta++)
		if (ta->ft_type == fl_target)
			break;
	if (ta)
		(*ta->ft_func)(lvl);
}


void	add_defs(fp, type)
FILE	*fp;
char	*type;
{
	struct	utsname	utsname;

	if (uname(&utsname) == -1)
		return;
	fprintf(fp, "#define __HOST %s\n", utsname.nodename);
	fprintf(fp, "#define __OS %s\n", utsname.sysname);
	fprintf(fp, "#define __OSREV %s\n", utsname.release);
	fprintf(fp, "#define __ARCH %s\n", utsname.machine);
	fprintf(fp, "#define __FILTER %s\n", type);
	fprintf(fp, "#define __%s__ 1\n", type);
}


char	*writetmp(fp, ispipe, type)
FILE	**fp;
int	ispipe;
char	*type;
{
	static	char	template[32];
	char	*s, *t, **key, c;
	FILE	*out;
	int	fd, lineno = 0;

	strcpy(template, "/tmp/frparXXXXXX");
	fd = mkstemp(template);
	out = fdopen(fd, "r+");
	if (!ispipe)
		add_defs(out, type);

	while (fgets(line, sizeof(line), *fp)) {
		line[sizeof(line) - 1] = '\0';
		if ((s = strchr(line, '\n')))
			*(s + 1) = '\0';
		if (*line == '#') {
			for (s = line + 1; *s && isspace(*s); s++)
				;
			if (!*s) {
				fprintf(out, "\n");
				continue;
			}
			for (t = s; *t && isalnum(*t); t++)
				;
			if (!*t || !isspace(*t)) {
				fprintf(out, "\n");
				continue;
			}
			c = *t;
			*t = '\0';

			/*
			 * handle # <number> "file..." lines
			 */
			if ((atoi(s) > 0) && (*(t + 1) == '\"')) {
				while (atoi(s) > (lineno + 1)) {
					fprintf(out, "\n");
					lineno++;
				}
				continue;
			}

			for (key = keywords; *key; key++)
				if (!strcmp(s, *key))
					break;
			*t = c;
			if (*key)
				fprintf(out, "%s", line);
			else
				fprintf(out, "\n");
		} else {
			if ((s = strchr(line, '#')))
				*s = '\0';
			if (*line)
				fprintf(out, "%s", line);
			else
				fprintf(out, "\n");
		}
		lineno++;
	}
	if (!ispipe)
		fclose(*fp);
	else
		pclose(*fp);
	rewind(out);
	*fp = out;
	return template;
}


int main(argc, argv)
int argc;
char *argv[];
{
	target_t *ta;
	FILE	*p, *fp, *pout;
	char	*cmd, *file1, *file2, c, *cpp;

	cpp = CPP;
	file1 = NULL;
	ta = NULL;

	while ((c = getopt(argc, argv, "c:f:t:v")) != -1)
		switch (c)
		{
		case 'c' :
			cpp = optarg;
			break;
		case 'f' :
			file1 = optarg;
			break;
		case 't' :
			for (ta = fltargets; ta->ft_name; ta++)
				if (!strcasecmp(ta->ft_name, optarg))
					break;
			if (ta->ft_type)
				fl_target = ta->ft_type;
			break;
		case 'v' :
			printf("1.12\n");
			exit(0);
		default :
			usage(argv[0]);
		}

	if (!ta)
		ta = fltargets;
	fp =  file1 ? fopen(file1, "r") : stdin;
	file1 = strdup(writetmp(&fp, 0, ta->ft_name));

	cmd = (char *)malloc(strlen(cpp) + strlen(file1) + 2);
	(void) sprintf(cmd, "%s %s", cpp, file1);
	p = popen(cmd, "r");
	file2 = writetmp(&p, 1, ta->ft_name);
	yyin = p;
	while (!feof(yyin))
		yyparse();
	(void) unlink(file1);
	(void) unlink(file2);
	return 0;
}
