# Makefile - MyGPGME.dsp

ifndef CFG
CFG=MyGPGME - Win32 Debug
endif
CC=gcc
CFLAGS=
CXX=g++
CXXFLAGS=$(CFLAGS)
RC=windres -O COFF
ifeq "$(CFG)"  "MyGPGME - Win32 Release"
CFLAGS+=-W -fexceptions -O2 -I../gnupg -I../ptd -DWIN32 -DNDEBUG -D_MBCS -D_LIB
AR=ar
ARFLAGS=rus
else
ifeq "$(CFG)"  "MyGPGME - Win32 Debug"
CFLAGS+=-W -fexceptions -g -O0 -I../gnupg -I../ptd -DWIN32 -D_DEBUG -D_MBCS -D_LIB
AR=ar
ARFLAGS=rus
endif
endif

ifndef TARGET
TARGET=libMyGPGME.a
endif

.PHONY: all
all: $(TARGET)

%.o: %.c
	$(CC) $(CFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cc
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cpp
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cxx
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.res: %.rc
	$(RC) $(CPPFLAGS) -o $@ -i $<

SRCS= \
	ChangeLog \
	clip.c \
	common-status.c \
	common-status.h \
	context.h \
	data.c \
	debug.c \
	decrypt.c \
	delete.c \
	editcard.c \
	editkey-util.c \
	editkey.c \
	encrypt.c \
	errors.c \
	export.c \
	genkey.c \
	getkey-openpgp.c \
	gpgme-config.h \
	gpgme-io.h \
	gpgme.c \
	gpgme.h \
	implist.c \
	import.c \
	key.c \
	key.h \
	keycache-openpgp.c \
	keycache.c \
	keylist.c \
	ops.h \
	ownertrust.c \
	recipient.c \
	revoke.c \
	rungpg.c \
	rungpg.h \
	sema.h \
	sig.c \
	sign-encrypt.c \
	sign.c \
	signers.c \
	status-table.h \
	sym-encrypt.c \
	trustlist.c \
	types.h \
	util.h \
	verify.c \
	version.c \
	w32-clip.c \
	w32-glibc.c \
	w32-io.c \
	w32-sema.c \
	w32-util.c \
	wait.c \
	wait.h

OBJS=$(patsubst %.rc,%.res,$(patsubst %.cxx,%.o,$(patsubst %.cpp,%.o,$(patsubst %.cc,%.o,$(patsubst %.c,%.o,$(filter %.c %.cc %.cpp %.cxx %.rc,$(SRCS)))))))

$(TARGET): $(OBJS)
	$(AR) $(ARFLAGS) $@ $(OBJS)

.PHONY: clean
clean:
	-rm -f $(OBJS) $(TARGET) MyGPGME.dep

.PHONY: depends
depends:
	-$(CXX) $(CXXFLAGS) $(CPPFLAGS) -MM $(filter %.c %.cc %.cpp %.cxx,$(SRCS)) > MyGPGME.dep

-include MyGPGME.dep

