/* wptVersion.h - WinPT version handling
 *	Copyright (C) 2000-2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef WPT_VERSION_H
#define WPT_VERSION_H

/* Application name */
#define PGM_NAME "WinPT" 

/* Application version */
#define PGM_VERSION "0.9.92"
#define PGM_DATE "(2005-04-19)"

/* Package version string */
#define PACKAGE_VERSION "Version: "PGM_VERSION" "PGM_DATE

/*-- WinPT.cpp --*/
extern HINSTANCE glob_hinst;	/* Global HINSTANCE for tray window */
extern HWND glob_hwnd;		/* Global HWND for tray window */
extern HWND activ_hwnd;		/* Active window HWND (dialog) */
extern int debug;		/* Global debug mode */
extern int mobile;		/* Mobile mode activated */
extern int scard_support;	/* Smartcard support available */
extern int gpg_read_only;
extern LOCK mo_file;
extern char gpgver[];


BOOL PTD_initialize (void);   
void PTD_delete (void);
const char * PTD_get_version (void);
int PTD_jpg_show (HWND, POINT*, LPCSTR);

/*-- wptMainProc.cpp --*/
LRESULT CALLBACK winpt_main_proc (HWND hwnd, UINT msg, WPARAM wparam,
				  LPARAM lparam); /* Global main procedure */

#endif /* WPT_VERSION_H */