/* wptPINDlg.cpp - PIN callback for smart cards
 *	Copyright (C) 2003, 2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptW32API.h"
#include "wptTypes.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptCard.h"
#include "wptUTF8.h"


BOOL CALLBACK
pin_cb_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam)
{
    static pin_cb_ctx_s * pin;
    const char * s;
    int n, len;

    switch( msg ) {
    case WM_INITDIALOG:
	pin = (struct pin_cb_ctx_s *)lparam;
	if (!pin)
	    BUG (0);
	if (pin->info_text)
	    s = pin->info_text;
	else
	    s = _("Please enter the PIN");
	SetDlgItemText( dlg, IDC_PIN_INFO, s );
	center_window( dlg );
	SetFocus( GetDlgItem( dlg, IDC_PIN_VALUE ) );
	SetForegroundWindow( dlg );
	return FALSE;
	
    case WM_COMMAND:
	switch( LOWORD( wparam ) ) {
	case IDOK:
	    n = SendDlgItemMessage( dlg, IDC_PIN_VALUE, WM_GETTEXTLENGTH, 0, 0 );
	    if( !n ) {
		msg_box( dlg, _("Please enter a PIN."), _("PIN"), MB_ERR );
		return FALSE;
	    }
	    if (!pin->which || pin->which == GPGME_EDITCARD_CHAPIN) {
		free_if_alloc (pin->apin);
		pin->apin = new char[n+2];
		if (!pin->apin)
		    BUG (0);
		len = GetDlgItemText( dlg, IDC_PIN_VALUE, pin->apin, n+1 );
		if (len < 8) {
		    msg_box (dlg, _("'Admin PIN' must be at least 8 characters long."),
			     _("PIN"), MB_ERR);
		    free_if_alloc (pin->apin);
		    return FALSE;
		}
		if (is_8bit_string (pin->apin)) {
		    msg_box (dlg, _("PIN's are currently limited to US-ASCII"),
			     _("PIN"), MB_ERR);
		    free_if_alloc (pin->apin);
		    return FALSE;
		}
	    }
	    else if( pin->which == GPGME_EDITCARD_CHUPIN) {
		free_if_alloc (pin->upin);
		pin->upin = new char[n+2];
		if (!pin->upin)
		    BUG( NULL );
		len = GetDlgItemText( dlg, IDC_PIN_VALUE, pin->upin, n+1 );
		if (len < 6) {
		    msg_box( dlg, _("'User PIN' must be at least 6 characters long."),
			     _("PIN"), MB_ERR );
		    free_if_alloc( pin->upin );
		    return FALSE;
		}
		if (is_8bit_string (pin->upin)) {
		    msg_box (dlg, _("PIN's are currently limited to US-ASCII"),
			     _("PIN"), MB_ERR);
		    free_if_alloc (pin->upin);
		    return FALSE;
		}
	    }
	    EndDialog( dlg, TRUE );
	    break;

	case IDCANCEL:
	    pin->apin = NULL;
	    pin->upin = NULL;
	    EndDialog (dlg, FALSE);
	    break;
	}
	break;
    }
    return FALSE;
} /* pin_cb_dlg_proc */