/* wptFilePrefs.cpp - File Manager preferences
 *	Copyright (C) 2001, 2002 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "../resource.h"
#include "wptW32API.h"

LRESULT CALLBACK
file_prefs_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    HWND cb;	
    
    switch( msg )  {
    case WM_INITDIALOG:
        cb = GetDlgItem( dlg, IDC_FILE_PREFS_ALGO );	
        combox_add_string( cb, (char *)"3DES" );
        combox_add_string( cb, (char *)"CAST5" );
        combox_add_string( cb, (char *)"BLOWFISH" );
        combox_add_string( cb, (char *)"AES128" );
        combox_add_string( cb, (char *)"AES192" );
        combox_add_string( cb, (char *)"AES256" );
        combox_add_string( cb, (char *)"TWOFISH" );
        combox_add_string( cb, CB_SETCURSEL, (WPARAM)1, 0 );
        return TRUE;
        
    case WM_SYSCOMMAND:
        if( LOWORD( wparam ) == SC_CLOSE )
            EndDialog( dlg, TRUE );
        return FALSE;
        
    case WM_COMMAND:
        switch( LOWORD(wparam) ) {
        case IDOK:
            EndDialog( dlg, TRUE );
            return TRUE;
        }
        break;
    }
    
    return FALSE;
} /* file_prefs_dlg_proc */