/* mymapitags.h - MAPI definitions
 *
 * This file defines constants as used by MAPI.  This interface
 * definition has been compiled from similar Python code by g10 Code
 * GmbH.
 *
 * Revisions:
 * 2005-07-26  Initial version.
 *
 */

#ifndef MAPITAGS_H
#define MAPITAGS_H 1


#define PT_UNSPECIFIED  0
#define PT_NULL         1
#define PT_I2           2
#define PT_LONG         3
#define PT_R4           4
#define PT_DOUBLE       5
#define PT_CURRENCY     6
#define PT_APPTIME      7
#define PT_ERROR       10
#define PT_BOOLEAN     11
#define PT_OBJECT      13
#define PT_I8          20
#define PT_STRING8     30
#define PT_UNICODE     31
#define PT_SYSTIME     64
#define PT_CLSID       72
#define PT_BINARY     258

#define PT_SHORT    PT_I2
#define PT_I4       PT_LONG
#define PT_FLOAT    PT_R4
#define PT_R8       PT_DOUBLE
#define PT_LONGLONG PT_I8

#define MV_FLAG    0x1000

#define PT_MV_I2        (MV_FLAG|PT_I2)
#define PT_MV_LONG      (MV_FLAG|PT_LONG)
#define PT_MV_R4        (MV_FLAG|PT_R4)
#define PT_MV_DOUBLE    (MV_FLAG|PT_DOUBLE)
#define PT_MV_CURRENCY  (MV_FLAG|PT_CURRENCY)
#define PT_MV_APPTIME   (MV_FLAG|PT_APPTIME)
#define PT_MV_SYSTIME   (MV_FLAG|PT_SYSTIME)
#define PT_MV_STRING8   (MV_FLAG|PT_STRING8)
#define PT_MV_BINARY    (MV_FLAG|PT_BINARY)
#define PT_MV_UNICODE   (MV_FLAG|PT_UNICODE)
#define PT_MV_CLSID     (MV_FLAG|PT_CLSID)
#define PT_MV_I8        (MV_FLAG|PT_I8)

#define PT_MV_SHORT     PT_MV_I2
#define PT_MV_I4        PT_MV_LONG
#define PT_MV_FLOAT     PT_MV_R4
#define PT_MV_R8        PT_MV_DOUBLE
#define PT_MV_LONGLONG  PT_MV_I8

#define PT_TSTRING      PT_UNICODE
#define PT_MV_TSTRING   (MV_FLAG|PT_UNICODE)

#define PROP_TYPE_MASK   0x0000FFFF

#define PROP_TYPE(t)  ((t) & PROP_TYPE_MASK)
#define PROP_ID(t)    ((t)>>16)
#define PROP_TAG(t,i) (((i)<<16)|(t))

#define PROP_ID_NULL          0
#define PROP_ID_INVALID  0xFFFF

#define PR_NULL                                 PROP_TAG(PT_NULL, PROP_ID_NULL)
#define PR_ACKNOWLEDGEMENT_MODE                 PROP_TAG( PT_LONG,      0x0001)
#define PR_ACKNOWLEDGEMENT_MODE                 PROP_TAG( PT_LONG,      0x0001)
#define PR_ALTERNATE_RECIPIENT_ALLOWED          PROP_TAG( PT_BOOLEAN,   0x0002)
#define PR_AUTHORIZING_USERS                    PROP_TAG( PT_BINARY,    0x0003)
#define PR_AUTO_FORWARD_COMMENT                 PROP_TAG( PT_TSTRING,   0x0004)
#define PR_AUTO_FORWARD_COMMENT_W               PROP_TAG( PT_UNICODE,   0x0004)
#define PR_AUTO_FORWARD_COMMENT_W               PROP_TAG( PT_UNICODE,   0x0004)
#define PR_AUTO_FORWARD_COMMENT_A               PROP_TAG( PT_STRING8,   0x0004)
#define PR_AUTO_FORWARDED                       PROP_TAG( PT_BOOLEAN,   0x0005)
#define PR_CONTENT_TYPE_A                       PROP_TAG( PT_STRING8,   0x8095)
#define PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID PROP_TAG( PT_BINARY,    0x0006)
#define PR_CONTENT_CORRELATOR                   PROP_TAG( PT_BINARY,    0x0007)
#define PR_CONTENT_IDENTIFIER                   PROP_TAG( PT_TSTRING,   0x0008)
#define PR_CONTENT_IDENTIFIER_W                 PROP_TAG( PT_UNICODE,   0x0008)
#define PR_CONTENT_IDENTIFIER_A                 PROP_TAG( PT_STRING8,   0x0008)
#define PR_CONTENT_LENGTH                       PROP_TAG( PT_LONG,      0x0009)
#define PR_CONTENT_RETURN_REQUESTED             PROP_TAG( PT_BOOLEAN,   0x000A)
#define PR_CONVERSATION_KEY                     PROP_TAG( PT_BINARY,    0x000B)
#define PR_CONVERSION_EITS                      PROP_TAG( PT_BINARY,    0x000C)
#define PR_CONVERSION_WITH_LOSS_PROHIBITED      PROP_TAG( PT_BOOLEAN,   0x000D)
#define PR_CONVERTED_EITS                       PROP_TAG( PT_BINARY,    0x000E)
#define PR_DEFERRED_DELIVERY_TIME               PROP_TAG( PT_SYSTIME,   0x000F)
#define PR_DELIVER_TIME                         PROP_TAG( PT_SYSTIME,   0x0010)
#define PR_DISCARD_REASON                       PROP_TAG( PT_LONG,      0x0011)
#define PR_DISCLOSURE_OF_RECIPIENTS             PROP_TAG( PT_BOOLEAN,   0x0012)
#define PR_DL_EXPANSION_HISTORY                 PROP_TAG( PT_BINARY,    0x0013)
#define PR_DL_EXPANSION_PROHIBITED              PROP_TAG( PT_BOOLEAN,   0x0014)
#define PR_EXPIRY_TIME                          PROP_TAG( PT_SYSTIME,   0x0015)
#define PR_IMPLICIT_CONVERSION_PROHIBITED       PROP_TAG( PT_BOOLEAN,   0x0016)
#define PR_IMPORTANCE                           PROP_TAG( PT_LONG,      0x0017)
#define PR_IPM_ID                               PROP_TAG( PT_BINARY,    0x0018)
#define PR_LATEST_DELIVERY_TIME                 PROP_TAG( PT_SYSTIME,   0x0019)
#define PR_MESSAGE_CLASS                        PROP_TAG( PT_TSTRING,   0x001A)
#define PR_MESSAGE_CLASS_W                      PROP_TAG( PT_UNICODE,   0x001A)
#define PR_MESSAGE_CLASS_A                      PROP_TAG( PT_STRING8,   0x001A)
#define PR_MESSAGE_DELIVERY_ID                  PROP_TAG( PT_BINARY,    0x001B)
#define PR_MESSAGE_SECURITY_LABEL               PROP_TAG( PT_BINARY,    0x001E)
#define PR_OBSOLETED_IPMS                       PROP_TAG( PT_BINARY,    0x001F)
#define PR_ORIGINALLY_INTENDED_RECIPIENT_NAME   PROP_TAG( PT_BINARY,    0x0020)
#define PR_ORIGINAL_EITS                        PROP_TAG( PT_BINARY,    0x0021)
#define PR_ORIGINATOR_CERTIFICATE               PROP_TAG( PT_BINARY,    0x0022)
#define PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED PROP_TAG( PT_BOOLEAN,   0x0023)
#define PR_ORIGINATOR_RETURN_ADDRESS            PROP_TAG( PT_BINARY,    0x0024)
#define PR_PARENT_KEY                           PROP_TAG( PT_BINARY,    0x0025)
#define PR_PRIORITY                             PROP_TAG( PT_LONG,      0x0026)
#define PR_ORIGIN_CHECK                         PROP_TAG( PT_BINARY,    0x0027)
#define PR_PROOF_OF_SUBMISSION_REQUESTED        PROP_TAG( PT_BOOLEAN,   0x0028)
#define PR_READ_RECEIPT_REQUESTED               PROP_TAG( PT_BOOLEAN,   0x0029)
#define PR_RECEIPT_TIME                         PROP_TAG( PT_SYSTIME,   0x002A)
#define PR_RECIPIENT_REASSIGNMENT_PROHIBITED    PROP_TAG( PT_BOOLEAN,   0x002B)
#define PR_REDIRECTION_HISTORY                  PROP_TAG( PT_BINARY,    0x002C)
#define PR_RELATED_IPMS                         PROP_TAG( PT_BINARY,    0x002D)
#define PR_ORIGINAL_SENSITIVITY                 PROP_TAG( PT_LONG,      0x002E)
#define PR_LANGUAGES                            PROP_TAG( PT_TSTRING,   0x002F)
#define PR_LANGUAGES_W                          PROP_TAG( PT_UNICODE,   0x002F)
#define PR_LANGUAGES_A                          PROP_TAG( PT_STRING8,   0x002F)
#define PR_REPLY_TIME                           PROP_TAG( PT_SYSTIME,   0x0030)
#define PR_REPORT_TAG                           PROP_TAG( PT_BINARY,    0x0031)
#define PR_REPORT_TIME                          PROP_TAG( PT_SYSTIME,   0x0032)
#define PR_RETURNED_IPM                         PROP_TAG( PT_BOOLEAN,   0x0033)
#define PR_SECURITY                             PROP_TAG( PT_LONG,      0x0034)
#define PR_INCOMPLETE_COPY                      PROP_TAG( PT_BOOLEAN,   0x0035)
#define PR_SENSITIVITY                          PROP_TAG( PT_LONG,      0x0036)
#define PR_SUBJECT                              PROP_TAG( PT_TSTRING,   0x0037)
#define PR_SUBJECT_W                            PROP_TAG( PT_UNICODE,   0x0037)
#define PR_SUBJECT_A                            PROP_TAG( PT_STRING8,   0x0037)
#define PR_SUBJECT_IPM                          PROP_TAG( PT_BINARY,    0x0038)
#define PR_CLIENT_SUBMIT_TIME                   PROP_TAG( PT_SYSTIME,   0x0039)
#define PR_REPORT_NAME                          PROP_TAG( PT_TSTRING,   0x003A)
#define PR_REPORT_NAME_W                        PROP_TAG( PT_UNICODE,   0x003A)
#define PR_REPORT_NAME_A                        PROP_TAG( PT_STRING8,   0x003A)
#define PR_SENT_REPRESENTING_SEARCH_KEY         PROP_TAG( PT_BINARY,    0x003B)
#define PR_X400_CONTENT_TYPE                    PROP_TAG( PT_BINARY,    0x003C)
#define PR_SUBJECT_PREFIX                       PROP_TAG( PT_TSTRING,   0x003D)
#define PR_SUBJECT_PREFIX_W                     PROP_TAG( PT_UNICODE,   0x003D)
#define PR_SUBJECT_PREFIX_A                     PROP_TAG( PT_STRING8,   0x003D)
#define PR_NON_RECEIPT_REASON                   PROP_TAG( PT_LONG,      0x003E)
#define PR_RECEIVED_BY_ENTRYID                  PROP_TAG( PT_BINARY,    0x003F)
#define PR_RECEIVED_BY_NAME                     PROP_TAG( PT_TSTRING,   0x0040)
#define PR_RECEIVED_BY_NAME_W                   PROP_TAG( PT_UNICODE,   0x0040)
#define PR_RECEIVED_BY_NAME_A                   PROP_TAG( PT_STRING8,   0x0040)
#define PR_SENT_REPRESENTING_ENTRYID            PROP_TAG( PT_BINARY,    0x0041)
#define PR_SENT_REPRESENTING_NAME               PROP_TAG( PT_TSTRING,   0x0042)
#define PR_SENT_REPRESENTING_NAME_W             PROP_TAG( PT_UNICODE,   0x0042)
#define PR_SENT_REPRESENTING_NAME_A             PROP_TAG( PT_STRING8,   0x0042)
#define PR_RCVD_REPRESENTING_ENTRYID            PROP_TAG( PT_BINARY,    0x0043)
#define PR_RCVD_REPRESENTING_NAME               PROP_TAG( PT_TSTRING,   0x0044)
#define PR_RCVD_REPRESENTING_NAME_W             PROP_TAG( PT_UNICODE,   0x0044)
#define PR_RCVD_REPRESENTING_NAME_A             PROP_TAG( PT_STRING8,   0x0044)
#define PR_REPORT_ENTRYID                       PROP_TAG( PT_BINARY,    0x0045)
#define PR_READ_RECEIPT_ENTRYID                 PROP_TAG( PT_BINARY,    0x0046)
#define PR_MESSAGE_SUBMISSION_ID                PROP_TAG( PT_BINARY,    0x0047)
#define PR_PROVIDER_SUBMIT_TIME                 PROP_TAG( PT_SYSTIME,   0x0048)
#define PR_ORIGINAL_SUBJECT                     PROP_TAG( PT_TSTRING,   0x0049)
#define PR_ORIGINAL_SUBJECT_W                   PROP_TAG( PT_UNICODE,   0x0049)
#define PR_ORIGINAL_SUBJECT_A                   PROP_TAG( PT_STRING8,   0x0049)
#define PR_DISC_VAL                             PROP_TAG( PT_BOOLEAN,   0x004A)
#define PR_ORIG_MESSAGE_CLASS                   PROP_TAG( PT_TSTRING,   0x004B)
#define PR_ORIG_MESSAGE_CLASS_W                 PROP_TAG( PT_UNICODE,   0x004B)
#define PR_ORIG_MESSAGE_CLASS_A                 PROP_TAG( PT_STRING8,   0x004B)
#define PR_ORIGINAL_AUTHOR_ENTRYID              PROP_TAG( PT_BINARY,    0x004C)
#define PR_ORIGINAL_AUTHOR_NAME                 PROP_TAG( PT_TSTRING,   0x004D)
#define PR_ORIGINAL_AUTHOR_NAME_W               PROP_TAG( PT_UNICODE,   0x004D)
#define PR_ORIGINAL_AUTHOR_NAME_A               PROP_TAG( PT_STRING8,   0x004D)
#define PR_ORIGINAL_SUBMIT_TIME                 PROP_TAG( PT_SYSTIME,   0x004E)
#define PR_REPLY_RECIPIENT_ENTRIES              PROP_TAG( PT_BINARY,    0x004F)
#define PR_REPLY_RECIPIENT_NAMES                PROP_TAG( PT_TSTRING,   0x0050)
#define PR_REPLY_RECIPIENT_NAMES_W              PROP_TAG( PT_UNICODE,   0x0050)
#define PR_REPLY_RECIPIENT_NAMES_A              PROP_TAG( PT_STRING8,   0x0050)
#define PR_RECEIVED_BY_SEARCH_KEY               PROP_TAG( PT_BINARY,    0x0051)
#define PR_RCVD_REPRESENTING_SEARCH_KEY         PROP_TAG( PT_BINARY,    0x0052)
#define PR_READ_RECEIPT_SEARCH_KEY              PROP_TAG( PT_BINARY,    0x0053)
#define PR_REPORT_SEARCH_KEY                    PROP_TAG( PT_BINARY,    0x0054)
#define PR_ORIGINAL_DELIVERY_TIME               PROP_TAG( PT_SYSTIME,   0x0055)
#define PR_ORIGINAL_AUTHOR_SEARCH_KEY           PROP_TAG( PT_BINARY,    0x0056)
#define PR_MESSAGE_TO_ME                        PROP_TAG( PT_BOOLEAN,   0x0057)
#define PR_MESSAGE_CC_ME                        PROP_TAG( PT_BOOLEAN,   0x0058)
#define PR_MESSAGE_RECIP_ME                     PROP_TAG( PT_BOOLEAN,   0x0059)
#define PR_ORIGINAL_SENDER_NAME                 PROP_TAG( PT_TSTRING,   0x005A)
#define PR_ORIGINAL_SENDER_NAME_W               PROP_TAG( PT_UNICODE,   0x005A)
#define PR_ORIGINAL_SENDER_NAME_A               PROP_TAG( PT_STRING8,   0x005A)
#define PR_ORIGINAL_SENDER_ENTRYID              PROP_TAG( PT_BINARY,    0x005B)
#define PR_ORIGINAL_SENDER_SEARCH_KEY           PROP_TAG( PT_BINARY,    0x005C)
#define PR_ORIGINAL_SENT_REPRESENTING_NAME      PROP_TAG( PT_TSTRING,   0x005D)
#define PR_ORIGINAL_SENT_REPRESENTING_NAME_W    PROP_TAG( PT_UNICODE,   0x005D)
#define PR_ORIGINAL_SENT_REPRESENTING_NAME_A    PROP_TAG( PT_STRING8,   0x005D)
#define PR_ORIGINAL_SENT_REPRESENTING_ENTRYID   PROP_TAG( PT_BINARY,    0x005E)
#define PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY PROP_TAG( PT_BINARY,   0x005F)
#define PR_START_DATE                           PROP_TAG( PT_SYSTIME,   0x0060)
#define PR_END_DATE                             PROP_TAG( PT_SYSTIME,   0x0061)
#define PR_OWNER_APPT_ID                        PROP_TAG( PT_LONG,      0x0062)
#define PR_RESPONSE_REQUESTED                   PROP_TAG( PT_BOOLEAN,   0x0063)
#define PR_SENT_REPRESENTING_ADDRTYPE           PROP_TAG( PT_TSTRING,   0x0064)
#define PR_SENT_REPRESENTING_ADDRTYPE_W         PROP_TAG( PT_UNICODE,   0x0064)
#define PR_SENT_REPRESENTING_ADDRTYPE_A         PROP_TAG( PT_STRING8,   0x0064)
#define PR_SENT_REPRESENTING_EMAIL_ADDRESS      PROP_TAG( PT_TSTRING,   0x0065)
#define PR_SENT_REPRESENTING_EMAIL_ADDRESS_W    PROP_TAG( PT_UNICODE,   0x0065)
#define PR_SENT_REPRESENTING_EMAIL_ADDRESS_A    PROP_TAG( PT_STRING8,   0x0065)
#define PR_ORIGINAL_SENDER_ADDRTYPE             PROP_TAG( PT_TSTRING,   0x0066)
#define PR_ORIGINAL_SENDER_ADDRTYPE_W           PROP_TAG( PT_UNICODE,   0x0066)
#define PR_ORIGINAL_SENDER_ADDRTYPE_A           PROP_TAG( PT_STRING8,   0x0066)
#define PR_ORIGINAL_SENDER_EMAIL_ADDRESS        PROP_TAG( PT_TSTRING,   0x0067)
#define PR_ORIGINAL_SENDER_EMAIL_ADDRESS_W      PROP_TAG( PT_UNICODE,   0x0067)
#define PR_ORIGINAL_SENDER_EMAIL_ADDRESS_A      PROP_TAG( PT_STRING8,   0x0067)
#define PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE  PROP_TAG( PT_TSTRING,   0x0068)
#define PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_W PROP_TAG( PT_UNICODE,  0x0068)
#define PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_A  PROP_TAG( PT_STRING8, 0x0068)
#define PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS \
                                                PROP_TAG( PT_TSTRING,   0x0069)
#define PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_W \
                                                PROP_TAG( PT_UNICODE,   0x0069)
#define PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_A \
                                                PROP_TAG( PT_STRING8,   0x0069)
#define PR_CONVERSATION_TOPIC                   PROP_TAG( PT_TSTRING,   0x0070)
#define PR_CONVERSATION_TOPIC_W                 PROP_TAG( PT_UNICODE,   0x0070)
#define PR_CONVERSATION_TOPIC_A                 PROP_TAG( PT_STRING8,   0x0070)
#define PR_CONVERSATION_INDEX                   PROP_TAG( PT_BINARY,    0x0071)
#define PR_ORIGINAL_DISPLAY_BCC                 PROP_TAG( PT_TSTRING,   0x0072)
#define PR_ORIGINAL_DISPLAY_BCC_W               PROP_TAG( PT_UNICODE,   0x0072)
#define PR_ORIGINAL_DISPLAY_BCC_A               PROP_TAG( PT_STRING8,   0x0072)
#define PR_ORIGINAL_DISPLAY_CC                  PROP_TAG( PT_TSTRING,   0x0073)
#define PR_ORIGINAL_DISPLAY_CC_W                PROP_TAG( PT_UNICODE,   0x0073)
#define PR_ORIGINAL_DISPLAY_CC_A                PROP_TAG( PT_STRING8,   0x0073)
#define PR_ORIGINAL_DISPLAY_TO                  PROP_TAG( PT_TSTRING,   0x0074)
#define PR_ORIGINAL_DISPLAY_TO_W                PROP_TAG( PT_UNICODE,   0x0074)
#define PR_ORIGINAL_DISPLAY_TO_A                PROP_TAG( PT_STRING8,   0x0074)
#define PR_RECEIVED_BY_ADDRTYPE                 PROP_TAG( PT_TSTRING,   0x0075)
#define PR_RECEIVED_BY_ADDRTYPE_W               PROP_TAG( PT_UNICODE,   0x0075)
#define PR_RECEIVED_BY_ADDRTYPE_A               PROP_TAG( PT_STRING8,   0x0075)
#define PR_RECEIVED_BY_EMAIL_ADDRESS            PROP_TAG( PT_TSTRING,   0x0076)
#define PR_RECEIVED_BY_EMAIL_ADDRESS_W          PROP_TAG( PT_UNICODE,   0x0076)
#define PR_RECEIVED_BY_EMAIL_ADDRESS_A          PROP_TAG( PT_STRING8,   0x0076)
#define PR_RCVD_REPRESENTING_ADDRTYPE           PROP_TAG( PT_TSTRING,   0x0077)
#define PR_RCVD_REPRESENTING_ADDRTYPE_W         PROP_TAG( PT_UNICODE,   0x0077)
#define PR_RCVD_REPRESENTING_ADDRTYPE_A         PROP_TAG( PT_STRING8,   0x0077)
#define PR_RCVD_REPRESENTING_EMAIL_ADDRESS      PROP_TAG( PT_TSTRING,   0x0078)
#define PR_RCVD_REPRESENTING_EMAIL_ADDRESS_W    PROP_TAG( PT_UNICODE,   0x0078)
#define PR_RCVD_REPRESENTING_EMAIL_ADDRESS_A    PROP_TAG( PT_STRING8,   0x0078)
#define PR_ORIGINAL_AUTHOR_ADDRTYPE             PROP_TAG( PT_TSTRING,   0x0079)
#define PR_ORIGINAL_AUTHOR_ADDRTYPE_W           PROP_TAG( PT_UNICODE,   0x0079)
#define PR_ORIGINAL_AUTHOR_ADDRTYPE_A           PROP_TAG( PT_STRING8,   0x0079)
#define PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS        PROP_TAG( PT_TSTRING,   0x007A)
#define PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_W      PROP_TAG( PT_UNICODE,   0x007A)
#define PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_A      PROP_TAG( PT_STRING8,   0x007A)
#define PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE   PROP_TAG( PT_TSTRING,   0x007B)
#define PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_W PROP_TAG( PT_UNICODE,   0x007B)
#define PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_A PROP_TAG( PT_STRING8,   0x007B)
#define PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS \
                                                PROP_TAG( PT_TSTRING,   0x007C)
#define PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_W \
                                                PROP_TAG( PT_UNICODE,   0x007C)
#define PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_A \
                                                PROP_TAG( PT_STRING8,   0x007C)
#define PR_TRANSPORT_MESSAGE_HEADERS            PROP_TAG(PT_TSTRING,    0x007D)
#define PR_TRANSPORT_MESSAGE_HEADERS_W          PROP_TAG(PT_UNICODE,    0x007D)
#define PR_TRANSPORT_MESSAGE_HEADERS_A          PROP_TAG(PT_STRING8,    0x007D)
#define PR_DELEGATION                           PROP_TAG(PT_BINARY,     0x007E)
#define PR_TNEF_CORRELATION_KEY                 PROP_TAG(PT_BINARY,     0x007F)
#define PR_BODY                                 PROP_TAG( PT_TSTRING,   0x1000)
#define PR_BODY_W                               PROP_TAG( PT_UNICODE,   0x1000)
#define PR_BODY_A                               PROP_TAG( PT_STRING8,   0x1000)
#define PR_REPORT_TEXT                          PROP_TAG( PT_TSTRING,   0x1001)
#define PR_REPORT_TEXT_W                        PROP_TAG( PT_UNICODE,   0x1001)
#define PR_REPORT_TEXT_A                        PROP_TAG( PT_STRING8,   0x1001)
#define PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY  PROP_TAG( PT_BINARY,    0x1002)
#define PR_REPORTING_DL_NAME                    PROP_TAG( PT_BINARY,    0x1003)
#define PR_REPORTING_MTA_CERTIFICATE            PROP_TAG( PT_BINARY,    0x1004)
#define PR_RTF_SYNC_BODY_CRC                    PROP_TAG( PT_LONG,      0x1006)
#define PR_RTF_SYNC_BODY_COUNT                  PROP_TAG( PT_LONG,      0x1007)
#define PR_RTF_SYNC_BODY_TAG                    PROP_TAG( PT_TSTRING,   0x1008)
#define PR_RTF_SYNC_BODY_TAG_W                  PROP_TAG( PT_UNICODE,   0x1008)
#define PR_RTF_SYNC_BODY_TAG_A                  PROP_TAG( PT_STRING8,   0x1008)
#define PR_RTF_COMPRESSED                       PROP_TAG( PT_BINARY,    0x1009)
#define PR_RTF_SYNC_PREFIX_COUNT                PROP_TAG( PT_LONG,      0x1010)
#define PR_RTF_SYNC_TRAILING_COUNT              PROP_TAG( PT_LONG,      0x1011)
#define PR_ORIGINALLY_INTENDED_RECIP_ENTRYID    PROP_TAG( PT_BINARY,    0x1012)
#define PR_BODY_HTML                            PROP_TAG( PT_TSTRING,   0x1013)
#define PR_BODY_HTML_W                          PROP_TAG( PT_UNICODE,   0x1013)
#define PR_BODY_HTML_A                          PROP_TAG( PT_STRING8,   0x1013)
#define PR_CONTENT_INTEGRITY_CHECK              PROP_TAG( PT_BINARY,    0x0C00)
#define PR_EXPLICIT_CONVERSION                  PROP_TAG( PT_LONG,      0x0C01)
#define PR_IPM_RETURN_REQUESTED                 PROP_TAG( PT_BOOLEAN,   0x0C02)
#define PR_MESSAGE_TOKEN                        PROP_TAG( PT_BINARY,    0x0C03)
#define PR_NDR_REASON_CODE                      PROP_TAG( PT_LONG,      0x0C04)
#define PR_NDR_DIAG_CODE                        PROP_TAG( PT_LONG,      0x0C05)
#define PR_NON_RECEIPT_NOTIFICATION_REQUESTED   PROP_TAG( PT_BOOLEAN,   0x0C06)
#define PR_DELIVERY_POINT                       PROP_TAG( PT_LONG,      0x0C07)
#define PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED \
                                                PROP_TAG( PT_BOOLEAN,   0x0C08)
#define PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT \
                                                PROP_TAG( PT_BINARY,    0x0C09)
#define PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY \
                                                PROP_TAG( PT_BOOLEAN,   0x0C0A)
#define PR_PHYSICAL_DELIVERY_MODE               PROP_TAG( PT_LONG,      0x0C0B)
#define PR_PHYSICAL_DELIVERY_REPORT_REQUEST     PROP_TAG( PT_LONG,      0x0C0C)
#define PR_PHYSICAL_FORWARDING_ADDRESS          PROP_TAG( PT_BINARY,    0x0C0D)
#define PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED \
                                                PROP_TAG( PT_BOOLEAN,   0x0C0E)
#define PR_PHYSICAL_FORWARDING_PROHIBITED       PROP_TAG( PT_BOOLEAN,   0x0C0F)
#define PR_PHYSICAL_RENDITION_ATTRIBUTES        PROP_TAG( PT_BINARY,    0x0C10)
#define PR_PROOF_OF_DELIVERY                    PROP_TAG( PT_BINARY,    0x0C11)
#define PR_PROOF_OF_DELIVERY_REQUESTED          PROP_TAG( PT_BOOLEAN,   0x0C12)
#define PR_RECIPIENT_CERTIFICATE                PROP_TAG( PT_BINARY,    0x0C13)
#define PR_RECIPIENT_NUMBER_FOR_ADVICE          PROP_TAG( PT_TSTRING,   0x0C14)
#define PR_RECIPIENT_NUMBER_FOR_ADVICE_W        PROP_TAG( PT_UNICODE,   0x0C14)
#define PR_RECIPIENT_NUMBER_FOR_ADVICE_A        PROP_TAG( PT_STRING8,   0x0C14)
#define PR_RECIPIENT_TYPE                       PROP_TAG( PT_LONG,      0x0C15)
#define PR_REGISTERED_MAIL_TYPE                 PROP_TAG( PT_LONG,      0x0C16)
#define PR_REPLY_REQUESTED                      PROP_TAG( PT_BOOLEAN,   0x0C17)
#define PR_REQUESTED_DELIVERY_METHOD            PROP_TAG( PT_LONG,      0x0C18)
#define PR_SENDER_ENTRYID                       PROP_TAG( PT_BINARY,    0x0C19)
#define PR_SENDER_NAME                          PROP_TAG( PT_TSTRING,   0x0C1A)
#define PR_SENDER_NAME_W                        PROP_TAG( PT_UNICODE,   0x0C1A)
#define PR_SENDER_NAME_A                        PROP_TAG( PT_STRING8,   0x0C1A)
#define PR_SUPPLEMENTARY_INFO                   PROP_TAG( PT_TSTRING,   0x0C1B)
#define PR_SUPPLEMENTARY_INFO_W                 PROP_TAG( PT_UNICODE,   0x0C1B)
#define PR_SUPPLEMENTARY_INFO_A                 PROP_TAG( PT_STRING8,   0x0C1B)
#define PR_TYPE_OF_MTS_USER                     PROP_TAG( PT_LONG,      0x0C1C)
#define PR_SENDER_SEARCH_KEY                    PROP_TAG( PT_BINARY,    0x0C1D)
#define PR_SENDER_ADDRTYPE                      PROP_TAG( PT_TSTRING,   0x0C1E)
#define PR_SENDER_ADDRTYPE_W                    PROP_TAG( PT_UNICODE,   0x0C1E)
#define PR_SENDER_ADDRTYPE_A                    PROP_TAG( PT_STRING8,   0x0C1E)
#define PR_SENDER_EMAIL_ADDRESS                 PROP_TAG( PT_TSTRING,   0x0C1F)
#define PR_SENDER_EMAIL_ADDRESS_W               PROP_TAG( PT_UNICODE,   0x0C1F)
#define PR_SENDER_EMAIL_ADDRESS_A               PROP_TAG( PT_STRING8,   0x0C1F)
#define PR_CURRENT_VERSION                      PROP_TAG( PT_I8,        0x0E00)
#define PR_DELETE_AFTER_SUBMIT                  PROP_TAG( PT_BOOLEAN,   0x0E01)
#define PR_DISPLAY_BCC                          PROP_TAG( PT_TSTRING,   0x0E02)
#define PR_DISPLAY_BCC_W                        PROP_TAG( PT_UNICODE,   0x0E02)
#define PR_DISPLAY_BCC_A                        PROP_TAG( PT_STRING8,   0x0E02)
#define PR_DISPLAY_CC                           PROP_TAG( PT_TSTRING,   0x0E03)
#define PR_DISPLAY_CC_W                         PROP_TAG( PT_UNICODE,   0x0E03)
#define PR_DISPLAY_CC_A                         PROP_TAG( PT_STRING8,   0x0E03)
#define PR_DISPLAY_TO                           PROP_TAG( PT_TSTRING,   0x0E04)
#define PR_DISPLAY_TO_W                         PROP_TAG( PT_UNICODE,   0x0E04)
#define PR_DISPLAY_TO_A                         PROP_TAG( PT_STRING8,   0x0E04)
#define PR_PARENT_DISPLAY                       PROP_TAG( PT_TSTRING,   0x0E05)
#define PR_PARENT_DISPLAY_W                     PROP_TAG( PT_UNICODE,   0x0E05)
#define PR_PARENT_DISPLAY_A                     PROP_TAG( PT_STRING8,   0x0E05)
#define PR_MESSAGE_DELIVERY_TIME                PROP_TAG( PT_SYSTIME,   0x0E06)
#define PR_MESSAGE_FLAGS                        PROP_TAG( PT_LONG,      0x0E07)
#define PR_MESSAGE_SIZE                         PROP_TAG( PT_LONG,      0x0E08)
#define PR_PARENT_ENTRYID                       PROP_TAG( PT_BINARY,    0x0E09)
#define PR_SENTMAIL_ENTRYID                     PROP_TAG( PT_BINARY,    0x0E0A)
#define PR_CORRELATE                            PROP_TAG( PT_BOOLEAN,   0x0E0C)
#define PR_CORRELATE_MTSID                      PROP_TAG( PT_BINARY,    0x0E0D)
#define PR_DISCRETE_VALUES                      PROP_TAG( PT_BOOLEAN,   0x0E0E)
#define PR_RESPONSIBILITY                       PROP_TAG( PT_BOOLEAN,   0x0E0F)
#define PR_SPOOLER_STATUS                       PROP_TAG( PT_LONG,      0x0E10)
#define PR_TRANSPORT_STATUS                     PROP_TAG( PT_LONG,      0x0E11)
#define PR_MESSAGE_RECIPIENTS                   PROP_TAG( PT_OBJECT,    0x0E12)
#define PR_MESSAGE_ATTACHMENTS                  PROP_TAG( PT_OBJECT,    0x0E13)
#define PR_SUBMIT_FLAGS                         PROP_TAG( PT_LONG,      0x0E14)
#define PR_RECIPIENT_STATUS                     PROP_TAG( PT_LONG,      0x0E15)
#define PR_TRANSPORT_KEY                        PROP_TAG( PT_LONG,      0x0E16)
#define PR_MSG_STATUS                           PROP_TAG( PT_LONG,      0x0E17)
#define PR_MESSAGE_DOWNLOAD_TIME                PROP_TAG( PT_LONG,      0x0E18)
#define PR_CREATION_VERSION                     PROP_TAG( PT_I8,        0x0E19)
#define PR_MODIFY_VERSION                       PROP_TAG( PT_I8,        0x0E1A)
#define PR_HASATTACH                            PROP_TAG( PT_BOOLEAN,   0x0E1B)
#define PR_BODY_CRC                             PROP_TAG( PT_LONG,      0x0E1C)
#define PR_NORMALIZED_SUBJECT                   PROP_TAG( PT_TSTRING,   0x0E1D)
#define PR_NORMALIZED_SUBJECT_W                 PROP_TAG( PT_UNICODE,   0x0E1D)
#define PR_NORMALIZED_SUBJECT_A                 PROP_TAG( PT_STRING8,   0x0E1D)
#define PR_RTF_IN_SYNC                          PROP_TAG( PT_BOOLEAN,   0x0E1F)
#define PR_ATTACH_SIZE                          PROP_TAG( PT_LONG,      0x0E20)
#define PR_ATTACH_NUM                           PROP_TAG( PT_LONG,      0x0E21)
#define PR_PREPROCESS                           PROP_TAG( PT_BOOLEAN,   0x0E22)
#define PR_ORIGINATING_MTA_CERTIFICATE          PROP_TAG( PT_BINARY,    0x0E25)
#define PR_PROOF_OF_SUBMISSION                  PROP_TAG( PT_BINARY,    0x0E26)
#define PR_PRIMARY_SEND_ACCT                    PROP_TAG( PT_UNICODE,   0x0E28)
#define PR_ENTRYID                              PROP_TAG( PT_BINARY,    0x0FFF)
#define PR_OBJECT_TYPE                          PROP_TAG( PT_LONG,      0x0FFE)
#define PR_ICON                                 PROP_TAG( PT_BINARY,    0x0FFD)
#define PR_MINI_ICON                            PROP_TAG( PT_BINARY,    0x0FFC)
#define PR_STORE_ENTRYID                        PROP_TAG( PT_BINARY,    0x0FFB)
#define PR_STORE_RECORD_KEY                     PROP_TAG( PT_BINARY,    0x0FFA)
#define PR_RECORD_KEY                           PROP_TAG( PT_BINARY,    0x0FF9)
#define PR_MAPPING_SIGNATURE                    PROP_TAG( PT_BINARY,    0x0FF8)
#define PR_ACCESS_LEVEL                         PROP_TAG( PT_LONG,      0x0FF7)
#define PR_INSTANCE_KEY                         PROP_TAG( PT_BINARY,    0x0FF6)
#define PR_ROW_TYPE                             PROP_TAG( PT_LONG,      0x0FF5)
#define PR_ACCESS                               PROP_TAG( PT_LONG,      0x0FF4)
#define PR_ROWID                                PROP_TAG( PT_LONG,      0x3000)
#define PR_DISPLAY_NAME                         PROP_TAG( PT_TSTRING,   0x3001)
#define PR_DISPLAY_NAME_W                       PROP_TAG( PT_UNICODE,   0x3001)
#define PR_DISPLAY_NAME_A                       PROP_TAG( PT_STRING8,   0x3001)
#define PR_ADDRTYPE                             PROP_TAG( PT_TSTRING,   0x3002)
#define PR_ADDRTYPE_W                           PROP_TAG( PT_UNICODE,   0x3002)
#define PR_ADDRTYPE_A                           PROP_TAG( PT_STRING8,   0x3002)
#define PR_EMAIL_ADDRESS                        PROP_TAG( PT_TSTRING,   0x3003)
#define PR_EMAIL_ADDRESS_W                      PROP_TAG( PT_UNICODE,   0x3003)
#define PR_EMAIL_ADDRESS_A                      PROP_TAG( PT_STRING8,   0x3003)
#define PR_COMMENT                              PROP_TAG( PT_TSTRING,   0x3004)
#define PR_COMMENT_W                            PROP_TAG( PT_UNICODE,   0x3004)
#define PR_COMMENT_A                            PROP_TAG( PT_STRING8,   0x3004)
#define PR_DEPTH                                PROP_TAG( PT_LONG,      0x3005)
#define PR_PROVIDER_DISPLAY                     PROP_TAG( PT_TSTRING,   0x3006)
#define PR_PROVIDER_DISPLAY_W                   PROP_TAG( PT_UNICODE,   0x3006)
#define PR_PROVIDER_DISPLAY_A                   PROP_TAG( PT_STRING8,   0x3006)
#define PR_CREATION_TIME                        PROP_TAG( PT_SYSTIME,   0x3007)
#define PR_LAST_MODIFICATION_TIME               PROP_TAG( PT_SYSTIME,   0x3008)
#define PR_RESOURCE_FLAGS                       PROP_TAG( PT_LONG,      0x3009)
#define PR_PROVIDER_DLL_NAME                    PROP_TAG( PT_TSTRING,   0x300A)
#define PR_PROVIDER_DLL_NAME_W                  PROP_TAG( PT_UNICODE,   0x300A)
#define PR_PROVIDER_DLL_NAME_A                  PROP_TAG( PT_STRING8,   0x300A)
#define PR_SEARCH_KEY                           PROP_TAG( PT_BINARY,    0x300B)
#define PR_PROVIDER_UID                         PROP_TAG( PT_BINARY,    0x300C)
#define PR_PROVIDER_ORDINAL                     PROP_TAG( PT_LONG,      0x300D)
#define PR_FORM_VERSION                         PROP_TAG(PT_TSTRING,    0x3301)
#define PR_FORM_VERSION_W                       PROP_TAG(PT_UNICODE,    0x3301)
#define PR_FORM_VERSION_A                       PROP_TAG(PT_STRING8,    0x3301)
#define PR_FORM_CLSID                           PROP_TAG(PT_CLSID,      0x3302)
#define PR_FORM_CONTACT_NAME                    PROP_TAG(PT_TSTRING,    0x3303)
#define PR_FORM_CONTACT_NAME_W                  PROP_TAG(PT_UNICODE,    0x3303)
#define PR_FORM_CONTACT_NAME_A                  PROP_TAG(PT_STRING8,    0x3303)
#define PR_FORM_CATEGORY                        PROP_TAG(PT_TSTRING,    0x3304)
#define PR_FORM_CATEGORY_W                      PROP_TAG(PT_UNICODE,    0x3304)
#define PR_FORM_CATEGORY_A                      PROP_TAG(PT_STRING8,    0x3304)
#define PR_FORM_CATEGORY_SUB                    PROP_TAG(PT_TSTRING,    0x3305)
#define PR_FORM_CATEGORY_SUB_W                  PROP_TAG(PT_UNICODE,    0x3305)
#define PR_FORM_CATEGORY_SUB_A                  PROP_TAG(PT_STRING8,    0x3305)
#define PR_FORM_HOST_MAP                        PROP_TAG(PT_MV_LONG,    0x3306)
#define PR_FORM_HIDDEN                          PROP_TAG(PT_BOOLEAN,    0x3307)
#define PR_FORM_DESIGNER_NAME                   PROP_TAG(PT_TSTRING,    0x3308)
#define PR_FORM_DESIGNER_NAME_W                 PROP_TAG(PT_UNICODE,    0x3308)
#define PR_FORM_DESIGNER_NAME_A                 PROP_TAG(PT_STRING8,    0x3308)
#define PR_FORM_DESIGNER_GUID                   PROP_TAG(PT_CLSID,      0x3309)
#define PR_FORM_MESSAGE_BEHAVIOR                PROP_TAG(PT_LONG,       0x330A)
#define PR_DEFAULT_STORE                        PROP_TAG( PT_BOOLEAN,   0x3400)
#define PR_STORE_SUPPORT_MASK                   PROP_TAG( PT_LONG,      0x340D)
#define PR_STORE_STATE                          PROP_TAG( PT_LONG,      0x340E)
#define PR_IPM_SUBTREE_SEARCH_KEY               PROP_TAG( PT_BINARY,    0x3410)
#define PR_IPM_OUTBOX_SEARCH_KEY                PROP_TAG( PT_BINARY,    0x3411)
#define PR_IPM_WASTEBASKET_SEARCH_KEY           PROP_TAG( PT_BINARY,    0x3412)
#define PR_IPM_SENTMAIL_SEARCH_KEY              PROP_TAG( PT_BINARY,    0x3413)
#define PR_MDB_PROVIDER                         PROP_TAG( PT_BINARY,    0x3414)
#define PR_RECEIVE_FOLDER_SETTINGS              PROP_TAG( PT_OBJECT,    0x3415)
#define PR_VALID_FOLDER_MASK                    PROP_TAG( PT_LONG,      0x35DF)
#define PR_IPM_SUBTREE_ENTRYID                  PROP_TAG( PT_BINARY,    0x35E0)
#define PR_IPM_OUTBOX_ENTRYID                   PROP_TAG( PT_BINARY,    0x35E2)
#define PR_IPM_WASTEBASKET_ENTRYID              PROP_TAG( PT_BINARY,    0x35E3)
#define PR_IPM_SENTMAIL_ENTRYID                 PROP_TAG( PT_BINARY,    0x35E4)
#define PR_VIEWS_ENTRYID                        PROP_TAG( PT_BINARY,    0x35E5)
#define PR_COMMON_VIEWS_ENTRYID                 PROP_TAG( PT_BINARY,    0x35E6)
#define PR_FINDER_ENTRYID                       PROP_TAG( PT_BINARY,    0x35E7)
#define PR_CONTAINER_FLAGS                      PROP_TAG( PT_LONG,      0x3600)
#define PR_FOLDER_TYPE                          PROP_TAG( PT_LONG,      0x3601)
#define PR_CONTENT_COUNT                        PROP_TAG( PT_LONG,      0x3602)
#define PR_CONTENT_UNREAD                       PROP_TAG( PT_LONG,      0x3603)
#define PR_CREATE_TEMPLATES                     PROP_TAG( PT_OBJECT,    0x3604)
#define PR_DETAILS_TABLE                        PROP_TAG( PT_OBJECT,    0x3605)
#define PR_SEARCH                               PROP_TAG( PT_OBJECT,    0x3607)
#define PR_SELECTABLE                           PROP_TAG( PT_BOOLEAN,   0x3609)
#define PR_SUBFOLDERS                           PROP_TAG( PT_BOOLEAN,   0x360A)
#define PR_STATUS                               PROP_TAG( PT_LONG,      0x360B)
#define PR_ANR                                  PROP_TAG( PT_TSTRING,   0x360C)
#define PR_ANR_W                                PROP_TAG( PT_UNICODE,   0x360C)
#define PR_ANR_A                                PROP_TAG( PT_STRING8,   0x360C)
#define PR_CONTENTS_SORT_ORDER                  PROP_TAG( PT_MV_LONG,   0x360D)
#define PR_CONTAINER_HIERARCHY                  PROP_TAG( PT_OBJECT,    0x360E)
#define PR_CONTAINER_CONTENTS                   PROP_TAG( PT_OBJECT,    0x360F)
#define PR_FOLDER_ASSOCIATED_CONTENTS           PROP_TAG( PT_OBJECT,    0x3610)
#define PR_DEF_CREATE_DL                        PROP_TAG( PT_BINARY,    0x3611)
#define PR_DEF_CREATE_MAILUSER                  PROP_TAG( PT_BINARY,    0x3612)
#define PR_CONTAINER_CLASS                      PROP_TAG( PT_TSTRING,   0x3613)
#define PR_CONTAINER_CLASS_W                    PROP_TAG( PT_UNICODE,   0x3613)
#define PR_CONTAINER_CLASS_A                    PROP_TAG( PT_STRING8,   0x3613)
#define PR_CONTAINER_MODIFY_VERSION             PROP_TAG( PT_I8,        0x3614)
#define PR_AB_PROVIDER_ID                       PROP_TAG( PT_BINARY,    0x3615)
#define PR_DEFAULT_VIEW_ENTRYID                 PROP_TAG( PT_BINARY,    0x3616)
#define PR_ASSOC_CONTENT_COUNT                  PROP_TAG( PT_LONG,      0x3617)
#define PR_ATTACHMENT_X400_PARAMETERS           PROP_TAG( PT_BINARY,    0x3700)
#define PR_ATTACH_DATA_OBJ                      PROP_TAG( PT_OBJECT,    0x3701)
#define PR_ATTACH_DATA_BIN                      PROP_TAG( PT_BINARY,    0x3701)
#define PR_ATTACH_ENCODING                      PROP_TAG( PT_BINARY,    0x3702)
#define PR_ATTACH_EXTENSION                     PROP_TAG( PT_TSTRING,   0x3703)
#define PR_ATTACH_EXTENSION_W                   PROP_TAG( PT_UNICODE,   0x3703)
#define PR_ATTACH_EXTENSION_A                   PROP_TAG( PT_STRING8,   0x3703)
#define PR_ATTACH_FILENAME                      PROP_TAG( PT_TSTRING,   0x3704)
#define PR_ATTACH_FILENAME_W                    PROP_TAG( PT_UNICODE,   0x3704)
#define PR_ATTACH_FILENAME_A                    PROP_TAG( PT_STRING8,   0x3704)
#define PR_ATTACH_METHOD                        PROP_TAG( PT_LONG,      0x3705)
#define PR_ATTACH_LONG_FILENAME                 PROP_TAG( PT_TSTRING,   0x3707)
#define PR_ATTACH_LONG_FILENAME_W               PROP_TAG( PT_UNICODE,   0x3707)
#define PR_ATTACH_LONG_FILENAME_A               PROP_TAG( PT_STRING8,   0x3707)
#define PR_ATTACH_PATHNAME                      PROP_TAG( PT_TSTRING,   0x3708)
#define PR_ATTACH_PATHNAME_W                    PROP_TAG( PT_UNICODE,   0x3708)
#define PR_ATTACH_PATHNAME_A                    PROP_TAG( PT_STRING8,   0x3708)
#define PR_ATTACH_RENDERING                     PROP_TAG( PT_BINARY,    0x3709)
#define PR_ATTACH_TAG                           PROP_TAG( PT_BINARY,    0x370A)
#define PR_RENDERING_POSITION                   PROP_TAG( PT_LONG,      0x370B)
#define PR_ATTACH_TRANSPORT_NAME                PROP_TAG( PT_TSTRING,   0x370C)
#define PR_ATTACH_TRANSPORT_NAME_W              PROP_TAG( PT_UNICODE,   0x370C)
#define PR_ATTACH_TRANSPORT_NAME_A              PROP_TAG( PT_STRING8,   0x370C)
#define PR_ATTACH_LONG_PATHNAME                 PROP_TAG( PT_TSTRING,   0x370D)
#define PR_ATTACH_LONG_PATHNAME_W               PROP_TAG( PT_UNICODE,   0x370D)
#define PR_ATTACH_LONG_PATHNAME_A               PROP_TAG( PT_STRING8,   0x370D)
#define PR_ATTACH_MIME_TAG                      PROP_TAG( PT_TSTRING,   0x370E)
#define PR_ATTACH_MIME_TAG_W                    PROP_TAG( PT_UNICODE,   0x370E)
#define PR_ATTACH_MIME_TAG_A                    PROP_TAG( PT_STRING8,   0x370E)
#define PR_ATTACH_ADDITIONAL_INFO               PROP_TAG( PT_BINARY,    0x370F)
#define PR_ATTACH_CONTENT_ID                    PROP_TAG( PT_UNICODE,   0x3712)
#define PR_DISPLAY_TYPE                         PROP_TAG( PT_LONG,      0x3900)
#define PR_TEMPLATEID                           PROP_TAG( PT_BINARY,    0x3902)
#define PR_PRIMARY_CAPABILITY                   PROP_TAG( PT_BINARY,    0x3904)
#define PR_7BIT_DISPLAY_NAME                    PROP_TAG( PT_STRING8,   0x39FF)
#define PR_ACCOUNT                              PROP_TAG( PT_TSTRING,   0x3A00)
#define PR_ACCOUNT_W                            PROP_TAG( PT_UNICODE,   0x3A00)
#define PR_ACCOUNT_A                            PROP_TAG( PT_STRING8,   0x3A00)
#define PR_ALTERNATE_RECIPIENT                  PROP_TAG( PT_BINARY,    0x3A01)
#define PR_CALLBACK_TELEPHONE_NUMBER            PROP_TAG( PT_TSTRING,   0x3A02)
#define PR_CALLBACK_TELEPHONE_NUMBER_W          PROP_TAG( PT_UNICODE,   0x3A02)
#define PR_CALLBACK_TELEPHONE_NUMBER_A          PROP_TAG( PT_STRING8,   0x3A02)
#define PR_CONVERSION_PROHIBITED                PROP_TAG( PT_BOOLEAN,   0x3A03)
#define PR_DISCLOSE_RECIPIENTS                  PROP_TAG( PT_BOOLEAN,   0x3A04)
#define PR_GENERATION                           PROP_TAG( PT_TSTRING,   0x3A05)
#define PR_GENERATION_W                         PROP_TAG( PT_UNICODE,   0x3A05)
#define PR_GENERATION_A                         PROP_TAG( PT_STRING8,   0x3A05)
#define PR_GIVEN_NAME                           PROP_TAG( PT_TSTRING,   0x3A06)
#define PR_GIVEN_NAME_W                         PROP_TAG( PT_UNICODE,   0x3A06)
#define PR_GIVEN_NAME_A                         PROP_TAG( PT_STRING8,   0x3A06)
#define PR_GOVERNMENT_ID_NUMBER                 PROP_TAG( PT_TSTRING,   0x3A07)
#define PR_GOVERNMENT_ID_NUMBER_W               PROP_TAG( PT_UNICODE,   0x3A07)
#define PR_GOVERNMENT_ID_NUMBER_A               PROP_TAG( PT_STRING8,   0x3A07)
#define PR_BUSINESS_TELEPHONE_NUMBER            PROP_TAG( PT_TSTRING,   0x3A08)
#define PR_BUSINESS_TELEPHONE_NUMBER_W          PROP_TAG( PT_UNICODE,   0x3A08)
#define PR_BUSINESS_TELEPHONE_NUMBER_A          PROP_TAG( PT_STRING8,   0x3A08)
#define PR_OFFICE_TELEPHONE_NUMBER              PR_BUSINESS_TELEPHONE_NUMBER
#define PR_OFFICE_TELEPHONE_NUMBER_W            PR_BUSINESS_TELEPHONE_NUMBER_W
#define PR_OFFICE_TELEPHONE_NUMBER_A            PR_BUSINESS_TELEPHONE_NUMBER_A
#define PR_HOME_TELEPHONE_NUMBER                PROP_TAG( PT_TSTRING,   0x3A09)
#define PR_HOME_TELEPHONE_NUMBER_W              PROP_TAG( PT_UNICODE,   0x3A09)
#define PR_HOME_TELEPHONE_NUMBER_A              PROP_TAG( PT_STRING8,   0x3A09)
#define PR_INITIALS                             PROP_TAG( PT_TSTRING,   0x3A0A)
#define PR_INITIALS_W                           PROP_TAG( PT_UNICODE,   0x3A0A)
#define PR_INITIALS_A                           PROP_TAG( PT_STRING8,   0x3A0A)
#define PR_KEYWORD                              PROP_TAG( PT_TSTRING,   0x3A0B)
#define PR_KEYWORD_W                            PROP_TAG( PT_UNICODE,   0x3A0B)
#define PR_KEYWORD_A                            PROP_TAG( PT_STRING8,   0x3A0B)
#define PR_LANGUAGE                             PROP_TAG( PT_TSTRING,   0x3A0C)
#define PR_LANGUAGE_W                           PROP_TAG( PT_UNICODE,   0x3A0C)
#define PR_LANGUAGE_A                           PROP_TAG( PT_STRING8,   0x3A0C)
#define PR_LOCATION                             PROP_TAG( PT_TSTRING,   0x3A0D)
#define PR_LOCATION_W                           PROP_TAG( PT_UNICODE,   0x3A0D)
#define PR_LOCATION_A                           PROP_TAG( PT_STRING8,   0x3A0D)
#define PR_MAIL_PERMISSION                      PROP_TAG( PT_BOOLEAN,   0x3A0E)
#define PR_MHS_COMMON_NAME                      PROP_TAG( PT_TSTRING,   0x3A0F)
#define PR_MHS_COMMON_NAME_W                    PROP_TAG( PT_UNICODE,   0x3A0F)
#define PR_MHS_COMMON_NAME_A                    PROP_TAG( PT_STRING8,   0x3A0F)
#define PR_ORGANIZATIONAL_ID_NUMBER             PROP_TAG( PT_TSTRING,   0x3A10)
#define PR_ORGANIZATIONAL_ID_NUMBER_W           PROP_TAG( PT_UNICODE,   0x3A10)
#define PR_ORGANIZATIONAL_ID_NUMBER_A           PROP_TAG( PT_STRING8,   0x3A10)
#define PR_SURNAME                              PROP_TAG( PT_TSTRING,   0x3A11)
#define PR_SURNAME_W                            PROP_TAG( PT_UNICODE,   0x3A11)
#define PR_SURNAME_A                            PROP_TAG( PT_STRING8,   0x3A11)
#define PR_ORIGINAL_ENTRYID                     PROP_TAG( PT_BINARY,    0x3A12)
#define PR_ORIGINAL_DISPLAY_NAME                PROP_TAG( PT_TSTRING,   0x3A13)
#define PR_ORIGINAL_DISPLAY_NAME_W              PROP_TAG( PT_UNICODE,   0x3A13)
#define PR_ORIGINAL_DISPLAY_NAME_A              PROP_TAG( PT_STRING8,   0x3A13)
#define PR_ORIGINAL_SEARCH_KEY                  PROP_TAG( PT_BINARY,    0x3A14)
#define PR_POSTAL_ADDRESS                       PROP_TAG( PT_TSTRING,   0x3A15)
#define PR_POSTAL_ADDRESS_W                     PROP_TAG( PT_UNICODE,   0x3A15)
#define PR_POSTAL_ADDRESS_A                     PROP_TAG( PT_STRING8,   0x3A15)
#define PR_COMPANY_NAME                         PROP_TAG( PT_TSTRING,   0x3A16)
#define PR_COMPANY_NAME_W                       PROP_TAG( PT_UNICODE,   0x3A16)
#define PR_COMPANY_NAME_A                       PROP_TAG( PT_STRING8,   0x3A16)
#define PR_TITLE                                PROP_TAG( PT_TSTRING,   0x3A17)
#define PR_TITLE_W                              PROP_TAG( PT_UNICODE,   0x3A17)
#define PR_TITLE_A                              PROP_TAG( PT_STRING8,   0x3A17)
#define PR_DEPARTMENT_NAME                      PROP_TAG( PT_TSTRING,   0x3A18)
#define PR_DEPARTMENT_NAME_W                    PROP_TAG( PT_UNICODE,   0x3A18)
#define PR_DEPARTMENT_NAME_A                    PROP_TAG( PT_STRING8,   0x3A18)
#define PR_OFFICE_LOCATION                      PROP_TAG( PT_TSTRING,   0x3A19)
#define PR_OFFICE_LOCATION_W                    PROP_TAG( PT_UNICODE,   0x3A19)
#define PR_OFFICE_LOCATION_A                    PROP_TAG( PT_STRING8,   0x3A19)
#define PR_PRIMARY_TELEPHONE_NUMBER             PROP_TAG( PT_TSTRING,   0x3A1A)
#define PR_PRIMARY_TELEPHONE_NUMBER_W           PROP_TAG( PT_UNICODE,   0x3A1A)
#define PR_PRIMARY_TELEPHONE_NUMBER_A           PROP_TAG( PT_STRING8,   0x3A1A)
#define PR_BUSINESS2_TELEPHONE_NUMBER           PROP_TAG( PT_TSTRING,   0x3A1B)
#define PR_BUSINESS2_TELEPHONE_NUMBER_W         PROP_TAG( PT_UNICODE,   0x3A1B)
#define PR_BUSINESS2_TELEPHONE_NUMBER_A         PROP_TAG( PT_STRING8,   0x3A1B)
#define PR_OFFICE2_TELEPHONE_NUMBER             PR_BUSINESS2_TELEPHONE_NUMBER
#define PR_OFFICE2_TELEPHONE_NUMBER_W           PR_BUSINESS2_TELEPHONE_NUMBER_W
#define PR_OFFICE2_TELEPHONE_NUMBER_A           PR_BUSINESS2_TELEPHONE_NUMBER_A
#define PR_MOBILE_TELEPHONE_NUMBER              PROP_TAG( PT_TSTRING,   0x3A1C)
#define PR_MOBILE_TELEPHONE_NUMBER_W            PROP_TAG( PT_UNICODE,   0x3A1C)
#define PR_MOBILE_TELEPHONE_NUMBER_A            PROP_TAG( PT_STRING8,   0x3A1C)
#define PR_CELLULAR_TELEPHONE_NUMBER            PR_MOBILE_TELEPHONE_NUMBER
#define PR_CELLULAR_TELEPHONE_NUMBER_W          PR_MOBILE_TELEPHONE_NUMBER_W
#define PR_CELLULAR_TELEPHONE_NUMBER_A          PR_MOBILE_TELEPHONE_NUMBER_A
#define PR_RADIO_TELEPHONE_NUMBER               PROP_TAG( PT_TSTRING,   0x3A1D)
#define PR_RADIO_TELEPHONE_NUMBER_W             PROP_TAG( PT_UNICODE,   0x3A1D)
#define PR_RADIO_TELEPHONE_NUMBER_A             PROP_TAG( PT_STRING8,   0x3A1D)
#define PR_CAR_TELEPHONE_NUMBER                 PROP_TAG( PT_TSTRING,   0x3A1E)
#define PR_CAR_TELEPHONE_NUMBER_W               PROP_TAG( PT_UNICODE,   0x3A1E)
#define PR_CAR_TELEPHONE_NUMBER_A               PROP_TAG( PT_STRING8,   0x3A1E)
#define PR_OTHER_TELEPHONE_NUMBER               PROP_TAG( PT_TSTRING,   0x3A1F)
#define PR_OTHER_TELEPHONE_NUMBER_W             PROP_TAG( PT_UNICODE,   0x3A1F)
#define PR_OTHER_TELEPHONE_NUMBER_A             PROP_TAG( PT_STRING8,   0x3A1F)
#define PR_TRANSMITABLE_DISPLAY_NAME            PROP_TAG( PT_TSTRING,   0x3A20)
#define PR_TRANSMITABLE_DISPLAY_NAME_W          PROP_TAG( PT_UNICODE,   0x3A20)
#define PR_TRANSMITABLE_DISPLAY_NAME_A          PROP_TAG( PT_STRING8,   0x3A20)
#define PR_PAGER_TELEPHONE_NUMBER               PROP_TAG( PT_TSTRING,   0x3A21)
#define PR_PAGER_TELEPHONE_NUMBER_W             PROP_TAG( PT_UNICODE,   0x3A21)
#define PR_PAGER_TELEPHONE_NUMBER_A             PROP_TAG( PT_STRING8,   0x3A21)
#define PR_BEEPER_TELEPHONE_NUMBER              PR_PAGER_TELEPHONE_NUMBER
#define PR_BEEPER_TELEPHONE_NUMBER_W            PR_PAGER_TELEPHONE_NUMBER_W
#define PR_BEEPER_TELEPHONE_NUMBER_A            PR_PAGER_TELEPHONE_NUMBER_A
#define PR_USER_CERTIFICATE                     PROP_TAG( PT_BINARY,    0x3A22)
#define PR_PRIMARY_FAX_NUMBER                   PROP_TAG( PT_TSTRING,   0x3A23)
#define PR_PRIMARY_FAX_NUMBER_W                 PROP_TAG( PT_UNICODE,   0x3A23)
#define PR_PRIMARY_FAX_NUMBER_A                 PROP_TAG( PT_STRING8,   0x3A23)
#define PR_BUSINESS_FAX_NUMBER                  PROP_TAG( PT_TSTRING,   0x3A24)
#define PR_BUSINESS_FAX_NUMBER_W                PROP_TAG( PT_UNICODE,   0x3A24)
#define PR_BUSINESS_FAX_NUMBER_A                PROP_TAG( PT_STRING8,   0x3A24)
#define PR_HOME_FAX_NUMBER                      PROP_TAG( PT_TSTRING,   0x3A25)
#define PR_HOME_FAX_NUMBER_W                    PROP_TAG( PT_UNICODE,   0x3A25)
#define PR_HOME_FAX_NUMBER_A                    PROP_TAG( PT_STRING8,   0x3A25)
#define PR_COUNTRY                              PROP_TAG( PT_TSTRING,   0x3A26)
#define PR_COUNTRY_W                            PROP_TAG( PT_UNICODE,   0x3A26)
#define PR_COUNTRY_A                            PROP_TAG( PT_STRING8,   0x3A26)
#define PR_BUSINESS_ADDRESS_COUNTRY             PR_COUNTRY
#define PR_BUSINESS_ADDRESS_COUNTRY_W           PR_COUNTRY_W
#define PR_BUSINESS_ADDRESS_COUNTRY_A           PR_COUNTRY_A
#define PR_LOCALITY                             PROP_TAG( PT_TSTRING,   0x3A27)
#define PR_LOCALITY_W                           PROP_TAG( PT_UNICODE,   0x3A27)
#define PR_LOCALITY_A                           PROP_TAG( PT_STRING8,   0x3A27)
#define PR_BUSINESS_ADDRESS_CITY                PR_LOCALITY
#define PR_BUSINESS_ADDRESS_CITY_W              PR_LOCALITY_W
#define PR_BUSINESS_ADDRESS_CITY_A              PR_LOCALITY_A
#define PR_STATE_OR_PROVINCE                    PROP_TAG( PT_TSTRING,   0x3A28)
#define PR_STATE_OR_PROVINCE_W                  PROP_TAG( PT_UNICODE,   0x3A28)
#define PR_STATE_OR_PROVINCE_A                  PROP_TAG( PT_STRING8,   0x3A28)
#define PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE   PR_STATE_OR_PROVINCE
#define PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE_W PR_STATE_OR_PROVINCE_W
#define PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE_A PR_STATE_OR_PROVINCE_A
#define PR_STREET_ADDRESS                       PROP_TAG( PT_TSTRING,   0x3A29)
#define PR_STREET_ADDRESS_W                     PROP_TAG( PT_UNICODE,   0x3A29)
#define PR_STREET_ADDRESS_A                     PROP_TAG( PT_STRING8,   0x3A29)
#define PR_BUSINESS_ADDRESS_STREET              PR_STREET_ADDRESS
#define PR_BUSINESS_ADDRESS_STREET_W            PR_STREET_ADDRESS_W
#define PR_BUSINESS_ADDRESS_STREET_A            PR_STREET_ADDRESS_A
#define PR_POSTAL_CODE                          PROP_TAG( PT_TSTRING,   0x3A2A)
#define PR_POSTAL_CODE_W                        PROP_TAG( PT_UNICODE,   0x3A2A)
#define PR_POSTAL_CODE_A                        PROP_TAG( PT_STRING8,   0x3A2A)
#define PR_BUSINESS_ADDRESS_POSTAL_CODE         PR_POSTAL_CODE
#define PR_BUSINESS_ADDRESS_POSTAL_CODE_W       PR_POSTAL_CODE_W
#define PR_BUSINESS_ADDRESS_POSTAL_CODE_A       PR_POSTAL_CODE_A
#define PR_POST_OFFICE_BOX                      PROP_TAG( PT_TSTRING,   0x3A2B)
#define PR_POST_OFFICE_BOX_W                    PROP_TAG( PT_UNICODE,   0x3A2B)
#define PR_POST_OFFICE_BOX_A                    PROP_TAG( PT_STRING8,   0x3A2B)
#define PR_BUSINESS_ADDRESS_POST_OFFICE_BOX     PR_POST_OFFICE_BOX
#define PR_BUSINESS_ADDRESS_POST_OFFICE_BOX_W   PR_POST_OFFICE_BOX_W
#define PR_BUSINESS_ADDRESS_POST_OFFICE_BOX_A   PR_POST_OFFICE_BOX_A
#define PR_TELEX_NUMBER                         PROP_TAG( PT_TSTRING,   0x3A2C)
#define PR_TELEX_NUMBER_W                       PROP_TAG( PT_UNICODE,   0x3A2C)
#define PR_TELEX_NUMBER_A                       PROP_TAG( PT_STRING8,   0x3A2C)
#define PR_ISDN_NUMBER                          PROP_TAG( PT_TSTRING,   0x3A2D)
#define PR_ISDN_NUMBER_W                        PROP_TAG( PT_UNICODE,   0x3A2D)
#define PR_ISDN_NUMBER_A                        PROP_TAG( PT_STRING8,   0x3A2D)
#define PR_ASSISTANT_TELEPHONE_NUMBER           PROP_TAG( PT_TSTRING,   0x3A2E)
#define PR_ASSISTANT_TELEPHONE_NUMBER_W         PROP_TAG( PT_UNICODE,   0x3A2E)
#define PR_ASSISTANT_TELEPHONE_NUMBER_A         PROP_TAG( PT_STRING8,   0x3A2E)
#define PR_HOME2_TELEPHONE_NUMBER               PROP_TAG( PT_TSTRING,   0x3A2F)
#define PR_HOME2_TELEPHONE_NUMBER_W             PROP_TAG( PT_UNICODE,   0x3A2F)
#define PR_HOME2_TELEPHONE_NUMBER_A             PROP_TAG( PT_STRING8,   0x3A2F)
#define PR_ASSISTANT                            PROP_TAG( PT_TSTRING,   0x3A30)
#define PR_ASSISTANT_W                          PROP_TAG( PT_UNICODE,   0x3A30)
#define PR_ASSISTANT_A                          PROP_TAG( PT_STRING8,   0x3A30)
#define PR_SEND_RICH_INFO                       PROP_TAG( PT_BOOLEAN,   0x3A40)
#define PR_WEDDING_ANNIVERSARY                  PROP_TAG( PT_SYSTIME,   0x3A41)
#define PR_BIRTHDAY                             PROP_TAG( PT_SYSTIME,   0x3A42)
#define PR_HOBBIES                              PROP_TAG( PT_TSTRING,   0x3A43)
#define PR_HOBBIES_W                            PROP_TAG( PT_UNICODE,   0x3A43)
#define PR_HOBBIES_A                            PROP_TAG( PT_STRING8,   0x3A43)
#define PR_MIDDLE_NAME                          PROP_TAG( PT_TSTRING,   0x3A44)
#define PR_MIDDLE_NAME_W                        PROP_TAG( PT_UNICODE,   0x3A44)
#define PR_MIDDLE_NAME_A                        PROP_TAG( PT_STRING8,   0x3A44)
#define PR_DISPLAY_NAME_PREFIX                  PROP_TAG( PT_TSTRING,   0x3A45)
#define PR_DISPLAY_NAME_PREFIX_W                PROP_TAG( PT_UNICODE,   0x3A45)
#define PR_DISPLAY_NAME_PREFIX_A                PROP_TAG( PT_STRING8,   0x3A45)
#define PR_PROFESSION                           PROP_TAG( PT_TSTRING,   0x3A46)
#define PR_PROFESSION_W                         PROP_TAG( PT_UNICODE,   0x3A46)
#define PR_PROFESSION_A                         PROP_TAG( PT_STRING8,   0x3A46)
#define PR_PREFERRED_BY_NAME                    PROP_TAG( PT_TSTRING,   0x3A47)
#define PR_PREFERRED_BY_NAME_W                  PROP_TAG( PT_UNICODE,   0x3A47)
#define PR_PREFERRED_BY_NAME_A                  PROP_TAG( PT_STRING8,   0x3A47)
#define PR_SPOUSE_NAME                          PROP_TAG( PT_TSTRING,   0x3A48)
#define PR_SPOUSE_NAME_W                        PROP_TAG( PT_UNICODE,   0x3A48)
#define PR_SPOUSE_NAME_A                        PROP_TAG( PT_STRING8,   0x3A48)
#define PR_COMPUTER_NETWORK_NAME                PROP_TAG( PT_TSTRING,   0x3A49)
#define PR_COMPUTER_NETWORK_NAME_W              PROP_TAG( PT_UNICODE,   0x3A49)
#define PR_COMPUTER_NETWORK_NAME_A              PROP_TAG( PT_STRING8,   0x3A49)
#define PR_CUSTOMER_ID                          PROP_TAG( PT_TSTRING,   0x3A4A)
#define PR_CUSTOMER_ID_W                        PROP_TAG( PT_UNICODE,   0x3A4A)
#define PR_CUSTOMER_ID_A                        PROP_TAG( PT_STRING8,   0x3A4A)
#define PR_TTYTDD_PHONE_NUMBER                  PROP_TAG( PT_TSTRING,   0x3A4B)
#define PR_TTYTDD_PHONE_NUMBER_W                PROP_TAG( PT_UNICODE,   0x3A4B)
#define PR_TTYTDD_PHONE_NUMBER_A                PROP_TAG( PT_STRING8,   0x3A4B)
#define PR_FTP_SITE                             PROP_TAG( PT_TSTRING,   0x3A4C)
#define PR_FTP_SITE_W                           PROP_TAG( PT_UNICODE,   0x3A4C)
#define PR_FTP_SITE_A                           PROP_TAG( PT_STRING8,   0x3A4C)
#define PR_GENDER                               PROP_TAG( PT_SHORT,     0x3A4D)
#define PR_MANAGER_NAME                         PROP_TAG( PT_TSTRING,   0x3A4E)
#define PR_MANAGER_NAME_W                       PROP_TAG( PT_UNICODE,   0x3A4E)
#define PR_MANAGER_NAME_A                       PROP_TAG( PT_STRING8,   0x3A4E)
#define PR_NICKNAME                             PROP_TAG( PT_TSTRING,   0x3A4F)
#define PR_NICKNAME_W                           PROP_TAG( PT_UNICODE,   0x3A4F)
#define PR_NICKNAME_A                           PROP_TAG( PT_STRING8,   0x3A4F)
#define PR_PERSONAL_HOME_PAGE                   PROP_TAG( PT_TSTRING,   0x3A50)
#define PR_PERSONAL_HOME_PAGE_W                 PROP_TAG( PT_UNICODE,   0x3A50)
#define PR_PERSONAL_HOME_PAGE_A                 PROP_TAG( PT_STRING8,   0x3A50)
#define PR_BUSINESS_HOME_PAGE                   PROP_TAG( PT_TSTRING,   0x3A51)
#define PR_BUSINESS_HOME_PAGE_W                 PROP_TAG( PT_UNICODE,   0x3A51)
#define PR_BUSINESS_HOME_PAGE_A                 PROP_TAG( PT_STRING8,   0x3A51)
#define PR_CONTACT_VERSION                      PROP_TAG( PT_CLSID,     0x3A52)
#define PR_CONTACT_ENTRYIDS                  PROP_TAG( PT_MV_BINARY,    0x3A53)
#define PR_CONTACT_ADDRTYPES                 PROP_TAG( PT_MV_TSTRING,   0x3A54)
#define PR_CONTACT_ADDRTYPES_W               PROP_TAG( PT_MV_UNICODE,   0x3A54)
#define PR_CONTACT_ADDRTYPES_A               PROP_TAG( PT_MV_STRING8,   0x3A54)
#define PR_CONTACT_DEFAULT_ADDRESS_INDEX        PROP_TAG( PT_LONG,      0x3A55)
#define PR_CONTACT_EMAIL_ADDRESSES           PROP_TAG( PT_MV_TSTRING,   0x3A56)
#define PR_CONTACT_EMAIL_ADDRESSES_W         PROP_TAG( PT_MV_UNICODE,   0x3A56)
#define PR_CONTACT_EMAIL_ADDRESSES_A         PROP_TAG( PT_MV_STRING8,   0x3A56)
#define PR_COMPANY_MAIN_PHONE_NUMBER            PROP_TAG( PT_TSTRING,   0x3A57)
#define PR_COMPANY_MAIN_PHONE_NUMBER_W          PROP_TAG( PT_UNICODE,   0x3A57)
#define PR_COMPANY_MAIN_PHONE_NUMBER_A          PROP_TAG( PT_STRING8,   0x3A57)
#define PR_CHILDRENS_NAMES                   PROP_TAG( PT_MV_TSTRING,   0x3A58)
#define PR_CHILDRENS_NAMES_W                 PROP_TAG( PT_MV_UNICODE,   0x3A58)
#define PR_CHILDRENS_NAMES_A                 PROP_TAG( PT_MV_STRING8,   0x3A58)
#define PR_HOME_ADDRESS_CITY                    PROP_TAG( PT_TSTRING,   0x3A59)
#define PR_HOME_ADDRESS_CITY_W                  PROP_TAG( PT_UNICODE,   0x3A59)
#define PR_HOME_ADDRESS_CITY_A                  PROP_TAG( PT_STRING8,   0x3A59)
#define PR_HOME_ADDRESS_COUNTRY                 PROP_TAG( PT_TSTRING,   0x3A5A)
#define PR_HOME_ADDRESS_COUNTRY_W               PROP_TAG( PT_UNICODE,   0x3A5A)
#define PR_HOME_ADDRESS_COUNTRY_A               PROP_TAG( PT_STRING8,   0x3A5A)
#define PR_HOME_ADDRESS_POSTAL_CODE             PROP_TAG( PT_TSTRING,   0x3A5B)
#define PR_HOME_ADDRESS_POSTAL_CODE_W           PROP_TAG( PT_UNICODE,   0x3A5B)
#define PR_HOME_ADDRESS_POSTAL_CODE_A           PROP_TAG( PT_STRING8,   0x3A5B)
#define PR_HOME_ADDRESS_STATE_OR_PROVINCE       PROP_TAG( PT_TSTRING,   0x3A5C)
#define PR_HOME_ADDRESS_STATE_OR_PROVINCE_W     PROP_TAG( PT_UNICODE,   0x3A5C)
#define PR_HOME_ADDRESS_STATE_OR_PROVINCE_A     PROP_TAG( PT_STRING8,   0x3A5C)
#define PR_HOME_ADDRESS_STREET                  PROP_TAG( PT_TSTRING,   0x3A5D)
#define PR_HOME_ADDRESS_STREET_W                PROP_TAG( PT_UNICODE,   0x3A5D)
#define PR_HOME_ADDRESS_STREET_A                PROP_TAG( PT_STRING8,   0x3A5D)
#define PR_HOME_ADDRESS_POST_OFFICE_BOX         PROP_TAG( PT_TSTRING,   0x3A5E)
#define PR_HOME_ADDRESS_POST_OFFICE_BOX_W       PROP_TAG( PT_UNICODE,   0x3A5E)
#define PR_HOME_ADDRESS_POST_OFFICE_BOX_A       PROP_TAG( PT_STRING8,   0x3A5E)
#define PR_OTHER_ADDRESS_CITY                   PROP_TAG( PT_TSTRING,   0x3A5F)
#define PR_OTHER_ADDRESS_CITY_W                 PROP_TAG( PT_UNICODE,   0x3A5F)
#define PR_OTHER_ADDRESS_CITY_A                 PROP_TAG( PT_STRING8,   0x3A5F)
#define PR_OTHER_ADDRESS_COUNTRY                PROP_TAG( PT_TSTRING,   0x3A60)
#define PR_OTHER_ADDRESS_COUNTRY_W              PROP_TAG( PT_UNICODE,   0x3A60)
#define PR_OTHER_ADDRESS_COUNTRY_A              PROP_TAG( PT_STRING8,   0x3A60)
#define PR_OTHER_ADDRESS_POSTAL_CODE            PROP_TAG( PT_TSTRING,   0x3A61)
#define PR_OTHER_ADDRESS_POSTAL_CODE_W          PROP_TAG( PT_UNICODE,   0x3A61)
#define PR_OTHER_ADDRESS_POSTAL_CODE_A          PROP_TAG( PT_STRING8,   0x3A61)
#define PR_OTHER_ADDRESS_STATE_OR_PROVINCE      PROP_TAG( PT_TSTRING,   0x3A62)
#define PR_OTHER_ADDRESS_STATE_OR_PROVINCE_W    PROP_TAG( PT_UNICODE,   0x3A62)
#define PR_OTHER_ADDRESS_STATE_OR_PROVINCE_A    PROP_TAG( PT_STRING8,   0x3A62)
#define PR_OTHER_ADDRESS_STREET                 PROP_TAG( PT_TSTRING,   0x3A63)
#define PR_OTHER_ADDRESS_STREET_W               PROP_TAG( PT_UNICODE,   0x3A63)
#define PR_OTHER_ADDRESS_STREET_A               PROP_TAG( PT_STRING8,   0x3A63)
#define PR_OTHER_ADDRESS_POST_OFFICE_BOX        PROP_TAG( PT_TSTRING,   0x3A64)
#define PR_OTHER_ADDRESS_POST_OFFICE_BOX_W      PROP_TAG( PT_UNICODE,   0x3A64)
#define PR_OTHER_ADDRESS_POST_OFFICE_BOX_A      PROP_TAG( PT_STRING8,   0x3A64)
#define PR_STORE_PROVIDERS                    PROP_TAG( PT_BINARY,      0x3D00)
#define PR_AB_PROVIDERS                       PROP_TAG( PT_BINARY,      0x3D01)
#define PR_TRANSPORT_PROVIDERS                PROP_TAG( PT_BINARY,      0x3D02)
#define PR_DEFAULT_PROFILE                    PROP_TAG( PT_BOOLEAN,     0x3D04)
#define PR_AB_SEARCH_PATH                     PROP_TAG( PT_MV_BINARY,   0x3D05)
#define PR_AB_DEFAULT_DIR                     PROP_TAG( PT_BINARY,      0x3D06)
#define PR_AB_DEFAULT_PAB                     PROP_TAG( PT_BINARY,      0x3D07)
#define PR_FILTERING_HOOKS                    PROP_TAG( PT_BINARY,      0x3D08)
#define PR_SERVICE_NAME                       PROP_TAG( PT_TSTRING,     0x3D09)
#define PR_SERVICE_NAME_W                     PROP_TAG( PT_UNICODE,     0x3D09)
#define PR_SERVICE_NAME_A                     PROP_TAG( PT_STRING8,     0x3D09)
#define PR_SERVICE_DLL_NAME                   PROP_TAG( PT_TSTRING,     0x3D0A)
#define PR_SERVICE_DLL_NAME_W                 PROP_TAG( PT_UNICODE,     0x3D0A)
#define PR_SERVICE_DLL_NAME_A                 PROP_TAG( PT_STRING8,     0x3D0A)
#define PR_SERVICE_ENTRY_NAME                 PROP_TAG( PT_STRING8,     0x3D0B)
#define PR_SERVICE_UID                        PROP_TAG( PT_BINARY,      0x3D0C)
#define PR_SERVICE_EXTRA_UIDS                 PROP_TAG( PT_BINARY,      0x3D0D)
#define PR_SERVICES                           PROP_TAG( PT_BINARY,      0x3D0E)
#define PR_SERVICE_SUPPORT_FILES             PROP_TAG( PT_MV_TSTRING,   0x3D0F)
#define PR_SERVICE_SUPPORT_FILES_W           PROP_TAG( PT_MV_UNICODE,   0x3D0F)
#define PR_SERVICE_SUPPORT_FILES_A           PROP_TAG( PT_MV_STRING8,   0x3D0F)
#define PR_SERVICE_DELETE_FILES              PROP_TAG( PT_MV_TSTRING,   0x3D10)
#define PR_SERVICE_DELETE_FILES_W            PROP_TAG( PT_MV_UNICODE,   0x3D10)
#define PR_SERVICE_DELETE_FILES_A            PROP_TAG( PT_MV_STRING8,   0x3D10)
#define PR_AB_SEARCH_PATH_UPDATE             PROP_TAG( PT_BINARY,       0x3D11)
#define PR_PROFILE_NAME                       PROP_TAG( PT_TSTRING,     0x3D12)
#define PR_PROFILE_NAME_A                     PROP_TAG( PT_STRING8,     0x3D12)
#define PR_PROFILE_NAME_W                     PROP_TAG( PT_UNICODE,     0x3D12)
#define PR_IDENTITY_DISPLAY                   PROP_TAG( PT_TSTRING,     0x3E00)
#define PR_IDENTITY_DISPLAY_W                 PROP_TAG( PT_UNICODE,     0x3E00)
#define PR_IDENTITY_DISPLAY_A                 PROP_TAG( PT_STRING8,     0x3E00)
#define PR_IDENTITY_ENTRYID                   PROP_TAG( PT_BINARY,      0x3E01)
#define PR_RESOURCE_METHODS                   PROP_TAG( PT_LONG,        0x3E02)
#define PR_RESOURCE_TYPE                      PROP_TAG( PT_LONG,        0x3E03)
#define PR_STATUS_CODE                        PROP_TAG( PT_LONG,        0x3E04)
#define PR_IDENTITY_SEARCH_KEY                PROP_TAG( PT_BINARY,      0x3E05)
#define PR_OWN_STORE_ENTRYID                  PROP_TAG( PT_BINARY,      0x3E06)
#define PR_RESOURCE_PATH                      PROP_TAG( PT_TSTRING,     0x3E07)
#define PR_RESOURCE_PATH_W                    PROP_TAG( PT_UNICODE,     0x3E07)
#define PR_RESOURCE_PATH_A                    PROP_TAG( PT_STRING8,     0x3E07)
#define PR_STATUS_STRING                      PROP_TAG( PT_TSTRING,     0x3E08)
#define PR_STATUS_STRING_W                    PROP_TAG( PT_UNICODE,     0x3E08)
#define PR_STATUS_STRING_A                    PROP_TAG( PT_STRING8,     0x3E08)
#define PR_X400_DEFERRED_DELIVERY_CANCEL      PROP_TAG( PT_BOOLEAN,     0x3E09)
#define PR_HEADER_FOLDER_ENTRYID              PROP_TAG( PT_BINARY,      0x3E0A)
#define PR_REMOTE_PROGRESS                    PROP_TAG( PT_LONG,        0x3E0B)
#define PR_REMOTE_PROGRESS_TEXT               PROP_TAG( PT_TSTRING,     0x3E0C)
#define PR_REMOTE_PROGRESS_TEXT_W             PROP_TAG( PT_UNICODE,     0x3E0C)
#define PR_REMOTE_PROGRESS_TEXT_A             PROP_TAG( PT_STRING8,     0x3E0C)
#define PR_REMOTE_VALIDATE_OK                 PROP_TAG( PT_BOOLEAN,     0x3E0D)
#define PR_CONTROL_FLAGS                      PROP_TAG( PT_LONG,        0x3F00)
#define PR_CONTROL_STRUCTURE                  PROP_TAG( PT_BINARY,      0x3F01)
#define PR_CONTROL_TYPE                       PROP_TAG( PT_LONG,        0x3F02)
#define PR_DELTAX                             PROP_TAG( PT_LONG,        0x3F03)
#define PR_DELTAY                             PROP_TAG( PT_LONG,        0x3F04)
#define PR_XPOS                               PROP_TAG( PT_LONG,        0x3F05)
#define PR_YPOS                               PROP_TAG( PT_LONG,        0x3F06)
#define PR_CONTROL_ID                         PROP_TAG( PT_BINARY,      0x3F07)
#define PR_INITIAL_DETAILS_PANE               PROP_TAG( PT_LONG,        0x3F08)
#define PR_MSG_EDITOR_FORMAT                  PROP_TAG( PT_LONG,        0x5903)
#define PR_ATTACHMENT_HIDDEN                  PROP_TAG( PT_BOOLEAN,     0x7ffe)
#define PR_SMTP_ADDRESS                       PROP_TAG( PT_TSTRING,     0x39fe)
#define PR_SMTP_ADDRESS_W                     PROP_TAG( PT_UNICODE,     0x39fe)
#define PR_SMTP_ADDRESS_A                     PROP_TAG( PT_STRING8,     0x39fe)
#define PR_SENT_REPRESENTING_SMTP_ADDRESS     PROP_TAG( PT_TSTRING,     0x5d02)
#define PR_SENT_REPRESENTING_SMTP_ADDRESS_A   PROP_TAG( PT_STRING8,     0x5d02)
#define PR_SENT_REPRESENTING_SMTP_ADDRESS_W   PROP_TAG( PT_UNICODE,     0x5d02)
#define PidTagSenderSmtpAddress_W             PROP_TAG( PT_UNICODE,     0x5d01)

#define PROP_ID_SECURE_MIN                0x67F0
#define PROP_ID_SECURE_MAX                0x67FF

#define pidExchangeXmitReservedMin        0x3FE0
#define pidExchangeNonXmitReservedMin     0x65E0
#define pidProfileMin                     0x6600
#define pidStoreMin                       0x6618
#define pidFolderMin                      0x6638
#define pidMessageReadOnlyMin             0x6640
#define pidMessageWriteableMin            0x6658
#define pidAttachReadOnlyMin              0x666C
#define pidSpecialMin                     0x6670
#define pidAdminMin                       0x6690
#define pidSecureProfileMin               PROP_ID_SECURE_MIN

#define PR_PROFILE_VERSION           PROP_TAG( PT_LONG, pidProfileMin+0x00)
#define PR_PROFILE_CONFIG_FLAGS      PROP_TAG( PT_LONG, pidProfileMin+0x01)
#define PR_PROFILE_HOME_SERVER       PROP_TAG( PT_STRING8, pidProfileMin+0x02)
#define PR_PROFILE_HOME_SERVER_DN    PROP_TAG( PT_STRING8, pidProfileMin+0x12)
#define PR_PROFILE_HOME_SERVER_ADDRS PROP_TAG( PT_MV_STRING8, \
                                                           pidProfileMin+0x13)
#define PR_PROFILE_USER              PROP_TAG( PT_STRING8, pidProfileMin+0x03)
#define PR_PROFILE_CONNECT_FLAGS     PROP_TAG( PT_LONG,    pidProfileMin+0x04)
#define PR_PROFILE_TRANSPORT_FLAGS   PROP_TAG( PT_LONG,    pidProfileMin+0x05)
#define PR_PROFILE_UI_STATE          PROP_TAG( PT_LONG,    pidProfileMin+0x06)
#define PR_PROFILE_UNRESOLVED_NAME   PROP_TAG( PT_STRING8, pidProfileMin+0x07)
#define PR_PROFILE_UNRESOLVED_SERVER PROP_TAG( PT_STRING8, pidProfileMin+0x08)
#define PR_PROFILE_BINDING_ORDER     PROP_TAG( PT_STRING8, pidProfileMin+0x09)
#define PR_PROFILE_MAX_RESTRICT      PROP_TAG( PT_LONG,    pidProfileMin+0x0D)
#define PR_PROFILE_AB_FILES_PATH     PROP_TAG( PT_STRING8, pidProfileMin+0xE)
#define PR_PROFILE_OFFLINE_STORE_PATH PROP_TAG( PT_STRING8,pidProfileMin+0x10)
#define PR_PROFILE_OFFLINE_INFO      PROP_TAG( PT_BINARY,  pidProfileMin+0x11)
#define PR_PROFILE_ADDR_INFO         PROP_TAG( PT_BINARY,  pidSpecialMin+0x17)
#define PR_PROFILE_OPTIONS_DATA      PROP_TAG( PT_BINARY,  pidSpecialMin+0x19)
#define PR_PROFILE_SECURE_MAILBOX    PROP_TAG( PT_BINARY, \
                                                      pidSecureProfileMin + 0)
#define PR_DISABLE_WINSOCK           PROP_TAG( PT_LONG,    pidProfileMin+0x18)
#define PR_OST_ENCRYPTION            PROP_TAG( PT_LONG,    0x6702)
#define PR_PROFILE_OPEN_FLAGS        PROP_TAG( PT_LONG,    pidProfileMin+0x09)
#define PR_PROFILE_TYPE              PROP_TAG( PT_LONG,    pidProfileMin+0x0A)
#define PR_PROFILE_MAILBOX           PROP_TAG( PT_STRING8, pidProfileMin+0x0B)
#define PR_PROFILE_SERVER            PROP_TAG( PT_STRING8, pidProfileMin+0x0C)
#define PR_PROFILE_SERVER_DN         PROP_TAG( PT_STRING8, pidProfileMin+0x14)
#define PR_PROFILE_FAVFLD_DISPLAY_NAME PROP_TAG(PT_STRING8,pidProfileMin+0x0F)
#define PR_PROFILE_FAVFLD_COMMENT    PROP_TAG(PT_STRING8,  pidProfileMin+0x15)
#define PR_PROFILE_ALLPUB_DISPLAY_NAME PROP_TAG(PT_STRING8,pidProfileMin+0x16)
#define PR_PROFILE_ALLPUB_COMMENT    PROP_TAG(PT_STRING8,  pidProfileMin+0x17)

#define OSTF_NO_ENCRYPTION            0x80000000
#define OSTF_COMPRESSABLE_ENCRYPTION  0x40000000
#define OSTF_BEST_ENCRYPTION          0x20000000

#define PR_NON_IPM_SUBTREE_ENTRYID    PROP_TAG( PT_BINARY, pidStoreMin+0x08)
#define PR_EFORMS_REGISTRY_ENTRYID    PROP_TAG( PT_BINARY, pidStoreMin+0x09)
#define PR_SPLUS_FREE_BUSY_ENTRYID    PROP_TAG( PT_BINARY, pidStoreMin+0x0A)
#define PR_OFFLINE_ADDRBOOK_ENTRYID   PROP_TAG( PT_BINARY, pidStoreMin+0x0B)
#define PR_EFORMS_FOR_LOCALE_ENTRYID  PROP_TAG( PT_BINARY, pidStoreMin+0x0C)
#define PR_FREE_BUSY_FOR_LOCAL_SITE_ENTRYID \
                                      PROP_TAG( PT_BINARY, pidStoreMin+0x0D)
#define PR_ADDRBOOK_FOR_LOCAL_SITE_ENTRYID \
                                      PROP_TAG( PT_BINARY, pidStoreMin+0x0E)
#define PR_OFFLINE_MESSAGE_ENTRYID    PROP_TAG( PT_BINARY, pidStoreMin+0x0F)
#define PR_IPM_FAVORITES_ENTRYID      PROP_TAG( PT_BINARY, pidStoreMin+0x18)
#define PR_IPM_PUBLIC_FOLDERS_ENTRYID PROP_TAG( PT_BINARY, pidStoreMin+0x19)
#define PR_GW_MTSIN_ENTRYID           PROP_TAG( PT_BINARY, pidStoreMin+0x10)
#define PR_GW_MTSOUT_ENTRYID          PROP_TAG( PT_BINARY, pidStoreMin+0x11)
#define PR_TRANSFER_ENABLED           PROP_TAG( PT_BOOLEAN,pidStoreMin+0x12)
#define PR_TEST_LINE_SPEED            PROP_TAG( PT_BINARY, pidStoreMin+0x13)
#define PR_HIERARCHY_SYNCHRONIZER     PROP_TAG( PT_OBJECT, pidStoreMin+0x14)
#define PR_CONTENTS_SYNCHRONIZER      PROP_TAG( PT_OBJECT, pidStoreMin+0x15)
#define PR_COLLECTOR                  PROP_TAG( PT_OBJECT, pidStoreMin+0x16)
#define PR_FAST_TRANSFER              PROP_TAG( PT_OBJECT, pidStoreMin+0x17)
#define PR_STORE_OFFLINE              PROP_TAG( PT_BOOLEAN,pidStoreMin+0x1A)
#define PR_IN_TRANSIT                 PROP_TAG( PT_BOOLEAN,pidStoreMin)
#define PR_REPLICATION_STYLE          PROP_TAG( PT_LONG,   pidAdminMin)
#define PR_REPLICATION_SCHEDULE       PROP_TAG( PT_BINARY, pidAdminMin+0x01)
#define PR_REPLICATION_MESSAGE_PRIORITY PROP_TAG( PT_LONG, pidAdminMin+0x02)
#define PR_OVERALL_MSG_AGE_LIMIT      PROP_TAG( PT_LONG,   pidAdminMin+0x03 )
#define PR_REPLICATION_ALWAYS_INTERVAL PROP_TAG( PT_LONG, pidAdminMin+0x04 )
#define PR_REPLICATION_MSG_SIZE       PROP_TAG( PT_LONG, pidAdminMin+0x05 )


#define REPLICATION_MESSAGE_SIZE_LIMIT_DEFAULT  100

#define STYLE_DEFAULT                 (-1)
#define STYLE_NEVER                     0
#define STYLE_NORMAL                    1
#define STYLE_ALWAYS                    2
#define STYLE_ALWAYS_INTERVAL_DEFAULT  15

#define PR_SOURCE_KEY   PROP_TAG( PT_BINARY, pidExchangeNonXmitReservedMin+0x0)
#define PR_PARENT_SOURCE_KEY \
                        PROP_TAG( PT_BINARY, pidExchangeNonXmitReservedMin+0x1)
#define PR_CHANGE_KEY   PROP_TAG( PT_BINARY, pidExchangeNonXmitReservedMin+0x2)
#define PR_PREDECESSOR_CHANGE_LIST \
                        PROP_TAG( PT_BINARY, pidExchangeNonXmitReservedMin+0x3)

#define PR_FOLDER_CHILD_COUNT      PROP_TAG( PT_LONG,    pidFolderMin)
#define PR_RIGHTS                  PROP_TAG( PT_LONG,    pidFolderMin+1)
#define PR_HAS_RULES               PROP_TAG( PT_BOOLEAN, pidFolderMin+2)
#define PR_ACL_TABLE       PROP_TAG( PT_OBJECT, pidExchangeXmitReservedMin)
#define PR_RULES_TABLE     PROP_TAG( PT_OBJECT, pidExchangeXmitReservedMin+1)
#define PR_ADDRESS_BOOK_ENTRYID    PROP_TAG( PT_BINARY, pidFolderMin+0x03)
#define PR_ACL_DATA        PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin)
#define PR_RULES_DATA      PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x1)
#define PR_FOLDER_DESIGN_FLAGS  \
                             PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0x2)
#define PR_DESIGN_IN_PROGRESS \
                          PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x4)
#define PR_SECURE_ORIGINATION \
                          PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x5)
#define PR_PUBLISH_IN_ADDRESS_BOOK \
                          PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x6)
#define PR_RESOLVE_METHOD PROP_TAG( PT_LONG,    pidExchangeXmitReservedMin+0x7)
#define PR_ADDRESS_BOOK_DISPLAY_NAME \
                          PROP_TAG( PT_TSTRING, pidExchangeXmitReservedMin+0x8)
#define PR_EFORMS_LOCALE_ID  PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0x9)
#define PR_REPLICA_LIST         PROP_TAG( PT_BINARY, pidAdminMin+0x8)
#define PR_OVERALL_AGE_LIMIT    PROP_TAG( PT_LONG,   pidAdminMin+0x9)

#define RESOLVE_METHOD_DEFAULT                  0
#define RESOLVE_METHOD_LAST_WRITER_WINS         1
#define RESOLVE_METHOD_NO_CONFLICT_NOTIFICATION 2

#define PR_PUBLIC_FOLDER_ENTRYID   PROP_TAG( PT_BINARY, pidFolderMin+0x04)
#define PR_HAS_NAMED_PROPERTIES  \
                          PROP_TAG(PT_BOOLEAN, pidMessageReadOnlyMin+0x0A)
#define PR_CREATOR_NAME          \
                          PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin+0x18)
#define PR_CREATOR_ENTRYID       \
                          PROP_TAG(PT_BINARY, pidExchangeXmitReservedMin+0x19)
#define PR_LAST_MODIFIER_NAME    \
                          PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin+0x1A)
#define PR_LAST_MODIFIER_ENTRYID \
                          PROP_TAG(PT_BINARY, pidExchangeXmitReservedMin+0x1B)
#define PR_HAS_DAMS              \
                          PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0xA)
#define PR_RULE_TRIGGER_HISTORY  \
                          PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x12)
#define PR_MOVE_TO_STORE_ENTRYID \
                          PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x13)
#define PR_MOVE_TO_FOLDER_ENTRYID \
                          PROP_TAG( PT_BINARY, pidExchangeXmitReservedMin+0x14)
#define PR_REPLICA_SERVER        \
                            PROP_TAG(PT_TSTRING, pidMessageReadOnlyMin+0x4)
#define PR_DEFERRED_SEND_NUMBER  \
                            PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0xB)
#define PR_DEFERRED_SEND_UNITS   \
                            PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0xC)
#define PR_EXPIRY_NUMBER         \
                            PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0xD)
#define PR_EXPIRY_UNITS          \
                            PROP_TAG( PT_LONG, pidExchangeXmitReservedMin+0xE)
#define PR_DEFERRED_SEND_TIME    \
                         PROP_TAG( PT_SYSTIME, pidExchangeXmitReservedMin+0xF)
#define PR_GW_ADMIN_OPERATIONS   PROP_TAG( PT_LONG, pidMessageWriteableMin)
#define PR_P1_CONTENT            PROP_TAG( PT_BINARY, 0x1100)
#define PR_P1_CONTENT_TYPE       PROP_TAG( PT_BINARY, 0x1101)
#define PR_CLIENT_ACTIONS        PROP_TAG(PT_BINARY, pidMessageReadOnlyMin+0x5)
#define PR_DAM_ORIGINAL_ENTRYID  PROP_TAG(PT_BINARY, pidMessageReadOnlyMin+0x6)
#define PR_DAM_BACK_PATCHED     PROP_TAG(PT_BOOLEAN, pidMessageReadOnlyMin+0x7)
#define PR_RULE_ERROR           PROP_TAG(PT_LONG,    pidMessageReadOnlyMin+0x8)
#define PR_RULE_ACTION_TYPE     PROP_TAG(PT_LONG,    pidMessageReadOnlyMin+0x9)
#define PR_RULE_ACTION_NUMBER   PROP_TAG(PT_LONG,   pidMessageReadOnlyMin+0x10)
#define PR_RULE_FOLDER_ENTRYID  PROP_TAG(PT_BINARY, pidMessageReadOnlyMin+0x11)
#define PR_CONFLICT_ENTRYID  \
                           PROP_TAG(PT_BINARY, pidExchangeXmitReservedMin+0x10)
#define PR_MESSAGE_LOCALE_ID \
                             PROP_TAG(PT_LONG, pidExchangeXmitReservedMin+0x11)
#define PR_STORAGE_QUOTA_LIMIT \
                             PROP_TAG(PT_LONG, pidExchangeXmitReservedMin+0x15)
#define PR_EXCESS_STORAGE_USED \
                             PROP_TAG(PT_LONG, pidExchangeXmitReservedMin+0x16)
#define PR_SVR_GENERATING_QUOTA_MSG \
                          PROP_TAG(PT_TSTRING, pidExchangeXmitReservedMin+0x17)
#define PR_DELEGATED_BY_RULE \
                          PROP_TAG( PT_BOOLEAN, pidExchangeXmitReservedMin+0x3)

#define MSGSTATUS_IN_CONFLICT      0x800

#define PR_IN_CONFLICT             PROP_TAG(PT_BOOLEAN, pidAttachReadOnlyMin)
#define PR_LONGTERM_ENTRYID_FROM_TABLE  PROP_TAG(PT_BINARY, pidSpecialMin)
#define PR_ORIGINATOR_NAME    PROP_TAG( PT_TSTRING, pidMessageWriteableMin+0x3)
#define PR_ORIGINATOR_ADDR    PROP_TAG( PT_TSTRING, pidMessageWriteableMin+0x4)
#define PR_ORIGINATOR_ADDRTYPE \
                              PROP_TAG( PT_TSTRING, pidMessageWriteableMin+0x5)
#define PR_ORIGINATOR_ENTRYID PROP_TAG( PT_BINARY, pidMessageWriteableMin+0x6)
#define PR_ARRIVAL_TIME       PROP_TAG( PT_SYSTIME, pidMessageWriteableMin+0x7)
#define PR_TRACE_INFO         PROP_TAG( PT_BINARY, pidMessageWriteableMin+0x8)
#define PR_INTERNAL_TRACE_INFO \
                              PROP_TAG( PT_BINARY, pidMessageWriteableMin+0x12)
#define PR_SUBJECT_TRACE_INFO PROP_TAG( PT_BINARY, pidMessageWriteableMin+0x9)
#define PR_RECIPIENT_NUMBER   PROP_TAG( PT_LONG, pidMessageWriteableMin+0xA)
#define PR_MTS_SUBJECT_ID     PROP_TAG(PT_BINARY, pidMessageWriteableMin+0xB)
#define PR_REPORT_DESTINATION_NAME \
                              PROP_TAG(PT_TSTRING, pidMessageWriteableMin+0xC)
#define PR_REPORT_DESTINATION_ENTRYID \
                              PROP_TAG(PT_BINARY, pidMessageWriteableMin+0xD)
#define PR_CONTENT_SEARCH_KEY PROP_TAG(PT_BINARY, pidMessageWriteableMin+0xE)
#define PR_FOREIGN_ID         PROP_TAG(PT_BINARY, pidMessageWriteableMin+0xF)
#define PR_FOREIGN_REPORT_ID  PROP_TAG(PT_BINARY, pidMessageWriteableMin+0x10)
#define PR_FOREIGN_SUBJECT_ID PROP_TAG(PT_BINARY, pidMessageWriteableMin+0x11)

#define PR_MTS_ID             PR_MESSAGE_SUBMISSION_ID
#define PR_MTS_REPORT_ID      PR_MESSAGE_SUBMISSION_ID

#define PR_FOLDER_FLAGS                  PROP_TAG( PT_LONG, pidAdminMin+0x18 )
#define PR_LAST_ACCESS_TIME              PROP_TAG( PT_SYSTIME,pidAdminMin+0x19)
#define PR_RESTRICTION_COUNT             PROP_TAG( PT_LONG, pidAdminMin+0x1A )
#define PR_CATEG_COUNT                   PROP_TAG( PT_LONG, pidAdminMin+0x1B )
#define PR_CACHED_COLUMN_COUNT           PROP_TAG( PT_LONG, pidAdminMin+0x1C )
#define PR_NORMAL_MSG_W_ATTACH_COUNT     PROP_TAG( PT_LONG, pidAdminMin+0x1D )
#define PR_ASSOC_MSG_W_ATTACH_COUNT      PROP_TAG( PT_LONG, pidAdminMin+0x1E )
#define PR_RECIPIENT_ON_NORMAL_MSG_COUNT PROP_TAG( PT_LONG, pidAdminMin+0x1F )
#define PR_RECIPIENT_ON_ASSOC_MSG_COUNT  PROP_TAG( PT_LONG, pidAdminMin+0x20 )
#define PR_ATTACH_ON_NORMAL_MSG_COUNT    PROP_TAG( PT_LONG, pidAdminMin+0x21 )
#define PR_ATTACH_ON_ASSOC_MSG_COUNT     PROP_TAG( PT_LONG, pidAdminMin+0x22 )
#define PR_NORMAL_MESSAGE_SIZE           PROP_TAG( PT_LONG, pidAdminMin+0x23 )
#define PR_NORMAL_MESSAGE_SIZE_EXTENDED  PROP_TAG( PT_I8, pidAdminMin+0x23 )
#define PR_ASSOC_MESSAGE_SIZE            PROP_TAG( PT_LONG, pidAdminMin+0x24 )
#define PR_ASSOC_MESSAGE_SIZE_EXTENDED   PROP_TAG( PT_I8, pidAdminMin+0x24 )
#define PR_FOLDER_PATHNAME             PROP_TAG(PT_TSTRING, pidAdminMin+0x25 )
#define PR_OWNER_COUNT                 PROP_TAG( PT_LONG, pidAdminMin+0x26 )
#define PR_CONTACT_COUNT               PROP_TAG( PT_LONG, pidAdminMin+0x27 )

#define PR_MESSAGE_SIZE_EXTENDED   PROP_TAG(PT_I8, PROP_ID(PR_MESSAGE_SIZE))

#endif /*MAPITAGS_H*/
