/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.sig.dss;

import gnu.crypto.sig.dss.DSSKeyPairGenerator;
import gnu.crypto.sig.dss.DSSSignature;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.security.KeyPair;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.HashMap;

public class TestOfDSSSignature
implements Testlet {
    public void test(TestHarness harness) {
        harness.checkPoint("TestOfDSSSignature");
        DSSKeyPairGenerator kpg = new DSSKeyPairGenerator();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gnu.crypto.dss.L", new Integer(512));
        map.put("gnu.crypto.dss.use.defaults", new Boolean(false));
        kpg.setup(map);
        KeyPair kp = kpg.generate();
        DSAPublicKey publicK = (DSAPublicKey)kp.getPublic();
        DSAPrivateKey privateK = (DSAPrivateKey)kp.getPrivate();
        DSSSignature alice = new DSSSignature();
        DSSSignature bob = (DSSSignature)alice.clone();
        byte[] message = "1 if by land, 2 if by sea...".getBytes();
        map.put("gnu.crypto.sig.private.key", privateK);
        alice.setupSign(map);
        alice.update(message, 0, message.length);
        Object signature = alice.sign();
        map.put("gnu.crypto.sig.public.key", publicK);
        bob.setupVerify(map);
        bob.update(message, 0, message.length);
        harness.check(bob.verify(signature));
    }
}

