/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.hash;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.MD5;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class TestOfMD5
implements Testlet {
    private IMessageDigest algorithm;
    private IMessageDigest clone;

    public void test(TestHarness harness) {
        String exp;
        byte[] md;
        harness.checkPoint("TestOfMD5");
        try {
            this.algorithm = new MD5();
            harness.check(this.algorithm.selfTest(), "selfTest");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD5.selfTest");
        }
        try {
            this.algorithm = new MD5();
            this.algorithm.update("a".getBytes(), 0, 1);
            md = this.algorithm.digest();
            exp = "0CC175B9C0F1B6A831C399E269772661";
            harness.check(exp.equals(Util.toString((byte[])md)), "testA");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD5.testA");
        }
        try {
            this.algorithm = new MD5();
            this.algorithm.update("abc".getBytes(), 0, 3);
            md = this.algorithm.digest();
            exp = "900150983CD24FB0D6963F7D28E17F72";
            harness.check(exp.equals(Util.toString((byte[])md)), "testABC");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD5.testABC");
        }
        try {
            this.algorithm = new MD5();
            this.algorithm.update("message digest".getBytes(), 0, 14);
            md = this.algorithm.digest();
            exp = "F96B697D7CB7938D525A2F31AAF161D0";
            harness.check(exp.equals(Util.toString((byte[])md)), "testMessageDigest");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD5.testMessageDigest");
        }
        try {
            this.algorithm = new MD5();
            this.algorithm.update("abcdefghijklmnopqrstuvwxyz".getBytes(), 0, 26);
            md = this.algorithm.digest();
            exp = "C3FCD3D76192E4007DFB496CCA67E13B";
            harness.check(exp.equals(Util.toString((byte[])md)), "testAlphabet");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD5.testAlphabet");
        }
        try {
            this.algorithm = new MD5();
            this.algorithm.update("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".getBytes(), 0, 62);
            md = this.algorithm.digest();
            exp = "D174AB98D277D9F5A5611C2C9F419D9F";
            harness.check(exp.equals(Util.toString((byte[])md)), "testAsciiSubset");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD5.testAsciiSubset");
        }
        try {
            this.algorithm = new MD5();
            this.algorithm.update("12345678901234567890123456789012345678901234567890123456789012345678901234567890".getBytes(), 0, 80);
            md = this.algorithm.digest();
            exp = "57EDF4A22BE3C955AC49DA2E2107B67A";
            harness.check(exp.equals(Util.toString((byte[])md)), "testEightyNumerics");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD5.testEightyNumerics");
        }
        try {
            this.algorithm = new MD5();
            this.algorithm.update("a".getBytes(), 0, 1);
            this.clone = (IMessageDigest)this.algorithm.clone();
            md = this.algorithm.digest();
            exp = "0CC175B9C0F1B6A831C399E269772661";
            harness.check(exp.equals(Util.toString((byte[])md)), "testCloning #1");
            this.clone.update("bc".getBytes(), 0, 2);
            md = this.clone.digest();
            exp = "900150983CD24FB0D6963F7D28E17F72";
            harness.check(exp.equals(Util.toString((byte[])md)), "testCloning #2");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD5.testCloning");
        }
    }
}

