/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;

public class BERConstructedOctetString
extends DEROctetString {
    private Vector octs;

    private static byte[] toBytes(Vector octs) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        int i = 0;
        while (i != octs.size()) {
            DEROctetString o = (DEROctetString)octs.elementAt(i);
            try {
                bOut.write(o.getOctets());
            }
            catch (IOException e) {
                throw new RuntimeException("exception converting octets " + e.toString());
            }
            ++i;
        }
        return bOut.toByteArray();
    }

    public BERConstructedOctetString(byte[] string) {
        super(string);
    }

    public BERConstructedOctetString(Vector octs) {
        super(BERConstructedOctetString.toBytes(octs));
        this.octs = octs;
    }

    public BERConstructedOctetString(DERObject obj) {
        super(obj);
    }

    public BERConstructedOctetString(DEREncodable obj) {
        super(obj.getDERObject());
    }

    public byte[] getOctets() {
        return this.string;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            this.octs = this.generateOcts();
        }
        return this.octs.elements();
    }

    private Vector generateOcts() {
        int i;
        byte[] nStr;
        int start = 0;
        int end = 0;
        Vector<DEROctetString> vec = new Vector<DEROctetString>();
        while (end + 1 < this.string.length) {
            if (this.string[end] == 0 && this.string[end + 1] == 0) {
                nStr = new byte[end - start + 1];
                i = 0;
                while (i != nStr.length) {
                    nStr[i] = this.string[start + i];
                    ++i;
                }
                vec.addElement(new DEROctetString(nStr));
                start = end + 1;
            }
            ++end;
        }
        nStr = new byte[this.string.length - start];
        i = 0;
        while (i != nStr.length) {
            nStr[i] = this.string[start + i];
            ++i;
        }
        vec.addElement(new DEROctetString(nStr));
        return vec;
    }

    public void encode(DEROutputStream out) throws IOException {
        if (out instanceof ASN1OutputStream || out instanceof BEROutputStream) {
            out.write(36);
            out.write(128);
            if (this.octs == null) {
                this.octs = this.generateOcts();
            }
            int i = 0;
            while (i != this.octs.size()) {
                out.writeObject(this.octs.elementAt(i));
                ++i;
            }
            out.write(0);
            out.write(0);
        } else {
            super.encode(out);
        }
    }
}

