/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class NullCipher
extends Cipher {
    public NullCipher() {
        super(new NullCipherSpi(), null, "NULL");
    }

    private static class NullCipherSpi
    extends CipherSpi {
        private NullCipherSpi() {
        }

        protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        }

        protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        }

        protected int engineGetBlockSize() {
            return 1;
        }

        protected int engineGetOutputSize(int inputLen) {
            return inputLen;
        }

        protected byte[] engineGetIV() {
            return null;
        }

        protected AlgorithmParameters engineGetParameters() {
            return null;
        }

        protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        }

        protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        }

        protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        }

        protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
            if (input == null) {
                return null;
            }
            byte[] tmp = new byte[inputLen];
            System.arraycopy(input, inputOffset, tmp, 0, inputLen);
            return tmp;
        }

        protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
            if (input == null) {
                return 0;
            }
            if (output.length - outputOffset < inputLen) {
                throw new ShortBufferException("output buffer to short for NullCipher");
            }
            System.arraycopy(input, inputOffset, output, outputOffset, inputLen);
            return inputLen;
        }

        protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
            if (input == null) {
                return new byte[0];
            }
            byte[] tmp = new byte[inputLen];
            System.arraycopy(input, inputOffset, tmp, 0, inputLen);
            return tmp;
        }

        protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
            if (input == null) {
                return 0;
            }
            if (output.length - outputOffset < inputLen) {
                throw new ShortBufferException("output buffer too short for NullCipher");
            }
            System.arraycopy(input, inputOffset, output, outputOffset, inputLen);
            return inputLen;
        }

        protected int engineGetKeySize(Key key) throws InvalidKeyException {
            return 0;
        }
    }
}

