/*
 * Decompiled with CFR 0.152.
 */
package test.prng;

import gnu.crypto.prng.ICMGenerator;
import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.PRNGFactory;
import gnu.crypto.util.Util;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfICMGenerator
extends TestCase {
    HashMap map = new HashMap();
    static /* synthetic */ Class class$test$prng$TestOfICMGenerator;

    public TestOfICMGenerator(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfICMGenerator.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$prng$TestOfICMGenerator == null ? (class$test$prng$TestOfICMGenerator = TestOfICMGenerator.class$("test.prng.TestOfICMGenerator")) : class$test$prng$TestOfICMGenerator);
    }

    public void testVectorOne() {
        byte[] key = new byte[16];
        byte[] offset = new byte[16];
        int i = 0;
        while (i < 16) {
            key[i] = (byte)i;
            offset[i] = (byte)i;
            ++i;
        }
        this.map.put("gnu.crypto.cipher.block.size", new Integer(16));
        this.map.put("gnu.crypto.cipher.key.material", key);
        this.map.put("gnu.crypto.prng.icm.segment.index.length", new Integer(4));
        this.map.put("gnu.crypto.prng.icm.offset", offset);
        this.map.put("gnu.crypto.prng.icm.segment.index", BigInteger.ZERO);
        ICMGenerator icm = new ICMGenerator();
        byte[] data = new byte[16];
        try {
            icm.init((Map)this.map);
            String ks = "0A940BB5416EF045F1C39458C653EA5A";
            icm.nextBytes(data, 0, 16);
            String computed = Util.toString((byte[])data);
            Assert.assertTrue((boolean)ks.equals(computed));
            ks = "0263EC94661872969ADAFD0F4BA40FDC";
            icm.nextBytes(data, 0, 16);
            computed = Util.toString((byte[])data);
            Assert.assertTrue((boolean)ks.equals(computed));
            ks = "1A2D94B3111CA5F8BDC2C84DCC29EC47";
            icm.nextBytes(data, 0, 16);
            computed = Util.toString((byte[])data);
            Assert.assertTrue((boolean)ks.equals(computed));
            ks = "4D0BABD2995F9F076223246847B5D30E";
            icm.nextBytes(data, 0, 16);
            computed = Util.toString((byte[])data);
            Assert.assertTrue((boolean)ks.equals(computed));
            ks = "8D33F128463B88EFD3F8A52505020379";
            icm.nextBytes(data, 0, 16);
            computed = Util.toString((byte[])data);
            Assert.assertTrue((boolean)ks.equals(computed));
        }
        catch (Exception x) {
            Assert.fail((String)String.valueOf(x));
        }
    }

    public void testVectorTwo() {
        byte[] key = new byte[]{117, 56, 120, 36, -47, -15, -13, -127, 86, 65, -74, 93, 120, -43, 30, -37};
        byte[] offset = new byte[]{-106, -55, 120, 25, -127, 5, 60, -69, -53, 54, -110, 120, 68, -15, -109, 44};
        this.map.put("gnu.crypto.cipher.block.size", new Integer(16));
        this.map.put("gnu.crypto.cipher.key.material", key);
        this.map.put("gnu.crypto.prng.icm.block.index.length", new Integer(2));
        this.map.put("gnu.crypto.prng.icm.offset", new BigInteger(1, offset));
        this.map.put("gnu.crypto.prng.icm.segment.index", new BigInteger("12345678", 16));
        IRandom icm = PRNGFactory.getInstance((String)"icm");
        byte[] data = new byte[16];
        try {
            icm.init((Map)this.map);
            String ks = "EA0AA027BA6D56E44B28F43A7E3E5F58";
            icm.nextBytes(data, 0, 16);
            String computed = Util.toString((byte[])data);
            Assert.assertTrue((boolean)ks.equals(computed));
            ks = "CBDB3107EDA8D420D3EF7AB7FF290166";
            icm.nextBytes(data, 0, 16);
            computed = Util.toString((byte[])data);
            Assert.assertTrue((boolean)ks.equals(computed));
            ks = "AED6F7CB14ED49174336CC010AEB8780";
            icm.nextBytes(data, 0, 16);
            computed = Util.toString((byte[])data);
            Assert.assertTrue((boolean)ks.equals(computed));
            ks = "4C3A754AF027A5C8CCB40E0FE20AF246";
            icm.nextBytes(data, 0, 16);
            computed = Util.toString((byte[])data);
            Assert.assertTrue((boolean)ks.equals(computed));
            ks = "01A6D1CE983EF993E980CC9568587E3D";
            icm.nextBytes(data, 0, 16);
            computed = Util.toString((byte[])data);
            Assert.assertTrue((boolean)ks.equals(computed));
        }
        catch (Exception x) {
            Assert.fail((String)String.valueOf(x));
        }
    }

    protected void setUp() throws Exception {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

