/*
 * Decompiled with CFR 0.152.
 */
package test.jce;

import gnu.crypto.jce.GnuCrypto;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfSignature
extends TestCase {
    static /* synthetic */ Class class$test$jce$TestOfSignature;

    public TestOfSignature(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfSignature.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$jce$TestOfSignature == null ? (class$test$jce$TestOfSignature = TestOfSignature.class$("test.jce.TestOfSignature")) : class$test$jce$TestOfSignature);
    }

    public void testUnknownScheme() {
        try {
            Signature.getInstance("ABC", "GNU-CRYPTO");
            Assert.fail((String)"testUnknownScheme()");
        }
        catch (Exception x) {
            Assert.assertTrue((String)"testUnknownScheme()", (boolean)true);
        }
    }

    public void testDSSRawSignature() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("DSA", "GNU-CRYPTO");
        kpg.initialize(512);
        KeyPair kp = kpg.generateKeyPair();
        Signature alice = Signature.getInstance("DSA", "GNU-CRYPTO");
        Signature bob = (Signature)alice.clone();
        byte[] message = "1 if by land, 2 if by sea...".getBytes();
        alice.initSign(kp.getPrivate());
        alice.update(message);
        byte[] signature = alice.sign();
        bob.initVerify(kp.getPublic());
        bob.update(message);
        Assert.assertTrue((String)"Verify own signature", (boolean)bob.verify(signature));
    }

    public void testRSAPSSRawSignature() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "GNU-CRYPTO");
        kpg.initialize(1024);
        KeyPair kp = kpg.generateKeyPair();
        Signature alice = Signature.getInstance("RSA-PSS", "GNU-CRYPTO");
        Signature bob = (Signature)alice.clone();
        byte[] message = "Que du magnifique...".getBytes();
        alice.initSign(kp.getPrivate());
        alice.update(message);
        byte[] signature = alice.sign();
        bob.initVerify(kp.getPublic());
        bob.update(message);
        Assert.assertTrue((String)"Verify own signature", (boolean)bob.verify(signature));
    }

    protected void setUp() {
        Security.addProvider((Provider)new GnuCrypto());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

