/* w32_fast.cpp Win32 fast seeder
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include<windows.h>
#include<string.h>
#include<util.h>
#include<md5_internal.h>
#include<w32_fast.h>

struct junk_buffer {
	SYSTEMTIME						getsystemtime;
	MEMORYSTATUS					getmemorystatus;
	struct { DWORD a,b,c,d; }		dws;
	struct { FILETIME a,b,c,d; }	fts;
	HANDLE							hdl;
	int								rnd;
	DWORD							gtc;
	DWORD							pid;
	SYSTEM_INFO						sinfo;
	CONTEXT							context;
	POINT							ptCursor;
	HWND							gaw;
	WINDOWPLACEMENT					wpl;
	HWND							capture;  /* handle of window with mouse capture*/
	HWND							clpown;   /* handle of clipboard owner */
	HWND							clpview;  /* handle of clipboard viewer */
	HANDLE							procself; /* pseudo handle of current process*/
	HANDLE							thrdself; /* pseudo handle of current thread*/
	DWORD							threadID; /* ID of current thread */
	HWND							dskwin;   /* handle of desktopwindow */
	HWND							winfoc;   /* handle of window woth focus */
	BOOL							instate;  /* are there any messages ? */
	DWORD							msgpos;   /* mouse pos for last message */
	LONG							msgtime;  /* time of last message */
	HANDLE							heaphnd;  /* handle for heap of calling process */
	HWINSTA							winst;    /* window station of process */
	DWORD							qstat;    /* type of messages in queue */
	POINT							crtpos;   /* position of caret */
	struct { FILETIME a,b,c,d; }	thts;     /* thread timing */
	struct { DWORD a, b; }			wset;     /* min and max working set size */
};

static const UINT32 WIN32_FAST_SEEDER_EXPECTED_SIZE = sizeof(junk_buffer);

win32_fast_seeder::win32_fast_seeder()
	: seeder(WIN32_FAST_SEEDER_EXPECTED_SIZE)
{
	;
}

win32_fast_seeder::win32_fast_seeder(UINT32 internal_buffer_size)
	: seeder(internal_buffer_size)
{
	;
}

UINT32 win32_fast_seeder::get_expected_seed_size()
{
	return WIN32_FAST_SEEDER_EXPECTED_SIZE;
}

UINT32 win32_fast_seeder::get_seed(UINT8 *seed, UINT32& desired_length)
{
	junk_buffer junkBuffer;
	UINT32 result = PCP_SUCCESS, bytes_to_copy;
	CMD5Internal md5;

	junkBuffer.capture	= GetCapture();
	junkBuffer.clpown	= GetClipboardOwner();
	junkBuffer.clpview	= GetClipboardViewer();
	junkBuffer.procself = GetCurrentProcess();
	GetProcessWorkingSetSize(junkBuffer.procself, &junkBuffer.wset.a,
		&junkBuffer.wset.b);
	junkBuffer.thrdself = GetCurrentThread();
	GetThreadTimes(junkBuffer.thrdself, &junkBuffer.thts.a, 
		&junkBuffer.thts.b, &junkBuffer.thts.c, &junkBuffer.thts.d);
	junkBuffer.threadID = GetCurrentThreadId();
	junkBuffer.dskwin	= GetDesktopWindow();
	junkBuffer.winfoc	= GetFocus();
	junkBuffer.instate	= GetInputState();
	junkBuffer.msgpos	= GetMessagePos();
	junkBuffer.msgtime	= GetMessageTime();
	junkBuffer.heaphnd	= GetProcessHeap();
	junkBuffer.winst	= GetProcessWindowStation();
	junkBuffer.qstat	= GetQueueStatus(QS_ALLEVENTS);
	GetCaretPos(&junkBuffer.crtpos); 
	

	junkBuffer.gtc		= GetTickCount();
	junkBuffer.pid		= GetCurrentProcessId();
	GetSystemTime( &junkBuffer.getsystemtime );
	GlobalMemoryStatus( &junkBuffer.getmemorystatus );
	GetDiskFreeSpace( NULL,
	 &junkBuffer.dws.a, &junkBuffer.dws.b,
	 &junkBuffer.dws.c, &junkBuffer.dws.d );
	junkBuffer.hdl = OpenProcess(
	 PROCESS_QUERY_INFORMATION,
	 FALSE,
	 GetCurrentProcessId() );
	GetProcessTimes( junkBuffer.hdl,
	 &junkBuffer.fts.a, &junkBuffer.fts.b,
	 &junkBuffer.fts.c, &junkBuffer.fts.d );
	CloseHandle( junkBuffer.hdl );
	junkBuffer.rnd		= rand();
	GetSystemInfo( &junkBuffer.sinfo );
	GetThreadContext( GetCurrentThread(), &junkBuffer.context );
	GetCursorPos( &junkBuffer.ptCursor );
	junkBuffer.gaw		= GetActiveWindow();
	junkBuffer.wpl.length = sizeof(WINDOWPLACEMENT);
	GetWindowPlacement( junkBuffer.gaw, &junkBuffer.wpl );

	if (seed == NULL)
	{
		result = PCP_NULL_POINTER;
		desired_length = 0;
	}
	else
	{
		bytes_to_copy = min(sizeof(junk_buffer), desired_length);

		memcpy(seed, (UINT8 *)(&junkBuffer), bytes_to_copy);

		/* 
			In case some people do not want to retrieve the full size seed
			we xor the hash (which depends on the full seed) to the first  
			16 bytes of the returned buffer. This (hopefully) makes sure   
			that no entropy is lost even if some seed bytes are not        
			returned to the caller.                                        
		*/
		md5.md5_mem((UINT8 *)(&junkBuffer), sizeof(junk_buffer));
		pcp_util::mem_xor(seed, bytes_to_copy, md5.ctx_digest, 16);
		
		desired_length = bytes_to_copy;
	}

	pcp_util::zero_memory((UINT8 *)(&junkBuffer), sizeof(junk_buffer));

	return result;
}
