/* net_api_loader.h header file for the class which provides
 *                  access to the netapi32.dll
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __netapi_loader_h__
#define __netapi_loader_h__

#include<dll_loader.h>
#include<lmcons.h>
#include<lmstats.h>
#include<lmapibuf.h>

typedef NET_API_STATUS (NET_API_FUNCTION *pNetApiBufferFree)(LPVOID Buffer);
typedef NET_API_STATUS (NET_API_FUNCTION *pNetApiBufferSize)(LPVOID Buffer,LPDWORD ByteCount);
typedef NET_API_STATUS (NET_API_FUNCTION *pNetStatisticsGet2)(LPWSTR server, LPWSTR service, DWORD level, DWORD options, LPBYTE *bufptr);

class netapi_loader : public dll_loader {
public:
	netapi_loader() : dll_loader() {;}
	UINT32 Init();
	pNetApiBufferFree NaNetApiBufferFree;
	pNetApiBufferSize NaNetApiBufferSize;
	pNetStatisticsGet2 NaNetStatisticsGet2;
};

#endif /* __netapi_loader_h__ */