/* mem_writer.h     header file for a little helper class
 *                  which more or less allows to fill a
 *                  buffer without having to worry about
 *                  writing over array boundaries
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __mem_writer_h__
#define __mem_writer_h__

#include<pcp_common.h>

class mem_writer {
public:
	mem_writer(UINT8 *block, UINT32 length);
	mem_writer();
	void add(UINT8 *block, UINT32 length);
	void rewind();
	void reset(UINT8 *block, UINT32 length);
	void set_pos(UINT32 new_pos);
	UINT32 get_pos() { return current_pos; }
	bool is_full();
protected:
	UINT32 block_length;
	UINT8  *mem_block;
	UINT32 current_pos;
};


#endif /* __mem_writer_h__ */