/* mem_writer.cpp implementation for a little helper class
 *                  which more or less allows to fill a
 *                  buffer without having to worry about
 *                  writing over array boundaries
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include<mem_writer.h>

mem_writer::mem_writer(UINT8 *block, UINT32 length)
{
	reset(block, length);
}

mem_writer::mem_writer()
{
	reset(NULL, 0);
}

void mem_writer::reset(UINT8 *block, UINT32 length)
{
	if (block == NULL)
	{
		block_length = 0;
	}
	else
	{
		block_length = length;
	}

	mem_block = block;
	current_pos = 0;
}


void mem_writer::set_pos(UINT32 new_pos)
{
	if (new_pos >= block_length)
	{
		current_pos = block_length;
	}
	else
	{
		current_pos = new_pos;
	}
}

bool mem_writer::is_full()
{
	return (current_pos >= block_length);
}

void mem_writer::rewind()
{
	current_pos = 0;
}

void mem_writer::add(UINT8 *block, UINT32 length)
{
	UINT32 count;

	for(count = 0; (current_pos < block_length) && (count < length); count++, current_pos++)
	{
		mem_block[current_pos] = block[count];
	}
}
