/* md5_internal.h header file for a class providing a
 *                simple C++ interface for the MD5 message
 *                digest algorithm
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __md5_internal_h__
#define __md5_internal_h__

#include<pcp_common.h>

typedef struct {
    UINT32 A,B,C,D;	  /* chaining variables */
    UINT32 total[2];
    UINT32  buflen;
    UINT8 buffer[128];
} MD5_CONTEXT;

class CMD5Internal  
{
public:
	CMD5Internal();
	virtual ~CMD5Internal();
	void self_test();
	void md5_init();
	void md5_update (UINT8 *inBuf, UINT32 inLen);
	void md5_final();
	void md5_transform (UINT32 *buf, UINT32 *in);
	void md5_mem(UINT8 *test_val, UINT32 test_len);
	UINT8 ctx_digest[16];     /* actual digest after md5_final call */

private:
	MD5_CONTEXT context;
	void internal_md5_init( MD5_CONTEXT *ctx );
	void transform( MD5_CONTEXT *ctx, const void *buffer, size_t len );
	void md5_write( MD5_CONTEXT *ctx, const void *buffer, size_t len);
	void internal_md5_final( MD5_CONTEXT *ctx );
	UINT8 *md5_read( MD5_CONTEXT *hd );
};

#endif /* __md5_internal_h__ */
