/* $Revision: 1.2 $ */
/*
 * "gpgp" Gnome/GTK Front for PGP
 * Copyright (C) 1998  Max Valianskiy
 * Copyright (C) 1999 tftp@netscape.net
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */
#ifndef __GPGP_H__
#define __GPGP_H__

#include <gnome.h>

#define GPGP_OPTIONS_FILE       "/gpgp/Options/"
#define ENV_GNUPGHOME           "GNUPGHOME"
#define DIR_GNUPGHOME           ".gnupg"

#define DEF_PUBRING_FILE        "pubring.gpg"
#define DEF_SECRING_FILE        "secring.gpg"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* general functions */

struct gpgp_options
{
   char* pgppath; /* $PGPPATH plus "/" by default */

   char* defpub; /* default public ring */
   char* defsec; /* default secret ring */
   char* defkey; /* default secret key uid */

   int   sign_verbose; /* show "Ok" dialog box in Sign */
   int   unsign_verbose; /* show "Ok" dialog box in UnSign decrypt */

   int   completes_need; /* minimum number of complete trusted signatures
                            to completly trust to key, 1 by default */
   int   marginals_need; /*  mininum number of marginal trusted signatures
                            to completly trust to key, 2 by default */

   int   rfc1991;   /* rfc mode */
   int   comment;

   char*   cipher; 
   char*   pubkey;
   char*   digest;

   int     compress;
   int     compresslevel; /* zlib only */

   /* private */
   GnomeApp* app;
   int       use_status;
   char*     optstring;
};

extern struct gpgp_options gpgp_options;

/* call every time when you change something in gpgp_options */
void update_gpgp_options();

/* this func must called once before use of any thing 
   from libgpgp. It reads options and initializes
   some internal structures

   if use_status=TRUE, then LibGPGP will use applications
   progress/status bar
*/

void gpgp_init(GnomeApp* app, int use_status);

/*******************************************************************/
/*    GnomePgpKeyring                                               */
/*******************************************************************/

#define GNOME_PGP_KEYRING(obj)          GTK_CHECK_CAST (obj, gnome_pgp_keyring_get_type (), GnomePgpKeyring)
#define GNOME_PGP_KEYRING_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gnome_pgp_keyring_get_type (), GnomePgpKeyringClass)
#define IS_GNOME_PGP_KEYRING(obj)       GTK_CHECK_TYPE (obj, gnome_pgp_keyring_get_type ())

typedef struct _GnomePgpKeyring      GnomePgpKeyring;
typedef struct _GnomePgpKeyringClass GnomePgpKeyringClass;

struct _GnomePgpKeyring
{
    GtkVBox misc;

    GtkWidget* box;
    GtkCList* keylist;
    GList* list;
    char* name;
    int is_secret;              /* Used to properly form gpg command line */
    GtkButton* properties;

    const char* error_info;
};

struct _GnomePgpKeyringClass
{
  GtkVBoxClass parent_class;
  void (* error) (GnomePgpKeyring *page);
};

guint          gnome_pgp_keyring_get_type        (void);
GtkWidget*     gnome_pgp_keyring_new             (void);
void           gnome_pgp_keyring_refresh         (GnomePgpKeyring* page);
void           gnome_pgp_keyring_select          (GnomePgpKeyring* page, char* ring);


/*********************************************************************/
/*   GnomePgpKeyringProperties                                        */
/*********************************************************************/


#define GNOME_PGP_KEYRING_PROPERTIES(obj)          GTK_CHECK_CAST (obj, gnome_pgp_keyring_properties_get_type (), GnomePgpKeyringProperties)
#define GNOME_PGP_KEYRING_PROPERTIES_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gnome_pgp_keyring_properties_get_type (), GnomePgpKeyringPropertiesClass)
#define IS_GNOME_PGP_KEYRING_PROPERTIES(obj)       GTK_CHECK_TYPE (obj, gnome_pgp_keyring_properties_get_type ())

typedef struct _GnomePgpKeyringProperties      GnomePgpKeyringProperties;
typedef struct _GnomePgpKeyringPropertiesClass GnomePgpKeyringPropertiesClass;

struct _GnomePgpKeyringProperties
{
  GtkWindow misc;

  char* userid;
  char* name;

  GtkEntry *finger, *bits, *keyid, *date, *validity, *trust;
  GtkButton *bok, *bsign, *bdel, *bexport;
  GtkLabel *title;
  GtkCList  *signedby;
   
  const char* error_info;
};

struct _GnomePgpKeyringPropertiesClass
{
  GtkWindowClass parent_class;

  void (* error)  (GnomePgpKeyringProperties *page);
};

guint          gnome_pgp_keyring_properties_get_type        (void);
GtkWidget*     gnome_pgp_keyring_properties_new             (void);
void           gnome_pgp_keyring_properties_select          (GnomePgpKeyringProperties* page, char* ring, char* userid);

/*********************************************************************/
/*   GnomePgpSign                                        */
/*********************************************************************/


#define GNOME_PGP_SIGN(obj)          GTK_CHECK_CAST (obj, gnome_pgp_sign_get_type (), GnomePgpSign)
#define GNOME_PGP_SIGN_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gnome_pgp_sign_get_type (), GnomePgpSignClass)
#define IS_GNOME_PGP_SIGN(obj)       GTK_CHECK_TYPE (obj, gnome_pgp_sign_get_type ())

typedef struct _GnomePgpSign      GnomePgpSign;
typedef struct _GnomePgpSignClass GnomePgpSignClass;

struct _GnomePgpSign
{
  GtkWindow misc;

  GnomeEntry* sec;
  GnomeEntry* pub;
  GtkEntry* pass;
  GtkCheckButton* enable;
  GtkCheckButton* sign;
  GtkCheckButton* enc;

  GtkCheckButton* textmode;
  GtkCheckButton* armor;
  GtkCheckButton* clearsig;

  GtkButton* bsign;
  GtkButton* benc;
  
  char* buf;
  int bufsize;
  char* obuf;
  int obufsize;

  char* filename;

  const char* error_info;
};

struct _GnomePgpSignClass
{
  GtkWindowClass parent_class;

  void (* error)  (GnomePgpSign *page);
  void (* cancel)  (GnomePgpSign *page);
};

guint          gnome_pgp_sign_get_type        (void);

/* filename field is only for pgp structures, file do not need to
   be really exist. unsign widget reads this filename from pgp
   packet and returns as default filename 
   
   it is safe to leave this field NULL if you do not need it */
GtkWidget*     gnome_pgp_sign_new             (char* buf, int bufsize, char* filename);

/*********************************************************************/
/*   GnomePgpUnSign                                                  */
/*********************************************************************/


#define GNOME_PGP_UNSIGN(obj)          GTK_CHECK_CAST (obj, gnome_pgp_unsign_get_type (), GnomePgpUnSign)
#define GNOME_PGP_UNSIGN_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gnome_pgp_unsign_get_type (), GnomePgpUnSignClass)
#define IS_GNOME_PGP_UNSIGN(obj)       GTK_CHECK_TYPE (obj, gnome_pgp_unsign_get_type ())

typedef struct _GnomePgpUnSign      GnomePgpUnSign;
typedef struct _GnomePgpUnSignClass GnomePgpUnSignClass;

struct _GnomePgpUnSign
{
  GtkWidget widget;

  GtkLabel* status;
  GtkProgressBar* bar;

  char* buf;
  int bufsize;
  char* obuf;
  int obufsize;

  char* filename; /* filename read from packet */

  const char* error_info;
};

struct _GnomePgpUnSignClass
{
  GtkWidgetClass parent_class;

  void (* error)  (GnomePgpUnSign *page);
  void (* cancel)  (GnomePgpUnSign *page);
};

guint          gnome_pgp_unsign_get_type  (void);


GtkWidget*     gnome_pgp_unsign_new       (char* buf, int bufsize);

/* this function just starts process (it can terminate before end of
   decryption/cheching */
void           gnome_pgp_unsign_action    (GnomePgpUnSign* page); /* do the work */

/*********************************************************************/
/*   GnomePgpLibProperties                                              */
/*********************************************************************/


#define GNOME_PGP_LIB_PROPERTIES(obj)          GTK_CHECK_CAST (obj, gnome_pgp_lib_properties_get_type (), GnomePgpLibProperties)
#define GNOME_PGP_LIB_PROPERTIES_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gnome_lib_properties_get_type (), GnomePgpLibPropertiesClass)
#define IS_GNOME_PGP_LIB_PROPERTIES(obj)       GTK_CHECK_TYPE (obj, gnome_pgp_lib_properties_get_type ())

typedef struct _GnomePgpLibProperties      GnomePgpLibProperties;
typedef struct _GnomePgpLibPropertiesClass GnomePgpLibPropertiesClass;

struct _GnomePgpLibProperties
{
  GnomePropertyBox misc;

  GnomeFileEntry* pgppath;
  GnomeFileEntry* defsec;
  GnomeFileEntry* defpub;
  GnomeEntry* defkey;

  GtkCheckButton* sign_verbose;
  GtkCheckButton* unsign_verbose;

  GnomeEntry* completes_need;
  GnomeEntry* marginals_need;
  
  GtkCheckButton* rfc1991;
  GtkCheckButton* comment;

  GtkCombo* cipher;
  GtkCombo* pubkey;
  GtkCombo* digest;

  GtkCombo* compression;
  GtkCombo* compressionlevel;
};

struct _GnomePgpLibPropertiesClass
{
  GnomePropertyBoxClass parent_class;
};

guint          gnome_pgp_lib_properties_get_type  (void);

GtkWidget*     gnome_pgp_lib_properties_new       (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GPGP_H__ */
