# Cherokee
# Copyright (C) 2001-2010 Alvaro Lopez Ortega

Name:           cherokee
Version:        1.0.16
Release:        1
License:        GPL
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
Docdir:         %{_datadir}/doc
Autoreqprov:    on
Source:         %{name}-%{version}.tar.gz
Summary:        Flexible and Fast web server
Group:          Productivity/Networking/Web/Servers
URL:            http://www.cherokee-project.com

%description
Cherokee is a very fast, flexible and easy to configure Web Server. It
supports the widespread technologies nowadays: FastCGI, SCGI, PHP,
CGI, uWSGI, SSI, TLS and SSL encrypted connections, Virtual hosts,
Authentication, on the fly encoding, Load Balancing, Apache compatible
log files, Data Base Balancing, Reverse HTTP Proxy, Traffic Shaper,
Video Streaming and much more.

%prep
%setup -q
gzip -dc %SOURCE | tar xvf -

%build
CFLAGS="$RPM_OPT_FLAGS"                 \
./configure --prefix=%{_prefix}         \
            --sysconfdir=%{_sysconfdir} \
            --mandir=%{_mandir}         \
            --sbindir=%{_sbindir}       \
		  --with-wwwroot=/home/httpd
make CFLAGS="-O0 -ggdb"

%install
make install DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
mkdir -p /home/httpd
mkdir -p %{_localstatedir}/log
mkdir -p %{_localstatedir}/run

%postun
/sbin/ldconfig

%files
%{_mandir}/*
%{_bindir}/*
%{_libdir}/*
%{_datadir}/*
%{_sbindir}/*
%{_includedir}/*
%{_sysconfdir}/*
/home/httpd/*

