/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2010 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

/* NOTE: File automatically generated (by error_list.py). */

static const cherokee_error_t __cherokee_errors[] =
{
  {   0, "Could not parse header from the back-end", "It looks like the back-end server sent a malformed HTTP response.", NULL, "Dump of the header buffer (len=%d): %s", true },
  {   1, "Failed to set nonblocking (fd=%d): ${errno}", "The issue seems to be related to your system.", NULL, NULL, true },
  {   2, "Could not find the rrdtool binary.", "A custom rrdtool binary has not been defined, and the server could not find one in the $PATH.", "/general#tabs_general-0", "PATH=%s", false },
  {   3, "execv failed cmd='%s': ${errno}", "The issue seems to be related to your system.", NULL, NULL, true },
  {   4, "Fork failed pid=%d: ${errno}", "The issue seems to be related to your system.", NULL, NULL, true },
  {   5, "Cannot write in %s: ${errno}", "The issue seems to be related to your system.", NULL, NULL, true },
  {   6, "Insufficient permissions to work with the RRD directory: %s", "The issue seems to be related to your system.", "/general#tabs_general-0", NULL, true },
  {   7, "Cannot create the '%s' directory", "The issue seems to be related to your system.", "/general#tabs_general-0", NULL, true },
  {   8, "Taking source='%s' back on-line: %d active.", "The server is re-enabling one of the Information Sources.", NULL, NULL, true },
  {   9, "Taking source='%s' off-line. Active %d.", "The server is disabling one of the Information Sources.", NULL, NULL, true },
  {  10, "Sources exhausted: re-enabling one.", "All the information sources are disabled at this moment. Cherokee needs to re-enable at least one.", NULL, NULL, true },
  {  11, "Timed out while resolving '%s'", "For some reason, Cherokee could not resolve the hostname.", NULL, NULL, true },
  {  12, "Could not read 'user' value for '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  13, "Could not read 'password' value for '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  14, "Empty authlist: Access will be denied.", "The access to this resource will be denied as long as the list of allowed users is empty.", NULL, NULL, true },
  {  15, "Setting pam fail delay failed", "Cherokee could not configure PAM propertly. Most likely you have found an incompatibility issue between Cherokee and your system PAM library.", NULL, NULL, true },
  {  16, "User '%s' - not authenticated: %s", "Most likely the password did not match", NULL, NULL, true },
  {  17, "User '%s' - invalid account: %s", "The specified user does not exist on the sytem.", NULL, NULL, true },
  {  18, "Validator LDAP: Unknown key: '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  19, "The LDAP validation module requires a '%s' property", "It looks like you did not fill a required property. Check the LDAP details and try again.", NULL, NULL, true },
  {  20, "Security problem found in LDAP validation config", "LDAP validator: Potential security problem found: anonymous bind validation. Check (RFC 2251, section 4.2.2)", NULL, NULL, true },
  {  21, "Could not connect to LDAP: %s:%d: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  22, "Could not set the LDAP version 3: %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  23, "Could not set CA file %s: %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  24, "cannot StartTLS, it is not supported by LDAP client libraries", "The issue seems to be related to your system.", NULL, NULL, true },
  {  25, "Could not bind (%s:%d): %s:%s : %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  26, "Could not search in LDAP server: %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  27, "Unknown path type '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  28, "File based validators need a password file", "This validation modules reads a local file in order to get the authorizated user list. The configuration specifies. Please try to reconfigure the details and ensure a filename is provided.", NULL, NULL, true },
  {  29, "Unknown authentication method '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  30, "Too many groups in the regex", "The specified regular expression is wrong. Please double check it.", NULL, NULL, true },
  {  31, "The handler needs a balancer", "The configuration file seems to be broken.", NULL, NULL, true },
  {  32, "Handler secdownload needs a secret", "You must define a passphrase to be used as shared secret between the Hidden Downloads handler and the script you use to generate the URLs.", NULL, NULL, true },
  {  33, "Unknown module type (%d)", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  34, "Unknown ServerInfo type: '%s'", "Your configuration file is either broken, obsolete or has been tampered with. You need to reconfigure the verbosity of your ServerInfo handler.", NULL, NULL, true },
  {  35, "Unparseable time '%s'", NULL, NULL, NULL, true },
  {  36, "Unknown SSI property: '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  37, "Parsing error: unknown version", NULL, NULL, NULL, true },
  {  38, "Parsing error: unknown type", NULL, NULL, NULL, true },
  {  39, "%s", NULL, NULL, NULL, true },
  {  40, "Found a FastCGI handler without a Load Balancer", "The configuration file seems to be broken.", NULL, NULL, true },
  {  41, "Wrong error code: '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  42, "HTTP Error %d redirection: An 'url' property is required", "The configuration file seems to be broken.", NULL, NULL, true },
  {  43, "Could not load theme '%s': %s", "Either the directory where your theme resides has been deleted, or the permissions are wrong.", NULL, NULL, true },
  {  44, "The theme is incomplete", "Most likely someone has inadvertedly deleted some of the files of your theme. Please try to restore the files or change your theme selection.", NULL, NULL, true },
  {  45, "Unrecognized language '%s'", "Cherokee's POST status reporter supports a number of output languages and formats, including: JSON, Python, PHP and Ruby.", NULL, NULL, true },
  {  46, "Unrecognized language '%s'", "Cherokee's DBSlayer supports a number of output languages and formats, including: JSON, Python, PHP and Ruby. Please reconfigure the DBSlayer rule to match one of those.", NULL, NULL, true },
  {  47, "DBSlayer handler needs a balancer", "The DBSlayer handler needs must specify a load balancing strategy and a list of target hosts to attend the load. At least one host is required. Please ensure it is correctly configured.", NULL, NULL, true },
  {  48, "Handler custom error needs an HTTP error value.", "The configuration file seems to be broken.", NULL, NULL, true },
  {  49, "Setting pipe properties fd=%d: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  50, "%s: could not set UID %d", "Most probably the server is not running as root, and therefore it cannot switch to a new user. If you want Cherokee to be able to change use UID to execute CGIs, you'll have to run it as root.", NULL, NULL, true },
  {  51, "Could not execute '%s': %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  52, "CreateProcess error: error=%d", "The issue seems to be related to your system.", NULL, NULL, true },
  {  53, "Error getting host name.", "The issue seems to be related to your system.", NULL, NULL, true },
  {  54, "Wrong plug-in: The module must implement a handler.", "The server tried to set a handler, but the loaded plug-in contained another sort of module.", NULL, NULL, true },
  {  55, "The Load Balancer cannot be empty", "The configuration file seems to be broken.", NULL, NULL, true },
  {  56, "Balancer defined without a value", "The configuration file seems to be broken.", NULL, NULL, true },
  {  57, "Balancer: No '%s' log has been defined.", "The configuration file seems to be broken.", NULL, NULL, true },
  {  58, "Could not find source '%s'", "For some reason the load balancer module is using a missing Information Source. Please recheck that it uses a correct one.", "/source", NULL, true },
  {  59, "Taking source='%s' back on-line", "The information source is being re-enabled.", NULL, NULL, true },
  {  60, "Taking source='%s' back on-line", "The information source is being disabled.", NULL, NULL, true },
  {  61, "Sources exhausted: re-enabling one.", "All the Information Sources have been off-lined. The server needs to re-enable at least one of them.", NULL, NULL, true },
  {  62, "deflateInit2(): %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  63, "deflateEnd(): %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  64, "deflate(): err=%s, avail=%d", "The issue seems to be related to your system.", NULL, NULL, true },
  {  65, "Logger: No '%s' log has been defined.", "The configuration file seems to be broken.", NULL, NULL, true },
  {  66, "Logger writer type is required.", "The configuration file seems to be broken.", NULL, NULL, true },
  {  67, "Unknown logger writer type '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  68, "Logger writer (%s): Could not read the filename.", "A property of the log writer is missing. Odds are you selected to write the output of the log into a file but you did not define it.", NULL, NULL, true },
  {  69, "Could not open '%s' for appending", "This is probably related to the file permissions. Please make sure that it is writable for the user under which Cherokee is run.", NULL, NULL, true },
  {  70, "Allocation logger->max_bufsize %d failed.", "The system might have run out of memory.", NULL, NULL, true },
  {  71, "Could not create pipe (errno=%d): ${errno}", "The issue seems to be related to your system.", NULL, NULL, true },
  {  72, "Could not fork (errno=%d): ${errno}", "The issue seems to be related to your system.", NULL, NULL, true },
  {  73, "Could not parse X-Real-IP access list", "You must define an access list in order to activate the X-Real-IP support.", NULL, NULL, true },
  {  74, "A template is needed for logging connections: %s", "Since you are trying to use a custom logging template, providing the template is mandatory.", NULL, NULL, true },
  {  75, "Could not parse custom log: '%s'", "The server found a problem while processing the logging template. Please ensure it is correct.", NULL, NULL, true },
  {  76, "epoll_ctl: ep_fd %d, fd %d: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  77, "epoll_ctl: ep_fd %d, fd %d: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  78, "epoll_ctl: ep_fd %d, fd %d: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  79, "epoll_create: %d: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  80, "Could not set CloseExec to the epoll descriptor: fcntl: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  81, "fd_associate: fd %d: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  82, "port_associate: fd %d: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  83, "port_getn: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  84, "The FD Poll is full", "The server reached the file descriptor limit. This usaully happens when many simultaneous connections are kept open. Try to increase this limit.", "/advanced#Resources-2", NULL, true },
  {  85, "Could not remove fd %d (idx=%d) from the poll", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  86, "kevent returned: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  87, "EvHost needs a 'tpl_document_root property'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  88, "EvHost: Could not parse template '%s'", "Could not parse the template definining how virtual servers are located. You need to re-define the Dynamic Document Root for your Advanced Virtual Hosting.", NULL, NULL, true },
  {  89, "Virtual Server Rule prio=%d needs a '%s' property", "The configuration file seems to be broken.", NULL, NULL, true },
  {  90, "Could not parse 'to' entry: '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  91, "Virtual Server '%s' regex vrule needs a 'domain' entry", "The configuration file seems to be broken.", NULL, NULL, true },
  {  92, "Rule prio=%d needs a '%s' property", "The configuration file seems to be broken.", NULL, NULL, true },
  {  93, "Could not access to the RegEx table", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  94, "RegExp rule has null pcre", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  95, "Could not recognize HTTP method '%s'", "The rule found an entry with an unsupported HTTP method. Probably the configuration file has been tampered with.", NULL, NULL, true },
  {  96, "Unknown header '%s'", "The rule found an entry with an unsupported header. Probably the configuration file has been tampered with.", NULL, NULL, true },
  {  97, "Unknown type '%s'", "The rule found an entry with an unsupported type. Probably the configuration file has been tampered with.", NULL, NULL, true },
  {  98, "Could not parse 'from' entry: '%s'", "The entries of this rule must be either IP address or network masks. Both IPv4 and IPv6 addresses and masks are supported.", NULL, NULL, true },
  {  99, "Rule prio=%d type='bind', invalid port='%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  100, "Group '%s' not found in the system", "Seem like you've specified a wrong GID. Change the specified one or try to create it using the addgroup/groupadd command.", "/general#Permissions-3", NULL, true },
  {  101, "User '%s' not found in the system", "Looks like you've specified a wrong UID. Either change the specified one or try to create it using the adduser/useradd command.", "/general#Permissions-3", NULL, true },
  {  102, "Ignoring thread_policy entry '%s'", "It looks like an error ocurred with the selected OS thread policy and it has been ignored. Once a valid one is selected, the issue will be fixed.", "/advanced#Resources-2", NULL, true },
  {  103, "Unknown thread policy '%s'", "The specified OS thread policy is unknown. You should try re-selecting one.", "/advanced#Resources-2", NULL, true },
  {  104, "Unknown server token '%s'", "An incorrect server token was specified. Please choose one that is available in you Network behavior settings.", "/general", NULL, true },
  {  105, "Polling method '%s' has not been recognized", "An incorrect polling method was specified. Please try to fix that in your advanced settings.", "/advanced#Connections-1", NULL, true },
  {  106, "Polling method '%s' is not supported by this OS", "The specified polling method does not work on your platform. Please try to choose another one in your advanced settings.", "/advanced#Connections-1", NULL, true },
  {  107, "Unknown polling method '%s'", "An incorrect polling method was specified. Please try to fix that in your advanced settings.", "/advanced#Connections-1", NULL, true },
  {  108, "Not listening on any port.", "The web server needs to be associated to a TCP port. Please try to specify that in your general settings.", "/general#Ports_to_listen-2", NULL, true },
  {  109, "Ignoring TLS port %d", "No TLS backend is specified, but the configuration specifies a secure port and it is being ignored. Either enable a TLS backend or disable the TLS checkbox for the specified port.", "/general#Network-1", NULL, false },
  {  110, "TLS/SSL support required for 'default' Virtual Server.", "TLS/SSL support must be set up in the 'default' Virtual Server. Its certificate will be used by the server in case TLS SNI information is not provided by the client.", NULL, NULL, true },
  {  111, "Virtual Server '%s' is trying to use SSL/TLS, but no Crypto engine is active.", "For a Virtual Server to use SSL/TLS, a Crypto engine must be available server-wide.", NULL, NULL, true },
  {  112, "Server parser: Unknown key '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  113, "initgroups: Unable to set groups for user '%s' and GID %d", "The issue seems to be related to your system.", NULL, NULL, true },
  {  114, "cannot change group to GID %d, running with GID=%d", "Most probably you the server did not have enough permissions to change its execution group.", NULL, NULL, true },
  {  115, "cannot change group to UID %d, running with UID=%d", "Most probably you the server did not have enough permissions to change its execution user.", NULL, NULL, true },
  {  116, "Could not get File Descriptor limit", "The issue seems to be related to your system.", NULL, "poll_type = %d", true },
  {  117, "The server FD limit seems to be higher than the system limit", "The opened file descriptor limit of the server is %d, while the limit of the system is %d. This is an unlikely situation. You could try to raise the opened file descriptor limit of your system.", NULL, NULL, true },
  {  118, "The FD limit of the thread is greater than the limit of the poll", "It seems that an internal server thread assumed a file descriptor limit of %d. However, its FD poll has a lower limit of %d descriptors. The limit has been reduced to the poll limit.", NULL, NULL, true },
  {  119, "Could not create an internal server thread", "This is a extremely unusual error. For some reason the server could not create a thread while launching the server.", NULL, "ret = %d", true },
  {  120, "cannot initialize TLS for '%s' virtual host", "This is usually caused by an error with a certificate or private key.", NULL, NULL, true },
  {  121, "Unable to raise file descriptor limit to %d", "The issue seems to be related to your system.", NULL, NULL, true },
  {  122, "Unable to read the file descriptor limit of the system", "The issue seems to be related to your system.", NULL, NULL, true },
  {  123, "The number of available file descriptors is too low", "The number of available file descriptors: %d, is too low. At least there should be %d available. Please, try to raise your system file descriptor limit.", NULL, NULL, true },
  {  124, "Could not get information about the UID %d", "The issue seems to be related to your system.", NULL, NULL, true },
  {  125, "Could not chroot() to '%s': '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  126, "Could not chdir() to '%s': '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  127, "Invalid Source entry '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  128, "Source %d: An entry 'type' is required", "The configuration file seems to be broken.", NULL, NULL, true },
  {  129, "Source %d has an unknown type: '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  130, "Invalid Virtual Server entry '%s'", "The configuration file seems to be broken.", NULL, NULL, true },
  {  131, "No virtual hosts have been configured", "There should exist at least one virtual server.", NULL, NULL, true },
  {  132, "Lowest priority virtual server must be 'default'", "The lowest priority virtual server should be named 'default'.", NULL, NULL, true },
  {  133, "Could not fork()", "The issue seems to be related to your system.", NULL, NULL, true },
  {  134, "Could not execute the Panic handler: '%s', status %d", "Something happened with the server, and it felt panic. It tried to call an external program to report it to the administrator, but it failed.", NULL, NULL, true },
  {  135, "User '%s' not found in the system", "The server is configured to execute an interpreter as a different user. However, it seems that the user does not exist in the system.", "/source/%d", NULL, true },
  {  136, "Group '%s' not found in the system", "The server is configured to execute an interpreter as a different group. However, it seems that the group does not exist in the system.", "/source/%d", NULL, true },
  {  137, "There is a 'Interpreter Source' witout an interpreter.", "The server configuration defines an 'interpreter' information source that does not specify an interpreter.", "/source/%d", NULL, true },
  {  138, "Could not find interpreter '%s'", "The server configuration refers to an interpreter that is not installed in this system.", "/source/%d", NULL, true },
  {  139, "Could not spawn '%s'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  140, "Could not access file", "The configuration file '%s' could not be accessed. Most probably the server user does not have enough permissions to read it.", NULL, NULL, false },
  {  141, "'%s' and '%s' as child of the same node", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  142, "Parsing error", "The server could not parse the configuration. Something must be wrong with formation. At this stage the lexical is checked.", NULL, "%s", true },
  {  143, "Token not found '%s'", "It seems that the template uses an undefined token.", NULL, NULL, true },
  {  144, "Could not initialize SHM '%s': ${errno}", "Check if your shared memory is mounted in /dev/shm", NULL, NULL, false },
  {  145, "Could not unlock spawning semaphore %d: ${errno}", "The issue seems to be related to your system.", NULL, NULL, true },
  {  146, "Unknown HTTP status code %d", NULL, NULL, NULL, true },
  {  147, "A default icon is needed", "Please, specify a default icon. It is the icon that Cherokee will use whenever no other icon is used.", "/general#Icons-4", NULL, true },
  {  148, "Could not assign suffix '%s' to file '%s'", "An unexpected error has just occurred in the server. The cause of the issue is unknown. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so the developer team can fix it.", "/general#Icons-4", NULL, true },
  {  149, "Duped suffix (case insensitive) '%s', pointing to '%s'", "An unexpected error has just occurred in the server. The cause of the issue is unknown. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so the developer team can fix it.", "/general#Icons-4", NULL, true },
  {  150, "Calling cherokee_header_parse() with an empty header", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  151, "Could not find the End Of Header", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, "len=%d, buf=%s", true },
  {  152, "Too many initial CRLF", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  153, "Failed to store a header entry while parsing", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  154, "IPv6 support is disabled. Configuring for IPv4 support only.", "The issue seems to be related to your system.", "/general#Network-4", NULL, false },
  {  155, "Could not create socket: ${errno}", "The issue seems to be related to your system.", NULL, NULL, true },
  {  156, "Could not set SO_KEEPALIVE on fd=%d: ${errno}", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  157, "Could not set SO_LINGER on fd=%d: ${errno}", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  158, "Could not disable Nagle's algorithm", "The issue seems to be related to your system.", NULL, NULL, true },
  {  159, "Could not set non-blocking, fd %d", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  160, "%s is not a socket", "The file is supposed to be a Unix socket, although it does not look like one.", NULL, NULL, true },
  {  161, "Could not remove %s", "Could not remove the Unix socket because: ${errno}", NULL, NULL, true },
  {  162, "Could not write to socket: write(%d, ..): '${errno}'", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  163, "Could not read from socket: read(%d, ..): '${errno}'", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  164, "Could not write a vector to socket: writev(%d, ..): '${errno}'", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  165, "Could not connect: ${errno}", "The issue seems to be related to your system.", NULL, NULL, true },
  {  166, "Unknown socket family: %d", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  167, "Could not set TCP_NODELAY to fd %d: ${errno}", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  168, "Could not remove TCP_NODELAY from fd %d: ${errno}", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  169, "Could not set TCP_CORK to fd %d: ${errno}", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  170, "Could not set TCP_CORK from fd %d: ${errno}", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  171, "Could not remove fd(%d) from fdpoll", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  172, "Unknown ret %d from handler %s", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  173, "Run out of file descriptors", "The server is under heavy load and it has run out of file descriptors. It can be fixed by raising the file descriptor limit and restarting the server.", "/advanced", NULL, true },
  {  174, "Trying to get a new connection object", "Either the system run out of memory, or you've hit a bug in the code.", NULL, NULL, true },
  {  175, "Could not set sockaddr", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  176, "Could not create a system thread: '${errno}'", "This is a extremely unusual error. For some reason your system could not create a thread while launching the server. You might have hit some system restriction.", NULL, "pthread_create() error = %d", true },
  {  177, "Unknown authentication method", "The configuration file seems to be broken.", NULL, NULL, true },
  {  178, "Could not build the local directory string", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  179, "Could not get virtual server: '%s'", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  180, "pstat_getdynamic() failed: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  181, "sysctl(CTL_HW:HW_NCPU) failed: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  182, "sysconf(_SC_NPROCESSORS_ONLN) failed: '${errno}'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  183, "Could not figure the CPU/core number of your server. Read %d, set to 1", NULL, NULL, NULL, true },
  {  184, "Could not get the file descriptor limit of your system", "The issue seems to be related to your system.", NULL, NULL, true },
  {  185, "fcntl (F_GETFL, fd=%d, 0): ${errno}", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  186, "fcntl (F_GETFL, fd=%d, flags=%d (+%s)): ${errno}", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  187, "fcntl (F_GETFD, fd=%d, 0): ${errno}", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  188, "fcntl (F_GETFD, fd=%d, flags=%d (+%s)): ${errno}", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  189, "Could not mkdir '%s': ${errno}", "Most probably there you have to adjust some permissions.", NULL, NULL, true },
  {  190, "AVL Tree inconsistency: Right child", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  191, "AVL Tree inconsistency: Left child", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  192, "AVL Tree inconsistency: Balance", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  193, "Buffer: Bad memory estimation. The format '%s' estimated a negative length: %d.", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  194, "Buffer: No target memory. The format '%s' got a free size of %d (estimated %d).", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  195, "Buffer: Bad estimation. Too few memory: '%s' -> '%s', esti=%d real=%d size=%d.", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  196, "Buffer: Bad estimation: Estimation=%d, needed=%d available size=%d: %s.", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  197, "Could not open the file: %s, ${errno}", "Please check that the file exists and the server has read access.", NULL, NULL, true },
  {  198, "Could not read from fd: read(%d, %d, ..) = ${errno}", "Please check that the file exists and the server has read access.", NULL, NULL, true },
  {  199, "Could not get simbol '%s': %s", "The server found an internal problem. ", NULL, NULL, true },
  {  200, "Something just happened while opening a plug-in file", "The operating system reported '%s' while trying to load '%s'.", NULL, NULL, true },
  {  201, "The plug-in initialization function (%s) could not be found", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  202, "Could not open the '%s' module", "Either you are trying to use an unavailable (uninstalled?) plugin, or there is a installation issue.", NULL, NULL, true },
  {  203, "Could not access the 'info' entry of the %s plug-in", "Either you are trying to use an unavailable (uninstalled?) plugin, or there is a installation issue.", NULL, NULL, true },
  {  204, "Unsupported method '%s'", "For some reason the configuration file is trying to use an invalid authentication method. Either the file has been tampered with, or you are using a legacy configuration from a system that was compiled with support for more authentication methods.", "/vserver/%d/rule/%d", NULL, true },
  {  205, "Expiration time without a 'time' property", "The expiration time feature is being used but no amount of time has been specified. Either provide on or disable Expiration.", "/vserver/%d/rule/%d", NULL, true },
  {  206, "Virtual Server Rule, Unknown key '%s'", "Most probably you are using an old configuration file that contains a deprecated key. Loading and then saving it through Cherokee-Admin should update the old entries for you automatically.", "/vserver/%d/rule/%d", NULL, true },
  {  207, "Rule matches must specify a 'type' property", "For some reason the rule is incomplete. Try editing or recreating it within Cherokee-Admin.", "/vserver/%d/rule/%d", NULL, true },
  {  208, "Could not load rule module '%s'", "The server could not load a plug-in file. This might be due to some problem in the installation.", "/vserver/%d", NULL, true },
  {  209, "Invalid priority '%s'", "For some reason your configuration file contains invalid priority values, which must be an integer higher than 0. Most likely it has been edited by hand and the value must be fixed manually or the rule has to be discarded.", "/vserver/%d", NULL, true },
  {  210, "Rules must specify a 'match' property", "For some reason there is an incomplete rule in your configuration file. Try locating it in Cherokee-Admin and fill in all the mandatory fields.", "/vserver/%d/rule/%d", NULL, true },
  {  211, "Virtual Server must specify a 'match' property", "Try filling in the fields under the 'Host Match' tab.", "/vserver/%d#Host_Match-2", NULL, true },
  {  212, "Virtual Server, Unknown key '%s'", "Most probably you are using an old configuration file that contains a deprecated key. Loading and then saving it through Cherokee-Admin should update the old entries for you automatically.", "/vserver/%d", NULL, true },
  {  213, "Virtual Server  without a 'nick' property", "For some reason, a mandatory property is not present in your configuration. Fill in the 'Virtual Server nickname' field, under the 'Basics' tab.", "/vserver/%d#Basics-1", NULL, true },
  {  214, "Virtual Server  without a 'document_root' property", "You seem to have forgotten to provide a valid Document Root. This is the root path that contains the files and directories that will be made publicly available through the web server. It can be an empty path and even /dev/null, but it is a mandatory property.", "/vserver/%d#Basics-1", NULL, true },
  {  215, "Could not compile <<%s>>: %s (offset=%d)", "For some reason, PCRE could not compile the regular expression. Please modify the regular expression in order to solve this problem.", NULL, NULL, true },
  {  216, "This IP '%s' is IPv6-mapped IPv6 address", "It can be solved by specifying the IP in IPv4 style: a.b.c.d, instead of IPv6 style: ::ffff:a.b.c.d style", NULL, NULL, true },
  {  217, "The IP address '%s' seems to be invalid", "You must have made a mistake. Please, try to fix the IP and try again.", NULL, NULL, true },
  {  218, "The network mask '%s' seems to be invalid", "You must have made a mistake. Please, try to fix the IP and try again.", NULL, NULL, true },
  {  219, "A port entry is need", "It seems that the configuration file includes a port listening entry with the wrong format. It should contain one port specification, but it does not in this case.", "/general#Ports_to_listen-2", NULL, true },
  {  220, "Could not bind() port=%d (UID=%d, GID=%d)", "Most probably there is another web server listening to the same port. You will have to shut it down before launching Cherokee. It could also be a permissions issue as well. Remember that non-root user cannot listen to ports < 1024.", "/general#Ports_to_listen-2", NULL, true },
  {  221, "Could not execute RRD command: %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  222, "RRDtool empty response", "The issue seems to be related to your system.", NULL, NULL, true },
  {  223, "RRDtool replied an error message: %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  224, "Invalid request: %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  225, "Could not execute RRD command: %s", "The issue seems to be related to your system.", "/general#Network-1", NULL, true },
  {  226, "Could not create the RRD working thread: error=%d", "The issue seems to be related to your system.", NULL, NULL, true },
  {  227, "Could not create the RRD working mutex: error=%d", "The issue seems to be related to your system.", NULL, NULL, true },
  {  228, "Validator MySQL: Unknown hash type: '%s'", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  229, "Validator MySQL: Unknown key: '%s'", "It looks like you've hit a bug in the server. Please, do not hesitate to report it at http://bugs.cherokee-project.com/ so  the developer team can fix it.", NULL, NULL, true },
  {  230, "MySQL validator: a 'user' entry is needed", "Make sure that a valid MySQL user-name has been provided.", NULL, NULL, true },
  {  231, "MySQL validator: a 'database' entry is needed", "Make sure that a valid MySQL database-name has been provided.", NULL, NULL, true },
  {  232, "MySQL validator: a 'query' entry is needed", "Make sure that a MySQL query has been provided.", NULL, NULL, true },
  {  233, "MySQL validator misconfigured: A Host or Unix socket is needed.", "Make sure that a working database host is specified for MySQL validation.", NULL, NULL, true },
  {  234, "Unable to connect to MySQL server: %s:%d %s", "Most probably the MySQL server is down or you've mistyped a connetion parameter", NULL, NULL, true },
  {  235, "Unknown parameter type '%c'", "Accepted parameter are 's' and 'd'", NULL, NULL, true },
  {  236, "Not enough entropy in the pool", "The issue seems to be related to your system.", NULL, NULL, true },
  {  237, "Could not get the socket struct: %p", "The issue seems to be related to your system.", NULL, NULL, true },
  {  238, "Servername did not match: '%s'", "A TLS negotiation using SNI is sending a domain name that does not match any of the available ones. This makes it impossible to present a certificate with a correct CA. Check the list of TLS enabled Virtual Servers if you expect otherwise.", NULL, NULL, true },
  {  239, "Could not change the SSL context: servername='%s'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  240, "OpenSSL: Could not allocate OpenSSL context", "The issue seems to be related to your system.", NULL, NULL, true },
  {  241, "OpenSSL: cannot set cipher list '%s': %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  242, "OpenSSL: cannot use certificate file '%s':  %s", "An error occured while trying to load a certificate into the SSL context structure. Most likely the certificate file is wrong or has been corrupted.", NULL, NULL, true },
  {  243, "OpenSSL: cannot use private key file '%s': %s", "An error occured while trying to load a private key the SSL context structure. Most likely the file is wrong or has been corrupted.", NULL, NULL, true },
  {  244, "OpenSSL: Private key does not match the certificate public key", "The private key must agree with the corresponding public key in the certificate associated with a specific SSL context. Double check both private key and certificate.", NULL, NULL, true },
  {  245, "OpenSSL: cannot read trusted CA list '%s': %s", "If this happens, CA certificates for verification purposes cannot be located. It is likely there is a problem with your private key.", NULL, NULL, true },
  {  246, "SSL_load_client_CA_file '%s': %s", "A file of PEM formatted certificates should be read to extract data of the certificates found. It is likely there is a problem with your private key.", NULL, NULL, true },
  {  247, "Unable to set SSL session-id context for '%s': %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  248, "Could not activate TLS SNI for '%s': %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  249, "OpenSSL: Unable to create a new SSL connection from the SSL context: %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  250, "OpenSSL: cannot set fd(%d): %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  251, "Init OpenSSL: %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  252, "SSL_write: unknown errno: ${errno}", "The issue seems to be related to your system.", NULL, NULL, true },
  {  253, "SSL_write (%d, ..) -> err=%d '%s'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  254, "SSL_read: unknown errno: ${errno}", "The issue seems to be related to your system.", NULL, NULL, true },
  {  255, "OpenSSL: SSL_read (%d, ..) -> err=%d '%s'", "The issue seems to be related to your system.", NULL, NULL, true },
  {  256, "OpenSSL: Unable to create a new SSL context: %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  257, "OpenSSL: '%s': %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  258, "OpenSSL: cannot set certificate verification paths: %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  259, "OpenSSL: Could not set SNI server name: %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  260, "OpenSSL: cannot connect: %s", "The issue seems to be related to your system.", NULL, NULL, true },
  {  261, "Could not init pkcs11 engine", "The issue seems to be related to your system.", NULL, NULL, true },
  {  262, "Could not set all defaults", "The issue seems to be related to your system.", NULL, NULL, true },
  {  -1, NULL, NULL, NULL, NULL, true }
};
