/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "mime.h"


static cherokee_mime_t *_mime_global  = NULL;


static ret_t 
cherokee_mime_new  (cherokee_mime_t **mime)
{
	   CHEROKEE_NEW_STRUCT(n, mime);

	   cherokee_table_init(&n->table);

	   *mime = n;
	   return ret_ok;
}


ret_t
cherokee_mime_free (cherokee_mime_t *mime)
{
	cherokee_table_free2 (&mime->table, free);
	free (mime);

	return ret_ok;
}


static ret_t 
cherokee_mime_load (cherokee_mime_t *mime, char *filename)
{
	   FILE   *f;
	   char    ext[gbl_buffer_size];
	   char    mime_string[gbl_buffer_size];

	   f = fopen (filename, "r");
	   return_if_fail (f!=NULL, ret_file_not_found);

	   while (!feof(f)) {
			 fgets (gbl_buffer, gbl_buffer_size, f);

			 /* Empty
			  */
			 if (strlen(gbl_buffer) < 3) 
				    continue;

			 /* Comments
			  */
			 if (gbl_buffer[0] == '#')
				    continue;

			 /* Split the line
			  */
			 sscanf (gbl_buffer, "%s\t%s", ext, mime_string);

			 /* Add to table
			  */
			 cherokee_table_add (&mime->table, ext, strdup(mime_string));
	   }
	   
	   fclose(f);
	   return ret_ok;
}


char * 
cherokee_mime_get (cherokee_mime_t *mime, char *ext)
{
	return cherokee_table_get_val (&mime->table, ext);
}


ret_t 
cherokee_mime_get_default (cherokee_mime_t **mime)
{
	   *mime = _mime_global;
	   return ret_ok;
}


ret_t 
cherokee_mime_init (cherokee_mime_t **mime)
{
	return cherokee_mime_init_with_file (mime, CHEROKEE_DATADIR"/mime_types.txt");
}


ret_t 
cherokee_mime_init_with_file (cherokee_mime_t **mime, char *filename)
{
	ret_t ret;
	cherokee_mime_t *n;

	if (_mime_global != NULL) {
		*mime = _mime_global;
		return ret_ok;
	}

	cherokee_mime_new (&n);

	ret = cherokee_mime_load (n, filename);
	if (ret < ret_ok) goto error;

	*mime        = n;
	_mime_global = n;

	return ret_ok;

error:
	cherokee_mime_free (n);
	return ret_error;
}
