/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_VIRTUAL_SERVER_H__
#define __CHEROKEE_VIRTUAL_SERVER_H__

#include "common.h"

#ifdef HAVE_TLS
# include <gnutls/extra.h>
# include <gnutls/gnutls.h>
#endif

#include "handler_table.h"
#include "handler_table_entry.h"
#include "logger.h"


typedef struct {
	char                     *domain;       /* Domain name. Eg: www.alobbs.com */
	cherokee_handler_table_t *plugins;      /* plugin-to-path. Eg: (/public, common) */

	char                     *root;         /* Document root. Eg: /var/www */
	int                       root_len;     /* Document root length */

	cherokee_logger_t        *logger;
	cherokee_table_t         *logger_props;

	struct {                               /* HTTP Error codes: 400 .. 417 */
		char *file;
		char *url;
	} error_document400[http_type_400_max+1];

#ifdef HAVE_TLS
	char *server_cert;
	char *server_key;
	char *ca_cert;

	gnutls_certificate_server_credentials credentials;
	gnutls_dh_params                      dh_params;
	gnutls_rsa_params                     rsa_params;
#endif

} cherokee_virtual_server_t;

#define VSERVER(v)        ((cherokee_virtual_server_t *)(v))
#define VSERVER_LOGGER(v) (LOGGER(VSERVER(v)->logger))

ret_t cherokee_virtual_server_new   (cherokee_virtual_server_t **vserver);
ret_t cherokee_virtual_server_free  (cherokee_virtual_server_t  *vserver);
ret_t cherokee_virtual_server_clean (cherokee_virtual_server_t  *vserver);

ret_t cherokee_virtual_server_init_tls (cherokee_virtual_server_t *vserver);
ret_t cherokee_virtual_server_set      (cherokee_virtual_server_t *vserver, char *web_dir, char *handler_name, cherokee_handler_table_entry_t *plugin_entry);

ret_t cherokee_virtual_server_get_error_page (cherokee_virtual_server_t *vserver, cherokee_http_t error_code, char **filename_ref);
ret_t cherokee_virtual_server_get_error_url  (cherokee_virtual_server_t *vserver, cherokee_http_t error_code, char **url_ref);

#endif /* __CHEROKEE_VIRTUAL_SERVER_H__ */
