#include <stdio.h>
#include "common.h"
#include "buffer.h"
#include "header.h"

const char *mozilla_header = 
"GET /icons/compressed.png HTTP/1.1"CRLF
"Host: localhost"CRLF
"User-Agent: Cherokee 0.4.6 (http://www.0x50.org)"CRLF
"Accept: image/png,image/jpeg,image/gif;q=0.2,*/*;q=0.1"CRLF
"Accept-Language: en-us,en;q=0.5"CRLF
"Accept-Encoding: gzip,deflate"CRLF
"Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7"CRLF
"Keep-Alive: 300"CRLF
"Connection: keep-alive"CRLF
"Referer: http://localhost/"CRLF;

int
main (int argc, char **argv)
{
	   cherokee_buffer_t *buffer;
	   cherokee_header_t *header;

	   cherokee_buffer_new (&buffer);
	   cherokee_header_new (&header);

	   cherokee_buffer_add (buffer, mozilla_header, strlen(mozilla_header));
	   printf ("1\n");
	   cherokee_header_parse (header, buffer);
	   printf ("2\n");

	   cherokee_buffer_free (buffer);
	   cherokee_header_free (header);

	   return 0;
}
