/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "validator.h"


ret_t 
cherokee_validator_init_base (cherokee_validator_t *validator)
{
	cherokee_module_init_base (MODULE(validator));
	
	validator->func_check = NULL;

	return ret_ok;
}

ret_t 
cherokee_validator_init (cherokee_validator_t *validator, const char *dir)
{
	validator_init_t func = (validator_init_t) MODULE(validator)->func_init;

	if (func == NULL) {
		return ret_error;
	}
	
	return func (validator, dir);
}


ret_t 
cherokee_validator_free (cherokee_validator_t *validator)
{
	module_func_free_t func = (module_func_free_t) MODULE(validator)->func_free;

	if (func == NULL) {
		return ret_error;
	}
	
	return func (validator);
}


ret_t 
cherokee_validator_check (cherokee_validator_t *validator, const char *login, const char *passwd)
{
	if (validator->func_check == NULL) {
		return ret_error;
	}
	
	return validator->func_check (validator, login, passwd);
}


