/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_THREAD_H__
#define __CHEROKEE_THREAD_H__

#include "common.h"
#include "list.h"
#include "socket.h"
#include "connection.h"
#include "fdpoll.h"

#include <pthread.h>

typedef struct {
	struct list_head base;
	pthread_t        thread;

	cherokee_fdpoll_t *fdpoll;

	void              *server;
	int                exit;

	int              active_list_num;
	list_t           active_list;
	list_t           reuse_list;

} cherokee_thread_t;

#define THREAD(x)     ((cherokee_thread_t *)(x))
#define THREAD_SRV(t) (SRV(THREAD(t)->server))

ret_t cherokee_thread_new  (cherokee_thread_t **thd, void *server, int real_thread);
ret_t cherokee_thread_free (cherokee_thread_t  *thd);
ret_t cherokee_thread_step (cherokee_thread_t  *thd);

ret_t cherokee_thread_get_new_connection      (cherokee_thread_t *thd, cherokee_connection_t **conn);
ret_t cherokee_thread_set_reusable_connection (cherokee_thread_t *thd, cherokee_connection_t  *conn);

ret_t cherokee_thread_add_connection          (cherokee_thread_t *thd, cherokee_connection_t  *conn);
int   cherokee_thread_connection_num          (cherokee_thread_t *thd);
ret_t cherokee_thread_close_all_connections   (cherokee_thread_t *thd);

#endif /* __CHEROKEE_THREAD_H__ */
