/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_FD_POLL_H__
#define __CHEROKEE_FD_POLL_H__

#ifdef HAVE_EPOLL
#include <sys/epoll.h>
#else 
#ifdef USE_POOL_EMULATION
# include "poll_emu.h"
#else
# ifdef HAVE_SYS_POLL_H
#   include <sys/poll.h>
# else
#   include <poll.h>
# endif
#endif // USE_POOL_EMULATION
#endif // HAVE_EPOLL

#ifdef HAVE_PTHREAD
#include <pthread.h>
#endif

#include "common.h"


typedef enum {
	   fdp_read  = 0,
	   fdp_write = 1
} cherokee_fdpoll_rw_t;

#ifdef HAVE_EPOLL
# define USE_EPOLL
#else
# define USE_POLL
#endif



typedef struct {
	int nfiles;

#ifdef USE_EPOLL
	int                 ep_fd;
	struct epoll_event *ep_events;
	int                 ep_readyfds;
	int                *epoll_rs2idx;
	int                *epoll_idx2rs;
#endif

#ifdef USE_POLL
	struct pollfd *pollfds;
	int            npollfds;
	int           *fdidx;
#endif
	
#ifdef HAVE_PTHREAD
	pthread_rwlock_t rwlock;
#endif

} cherokee_fdpoll_t;

#ifdef USE_EPOLL
# define cherokee_fdpoll_new      fdpoll_epoll_new
# define cherokee_fdpoll_free     fdpoll_epoll_free
# define cherokee_fdpoll_add      fdpoll_epoll_add
# define cherokee_fdpoll_del      fdpoll_epoll_del
# define cherokee_fdpoll_set_mode fdpoll_epoll_set_mode
# define cherokee_fdpoll_watch    fdpoll_epoll_watch
# define cherokee_fdpoll_check    fdpoll_epoll_check
# define cherokee_fdpoll_reset    fdpoll_epoll_reset
#endif

#ifdef USE_POLL
# define cherokee_fdpoll_new      fdpoll_poll_new
# define cherokee_fdpoll_free     fdpoll_poll_free
# define cherokee_fdpoll_add      fdpoll_poll_add
# define cherokee_fdpoll_del      fdpoll_poll_del
# define cherokee_fdpoll_set_mode fdpoll_poll_set_mode
# define cherokee_fdpoll_watch    fdpoll_poll_watch
# define cherokee_fdpoll_check    fdpoll_poll_check
# define cherokee_fdpoll_reset    fdpoll_poll_reset
#endif


ret_t cherokee_fdpoll_new      (cherokee_fdpoll_t **fdp);
ret_t cherokee_fdpoll_free     (cherokee_fdpoll_t  *fdp);

ret_t cherokee_fdpoll_add      (cherokee_fdpoll_t  *fdp, int fd, int rw);
ret_t cherokee_fdpoll_del      (cherokee_fdpoll_t  *fdp, int fd);
void  cherokee_fdpoll_set_mode (cherokee_fdpoll_t  *fdp, int fd, int rw);
int   cherokee_fdpoll_check    (cherokee_fdpoll_t  *fdp, int fd, int rw);
int   cherokee_fdpoll_watch    (cherokee_fdpoll_t  *fdp, int timeout_msecs);

#endif /* __CHEROKEE_FD_POLL_H__ */
