/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_COMMON_H__
#define __CHEROKEE_COMMON_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_PTHREAD
#include <pthread.h>
#endif

#define DEFAULT_RECV_SIZE             1024
#define DEFAULT_READ_SIZE             8192
#define MAX_HEADER_LEN                4096
#define MAX_KEEP_ALIVE                100
#define MAX_NEW_CONNECTIONS_PER_STEP  100
#define MAX_ITEMS_MMAP_TABLE          15

#define EXIT_CANT_CREATE_SERVER_SOCKET4 10
#define EXIT_EPOLL_CREATE_ERROR         20
#define EXIT_EPOLL_CTL_ADD              21
#define EXIT_EPOLL_CTL_MOD              22
#define EXIT_EPOLL_CTL_DEL              23
#define EXIT_EPOLL_CREATE               24
#define EXIT_SERVER_CLEAN               30
#define EXIT_SERVER_READ_CONFIG         31
#define EXIT_SERVER_INIT                32


#define CRLF "\r\n"


/* Global mini-buffer:
 * for quick usage
 */
#define gbl_buffer_size 512
extern char gbl_buffer[gbl_buffer_size];


typedef enum {
	ret_nomem          = -2, 
	ret_error          = -1,
	ret_ok             =  0,
	ret_eof            =  1,
	ret_eof_have_data  =  2,
	ret_not_found      =  3,   
	ret_file_not_found =  4,
	ret_eagain         =  5, 
	ret_ok_and_sent    =  6
} ret_t;
	
#define return_if_fail(expr,ret) \
	if (!(expr)) {                                                    \
		fprintf (stderr,                                          \
       		         "file %s: line %d (%s): assertion `%s' failed\n",\
                          __FILE__,                                       \
                          __LINE__,                                       \
                          __PRETTY_FUNCTION__,                            \
                          #expr);                                         \
	        return (ret);                                             \
	};


#define SHOULDNT_HAPPEN \
	do { fprintf (stderr, "file %s: line %d (%s): this shouldn't happend\n", \
			            __FILE__, __LINE__, __PRETTY_FUNCTION__);          \
	} while (0);

#define CHEROKEE_NEW_STRUCT(obj,type)                                                                         \
	cherokee_ ## type ## _t * obj = (cherokee_ ## type ## _t *) malloc (sizeof(cherokee_ ## type ## _t)); \
	return_if_fail (obj != NULL, ret_nomem);

#define CHEROKEE_NEW(obj,type)                   \
	cherokee_ ## type ## _t * obj;           \
	cherokee_ ## type ## _new (& obj );      \
	return_if_fail (obj != NULL, ret_nomem);

#define CHEROKEE_TEMP(obj, size)                 \
        const unsigned int obj ## _size = size;  \
	char obj[size];


#ifdef HAVE_PTHREADS
#define CHEROKEE_MUTEX_LOCK(m)   pthread_mutex_lock(m)
#define CHEROKEE_MUTEX_UNLOCK(m) pthread_mutex_unlock(m)
#else
#define CHEROKEE_MUTEX_LOCK(m)
#define CHEROKEE_MUTEX_UNLOCK(m)
#endif

void PRINT_ERROR (const char *format, ...);



/* Misc functions
 */

int   hexit        (char c);
char *apr_strfsize (size_t size, char *buf);


/*                            0        1         2         3         4         5         6         7
						1234567890123456789012345678901234567890123456789012345678901234567890 */


#endif /* __CHEROKEE_COMMON_H__ */
