/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_SERVER_H__
#define __CHEROKEE_SERVER_H__

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else 
#include <time.h>
#endif

#include <unistd.h>
#include <sys/types.h>

#include "common.h"
#include "list.h"
#include "fdpoll.h"
#include "plugin_table.h"
#include "virtual_server.h"
#include "encoder_table.h"
#include "logger_table.h"
#include "thread.h"


typedef struct {
	time_t bogo_now;
	
	/* Virtual servers
	 */
	cherokee_table_t          *vservers;
	cherokee_virtual_server_t *vserver_default;
	
	/* Threads
	 */
	list_t             thread_list;
	cherokee_thread_t *main_thread;

	/* Encoders 
	 */
	cherokee_encoder_table_t *encoders;

	/* Default index files
	 */
	list_t index_list;

	/* Logging
	 */
	int    log_flush_elapse;
	time_t log_flush_next;
	cherokee_logger_table_t  *loggers;

	/* Configuration
	 */
	int   socket;
	int   ipv6;
	char *listen_to;	
	int   fdwatch_msecs;

	int   ncpus;
	int   thread_num;

	int   port;
	int   timeout;
	int   keepalive;
	int   hideversion;
	int   hideservername;

	uid_t  user;
	uid_t  user_orig;
	gid_t  group;
	gid_t  group_orig;

	char  *chroot;
	int    chrooted;

	char *mimetypes_file;

	char                          *userdir;              /* Eg: public_html */
	cherokee_plugin_table_entry_t *userdir_handler;     
} cherokee_server_t;


#define SRV(x) ((cherokee_server_t *)(x))


ret_t cherokee_server_new   (cherokee_server_t **srv);
ret_t cherokee_server_init  (cherokee_server_t  *srv);
ret_t cherokee_server_clean (cherokee_server_t  *srv);
ret_t cherokee_server_free  (cherokee_server_t  *srv);

void  cherokee_server_step            (cherokee_server_t  *srv);
void  cherokee_server_set_min_latency (cherokee_server_t  *srv, int msecs);

ret_t cherokee_server_read_config_file    (cherokee_server_t *srv, char *filename);
ret_t cherokee_server_read_config_string  (cherokee_server_t *srv, char *string);


/* System signal callback
 */
ret_t cherokee_server_handle_HUP (cherokee_server_t *srv);


#endif /* __CHEROKEE_SERVER_H__ */
