/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_CONNECTION_HANDLER_PHP4_H__
#define __CHEROKEE_CONNECTION_HANDLER_PHP4_H__

#include "common.h"
#include "buffer.h"
#include "handler.h"

#include "php.h"
#include "SAPI.h"


typedef struct {
	cherokee_handler_t handler;
	
	zend_file_handle *file_handle;
	zend_llist       *global_vars;
} cherokee_handler_php4_t;

#define PHPHANDLER(x)  ((cherokee_handler_php4_t *)(x))



/* Library init function
 */
void php4_init ();


ret_t cherokee_handler_php4_new   (cherokee_handler_t **hdl, void *cnt, cherokee_table_t *properties);

/* virtual methods implementation
 */
ret_t cherokee_handler_php4_init        (cherokee_handler_php4_t *hdl);
ret_t cherokee_handler_php4_free        (cherokee_handler_php4_t *hdl);
ret_t cherokee_handler_php4_step        (cherokee_handler_php4_t *hdl, cherokee_buffer_t *buffer);
ret_t cherokee_handler_php4_add_headers (cherokee_handler_php4_t *hdl, cherokee_buffer_t *buffer);


#endif /* __CHEROKEE_CONNECTION_HANDLER_PHP4_H__ */
