/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_MMAP_H__
#define __CHEROKEE_MMAP_H__

#include <unistd.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "common.h"
#include "list.h"


#define MMAP_HASH_BITS        8
#define MMAP_HASH_SIZE        (1 << MMAP_HASH_BITS)
#define MMAP_HASH_MASK        (MMAP_HASH_SIZE - 1)
#define MMAP_HASH_FUNC(s)     (((unsigned long int)s->st_ino) & MMAP_HASH_MASK)

typedef struct {
	list_t *hash[MMAP_HASH_SIZE];
} cherokee_mmap_t ;

#define MMAP(m) ((cherokee_mmap_t *)(m))


ret_t cherokee_mmap_new  (cherokee_mmap_t **mmap, int num);
ret_t cherokee_mmap_free (cherokee_mmap_t  *mmap);

void* cherokee_mmap_get  (cherokee_mmap_t  *mmap, const char *filename);


#endif /* __CHEROKEE_MMAP_H__ */
