/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_ENCODER_TABLE_H__
#define __CHEROKEE_ENCODER_TABLE_H__

#include "common.h"
#include "table.h"
#include "encoder.h"


typedef struct {
	   cherokee_table_t table;
} cherokee_encoder_table_t;

#define ETABLE(x) ((cherokee_encoder_table_t *)(x))


ret_t cherokee_encoder_table_new   (cherokee_encoder_table_t **et);
ret_t cherokee_encoder_table_free  (cherokee_encoder_table_t  *et);
ret_t cherokee_encoder_table_clean (cherokee_encoder_table_t  *et);

ret_t cherokee_encoder_table_load  (cherokee_encoder_table_t  *et, char *encoder);
ret_t cherokee_encoder_table_get   (cherokee_encoder_table_t  *et, char *encoder, cherokee_encoder_t **object);
ret_t cherokee_encoder_table_add   (cherokee_encoder_table_t  *et, char *encoder, void *new_func);

#endif /* __CHEROKEE_ENCODER_TABLE_H__ */
