/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_PLUGIN_TABLE_ENTRY_H__
#define __CHEROKEE_PLUGIN_TABLE_ENTRY_H__

#include "common.h"
#include "table.h"
#include "handler.h"
#include "encoder.h"


typedef struct {
	/* Handler
	 */
	cherokee_table_t   *properties; 
	handler_func_new_t  handler_new_func;

} cherokee_plugin_table_entry_t; 

#define PT_ENTRY(x) ((cherokee_plugin_table_t *)(x))


ret_t cherokee_plugin_table_entry_new  (cherokee_plugin_table_entry_t **entry);
ret_t cherokee_plugin_table_entry_free (cherokee_plugin_table_entry_t  *entry);

ret_t cherokee_plugin_table_entry_set  (cherokee_plugin_table_entry_t  *entry, char *prop_name, char *prop_value);

#endif /* __CHEROKEE_PLUGIN_TABLE_ENTRY_H__ */
